;*************************************************************************
;*                                                                       *
;*                Blitz Basic Graphical User Interface                   *
;*                                                                       *
;*                          Include file  v1.11                          *
;*                                                                       *
;*************************************************************************
;*                                                                       *
;*          Include this file to gain access to the functions            *
;*                                                                       *
;*************************************************************************
;*                                                                       *
;*                            Created by                                 *
;*                                                                       *
;*                          Jeppe Nielsen                                *
;*                                                                       *
;*                            2001-2002                                  *
;*                                                                       *
;*************************************************************************
;*                                                                       *
;*                             Websites:                                 *
;*                                                                       *
;*                     www.dahlsgaards.dk/bbgui                          *
;*                                                                       *
;*                     www.dahlsgaards.dk/blitz                          *
;*                                                                       *
;*                              e-mail:                                  *
;*                                                                       *
;*                    nielsen_jeppe@hotmail.com                          *
;*                                                                       *
;*************************************************************************


































Type window

Field x,y,wid,hei
Field style.guidesign
Field title$,font
Field activate
Field show,lock

Field control,move,resize,header,buttons
Field minwid,minhei,maxwid,maxhei

Field headhei
Field closed

Field areax1,areay1,areawid,areahei

End Type

Global windowinteract.window,windowinteractstate,windowinteractx,windowinteracty,windowinteractwid,windowinteracthei
Global windowinteractright,windowinteractdown,windowinteractleft,windowinteractup
Global windowhelpon=1,windowhelpdelay=2000
Global windowinteractclosed.window

Function window.window(x,y,wid,hei,style.guidesign,font,activate,title$,control=0,move=1,resize=0,buttons=0,header=1,show=1,lock=0,minwid=-1,minhei=-1,maxwid=-1,maxhei=-1,areax1=-1,areay1=-1,areawid=-1,areahei=-1)
If style=Null Then Return
w.window=New window
w\x=x
w\y=y
w\wid=wid
w\hei=hei
w\style=style.guidesign
w\font=font
w\activate=activate
w\title$=title$

w\control=control
If w\control=4 Then header=0
w\move=move
w\resize=resize
w\buttons=buttons
w\header=header
w\show=show
w\lock=lock

w\minwid=minwid
w\minhei=minhei
w\maxwid=maxwid
w\maxhei=maxhei

w\areax1=areax1
w\areay1=areay1
w\areawid=areawid
w\areahei=areahei


If w\minwid>-1
If w\wid<w\minwid Then w\wid=w\minwid
EndIf
If w\minhei>-1
If w\hei<w\minhei Then w\hei=w\minhei
EndIf
If w\maxwid>-1
If w\wid>w\maxwid Then w\wid=w\maxwid
EndIf
If w\maxhei>-1
If w\hei>w\maxhei Then w\hei=w\maxhei
EndIf

SetFont font
w\headhei=FontHeight()+4

If w\control=3 Or w\control=4 Then windowtoback(w)


Return w
End Function

Function windowgettitle$(w.window)
If w=Null Then Return
Return w\title$
End Function

Function windowsettitle(w.window,title$)
If w=Null Then Return
w\title$=title$
End Function

Function windowinfronttest(w.window,w2.window)
If w=Null Or w2=Null Then Return
For d.window=Each window
If d=w Then Return False
If d=w2 Then Return True
Next
End Function


Function windowlock(w.window)
If w=Null Then Return
w\lock=1
End Function

Function windowunlock(w.window)
If w=Null Then Return
w\lock=0
End Function

Function windowlocked(w.window)
If w=Null Then Return
Return w\lock=1
End Function



Function windowtoback(w.window)
If w=Null Then Return
Insert w Before First window
For wn.window=Each window
If wn\control=3 And w\control=4 Then Insert wn Before First window
Next
End Function

Function windowtofront(w.window)
If w=Null Then Return
If w\control=3 Or w\control=4 Then Return
Insert w After Last window
End Function

Function windowshow(w.window)
If w=Null Then Return
w\show=1
End Function

Function windowhide(w.window)
If w=Null Then Return
w\show=0
End Function

Function windowhidden(w.window)
If w=Null Then Return
Return w\show=0
End Function

Function windowmove(w.window,x,y)
If w=Null Then Return
w\x=x
w\y=y
End Function

Function windowsize(w.window,wid,hei)
If w=Null Then Return
If wid<1 Then wid=1
If hei<1 Then hei=1
w\wid=wid
w\hei=hei
End Function

Function windowx(w.window)
If w=Null Then Return
Return w\x
End Function

Function windowy(w.window)
If w=Null Then Return
Return w\y
End Function

Function windowwidth(w.window)
If w=Null Then Return
Return w\wid
End Function

Function windowheight(w.window)
If w=Null Then Return
Return w\hei
End Function

Function windowinback(w.window)
If w=Null Then Return
Return w=First window 
End Function

Function windowinfront(w.window)
If w=Null Then Return
Return w=Last window 
End Function

Function windowdelete(w.window)
If w=Null Then Return
For g.gadget=Each gadget
If g\window=w Then Delete g
Next
Delete w
gadgetinteractstate=0

windowinteractstate=0
End Function

Function windowexists(w.window)
If w<>Null Then Return True Else Return False
End Function

Function windowcheckifclosed(w.window)
If w=Null Then Return
t=w\closed
w\closed=0
Return t
End Function

Function windowclosed.window()
w.window=windowinteractclosed
windowinteractclosed=Null
Return w
End Function

Function windowsetarea(w.window,x=0,y=0,wid=-1,hei=-1)
If w=Null Then Return
If wid=-1 Then wid=GraphicsWidth()
If hei=-1 Then wid=GraphicsHeight()
w\areax1=x
w\areay1=y
w\areawid=wid
w\areahei=hei
If w\areawid<>-1 And w\areahei<>-1

If w\x<w\areax1 Then w\x=w\areax1
If w\y<w\areay1 Then w\y=w\areay1
If w\x+w\wid>w\areax1+w\areawid Then w\x=(w\areax1+w\areawid)-w\wid
If w\y+w\hei>w\areay1+w\areahei Then w\y=(w\areay1+w\areahei)-w\hei

If w\x+w\wid>w\areax1+w\areawid Then w\x=(w\areax1+w\areawid)-w\wid
If w\y+w\hei>w\areay1+w\areahei Then w\y=(w\areay1+w\areahei)-w\hei


EndIf
End Function

Function windowsetareaall(x=0,y=0,wid=-1,hei=-1)
If wid=-1 Then wid=GraphicsWidth()
If hei=-1 Then wid=GraphicsHeight()
For w.window=Each window
w\areax1=x
w\areay1=y
w\areawid=wid
w\areahei=hei
If w\areawid<>-1 And w\areahei<>-1

If w\x<w\areax1 Then w\x=w\areax1
If w\y<w\areay1 Then w\y=w\areay1
If w\x+w\wid>w\areax1+w\areawid Then w\x=(w\areax1+w\areawid)-w\wid
If w\y+w\hei>w\areay1+w\areahei Then w\y=(w\areay1+w\areahei)-w\hei

If w\x+w\wid>w\areax1+w\areawid Then w\x=(w\areax1+w\areawid)-w\wid
If w\y+w\hei>w\areay1+w\areahei Then w\y=(w\areay1+w\areahei)-w\hei

EndIf
Next
End Function

Function windowcleararea(w.window)
If w=Null Then Return
w\areax1=-1
w\areay1=-1
w\areawid=-1
w\areahei=-1
End Function

Function windowclearareaall()
For w.window=Each window
w\areax1=-1
w\areay1=-1
w\areawid=-1
w\areahei=-1
Next
End Function

Function windowsetdesign(w.window,d.guidesign,gadgets=0)
If w=Null Or d=Null Then Return
w\style=d
If gadgets
	For g.gadget=Each gadget
		If g\window=w
			gadgetsetdesign(g,d)
		EndIf
	Next
EndIf
End Function

Function windowhit.window(x,y,wid,hei)
w.window=Last window

While w<>Null

If RectsOverlap(x,y,wid,hei,w\x,w\y,w\wid,w\hei) And w\show=1 Then Return w

w=Before w


Wend

End Function

Function windowwherehit(w.window,x,y,wid,hei,dx=8,dy=8)
If w=Null Then Return


;w.window=Last window
;While w<>Null
If w\show=1
If w\header


;closecorner
he=w\headhei-2
If w\buttons=1 Or w\buttons=3
If RectsOverlap(x,y,wid,hei,w\x+6,w\y+6,he,he) Then Return 10 ;close button
EndIf

If w\buttons=2 Or w\buttons=3
cx=w\x+w\wid-he-6
If RectsOverlap(x,y,wid,hei,cx,w\y+6,he,he) Then Return 11 ;to front/back button
EndIf



If RectsOverlap(x,y,wid,hei,w\x+4,w\y+4,w\wid-8,w\headhei) Then Return 1
Else
If RectsOverlap(x,y,wid,hei,w\x+4,w\y+4,w\wid-8,8) Then Return 1
EndIf

If RectsOverlap(x,y,wid,hei,w\x+dx,w\y,w\wid-dx Shl 1,dy) Then Return 2
If RectsOverlap(x,y,wid,hei,w\x+w\wid-dx,w\y,dx,dy) Then Return 3
If RectsOverlap(x,y,wid,hei,w\x+w\wid-dx,w\y+dy,dx,w\hei-dy Shl 1) Then Return 4
If RectsOverlap(x,y,wid,hei,w\x+w\wid-dx,w\y+w\hei-dy,dx,dy) Then Return 5
If RectsOverlap(x,y,wid,hei,w\x+dx,w\y+w\hei-dy,w\wid-dx Shl 1,dy) Then Return 6
If RectsOverlap(x,y,wid,hei,w\x,w\y+w\hei-dy,dx,dy) Then Return 7
If RectsOverlap(x,y,wid,hei,w\x,w\y+dy,dx,w\hei-dy Shl 1) Then Return 8
If RectsOverlap(x,y,wid,hei,w\x,w\y,dy,dx) Then Return 9
EndIf

;w=Before w
;Wend

Return 0

End Function

Function windowdisablehelp()
windowhelpon=0
End Function

Function windowenablehelp()
windowhelpon=1:gadgetinteracthelptime=MilliSecs()+windowhelpdelay
End Function

Function windowsethelpdelay(millisek=2000)
windowhelpdelay=millisek
End Function


Function windowdrawall(x=0,y=0,wid=0,hei=0,buffer=0)
;If buffer=0 Then Return
If wid=0 Or hei=0
wid=GraphicsWidth()
hei=GraphicsHeight()
EndIf

If buffer<>0
buffermem=GraphicsBuffer()
SetBuffer buffer
EndIf
Viewport x,y,wid,hei

For w.window=Each window
If w\show

If w\control<>4


d.guidesign=w\style

If windowinteract<>w ;w\activate=0

Viewport w\x,w\y,w\wid+1,w\hei+1
If d\typ=0
Color d\r[0],d\g[0],d\b[0]
Rect w\x,w\y,w\wid,w\hei    ; background
Else
Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
If d\image[1]=0
TileImage d\image[0],w\x,w\y,4
Else
TileImage d\image[1],w\x,w\y
EndIf



EndIf

If d\bimage[0]
TileImage d\bimage[0],w\x+d\bimagexoff[0],w\y+d\bimageyoff[0]
EndIf

If d\typ=0

Color d\r[1],d\g[1],d\b[1]
Rect w\x,w\y,w\wid,1        ; top
Color d\r[2],d\g[2],d\b[2]
Rect w\x+w\wid,w\y,1,w\hei+1  ; right
Color d\r[3],d\g[3],d\b[3]
Rect w\x,w\y+w\hei,w\wid,1  ; bottom
Color d\r[4],d\g[4],d\b[4]
Rect w\x,w\y,1,w\hei        ; left
Color d\r[5],d\g[5],d\b[5]
Rect w\x+1,w\y+1,w\wid-2,1        ; top
Color d\r[6],d\g[6],d\b[6]
Rect w\x+w\wid-1,w\y+1,1,w\hei-1  ; right
Color d\r[7],d\g[7],d\b[7]
Rect w\x+1,w\y+w\hei-1,w\wid-1,1  ; bottom
Color d\r[8],d\g[8],d\b[8]
Rect w\x+1,w\y+1,1,w\hei-2        ; left


Else



Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,1
Viewport w\x-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,3
Viewport w\x+w\wid-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x+w\wid,w\y,5
Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y+w\hei-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y+w\hei,7

Viewport x,y,wid,hei
DrawImage d\image[0],w\x,w\y,0
DrawImage d\image[0],w\x+w\wid,w\y,2
DrawImage d\image[0],w\x,w\y+w\hei,6
DrawImage d\image[0],w\x+w\wid,w\y+w\hei,8




EndIf






If w\header

If w\font Then SetFont w\font:w\headhei=FontHeight()

gadgetdrawinwindow(w,w\x+2,w\y+w\headhei+8,w\wid-4,w\hei-(w\headhei+10))

If d\typ=0
Color d\r[13],d\g[13],d\b[13]
Rect w\x+4,w\y+5,w\wid-8,w\headhei+1

Else

If d\image[5]<>0
Viewport w\x+4,w\y+5,w\wid-8,w\headhei+1
TileImage d\image[5],w\x+4,w\y+5,4
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,1
Viewport w\x+4-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,3
Viewport w\x+4+w\wid-8-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4+w\wid-8,w\y+5,5
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5+w\headhei-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5+w\headhei+1,7

Viewport x,y,wid,hei
DrawImage d\image[5],w\x+4,w\y+5,0
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5,2
DrawImage d\image[5],w\x+4,w\y+5+w\headhei+1,6
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5+w\headhei+1,8
EndIf




EndIf


Viewport w\x+4,w\y+5,w\wid-8,w\headhei
If d\himage[0]
TileImage d\himage[0],w\x+4+d\himagexoff[0],w\y+5+d\himageyoff[0]
EndIf
Color d\r[14],d\g[14],d\b[14]
Text w\x+w\wid Shr 1,w\y+5,w\title$,1,0        ; title text
windowdrawwindowbuttons(w)

If d\typ=0
Viewport x,y,wid,hei

Color d\r[9],d\g[9],d\b[9]
Rect w\x+4,w\y+4,w\wid-8,1        		; top
Color d\r[10],d\g[10],d\b[10]
Rect w\x+w\wid-4,w\y+4,1,w\headhei+3  ; right
Color d\r[11],d\g[11],d\b[11]
Rect w\x+4,w\y+6+w\headhei,w\wid-8,1  ; bottom
Color d\r[12],d\g[12],d\b[12]
Rect w\x+4,w\y+4,1,w\headhei+2        ; left

EndIf


Else

gadgetdrawinwindow(w,w\x+2,w\y+2,w\wid-4,w\hei-4)


EndIf



Else



;Color d\r2[0],d\g2[0],d\b2[0]
;Rect w\x,w\y,w\wid,w\hei    ; background

If d\typ=0
Viewport w\x,w\y,w\wid+1,w\hei+1
Color d\r2[0],d\g2[0],d\b2[0]
Rect w\x,w\y,w\wid,w\hei    ; background
Else
Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])

If d\image[1]=0
TileImage d\image[0],w\x,w\y,13
Else
TileImage d\image[1],w\x,w\y
EndIf

EndIf

If d\bimage[1]
TileImage d\bimage[1],w\x+d\bimagexoff[1],w\y+d\bimageyoff[1]
EndIf



If d\typ=0

Color d\r2[1],d\g2[1],d\b2[1]
Rect w\x,w\y,w\wid,1        ; top
Color d\r2[2],d\g2[2],d\b2[2]
Rect w\x+w\wid,w\y,1,w\hei+1  ; right
Color d\r2[3],d\g2[3],d\b2[3]
Rect w\x,w\y+w\hei,w\wid,1  ; bottom
Color d\r2[4],d\g2[4],d\b2[4]
Rect w\x,w\y,1,w\hei        ; left
Color d\r2[5],d\g2[5],d\b2[5]
Rect w\x+1,w\y+1,w\wid-2,1        ; top
Color d\r2[6],d\g2[6],d\b2[6]
Rect w\x+w\wid-1,w\y+1,1,w\hei-1  ; right
Color d\r2[7],d\g2[7],d\b2[7]
Rect w\x+1,w\y+w\hei-1,w\wid-1,1  ; bottom
Color d\r2[8],d\g2[8],d\b2[8]
Rect w\x+1,w\y+1,1,w\hei-2        ; left




Else



Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,10
Viewport w\x-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,12
Viewport w\x+w\wid-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x+w\wid,w\y,14
Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y+w\hei-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y+w\hei,16

Viewport x,y,wid,hei
DrawImage d\image[0],w\x,w\y,9
DrawImage d\image[0],w\x+w\wid,w\y,11
DrawImage d\image[0],w\x,w\y+w\hei,15
DrawImage d\image[0],w\x+w\wid,w\y+w\hei,17




EndIf



















If w\header

If w\font Then SetFont w\font:w\headhei=FontHeight()

gadgetdrawinwindow(w,w\x+2,w\y+w\headhei+8,w\wid-4,w\hei-(w\headhei+10))


If d\typ=0
Color d\r2[13],d\g2[13],d\b2[13]
Rect w\x+4,w\y+5,w\wid-8,w\headhei+1

Else

If d\image[5]<>0
Viewport w\x+4,w\y+5,w\wid-8,w\headhei+1
TileImage d\image[5],w\x+4,w\y+5,13
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,10
Viewport w\x+4-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,12
Viewport w\x+4+w\wid-8-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4+w\wid-8,w\y+5,14
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5+w\headhei-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5+w\headhei+1,16

Viewport x,y,wid,hei
DrawImage d\image[5],w\x+4,w\y+5,9
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5,11
DrawImage d\image[5],w\x+4,w\y+5+w\headhei+1,15
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5+w\headhei+1,17
EndIf








EndIf



Viewport w\x+4,w\y+5,w\wid-8,w\headhei
If d\himage[1]
TileImage d\himage[1],w\x+4+d\himagexoff[1],w\y+5+d\himageyoff[1]
EndIf
Color d\r2[14],d\g2[14],d\b2[14]
Text w\x+w\wid/2,w\y+5,w\title$,1,0        ; title text
windowdrawwindowbuttons(w)

If d\typ=0
Viewport x,y,wid,hei
Color d\r2[9],d\g2[9],d\b2[9]
Rect w\x+4,w\y+4,w\wid-8,1        		; top
Color d\r2[10],d\g2[10],d\b2[10]
Rect w\x+w\wid-4,w\y+4,1,w\headhei+3  ; right
Color d\r2[11],d\g2[11],d\b2[11]
Rect w\x+4,w\y+6+w\headhei,w\wid-8,1  ; bottom
Color d\r2[12],d\g2[12],d\b2[12]
Rect w\x+4,w\y+4,1,w\headhei+2        ; left

EndIf


Else


gadgetdrawinwindow(w,w\x+2,w\y+2,w\wid-4,w\hei-4)

EndIf






EndIf





Else

gadgetdrawinwindow(w,w\x,w\y,w\wid,w\hei)


EndIf




EndIf
Next

If gadgetinteracthelpon And windowhelpon And gadgetinteracthelpgadget<>Null


SetFont gadgetinteracthelpgadget\font
wid=StringWidth(gadgetinteracthelptext$)+4
hei=StringHeight(gadgetinteracthelptext$)+4
x=gadgetinteracthelpx-wid Shr 1
y=gadgetinteracthelpy-hei

;Color gadgetinteracthelpstyle\r[0],gadgetinteracthelpstyle\g[0],gadgetinteracthelpstyle\b[0]
;Rect x,y,wid,hei

gadgetdrawborderback(x,y,wid,hei,gadgetinteracthelpgadget\style,0)
;Viewport x,y,wid,hei
Color gadgetinteracthelpgadget\style\r[14],gadgetinteracthelpgadget\style\g[14],gadgetinteracthelpgadget\style\b[14]
Text gadgetinteracthelpx,gadgetinteracthelpy-hei+2,gadgetinteracthelptext$,1,0

If MouseX()<>gadgetinteracthelpx Or MouseY()<>gadgetinteracthelpy Or MouseDown(1) Or MouseDown(2) Or MouseDown(3) Or MouseZSpeed()<>0 Then gadgetinteracthelpon=0:gadgetinteracthelptime=MilliSecs()+windowhelpdelay

EndIf

If buffer<>0
SetBuffer buffermem
EndIf
Viewport 0,0,GraphicsWidth(),GraphicsHeight()
End Function



Function windowdraw(w.window,x,y,wid,hei,buffer)
If buffer=0 Or w=Null Then Return

buffermem=GraphicsBuffer()
SetBuffer buffer
Viewport x,y,wid,hei

If w\show


d.guidesign=w\style

If windowinteract<>w ;w\activate=0
Viewport w\x,w\y,w\wid+1,w\hei+1
If d\typ=0
Color d\r[0],d\g[0],d\b[0]
Rect w\x,w\y,w\wid,w\hei    ; background
Else

If d\image[1]=0
TileImage d\image[0],w\x,w\y,4
Else
TileImage d\image[1],w\x,w\y
EndIf

EndIf

If d\bimage[0]
TileImage d\bimage[0],w\x+d\bimagexoff[0],w\y+d\bimageyoff[0]
EndIf


If d\typ=0

Color d\r[1],d\g[1],d\b[1]
Rect w\x,w\y,w\wid,1        ; top
Color d\r[2],d\g[2],d\b[2]
Rect w\x+w\wid,w\y,1,w\hei+1  ; right
Color d\r[3],d\g[3],d\b[3]
Rect w\x,w\y+w\hei,w\wid,1  ; bottom
Color d\r[4],d\g[4],d\b[4]
Rect w\x,w\y,1,w\hei        ; left
Color d\r[5],d\g[5],d\b[5]
Rect w\x+1,w\y+1,w\wid-2,1        ; top
Color d\r[6],d\g[6],d\b[6]
Rect w\x+w\wid-1,w\y+1,1,w\hei-1  ; right
Color d\r[7],d\g[7],d\b[7]
Rect w\x+1,w\y+w\hei-1,w\wid-1,1  ; bottom
Color d\r[8],d\g[8],d\b[8]
Rect w\x+1,w\y+1,1,w\hei-2        ; left



Else



Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,1
Viewport w\x-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,3
Viewport w\x+w\wid-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x+w\wid,w\y,5
Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y+w\hei-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y+w\hei,7

Viewport x,y,wid,hei
DrawImage d\image[0],w\x,w\y,0
DrawImage d\image[0],w\x+w\wid,w\y,2
DrawImage d\image[0],w\x,w\y+w\hei,6
DrawImage d\image[0],w\x+w\wid,w\y+w\hei,8




EndIf








If w\header

If w\font Then SetFont w\font:w\headhei=FontHeight()

gadgetdrawinwindow(w,w\x+2,w\y+w\headhei+8,w\wid-4,w\hei-(w\headhei+10))


If d\typ=0
Color d\r[13],d\g[13],d\b[13]
Rect w\x+4,w\y+5,w\wid-8,w\headhei+1

Else

If d\image[5]<>0
Viewport w\x+4,w\y+5,w\wid-8,w\headhei+1
TileImage d\image[5],w\x+4,w\y+5,4
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,1
Viewport w\x+4-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,3
Viewport w\x+4+w\wid-8-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4+w\wid-8,w\y+5,5
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5+w\headhei-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5+w\headhei+1,7

Viewport x,y,wid,hei
DrawImage d\image[5],w\x+4,w\y+5,0
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5,2
DrawImage d\image[5],w\x+4,w\y+5+w\headhei+1,6
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5+w\headhei+1,8
EndIf




EndIf


Viewport w\x+4,w\y+5,w\wid-8,w\headhei
If d\himage[0]
TileImage d\himage[0],w\x+4+d\himagexoff[0],w\y+5+d\himageyoff[0]
EndIf
Color d\r[14],d\g[14],d\b[14]
Text w\x+w\wid Shr 1,w\y+5,w\title$,1,0        ; title text
windowdrawwindowbuttons(w)

If d\typ=0
Viewport x,y,wid,hei
Color d\r[9],d\g[9],d\b[9]
Rect w\x+4,w\y+4,w\wid-8,1        		; top
Color d\r[10],d\g[10],d\b[10]
Rect w\x+w\wid-4,w\y+4,1,w\headhei+3  ; right
Color d\r[11],d\g[11],d\b[11]
Rect w\x+4,w\y+6+w\headhei,w\wid-8,1  ; bottom
Color d\r[12],d\g[12],d\b[12]
Rect w\x+4,w\y+4,1,w\headhei+2        ; left
EndIf



Else

gadgetdrawinwindow(w,w\x+2,w\y+2,w\wid-4,w\hei-4)


EndIf



Else



Viewport w\x,w\y,w\wid+1,w\hei+1
If d\typ=0
Color d\r[0],d\g[0],d\b[0]
Rect w\x,w\y,w\wid,w\hei    ; background
Else

If d\image[1]=0
TileImage d\image[0],w\x,w\y,4
Else
TileImage d\image[1],w\x,w\y
EndIf

EndIf

If d\bimage[1]
TileImage d\bimage[1],w\x+d\bimagexoff[1],w\y+d\bimageyoff[1]
EndIf



If d\typ=0

Color d\r2[1],d\g2[1],d\b2[1]
Rect w\x,w\y,w\wid,1        ; top
Color d\r2[2],d\g2[2],d\b2[2]
Rect w\x+w\wid,w\y,1,w\hei+1  ; right
Color d\r2[3],d\g2[3],d\b2[3]
Rect w\x,w\y+w\hei,w\wid,1  ; bottom
Color d\r2[4],d\g2[4],d\b2[4]
Rect w\x,w\y,1,w\hei        ; left
Color d\r2[5],d\g2[5],d\b2[5]
Rect w\x+1,w\y+1,w\wid-2,1        ; top
Color d\r2[6],d\g2[6],d\b2[6]
Rect w\x+w\wid-1,w\y+1,1,w\hei-1  ; right
Color d\r2[7],d\g2[7],d\b2[7]
Rect w\x+1,w\y+w\hei-1,w\wid-1,1  ; bottom
Color d\r2[8],d\g2[8],d\b2[8]
Rect w\x+1,w\y+1,1,w\hei-2        ; left


Else



Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,10
Viewport w\x-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y,12
Viewport w\x+w\wid-ImageWidth(d\image[0]) Shr 1,w\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),w\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],w\x+w\wid,w\y,14
Viewport w\x+ImageWidth(d\image[0]) Shr 1,w\y+w\hei-ImageHeight(d\image[0]) Shr 1,w\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],w\x,w\y+w\hei,16

Viewport x,y,wid,hei
DrawImage d\image[0],w\x,w\y,9
DrawImage d\image[0],w\x+w\wid,w\y,11
DrawImage d\image[0],w\x,w\y+w\hei,15
DrawImage d\image[0],w\x+w\wid,w\y+w\hei,17




EndIf






If w\header

If w\font Then SetFont w\font:w\headhei=FontHeight()

gadgetdrawinwindow(w,w\x+2,w\y+w\headhei+8,w\wid-4,w\hei-(w\headhei+10))


If d\typ=0
Color d\r2[13],d\g2[13],d\b2[13]
Rect w\x+4,w\y+5,w\wid-8,w\headhei+1

Else

If d\image[5]<>0
Viewport w\x+4,w\y+5,w\wid-8,w\headhei+1
TileImage d\image[5],w\x+4,w\y+5,13
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,10
Viewport w\x+4-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5,12
Viewport w\x+4+w\wid-8-ImageWidth(d\image[5]) Shr 1,w\y+5+ImageHeight(d\image[5]) Shr 1,ImageWidth(d\image[5]),w\headhei+1-ImageHeight(d\image[5])
TileImage d\image[5],w\x+4+w\wid-8,w\y+5,14
Viewport w\x+4+ImageWidth(d\image[5]) Shr 1,w\y+5+w\headhei-ImageHeight(d\image[5]) Shr 1,w\wid-8+1-ImageWidth(d\image[5]),ImageHeight(d\image[5])
TileImage d\image[5],w\x+4,w\y+5+w\headhei+1,16

Viewport x,y,wid,hei
DrawImage d\image[5],w\x+4,w\y+5,9
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5,11
DrawImage d\image[5],w\x+4,w\y+5+w\headhei+1,15
DrawImage d\image[5],w\x+4+w\wid-8,w\y+5+w\headhei+1,17
EndIf




EndIf



Viewport w\x+4,w\y+5,w\wid-8,w\headhei
If d\himage[1]
TileImage d\himage[1],w\x+4+d\himagexoff[1],w\y+5+d\himageyoff[1]
EndIf
Color d\r2[14],d\g2[14],d\b2[14]
Text w\x+w\wid/2,w\y+5,w\title$,1,0        ; title text
windowdrawwindowbuttons(w)

If d\typ=0
Viewport x,y,wid,hei

Color d\r2[9],d\g2[9],d\b2[9]
Rect w\x+4,w\y+4,w\wid-8,1        		; top
Color d\r2[10],d\g2[10],d\b2[10]
Rect w\x+w\wid-4,w\y+4,1,w\headhei+3  ; right
Color d\r2[11],d\g2[11],d\b2[11]
Rect w\x+4,w\y+6+w\headhei,w\wid-8,1  ; bottom
Color d\r2[12],d\g2[12],d\b2[12]
Rect w\x+4,w\y+4,1,w\headhei+2        ; left
EndIf



Else


gadgetdrawinwindow(w,w\x+2,w\y+2,w\wid-4,w\hei-4)

EndIf






EndIf











EndIf


If gadgetinteracthelpon And windowhelpon And gadgetinteracthelpgadget<>Null

SetFont gadgetinteracthelpgadget\font
wid=StringWidth(gadgetinteracthelptext$)+4
hei=StringHeight(gadgetinteracthelptext$)+4
x=gadgetinteracthelpx-wid Shr 1
y=gadgetinteracthelpy-hei

;Color gadgetinteracthelpstyle\r[0],gadgetinteracthelpstyle\g[0],gadgetinteracthelpstyle\b[0]
;Rect x,y,wid,hei

gadgetdrawborderback(x,y,wid,hei,gadgetinteracthelpgadget\style,0)
;Viewport x,y,wid,hei
Color gadgetinteracthelpgadget\style\r[14],gadgetinteracthelpgadget\style\g[14],gadgetinteracthelpgadget\style\b[14]
Text gadgetinteracthelpx,gadgetinteracthelpy-hei+2,gadgetinteracthelptext$,1,0

If MouseX()<>gadgetinteracthelpx Or MouseY()<>gadgetinteracthelpy Or MouseDown(1) Or MouseDown(2) Or MouseDown(3) Or MouseZSpeed()<>0 Then gadgetinteracthelpon=0:gadgetinteracthelptime=MilliSecs()+windowhelpdelay

EndIf



SetBuffer buffermem
Viewport 0,0,GraphicsWidth(),GraphicsHeight()
End Function

Function windowinteractstate()
Return windowinteractstate
End Function


Function windowinteractall(x=0,y=0,wid=0,hei=0)
If gadgetinteractscrollnum=1 Then Return
If gadgetinteractstate<>0 Then Return



If wid=0 Or hei=0
wid=GraphicsWidth()
hei=GraphicsWidth()
EndIf


winmx=MouseX()
winmy=MouseY()

If MouseDown(1) And RectsOverlap(winmx,winmy,1,1,x,y,wid,hei)


If windowinteractstate=0
w.window=windowhit(winmx,winmy,1,1)

If w<>Null 
If w\lock=0

If gadgetinteract<>Null 
	gadgetinteract\activate=0

	If gadgetinteract\typ=9
	gadgetsetviewsizefortexteditor(gadgetinteract,gadgetinteract\value$)
	EndIf

EndIf

gadgetinteractstate=0 ;gadgetinteractstate-1
gadgetinteract=Null

windowinteract=w
windowinteractx=w\x
windowinteracty=w\y
windowinteractwid=w\wid
windowinteracthei=w\hei
windowinteractright=winmx-w\x
windowinteractdown=winmy-w\y
windowinteractleft=((w\x+w\wid)-winmx)
windowinteractup=((w\y+w\hei)-winmy)

windowinteractstate=windowwherehit(w,winmx,winmy,1,1)

If w\control=1
windowtofront(w)
EndIf

If windowinteractstate=1

If w\control=0
windowtofront(w)
EndIf


For l.window=Each window
l\activate=0
Next
w\activate=1
EndIf


EndIf
EndIf

Else

If windowinteractstate>1 And windowinteractstate<10 
If windowinteract\resize=0 Then windowinteractstate=0
EndIf

Select windowinteractstate

Case 1

If windowinteract\move
windowinteract\x=winmx-windowinteractright
windowinteract\y=winmy-windowinteractdown

If windowinteract\areawid<>-1 And windowinteract\areahei<>-1

If windowinteract\x<windowinteract\areax1 Then windowinteract\x=windowinteract\areax1
If windowinteract\y<windowinteract\areay1 Then windowinteract\y=windowinteract\areay1
If windowinteract\x+windowinteract\wid>windowinteract\areax1+windowinteract\areawid Then windowinteract\x=(windowinteract\areax1+windowinteract\areawid)-windowinteract\wid
If windowinteract\y+windowinteract\hei>windowinteract\areay1+windowinteract\areahei Then windowinteract\y=(windowinteract\areay1+windowinteract\areahei)-windowinteract\hei

EndIf


EndIf

Case 2
windowinteract\y=winmy-windowinteractdown
windowinteract\hei=windowinteracthei+(windowinteracty-winmy)+windowinteractdown

Case 3
windowinteract\wid=(winmx-windowinteract\x)+windowinteractleft
windowinteract\y=winmy-windowinteractdown
windowinteract\hei=windowinteracthei+(windowinteracty-winmy)+windowinteractdown
Case 4

windowinteract\wid=(winmx-windowinteract\x)+windowinteractleft

Case 5
windowinteract\wid=(winmx-windowinteract\x)+windowinteractleft
windowinteract\hei=(winmy-windowinteract\y)+windowinteractup

Case 6
windowinteract\hei=(winmy-windowinteract\y)+windowinteractup

Case 7
windowinteract\x=winmx-windowinteractright
windowinteract\wid=windowinteractwid+(windowinteractx-winmx)+windowinteractright
windowinteract\hei=(winmy-windowinteract\y)+windowinteractup


Case 8
windowinteract\x=winmx-windowinteractright
windowinteract\wid=windowinteractwid+(windowinteractx-winmx)+windowinteractright


Case 9

windowinteract\x=winmx-windowinteractright
windowinteract\wid=windowinteractwid+(windowinteractx-winmx)+windowinteractright
windowinteract\y=winmy-windowinteractdown
windowinteract\hei=windowinteracthei+(windowinteracty-winmy)+windowinteractdown

Case 10
;close button pressed

Case 11


End Select

If windowinteractstate>1 And windowinteractstate<10
If windowinteract\minwid>-1
If windowinteract\wid<windowinteract\minwid Then windowinteract\wid=windowinteract\minwid
EndIf
If windowinteract\minhei>-1
If windowinteract\hei<windowinteract\minhei Then windowinteract\hei=windowinteract\minhei
EndIf
If windowinteract\maxwid>-1
If windowinteract\wid>windowinteract\maxwid Then windowinteract\wid=windowinteract\maxwid
EndIf
If windowinteract\maxhei>-1
If windowinteract\hei>windowinteract\maxhei Then windowinteract\hei=windowinteract\maxhei
EndIf

If windowinteract\areawid<>-1 And windowinteract\areahei<>-1

If windowinteract\x<windowinteract\areax1 Then windowinteract\x=windowinteract\areax1
If windowinteract\y<windowinteract\areay1 Then windowinteract\y=windowinteract\areay1
If windowinteract\x+windowinteract\wid>windowinteract\areax1+windowinteract\areawid Then windowinteract\wid=(windowinteract\areax1+windowinteract\areawid)-windowinteract\x ;-windowinteract\wid
If windowinteract\y+windowinteract\hei>windowinteract\areay1+windowinteract\areahei Then windowinteract\hei=(windowinteract\areay1+windowinteract\areahei)-windowinteract\y ;-windowinteract\hei

EndIf



For g.gadget=Each gadget
If g\window=windowinteract And g\scaleon

If g\scalex 

g\x=g\dx#*Float(windowinteract\wid)

EndIf

If g\scalew 

g\wid=g\dwid#*Float(windowinteract\wid)

EndIf

If g\scaleh 

g\hei=g\dhei#*Float(windowinteract\hei)

EndIf

If g\scaley 

g\y=g\dy#*Float(windowinteract\hei) 

EndIf












EndIf
Next

EndIf

If windowinteract<>Null
If windowinteract\wid<16 Then windowinteract\wid=16
If windowinteract\hei<windowinteract\headhei+9 Then windowinteract\hei=windowinteract\headhei+9
EndIf

EndIf

EndIf

If MouseDown(1)=False And windowinteractstate>0

windowinteractstate=windowwherehit(windowinteract,MouseX(),MouseY(),1,1)

If windowinteractstate=11
	If windowinteract\control<>3 And windowinteract\control<>4
		If windowinfront(windowinteract) Then windowtoback(windowinteract) Else windowtofront(windowinteract)
		;windowinteract=Null
	EndIf
EndIf

If windowinteractstate=10 Then windowinteract\closed=1:windowinteractclosed=windowinteract

windowinteractstate=0

EndIf




End Function




Function windowinteract(w.window,x,y,wid,hei)







End Function

Function windowdrawwindowbuttons(w.window)
d.guidesign=w\style

;closecorner
he=w\headhei-2
If w\buttons=1 Or w\buttons=3


	If windowinteract=w And windowinteractstate=10
	
		If d\typ=0
		Color d\r2[19],d\g2[19],d\b2[19]
		Rect w\x+6,w\y+6,he,he        		; main
		DrawImage d\cimage[1],w\x+7+he Shr 1,w\y+7+he Shr 1
		Color d\r2[15],d\g2[15],d\b2[15]
		Rect w\x+6,w\y+6,he,1        		; top
		Color d\r2[16],d\g2[16],d\b2[16]
		Rect w\x+6+he,w\y+6,1,he  ; right
		Color d\r2[17],d\g2[17],d\b2[17]
		Rect w\x+6,w\y+6+he,he+1,1  ; bottom
		Color d\r2[18],d\g2[18],d\b2[18]
		Rect w\x+6,w\y+6,1,he        ; left
		Else
		DrawImage d\image[0],w\x+7+he Shr 1,w\y+7+he Shr 1,23
		EndIf


	Else

		If d\typ=0
		Color d\r[19],d\g[19],d\b[19]
		Rect w\x+6,w\y+6,he,he        		; main
		DrawImage d\cimage[0],w\x+7+he Shr 1,w\y+7+he Shr 1
		Color d\r[15],d\g[15],d\b[15]
		Rect w\x+6,w\y+6,he,1        		; top
		Color d\r[16],d\g[16],d\b[16]
		Rect w\x+6+he,w\y+6,1,he  ; right
		Color d\r[17],d\g[17],d\b[17]
		Rect w\x+6,w\y+6+he,he+1,1  ; bottom
		Color d\r[18],d\g[18],d\b[18]
		Rect w\x+6,w\y+6,1,he        ; left
		Else
		DrawImage d\image[0],w\x+7+he Shr 1,w\y+7+he Shr 1,22
		EndIf
	
	
	EndIf

EndIf


If w\buttons=2 Or w\buttons=3

	cx=w\x+w\wid-he-6
	If windowinteract=w And windowinteractstate=11
	
		If d\typ=0
		Color d\r2[19],d\g2[19],d\b2[19]
		Rect cx,w\y+6,he,he        		; main
		DrawImage d\cimage[3],cx+he Shr 1,w\y+6+he Shr 1
		Color d\r2[15],d\g2[15],d\b2[15]
		Rect cx,w\y+6,he,1        		; top
		Color d\r2[16],d\g2[16],d\b2[16]
		Rect cx+he,w\y+6,1,he  ; right
		Color d\r2[17],d\g2[17],d\b2[17]
		Rect cx,w\y+6+he,he+1,1  ; bottom
		Color d\r2[18],d\g2[18],d\b2[18]
		Rect cx,w\y+6,1,he        ; left
		Else
		DrawImage d\image[0],cx+he Shr 1,w\y+6+he Shr 1,25
		EndIf
	
	Else
		If d\typ=0	
		Color d\r[19],d\g[19],d\b[19]
		Rect cx,w\y+6,he,he        		; main
		DrawImage d\cimage[2],cx+he Shr 1,w\y+6+he Shr 1
		Color d\r[15],d\g[15],d\b[15]
		Rect cx,w\y+6,he,1       ; top
		Color d\r[16],d\g[16],d\b[16]
		Rect cx+he,w\y+6,1,he  ; right
		Color d\r[17],d\g[17],d\b[17]
		Rect cx,w\y+6+he,he+1,1  ; bottom
		Color d\r[18],d\g[18],d\b[18]
		Rect cx,w\y+6,1,he        ; left
		Else
		DrawImage d\image[0],cx+he Shr 1,w\y+6+he Shr 1,24		
		EndIf
	
	EndIf

EndIf
End Function


Type gadget

Field x,y,wid,hei
Field place,tex$,style.guidesign
Field window.window
Field font
Field typ
Field show,lock
Field activate,release

Field inval$[10]


Field value$

Field xpos,ypos,xview,yview,viewwid,viewhei
Field fontwid,fonthei 


Field dx#,dy#,dwid#,dhei#
Field scaleon,scalex,scaley,scalew,scaleh

Field help$

Field target.gadget[4],settargettyp

End Type



Global gadgetinteractstate,gadgetinteract.gadget,gadgetinteractdelay,gadgetinteractx,gadgetinteracty,gadgetinteractx2,gadgetinteracty2,gadgetinteractxp#,gadgetinteractyp#
Global gadgetinteracthelpon,gadgetinteracthelptime,gadgetinteracthelpx,gadgetinteracthelpy,gadgetinteracthelptext$,gadgetinteracthelpgadget.gadget
Global gadgetinteracttimer,gadgetinteractmisc,gadgetinteractcycle,gadgetinteractscrollnum,gadgetinteractscrollgadget.gadget

Function gadgetinactive.gadget(g.gadget)
If g=gadgetinteract 
gadgetinteract\activate=0
gadgetinteract\release=1
If gadgetinteract\typ=9
gadgetsetviewsizefortexteditor(gadgetinteract,gadgetinteract\value$)
EndIf

gadgetinteractstate=0 ;gadgetinteractstate-1
gadgetinteract=Null
EndIf
End Function

Function gadgetactive.gadget()
Return gadgetinteract
End Function

;Function gadgetactivated(g.gadget)
;If g=Null Then Return
;Return g=gadgetinteract
;End Function

Function gadgetgetvalue$(g.gadget)
If g=Null Then Return
If g\typ<2
Return g\tex$
Else
Return g\value$
EndIf
End Function

Function gadgetsetvalue$(g.gadget,value$,updtar=0)
If g=Null Then Return
g\value$=value$



Select g\typ
Case 0,1
g\tex$=value$


Case 2
g\xpos=Len(g\value$)

Case 3
val#=g\value$
min#=g\inval$[1]
max#=g\inval$[2]
If min<>0 Or max<>0
If val#<min# Then g\value$=min#:g\xpos=Len(g\value$)
If val#>max# Then g\value$=max#:g\xpos=Len(g\value$)
EndIf
g\xpos=Len(g\value$)
Case 4
val=g\value$
min=g\inval$[1]
max=g\inval$[2]
If min<>0 Or max<>0
If val#<min Then g\value$=Int(min)
If val#>max Then g\value$=Int(max)
EndIf
g\xpos=Len(g\value$)

Case 7
g\inval$[4]=value$

Case 9,10

gadgetsetviewsizefortexteditor(g.gadget,value$)

;gadgetupdatetextselection$(g.gadget,value$)





End Select

If updtar=1 Then Return


gadgetupdatetarget(g)


End Function

Function gadgetmove(g.gadget,x,y)
If g=Null Then Return
g\x=x
g\y=y
End Function

Function gadgetsize(g.gadget,wid,hei)
If g=Null Then Return
g\wid=wid
g\hei=hei
End Function

Function gadgettoback(g.gadget)
If g=Null Then Return
Insert g Before First gadget
End Function

Function gadgettofront(g.gadget)
If g=Null Then Return
Insert g After Last gadget
End Function

Function gadgetdelete(g.gadget)
If g=Null Then Return
Delete g
gadgetinteractstate=0
End Function

Function gadgetexist(g.gadget)
If g<>Null Then Return True Else Return False
End Function

Function gadgetenablescale(g.gadget)
If g=Null Then Return
g\scaleon=1
End Function

Function gadgetdisablescale(g.gadget)
If g=Null Then Return
g\scaleon=0
End Function


Function gadgetx(g.gadget,globa=0)
If g=Null Then Return
If globa
Return g\window\x+g\x
Else
Return g\x
EndIf
End Function

Function gadgety(g.gadget,globa=0)
If g=Null Then Return
If globa
Return g\window\y+g\y
Else
Return g\y
EndIf
End Function

Function gadgetwidth(g.gadget)
If g=Null Then Return
Return g\wid
End Function

Function gadgetheight(g.gadget)
If g=Null Then Return
Return g\hei
End Function

Function gadgetsetdesign(g.gadget,d.guidesign)
If g=Null Then Return
g\style=d
End Function

Function gadgetsetimagepos(g.gadget,xpos#,ypos#)
If g=Null Then Return
If g\typ<>8 Then Return

image=g\inval$[0]
If xpos#<>-1
If (xpos#<=1 And xpos#>=0) 
g\xpos=(Float(xpos#)*Float(ImageWidth(image)-g\wid))
Else
g\xpos=xpos-((g\wid-4) Shr 1)
EndIf
EndIf

If ypos#<>-1
If (ypos#<=1 And ypos#>=0) 
g\ypos=(Float(ypos#)*Float(ImageHeight(image)-g\hei))
Else
g\ypos=ypos-((g\hei-4) Shr 1)
EndIf
EndIf

If g\xpos<0 Then g\xpos=0
If g\xpos>ImageWidth(image)-g\wid Then g\xpos=ImageWidth(image)-g\wid

If g\ypos<0 Then g\ypos=0
If g\ypos>ImageHeight(image)-g\hei Then g\ypos=ImageHeight(image)-g\hei

If ImageWidth(image)<=g\wid
g\xpos=((g\wid Shr 1)-2)-ImageWidth(image) Shr 1
EndIf

If ImageHeight(image)<=g\hei
g\ypos=((g\hei Shr 1)-2)-ImageHeight(image) Shr 1
EndIf


End Function

Function gadgetgetimagexpos#(g.gadget,n=0)
If g=Null Then Return
If g\typ<>8 Then Return

If g\style\typ=0
If n
	Return g\xpos
Else
	image=g\inval$[0]
	Return Float(g\xpos)/Float(ImageWidth(image)-g\wid)
	
EndIf

Else

If n
	Return g\xpos-6
Else
	image=g\inval$[0]
	Return Float(g\xpos)/Float(ImageWidth(image)-g\wid)-6
	
EndIf


EndIf

End Function

Function gadgetgetimageypos#(g.gadget,n=0)
If g=Null Then Return
If g\typ<>8 Then Return

If g\style\typ=0
If n
	Return g\ypos
Else
	image=g\inval$[0]
	Return Float(g\ypos)/Float(ImageHeight(image)-g\hei)
EndIf
Else
If n
	Return g\ypos-6
Else
	image=g\inval$[0]
	Return Float(g\ypos)/Float(ImageHeight(image)-g\hei)-6
EndIf


EndIf
End Function

Function gadgetchangeimage(g.gadget,newimage,frame=0)
If g=Null Then Return
If g\typ<>8 Then Return

g\ypos=0
g\xpos=0

g\inval$[0]=newimage
g\inval$[1]=frame

End Function



Function gadgetsettexteditorpos(g.gadget,xpos#,ypos#)
If g=Null Then Return
If g\typ<>9 And g\typ<>10 Then Return


If xpos#<>-1
If (xpos#<=1 And xpos#>=0) 
g\xview=(Float(xpos#)*Float(g\viewwid-g\wid))
Else
g\xview=xpos-((g\wid-4) Shr 1)
EndIf
EndIf

If ypos#<>-1
If (ypos#<=1 And ypos#>=0) 
g\yview=(Float(ypos#)*Float(g\viewhei-g\hei))
Else
g\yview=ypos-((g\hei-4) Shr 1)
EndIf
EndIf

If g\xview<0 Then g\xview=0
If g\xview>g\viewwid-g\wid Then g\xview=g\viewwid-g\wid

If g\yview<0 Then g\yview=0
If g\yview>g\viewhei-g\hei Then g\yview=g\viewhei-g\hei

If g\viewwid<=g\wid
g\xview=0
EndIf

If g\viewhei<=g\hei
g\yview=0
EndIf

End Function

Function gadgetgettexteditorxpos#(g.gadget,n=0)
If g=Null Then Return
If g\typ<>9 And g\typ<>10 Then Return

If n
	Return g\xview
Else
	Return Float(Abs(g\xview))/Float(Abs(g\wid-g\viewwid)+FontWidth())
	
EndIf

End Function

Function gadgetgettexteditorypos#(g.gadget,n=0)
If g=Null Then Return
If g\typ<>9 And g\typ<>10 Then Return

If n
	Return g\yview
Else
	Return Float(Abs(g\yview))/Float(Abs(g\hei-g\viewhei)+FontHeight())
	
EndIf

End Function

Function gadgetgettextselected$(g.gadget)
If g=Null Then Return
If g\typ<>7 And g\typ<>10 Then Return

Return g\inval$[3]
End Function

Function gadgetupdatetextselection$(g.gadget,intex$,selected=-1)
If g=Null Then Return
If g\typ<>10 Then Return
g\value$=selected
g\inval$[0]=intex$
;[1] is reserved
gadgetsetviewsizefortexteditor(g,g\inval$[0])

End Function



Function gadgethit.gadget(x,y,wid,hei,w.window,lock=0)
If w=Null
g.gadget=Last gadget
While g<>Null
If RectsOverlap(x,y,wid,hei,g\x+g\window\x,g\y+g\window\y,g\wid,g\hei) And g\show=1 And (g\lock=0 Or lock=1) Then Return g
g=Before g
Wend
Else
g.gadget=Last gadget
While g<>Null
If RectsOverlap(x,y,wid,hei,g\x+g\window\x,g\y+g\window\y,g\wid,g\hei) And g\window=w And g\show=1 And (g\lock=0 Or lock=1) Then Return g
g=Before g
Wend
EndIf
Return Null
End Function

Function gadgetoverlap(g1.gadget,g2.gadget)
If g1=Null Or g2=Null Then Return
Return RectsOverlap(g1\x,g1\y,g1\wid,g1\hei,g2\x,g2\y,g2\wid,g2\hei)
End Function

Function gadgetanyoverlapinwindow(w.window)
If w=Null
For g2.gadget=Each gadget
For g.gadget=Each gadget
If g2<>g
If RectsOverlap(g2\x,g2\y,g2\wid,g2\hei,g\x,g\y,g\wid,g\hei) Then Return True
EndIf
Next
Next
Else
For g2.gadget=Each gadget
For g.gadget=Each gadget
If g2<>g And g\window=w And g2\window=w
If RectsOverlap(g2\x,g2\y,g2\wid,g2\hei,g\x,g\y,g\wid,g\hei) Then Return True
EndIf
Next
Next
EndIf
End Function

Function gadgetinteractstate()
If gadgetinteract<>Null And gadgetinteractstate=0 Then Return 2
Return gadgetinteractstate
End Function

Function gadgetdrawborder(x,y,wid,hei,d.guidesign,act)

If act=0
Color d\r[32],d\g[32],d\b[32]
Rect x,y,wid,1        ; top
Color d\r[33],d\g[33],d\b[33]
Rect x+wid,y,1,hei+1  ; right
Color d\r[34],d\g[34],d\b[34]
Rect x,y+hei,wid,1  ; bottom
Color d\r[35],d\g[35],d\b[35]
Rect x,y,1,hei        ; left
Else
Color d\r2[32],d\g2[32],d\b2[32]
Rect x,y,wid,1        ; top
Color d\r2[33],d\g2[33],d\b2[33]
Rect x+wid,y,1,hei+1  ; right
Color d\r2[34],d\g2[34],d\b2[34]
Rect x,y+hei,wid,1  ; bottom
Color d\r2[35],d\g2[35],d\b2[35]
Rect x,y,1,hei        ; left

EndIf

End Function

Function gadgetdrawborderback(x,y,wid,hei,d.guidesign,act)

If act=0

Color d\r[36],d\g[36],d\b[36]
Rect x,y,wid,hei    ; background

Color d\r[32],d\g[32],d\b[32]
Rect x,y,wid,1        ; top
Color d\r[33],d\g[33],d\b[33]
Rect x+wid,y,1,hei+1  ; right
Color d\r[34],d\g[34],d\b[34]
Rect x,y+hei,wid,1  ; bottom
Color d\r[35],d\g[35],d\b[35]
Rect x,y,1,hei        ; left
Else

Color d\r2[36],d\g2[36],d\b2[36]
Rect x,y,wid,hei    ; background

Color d\r2[32],d\g2[32],d\b2[32]
Rect x,y,wid,1        ; top
Color d\r2[33],d\g2[33],d\b2[33]
Rect x+wid,y,1,hei+1  ; right
Color d\r2[34],d\g2[34],d\b2[34]
Rect x,y+hei,wid,1  ; bottom
Color d\r2[35],d\g2[35],d\b2[35]
Rect x,y,1,hei        ; left


EndIf

End Function

Function gadgetdraweyecandyborder(d.guidesign,x,y,wid,hei)
Origin 0,0
Viewport x+ImageWidth(d\image[0]) Shr 1,y+ImageHeight(d\image[0]) Shr 1,wid-ImageWidth(d\image[0]),hei-ImageHeight(d\image[0])
TileImage d\image[0],x,y,4
Viewport x+ImageWidth(d\image[0]) Shr 1,y-ImageHeight(d\image[0]) Shr 1,wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],x,y,1
Viewport x-ImageWidth(d\image[0]) Shr 1,y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),hei+1-ImageHeight(d\image[0])
TileImage d\image[0],x,y,3
Viewport x+wid-ImageWidth(d\image[0]) Shr 1,y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),hei+1-ImageHeight(d\image[0])
TileImage d\image[0],x+wid,y,5
Viewport x+ImageWidth(d\image[0]) Shr 1,y+hei-ImageHeight(d\image[0]) Shr 1,wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],x,y+hei,7

Viewport 0,0,GraphicsWidth(),GraphicsHeight()

DrawImage d\image[0],x,y,0
DrawImage d\image[0],x+wid,y,2
DrawImage d\image[0],x,y+hei,6
DrawImage d\image[0],x+wid,y+hei,8

End Function


Function gadgetsetviewsizefortexteditor(g.gadget,st$)

SetFont g\font

bn=0:nm=0
Repeat
hen2=Instr(st$,"|",nm+1)
hen=hen2-nm
te$=Mid$(st$,nm+1,hen-1)

;If (nm+Len(te$))>=g\xpos And vbn=0 Then g\ypos=bn:vbn=1:tex$=te$:hen3=nm

rt=StringWidth(te$)
If rt>viewwid Then viewwid=rt

nm=nm+hen
bn=bn+1

Until hen2=0

g\viewwid=viewwid+4
g\viewhei=bn*FontHeight()+4

maxline=g\inval$[0]

If maxline>=0
Return bn>=maxline
Else
Return False
EndIf

End Function

Function gadgetsettarget(g.gadget,target.gadget,settargettyp=0,gettargettyp=0)


g\target[gettargettyp]=target.gadget
g\settargettyp=settargettyp

End Function

Function gadgetupdatetarget(g.gadget)
If g=Null Then Return
If g\target[0]=Null And g\target[1]=Null And g\target[2]=Null And g\target[3]=Null Then Return 

For gettargettyp=0 To 4

If g\target[gettargettyp]<>Null

val$=g\value$

Select g\typ

Case 8

Select gettargettyp

Case 1
val$=gadgetgetimagexpos#(g,0)
Case 2
val$=gadgetgetimageypos#(g,0)
Case 3
val$=gadgetgetimagexpos#(g,1)
Case 4
val$=gadgetgetimageypos#(g,1)

End Select

Case 9,10

Select gettargettyp

Case 1
val$=gadgetgettexteditorxpos#(g,0)
Case 2
val$=gadgetgettexteditorypos#(g,0)
Case 3
val$=gadgetgettexteditorxpos#(g,1)
Case 4
val$=gadgetgettexteditorypos#(g,1)
Case 5
If g\typ=10 Then val$=gadgetgettextselected$(g)


End Select





End Select




Select g\target[gettargettyp]\typ

Case 0,1,2,3,5,6,7
gadgetsetvalue(g\target[gettargettyp],val$,1) 

Case 4
gadgetsetvalue(g\target[gettargettyp],Int(val$),1) 

Case 8

Select g\settargettyp
Case 0
;g\target[gettargettyp]\value$=val$
gadgetsetvalue(g\target[gettargettyp],val$,1) 
Case 1
gadgetsetimagepos(g\target[gettargettyp],val$,-1) ;gadgetgetimageypos#(g\target[gettargettyp]))
Case 2
gadgetsetimagepos(g\target[gettargettyp],-1,val$)
;gadgetsetimagepos(g\target[gettargettyp],gadgetgetimagexpos#(g\target[gettargettyp]),val$)

End Select



Case 9,10

Select g\settargettyp
Case 0
gadgetsetvalue(g\target[gettargettyp],val$,1) 
Case 1
gadgetsettexteditorpos(g\target[gettargettyp],val$,-1)
Case 2
gadgetsettexteditorpos(g\target[gettargettyp],-1,val$)

End Select


End Select

EndIf
Next

End Function


Function gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
If wid<1 Then wid=1
If hei<1 Then hei=1
g.gadget=New gadget
g\x=x
If w\header
g\y=y+w\headhei
Else
g\y=y
EndIf

g\wid=wid
g\hei=hei
g\tex$=tex$
g\place=place
g\style=style.guidesign
g\window=w
g\font=font
g\typ=typ
g\show=show
g\lock=lock

g\help$=help$

g\dx#=Float(g\x)/Float(g\window\wid-4)
g\dwid#=Float(g\wid)/Float(g\window\wid-4)

g\dy#=Float(g\y)/Float(g\window\hei-4)
g\dhei#=Float(g\hei)/Float(g\window\hei-4)







g\scaleon=scaleon
g\scalex=scalex
g\scaley=scaley
g\scalew=scalew
g\scaleh=scaleh

g\target[0]=Null


Return g

End Function



Function gadgetdraw(g.gadget,x,y,wid,hei,buffer)
If g=Null Or buffer=0 Then Return
buffermem=GraphicsBuffer()
SetBuffer buffer
Viewport x,y,wid,hei

d.guidesign=g\style

If g\activate=0


If d\typ=0
Color d\r[0],d\g[0],d\b[0]
Rect g\x,g\y,g\wid,g\hei    ; background
Else
Viewport g\x,g\y,g\wid,g\hei
TileImage d\image[0],g\x,g\y
EndIf



If d\bimage[0]
Viewport g\x,g\y,g\wid,g\hei
TileImage d\bimage[0],g\x+d\bimagexoff[0],g\y+d\bimageyoff[0]
Viewport x,y,wid,hei
EndIf



If d\typ=0

Color d\r[1],d\g[1],d\b[1]
Rect g\x,g\y,g\wid,1        ; top
Color d\r[2],d\g[2],d\b[2]
Rect g\x+g\wid,g\y,1,g\hei  ; right
Color d\r[3],d\g[3],d\b[3]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r[4],d\g[4],d\b[4]
Rect g\x,g\y,1,g\hei        ; left

Else


Viewport g\x+ImageWidth(d\image[0]) Shr 1,g\y-ImageHeight(d\image[0]) Shr 1,g\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y,1
Viewport g\x-ImageWidth(d\image[0]) Shr 1,g\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),g\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y,3
Viewport g\x+g\wid-ImageWidth(d\image[0]) Shr 1,g\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),g\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],g\x+g\wid,g\y,5
Viewport g\x+ImageWidth(d\image[0]) Shr 1,g\y+g\hei-ImageHeight(d\image[0]) Shr 1,g\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y+g\hei,7

Viewport x,y,wid,hei
DrawImage d\image[0],g\x,g\y,0
DrawImage d\image[0],g\x+g\wid,g\y,2
DrawImage d\image[0],g\x,g\y+g\hei,6
DrawImage d\image[0],g\x+g\wid,g\y+g\hei,8


EndIf










Else
Color d\r2[0],d\g2[0],d\b2[0]
Rect g\x,g\y,g\wid,g\hei    ; background

If d\bimage[1]
Viewport g\x,g\y,g\wid,g\hei
TileImage d\bimage[1],g\x+d\bimagexoff[1],g\y+d\bimageyoff[1]
Viewport x,y,wid,hei
EndIf

Color d\r2[1],d\g2[1],d\b2[1]
Rect g\x,g\y,g\wid,1        ; top
Color d\r2[2],d\g2[2],d\b2[2]
Rect g\x+g\wid,g\y,1,g\hei  ; right
Color d\r2[3],d\g2[3],d\b2[3]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r2[4],d\g2[4],d\b2[4]
Rect g\x,g\y,1,g\hei        ; left



EndIf

Select g\typ
















End Select

SetBuffer buffermem
Viewport 0,0,GraphicsWidth(),GraphicsHeight()
End Function



Function gadgetdrawinwindow(w.window,x,y,wid,hei)
If w=Null Then Return

Viewport x,y,wid,hei
Origin w\x,w\y

For g.gadget=Each gadget
If g\show And g\window=w
Viewport x,y,wid,hei

If g\font Then SetFont g\font

d.guidesign=g\style.guidesign

If gadgetinteract<>g  ;g\activate=0


If g\typ<>0 And g\typ<>12


If d\typ=0

Color d\r[29],d\g[29],d\b[29]
Rect g\x,g\y,g\wid,g\hei    ; background

Else

Viewport w\x+g\x+ImageWidth(d\image[0]) Shr 1,w\y+g\y+ImageHeight(d\image[0]) Shr 1,g\wid-ImageWidth(d\image[0]),g\hei-ImageHeight(d\image[0])


If d\image[1]=0
TileImage d\image[0],g\x+g\wid Shr 1-g\xview,g\y+g\hei Shr 1-g\yview,4
Else
TileImage d\image[1],g\x+g\wid Shr 1-g\xview,g\y+g\hei Shr 1-g\yview
EndIf



EndIf



If d\gimage[0]
wi=g\wid
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2

Viewport w\x+g\x,w\y+g\y,wi,he
TileImage d\gimage[0],g\x+d\gimagexoff[0],g\y+d\gimageyoff[0]
EndIf
EndIf

;Color d\r[13],d\b[13],d\g[13]
;Rect g\x+4,g\y+5,g\wid-8,FontHeight()
;Viewport g\x+4,g\y+5,g\wid-8,FontHeight()
;If d\himage[0]
;TileImage d\himage[0],g\x+4+d\himagexoff[0],g\y+5+d\himageyoff[0]
;EndIf




If (g\typ<>0 And g\typ<>11)  ;Or (g\typ=11 And d\typ=1)


If d\typ=0

Color d\r[21],d\g[21],d\b[21]
Rect g\x,g\y,g\wid,1        ; top
Color d\r[22],d\g[22],d\b[22]
Rect g\x+g\wid,g\y,1,g\hei+1  ; right
Color d\r[23],d\g[23],d\b[23]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r[24],d\g[24],d\b[24]
Rect g\x,g\y,1,g\hei        ; left
Color d\r[25],d\g[25],d\b[25]
Rect g\x+1,g\y+1,g\wid-2,1        ; top
Color d\r[26],d\g[26],d\b[26]
Rect g\x+g\wid-1,g\y+1,1,g\hei-1  ; right
Color d\r[27],d\g[27],d\b[27]
Rect g\x+1,g\y+g\hei-1,g\wid-1,1  ; bottom
Color d\r[28],d\g[28],d\b[28]
Rect g\x+1,g\y+1,1,g\hei-2        ; left



Else


Viewport w\x+g\x+ImageWidth(d\image[0]) Shr 1,w\y+g\y-ImageHeight(d\image[0]) Shr 1,g\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y,1
Viewport w\x+g\x-ImageWidth(d\image[0]) Shr 1,w\y+g\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),g\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y,3
Viewport w\x+g\x+g\wid-ImageWidth(d\image[0]) Shr 1,w\y+g\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),g\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],g\x+g\wid,g\y,5
Viewport w\x+g\x+ImageWidth(d\image[0]) Shr 1,w\y+g\y+g\hei-ImageHeight(d\image[0]) Shr 1,g\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y+g\hei,7

Viewport x,y,wid,hei
DrawImage d\image[0],g\x,g\y,0
DrawImage d\image[0],g\x+g\wid,g\y,2
DrawImage d\image[0],g\x,g\y+g\hei,6
DrawImage d\image[0],g\x+g\wid,g\y+g\hei,8


EndIf















;Color d\r[9],d\b[9],d\g[9]
;Rect g\x+4,g\y+4,g\wid-8,1        		; top
;Color d\r[10],d\b[10],d\g[10]
;Rect g\x+g\wid-4,g\y+4,1,FontHeight()+3  ; right
;Color d\r[11],d\b[11],d\g[11]
;Rect g\x+4,g\y+6+FontHeight(),g\wid-8,1  ; bottom
;Color d\r[12],d\b[12],d\g[12]
;Rect g\x+4,g\y+4,1,FontHeight()+2        ; left

EndIf


Viewport x,y,wid,hei

Color d\r[30],d\g[30],d\b[30]
Select g\place
Case 0
wi=g\wid
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x,w\y+g\y,wi,he
Text g\x+g\wid Shr 1,g\y+g\hei Shr 1,g\tex$,1,1 
Viewport x,y,wid,hei
Case 1
Text g\x+g\wid Shr 1,g\y-2-StringHeight(g\tex$),g\tex$,1,0
Case 2
Text g\x+g\wid+2,g\y+g\hei Shr 1,g\tex$,0,1
Case 3
Text g\x+g\wid Shr 1,g\y+g\hei+2,g\tex$,1,0
Case 4
Text g\x-2-StringWidth(g\tex$),g\y+g\hei Shr 1,g\tex$,0,1

End Select










Else



If g\typ<>0 And g\typ<>12

If d\typ=0
Color d\r2[29],d\g2[29],d\b2[29]
Rect g\x,g\y,g\wid,g\hei    ; background

Else


Viewport w\x+g\x+ImageWidth(d\image[0]) Shr 1,w\y+g\y+ImageHeight(d\image[0]) Shr 1,g\wid-ImageWidth(d\image[0]),g\hei-ImageHeight(d\image[0])

If d\image[1]=0
TileImage d\image[0],g\x+g\wid Shr 1-g\xview,g\y+g\hei Shr 1-g\yview,13
Else
TileImage d\image[1],g\x+g\wid Shr 1-g\xview,g\y+g\hei Shr 1-g\yview
EndIf


EndIf





If d\gimage[0]
wi=g\wid
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2

Viewport w\x+g\x,w\y+g\y,wi,he
TileImage d\gimage[0],g\x+d\gimagexoff[0],g\y+d\gimageyoff[0]
EndIf
EndIf
;Color d\r2[13],d\b2[13],d\g2[13]
;Rect g\x+4,g\y+5,g\wid-8,FontHeight()
;Viewport g\x+4,g\y+5,g\wid-8,FontHeight()
;If d\himage[0]
;TileImage d\himage[0],g\x+4+d\himagexoff[0],g\y+5+d\himageyoff[0]
;EndIf



If (g\typ<>0 And g\typ<>11 And g\typ<>12)  ;Or (g\typ=11 And d\typ=1)


If d\typ=0

Color d\r2[21],d\g2[21],d\b2[21]
Rect g\x,g\y,g\wid,1        ; top
Color d\r2[22],d\g2[22],d\b2[22]
Rect g\x+g\wid,g\y,1,g\hei+1  ; right
Color d\r2[23],d\g2[23],d\b2[23]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r2[24],d\g2[24],d\b2[24]
Rect g\x,g\y,1,g\hei        ; left
Color d\r2[25],d\g2[25],d\b2[25]
Rect g\x+1,g\y+1,g\wid-2,1        ; top
Color d\r2[26],d\g2[26],d\b2[26]
Rect g\x+g\wid-1,g\y+1,1,g\hei-1  ; right
Color d\r2[27],d\g2[27],d\b2[27]
Rect g\x+1,g\y+g\hei-1,g\wid-1,1  ; bottom
Color d\r2[28],d\g2[28],d\b2[28]
Rect g\x+1,g\y+1,1,g\hei-2        ; left

;Color d\r2[9],d\b2[9],d\g2[9]
;Rect g\x+4,g\y+4,g\wid-8,1        		; top
;Color d\r2[10],d\b2[10],d\g2[10]
;Rect g\x+g\wid-4,g\y+4,1,FontHeight()+3  ; right
;Color d\r2[11],d\b2[11],d\g2[11]
;Rect g\x+4,g\y+6+FontHeight(),g\wid-8,1  ; bottom
;Color d\r2[12],d\b2[12],d\g2[12]
;Rect g\x+4,g\y+4,1,FontHeight()+2        ; left


Else


Viewport w\x+g\x+ImageWidth(d\image[0]) Shr 1,w\y+g\y-ImageHeight(d\image[0]) Shr 1,g\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y,10
Viewport w\x+g\x-ImageWidth(d\image[0]) Shr 1,w\y+g\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),g\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y,12
Viewport w\x+g\x+g\wid-ImageWidth(d\image[0]) Shr 1,w\y+g\y+ImageHeight(d\image[0]) Shr 1,ImageWidth(d\image[0]),g\hei+1-ImageHeight(d\image[0])
TileImage d\image[0],g\x+g\wid,g\y,14
Viewport w\x+g\x+ImageWidth(d\image[0]) Shr 1,w\y+g\y+g\hei-ImageHeight(d\image[0]) Shr 1,g\wid+1-ImageWidth(d\image[0]),ImageHeight(d\image[0])
TileImage d\image[0],g\x,g\y+g\hei,16

Viewport x,y,wid,hei
DrawImage d\image[0],g\x,g\y,9
DrawImage d\image[0],g\x+g\wid,g\y,11
DrawImage d\image[0],g\x,g\y+g\hei,15
DrawImage d\image[0],g\x+g\wid,g\y+g\hei,17


EndIf



















EndIf


Viewport x,y,wid,hei

Color d\r2[30],d\g2[30],d\b2[30]
Select g\place
Case 0
wi=g\wid
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x,w\y+g\y,wi,he
Text g\x+g\wid Shr 1,g\y+g\hei Shr 1,g\tex$,1,1
Viewport x,y,wid,hei 
Case 1
Text g\x+g\wid Shr 1,g\y-2-StringHeight(g\tex$),g\tex$,1,0
Case 2
Text g\x+g\wid+2,g\y+g\hei Shr 1,g\tex$,0,1
Case 3
Text g\x+g\wid Shr 1,g\y+g\hei+2,g\tex$,1,0
Case 4
Text g\x-2-StringWidth(g\tex$),g\y+g\hei Shr 1,g\tex$,0,1

End Select





EndIf


Select g\typ

Case 2,3,4 ; text boxes

wi=g\wid
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x+2,w\y+g\y+2,wi-3,he-3

on=g\inval$[3]

If gadgetinteract=g And on<2

xhen=g\x+g\wid Shr 1-StringWidth(g\value$) Shr 1+StringWidth(Left$(g\value$,g\xpos))
If xhen>g\x+g\wid-FontWidth() Then xhen=g\x+g\wid-FontWidth():xhen2=(StringWidth(g\value$) Shr 1-g\wid Shr 1)+FontWidth()-StringWidth(Right$(g\value$,Len(g\value$)-g\xpos))

Color d\r2[37],d\g2[37],d\b2[37]
Rect xhen,g\y+g\hei Shr 1-FontHeight() Shr 1,4,FontHeight()

EndIf

If gadgetinteract=g Then Color d\r2[31],d\g2[31],d\b2[31] Else Color d\r[31],d\g[31],d\b[31]

Text g\x+g\wid Shr 1-xhen2,g\y+g\hei Shr 1,g\value$,1,1


Viewport x,y,wid,hei 



;scroller.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,value,min,max,ste,size)
Case 5  ; horizontal scroller

wi=g\wid-2
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x+1,w\y+g\y,wi,he

swi=g\inval$[3]

If gadgetinteract=g
	If d\typ=0

		gadgetdrawborderback(g\x+g\xpos+2,g\y+2,swi,g\hei-4,g\style,1)

	Else
		Viewport x,y,wid,hei
		DrawImage d\image[0],g\x+g\xpos+2+swi Shr 1,g\y+2+(g\hei-4) Shr 1,19
	
	EndIf

Else

val#=g\value$
tem1#=g\inval$[0]
tem2#=g\inval$[1]
siz=g\inval$[3]
g\xpos=Float(val#)/(Float( Float(Abs(tem2#-tem1#)) / Float(g\wid-siz-4) ))

;val#=Float(g\xpos)*Float( Float(Abs(tem2-tem1)) / Float(g\wid-siz-4) )

	If d\typ=0
	
		gadgetdrawborderback(g\x+g\xpos+2,g\y+2,swi,g\hei-4,g\style,0)
	
	Else
		Viewport x,y,wid,hei
		DrawImage d\image[0],g\x+g\xpos+2+swi Shr 1,g\y+2+(g\hei-4) Shr 1,18
	
	EndIf
	




EndIf


Viewport x,y,wid,hei 


Case 6  ; vertical scroller

wi=g\wid-2
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x+1,w\y+g\y,wi,he

swi=g\inval$[3]

If gadgetinteract=g

	If d\typ=0

		gadgetdrawborderback(g\x+2,g\y+g\ypos+2,g\wid-4,swi,g\style,1)

	Else
		Viewport x,y,wid,hei
		DrawImage d\image[0],g\x+2+(g\wid-4) Shr 1,g\y+g\ypos+2+(swi Shr 1),19
	
	EndIf

Else

val#=g\value$
tem1#=g\inval$[0]
tem2#=g\inval$[1]
siz=g\inval$[3]
g\ypos=Float(val)/(Float( Float(Abs(tem2#-tem1#)) / Float(g\hei-siz-4) ))

;val#=Float(g\xpos)*Float( Float(Abs(tem2-tem1)) / Float(g\wid-siz-4) )

	If d\typ=0

		gadgetdrawborderback(g\x+2,g\y+g\ypos+2,g\wid-4,swi,g\style,0)

	Else
		Viewport x,y,wid,hei
		DrawImage d\image[0],g\x+2+(g\wid-4) Shr 1,g\y+g\ypos+2+(swi Shr 1),18
	
	EndIf

EndIf


Viewport x,y,wid,hei 



Case 7 ; cycle gadget


If MouseDown(1) 

If g\inval$[4]<>-1 
g\value$=g\inval$[4]

g\activate=0
g\release=1
g\inval$[4]=-1

EndIf


EndIf

val=g\value$
bn=0:nm=0
Repeat
hen2=Instr(g\inval$[0],"|",nm+1)
hen=hen2-nm
te$=Mid$(g\inval$[0],nm+1,hen-1)
If val=bn Then tex$=te$:g\inval$[3]=te$
nm=nm+hen
bn=bn+1
Until hen2=0


wi=g\wid-2
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x+1,w\y+g\y,wi,he

If gadgetinteract=g Then Color d\r2[31],d\g2[31],d\b2[31] Else Color d\r[31],d\g[31],d\b[31]
Text g\x+g\wid Shr 1,g\y+g\hei Shr 1,tex$,1,1


If gadgetinteract=g
gadgetinteractx=bn


wi=g\wid
he=bn*FontHeight()+4

;If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
;If g\y+g\hei+he>w\hei-2 Then he=w\hei-g\y-g\hei-2

If d\typ=0
Viewport w\x+g\x,w\y+g\y+g\hei,wi,he
;Viewport 0,0,800,600
gadgetdrawborderback(g\x+1,g\y+g\hei+1,g\wid-2,he-2,g\style,1)

Else


.heeeeeeeeeeeeerrrrr

gadgetdraweyecandyborder(d,w\x+g\x+1,w\y+g\y+g\hei+1,g\wid-2,he-2)
Origin w\x,w\y


EndIf






Viewport w\x+g\x+2,w\y+g\y+g\hei+1,wi-3,he-2
val2=g\inval$[4]
bn=0:nm=0
Repeat
hen2=Instr(g\inval$[0],"|",nm+1)
hen=hen2-nm
te$=Mid$(g\inval$[0],nm+1,hen-1)
If bn=val
Color d\r2[37],g\style\g2[37],g\style\b2[37]
If d\typ=1
Viewport w\x+g\x+8,w\y+g\y+g\hei+bn*FontHeight()+1,g\wid-16,FontHeight()-2
TileImage d\image[0],g\x+4,g\y+g\hei+bn*FontHeight()+2,26
Viewport w\x+g\x+2,w\y+g\y+g\hei+1,wi-3,he-2
EndIf
Else
If bn=val2
Color d\r2[31],d\g2[31],d\b2[31]
If d\typ=1
Viewport w\x+g\x+8,w\y+g\y+g\hei+bn*FontHeight()+1,g\wid-16,FontHeight()-2
TileImage d\image[0],g\x+4,g\y+g\hei+bn*FontHeight()+2,26
Viewport w\x+g\x+2,w\y+g\y+g\hei+1,wi-3,he-2
EndIf

Else
Color d\r2[38],d\g2[38],d\b2[38]
EndIf

EndIf
Text g\x+g\wid Shr 1,g\y+g\hei+bn*FontHeight(),te$,1,0

;If RectsOverlap(mx,my,1,1,x,y+hei+bn*FontHeight(),wid,FontHeight())
;Rect x+1,y+hei+bn*FontHeight(),wid-2,FontHeight(),0
;If mb=1 Then se=bn:guion=-1:selectiondown=0:mb=2
;EndIf

nm=nm+hen
bn=bn+1

Until hen2=0




End If

Viewport x,y,wid,hei


Case 8 ; image gadget

ima=g\inval$[0]:fra=g\value$
If d\typ=0
CopyRect g\xpos,g\ypos,g\wid-4,g\hei-4,g\x+2,g\y+2,ImageBuffer(ima,fra)
Else
CopyRect g\xpos,g\ypos,g\wid-12,g\hei-12,g\x+6,g\y+6,ImageBuffer(ima,fra)
EndIf

bnm=g\inval$[1]
If gadgetinteract=g And MouseDown(1) And bnm

wi=g\wid
he=g\hei
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x,w\y+g\y,wi,he


Color gadgetinteract\style\r2[37],gadgetinteract\style\g2[37],gadgetinteract\style\b2[37]
Line gadgetinteractx2-g\window\x,gadgetinteracty2-g\window\y,MouseX()-g\window\x,MouseY()-g\window\y


EndIf


;g\inval$[1]=drag
;g\inval$[2]=xpos#
;g\inval$[3]=ypos#
;If (xpos#<1 Or xpos#>0) (ypos#<1 And ypos#>0) Then g\inval$[4]=1 Else g\inval$[4]=0



Case 9 ; editor text

wi=g\wid-4
he=g\hei-4
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x+2,w\y+g\y+2,wi,he


If gadgetinteract=g Then Color d\r2[31],d\g2[31],d\b2[31] Else Color d\r[31],d\g[31],d\b[31]

bn=0:nm=0:vbn=0:hen3=0:vbn2=0
Repeat
hen2=Instr(g\value$,"|",nm+1)
hen=hen2-nm
te$=Mid$(g\value$,nm+1,hen-1)



If (nm+Len(te$))>=g\xpos And vbn=0 Then g\ypos=bn:vbn=1:tex$=te$:hen3=nm


If ydraw=>-FontHeight() And vbn2=0 Then vbn2=1:g\inval$[1]=bn


ydraw=bn*FontHeight()-g\yview
If ydraw>-FontHeight()
Text g\x+2-g\xview,g\y+2+ydraw,te$,0,0
EndIf
If ydraw>g\hei Then Exit

nm=nm+hen
bn=bn+1

Until hen2=0


;If xhen>g\wid-FontWidth() Then xhen=g\wid-FontWidth():xhen2=-StringWidth(Right$(te$,Len(te$)-g\xpos))






If gadgetinteract=g




ydraw=g\ypos*FontHeight()



	
xhen=StringWidth(Left$(tex$,g\xpos-hen3))

If KeyHit(207) Then g\xpos=hen3+Len(tex$)
If KeyHit(199) Then g\xpos=hen3
	
If gadgetinteractmisc

	gadgetinteractmisc=0
	
	If ydraw+FontHeight()>g\hei+g\yview Then g\yview=g\ypos*FontHeight()-g\hei+FontHeight()
	If ydraw<g\yview Then g\yview=g\ypos*FontHeight()
	If xhen+FontWidth()>g\wid+g\xview Then g\xview=xhen-g\wid+FontWidth()
	If xhen<g\xview Then g\xview=xhen

EndIf

Color d\r2[37],d\g2[37],d\b2[37]

Rect g\x+2+xhen-g\xview,g\y+2+ydraw-g\yview,4,FontHeight()

EndIf

Case 10 ; selection text

wi=g\wid-4
he=g\hei-4
If g\x+wi>w\wid-2 Then wi=w\wid-g\x-2
If g\y+he>w\hei-2 Then he=w\hei-g\y-2
Viewport w\x+g\x+2,w\y+g\y+2,wi,he



val=g\value$

cen=g\inval$[2]
half=g\wid Shr 1
bn=0:nm=0:vbn=0:hen3=0
Repeat
hen2=Instr(g\inval$[0],"|",nm+1)
hen=hen2-nm
te$=Mid$(g\inval$[0],nm+1,hen-1)


;If (nm+Len(te$))>=g\xpos And vbn=0 Then g\ypos=bn:vbn=1:tex$=te$:hen3=nm

ydraw=bn*FontHeight()-g\yview


If ydraw=>-FontHeight() And vbn=0 Then vbn=1:g\inval$[1]=bn


If val=bn
g\inval$[3]=te$


If d\typ=0
gadgetdrawborderback(g\x+2-g\xview,g\y+2+ydraw,g\wid-4,FontHeight(),g\style,1)

Else



wi2=g\wid-4
he2=FontHeight()
sty=w\y+g\y+2+ydraw
dow=(w\y+g\y+2)-sty
If sty<w\y+g\y+2 Then sty=w\y+g\y+2:he2=he2-dow

by=w\y+g\y+g\hei-2
If sty+he2>by Then he2=by-sty

Viewport w\x+g\x+2-g\xview,sty,g\wid-4,he2
TileImage d\image[0],g\x+2-g\xview,g\y+2+ydraw+FontHeight() Shr 1,26




Viewport w\x+g\x+2,w\y+g\y+2,wi,he







EndIf




Color d\r2[37],d\g2[37],d\b2[37]
Else
Color d\r2[38],d\g2[38],d\b2[38]
EndIf




If ydraw>-FontHeight()
If cen
Text g\x+4-g\xview+half,g\y+2+ydraw,te$,1,0
Else
Text g\x+4-g\xview,g\y+2+ydraw,te$,0,0
EndIf

EndIf

If ydraw>g\hei Then Exit

nm=nm+hen
bn=bn+1

Until hen2=0


Case 11 ; checkbox

If d\typ=0
If g\value=0

Color d\r[21],d\g[21],d\b[21]
Rect g\x,g\y,g\wid,1        ; top
Color d\r[22],d\g[22],d\b[22]
Rect g\x+g\wid,g\y,1,g\hei+1  ; right
Color d\r[23],d\g[23],d\b[23]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r[24],d\g[24],d\b[24]
Rect g\x,g\y,1,g\hei        ; left
Color d\r[25],d\g[25],d\b[25]
Rect g\x+1,g\y+1,g\wid-2,1        ; top
Color d\r[26],d\g[26],d\b[26]
Rect g\x+g\wid-1,g\y+1,1,g\hei-1  ; right
Color d\r[27],d\g[27],d\b[27]
Rect g\x+1,g\y+g\hei-1,g\wid-1,1  ; bottom
Color d\r[28],d\g[28],d\b[28]
Rect g\x+1,g\y+1,1,g\hei-2        ; left


Else


Color d\r2[21],d\g2[21],d\b2[21]
Rect g\x,g\y,g\wid,1        ; top
Color d\r2[22],d\g2[22],d\b2[22]
Rect g\x+g\wid,g\y,1,g\hei+1  ; right
Color d\r2[23],d\g2[23],d\b2[23]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r2[24],d\g2[24],d\b2[24]
Rect g\x,g\y,1,g\hei        ; left
Color d\r2[25],d\g2[25],d\b2[25]
Rect g\x+1,g\y+1,g\wid-2,1        ; top
Color d\r2[26],d\g2[26],d\b2[26]
Rect g\x+g\wid-1,g\y+1,1,g\hei-1  ; right
Color d\r2[27],d\g2[27],d\b2[27]
Rect g\x+1,g\y+g\hei-1,g\wid-1,1  ; bottom
Color d\r2[28],d\g2[28],d\b2[28]
Rect g\x+1,g\y+1,1,g\hei-2        ; left
Color d\r2[31],d\g2[31],d\b2[31]
Oval g\x+g\wid Shr 1-3,g\y+g\hei Shr 1-3,6,6


EndIf


Else


If g\value=0 Then DrawImage d\image[0],g\x+g\wid Shr 1,g\y+g\hei Shr 1,20 Else DrawImage d\image[0],g\x+g\wid Shr 1,g\y+g\hei Shr 1,21


EndIf




Case 12 ; border

If g\value=0

Color d\r[21],d\g[21],d\b[21]
Rect g\x,g\y,g\wid,1        ; top
Color d\r[22],d\g[22],d\b[22]
Rect g\x+g\wid,g\y,1,g\hei+1  ; right
Color d\r[23],d\g[23],d\b[23]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r[24],d\g[24],d\b[24]
Rect g\x,g\y,1,g\hei        ; left
Color d\r[25],d\g[25],d\b[25]
Rect g\x+1,g\y+1,g\wid-2,1        ; top
Color d\r[26],d\g[26],d\b[26]
Rect g\x+g\wid-1,g\y+1,1,g\hei-1  ; right
Color d\r[27],d\g[27],d\b[27]
Rect g\x+1,g\y+g\hei-1,g\wid-1,1  ; bottom
Color d\r[28],d\g[28],d\b[28]
Rect g\x+1,g\y+1,1,g\hei-2        ; left


Else

Color d\r2[21],d\g2[21],d\b2[21]
Rect g\x,g\y,g\wid,1        ; top
Color d\r2[22],d\g2[22],d\b2[22]
Rect g\x+g\wid,g\y,1,g\hei+1  ; right
Color d\r2[23],d\g2[23],d\b2[23]
Rect g\x,g\y+g\hei,g\wid,1  ; bottom
Color d\r2[24],d\g2[24],d\b2[24]
Rect g\x,g\y,1,g\hei        ; left
Color d\r2[25],d\g2[25],d\b2[25]
Rect g\x+1,g\y+1,g\wid-2,1        ; top
Color d\r2[26],d\g2[26],d\b2[26]
Rect g\x+g\wid-1,g\y+1,1,g\hei-1  ; right
Color d\r2[27],d\g2[27],d\b2[27]
Rect g\x+1,g\y+g\hei-1,g\wid-1,1  ; bottom
Color d\r2[28],d\g2[28],d\b2[28]
Rect g\x+1,g\y+1,1,g\hei-2        ; left

EndIf



End Select

EndIf
Next


Viewport 0,0,GraphicsWidth(),GraphicsHeight()
Origin 0,0
End Function


Function gadgetinteractall(x=0,y=0,wid=0,hei=0)

If wid=0 Or hei=0
wid=GraphicsWidth()
hei=GraphicsWidth()
EndIf



If windowinteractstate<>0 Then Return
winmx=MouseX()
winmy=MouseY()


If gadgetinteractstate=0 And windowhelpon=1
	
	If gadgetinteracthelpon=False
	
		If MilliSecs()>gadgetinteracthelptime
		
			If RectsOverlap(winmx,winmy,1,1,x,y,wid,hei) And MouseXSpeed()=0 And MouseYSpeed()=0
			
			
			wq.window=windowhit(winmx,winmy,1,1)
			
			
			If wq<>Null 
				If wq\lock=0
				gq.gadget=gadgethit(winmx,winmy,1,1,wq)
				
				
					If gq<>Null 
					If gq\help$<>""
					
					gadgetinteracthelpx=winmx
					gadgetinteracthelpy=winmy
					gadgetinteracthelpon=1
					gadgetinteracthelptext$=gq\help$
					gadgetinteracthelpgadget=gq
					;gadgetinteracthelpstyle=gq\style
					;gadgetinteracthelpfont=gq\font
					
					EndIf
					EndIf
								
				EndIf
				
			EndIf
			
			
			
			EndIf
		
		gadgetinteracthelptime=MilliSecs()+windowhelpdelay
		
		EndIf
	
			
	EndIf

EndIf

If MouseDown(1)=False Then gadgetinteractcycle=0



If MouseDown(1) And RectsOverlap(winmx,winmy,1,1,x,y,wid,hei) 


If gadgetinteractstate=0 

w.window=windowhit(winmx,winmy,1,1)


If w<>Null 
If w\lock=0
g.gadget=gadgethit(winmx,winmy,1,1,w)


If g<>Null And gadgetinteractcycle=0 

;If g\show=1



If g\typ=2 Or g\typ=3 Or g\typ=4 Or g\typ=9 Then FlushKeys()

typegad=g\typ
gadgetinteractstate=1
gadgetinteract=g
gadgettofront(g)
g\release=0
g\activate=1
gadgetinteractdelay=0


gadgetinteractx=(winmx-(g\window\x+g\x+2+g\xpos))
gadgetinteracty=(winmy-(g\window\y+g\y+2+g\ypos))
gadgetinteractx2=winmx
gadgetinteracty2=winmy
gadgetinteractxp#=g\xpos
gadgetinteractyp#=g\ypos

If gadgetinteract\typ=9
gadgetsetviewsizefortexteditor(gadgetinteract,gadgetinteract\value$)



val2=gadgetinteract\inval$[1]

off=(val2*FontHeight())-gadgetinteract\yview

tal=(winmy-(gadgetinteract\y+gadgetinteract\window\y+off+2))/FontHeight()+val2

;gadgetinteract\value$=val
num=0:yes=0
For nm=1 To Len(gadgetinteract\value$)
b$=Mid$(gadgetinteract\value$,nm,1)
If b$="|" Then num=num+1:If num=tal Then gadgetinteract\xpos=nm:gadgetinteract\ypos=num:yes=1:Exit
Next
If yes=0 Then gadgetinteract\xpos=0:gadgetinteract\ypos=0



EndIf

;EndIf

Else

If gadgetinteract<>Null 

gadgetinteract\activate=0
gadgetinteract\release=1

If gadgetinteract\typ=9
gadgetsetviewsizefortexteditor(gadgetinteract,gadgetinteract\value$)
EndIf


EndIf

gadgetinteractstate=0 ;gadgetinteractstate-1
gadgetinteract=Null


EndIf
EndIf

Else

If gadgetinteract<>Null 
gadgetinteract\activate=0
gadgetinteract\release=1
If gadgetinteract\typ=9
gadgetsetviewsizefortexteditor(gadgetinteract,gadgetinteract\value$)
EndIf

EndIf

gadgetinteractstate=0 ;gadgetinteractstate-1
gadgetinteract=Null


EndIf


EndIf


EndIf

;If MouseDown(1)=False And gadgetinteractstate=2 
;gadgetinteractstate=0
;If gadgetinteract<>Null Then gadgetinteract\activate=0
;gadgetinteract=Null
;EndIf




;test=MouseDown(1)=False Or (typegad=3 Or typegad=4)

If gadgetinteractscrollnum=1 Then gadgetinteract=gadgetinteractscrollgadget ;:test=1
;If  gadgetinteract<>Null 

If gadgetinteract<>Null 
If gadgetinteract\typ=3 Or gadgetinteract\typ=4 Or MouseDown(1)=False

If gadgetinteractdelay>0 
gadgetinteractstate=0




If gadgetinteract<>Null
gadgetupdatetarget(gadgetinteract)
EndIf


Select gadgetinteract\typ

Case 0
gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null

Case 1
gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null

Case 2
g=gadgetinteract
maxchar=g\inval$[0]
ltr = GetKey()										
;If ltr > 46 And ltr < 123
If ltr > 31 And ltr < 255 And Len(g\value$)<maxchar
g\value$=Left$(g\value$,g\xpos)+Chr$(ltr)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos+1
EndIf

If KeyDown(14) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+100
;If Len(te\t$)=0 Then bn.tex=Before te: :If bn<>Null Then Delete te : yt=yt-1:xt=Len(bn\t$):If yt<0 : yt=0 : EndIf :Exit

If Len(g\value$)>0 And g\xpos>0
g\value$=Left$(g\value$,g\xpos-1)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos-1
EndIf
EndIf

If KeyDown(211) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+100

If Len(g\value$)>0 And g\xpos<Len(g\value$)
g\value$=Left$(g\value$,g\xpos)+Right$(g\value$,Len(g\value$)-g\xpos-1)
EndIf
EndIf

If KeyHit(207) Then g\xpos=Len(g\value$)
If KeyHit(199) Then g\xpos=0
If KeyHit(203) Then g\xpos=g\xpos-1:If g\xpos<0 Then g\xpos=0
If KeyHit(205) Then g\xpos=g\xpos+1:If g\xpos>Len(g\value$) Then g\xpos=Len(g\value$)

If KeyHit(28)
gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null
EndIf

Case 3
g=gadgetinteract

on=g\inval$[3]
;***************
If on<2
maxchar=255
ltr = GetKey()	
If Len(g\value$)<maxchar				
If (ltr > 47 And ltr < 58) Or ltr=46 Or ltr=45
g\value$=Left$(g\value$,g\xpos)+Chr$(ltr)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos+1
EndIf
EndIf

If KeyHit(14)
If Len(g\value$)>0 And g\xpos>0
g\value$=Left$(g\value$,g\xpos-1)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos-1
EndIf
EndIf

If KeyHit(211)
If Len(g\value$)>0 And g\xpos<Len(g\value$)
g\value$=Left$(g\value$,g\xpos)+Right$(g\value$,Len(g\value$)-g\xpos-1)
EndIf
EndIf

If KeyHit(207) Then g\xpos=Len(g\value$)
If KeyHit(199) Then g\xpos=0
If KeyHit(203) Then g\xpos=g\xpos-1:If g\xpos<0 Then g\xpos=0
If KeyHit(205) Then g\xpos=g\xpos+1:If g\xpos>Len(g\value$) Then g\xpos=Len(g\value$)




If KeyHit(28)
gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null
val#=g\value$
min#=g\inval$[1]
max#=g\inval$[2]
If min<>0 Or max<>0
If val#<min# Then g\value$=min#:g\xpos=Len(g\value$)
If val#>max# Then g\value$=max#:g\xpos=Len(g\value$)
EndIf


EndIf

EndIf
;***********

If on<>0

	zp=MouseZSpeed()
	
	If zp<>0
		scrstep#=g\inval[4]
		val#=g\value$
		val#=val#+Float(zp)*scrstep#
		g\value$=val#
		g\xpos=Len(g\value$)
		val#=g\value$
		min#=g\inval$[1]
		max#=g\inval$[2]
		If min<>0 Or max<>0
		If val#<min# Then g\value$=min#:g\xpos=Len(g\value$)
		If val#>max# Then g\value$=max#:g\xpos=Len(g\value$)
		EndIf
		;If val#>=0 Then g\value$=-val#:g\value$=Right$(g\value$,Len(g\value)-1)		
	EndIf
	
	If MouseDown(1)=False And g\xview=1 Then g\xview=0:gadgetinteractscrollnum=0
	
	If MouseDown(1) 
	
		If g\xview=0
		
			ggg.gadget=gadgethit(MouseX(),MouseY(),1,1,w)
			If ggg=g Then g\xview=1:g\yview=MouseY():gadgetinteractscrollnum=1:gadgetinteractscrollgadget=g:gadgetinteractmisc=MouseX()
		
		Else
			scrstep#=g\inval[4]
			val#=g\value$
			val#=val#+Float(g\yview-MouseY())*scrstep#
			MoveMouse gadgetinteractmisc,g\yview
		    g\value$=val#
			g\xpos=Len(g\value$)
			If val#>=0 Then g\value$=-val#:g\value$=Right$(g\value$,Len(g\value)-1)
			val#=g\value$
			min#=g\inval$[1]
			max#=g\inval$[2]
			If min<>0 Or max<>0
			If val#<min# Then g\value$=min#:g\xpos=Len(g\value$)
			If val#>max# Then g\value$=max#:g\xpos=Len(g\value$)
			EndIf
			;If val#>=0 Then g\value$=-val#:g\value$=Right$(g\value$,Len(g\value)-1)

		EndIf
	
	
	EndIf

EndIf








Case 4
g=gadgetinteract
on=g\inval$[3]
If on<2

maxchar=255
ltr = GetKey()
If Len(g\value$)<maxchar								
If (ltr > 47 And ltr < 58) Or ltr=45
g\value$=Left$(g\value$,g\xpos)+Chr$(ltr)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos+1
EndIf
EndIf

If KeyHit(14)
If Len(g\value$)>0 And g\xpos>0
g\value$=Left$(g\value$,g\xpos-1)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos-1
EndIf
EndIf

If KeyHit(211)
If Len(g\value$)>0 And g\xpos<Len(g\value$)
g\value$=Left$(g\value$,g\xpos)+Right$(g\value$,Len(g\value$)-g\xpos-1)
EndIf
EndIf

If KeyHit(207) Then g\xpos=Len(g\value$)
If KeyHit(199) Then g\xpos=0
If KeyHit(203) Then g\xpos=g\xpos-1:If g\xpos<0 Then g\xpos=0
If KeyHit(205) Then g\xpos=g\xpos+1:If g\xpos>Len(g\value$) Then g\xpos=Len(g\value$)




If KeyHit(28)
gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null

val=Int(g\value$)
min=g\inval$[1]
max=g\inval$[2]
If min<>0 Or max<>0
If val#<min Then g\value$=Int(min):g\xpos=Len(g\value$)
If val#>max Then g\value$=Int(max):g\xpos=Len(g\value$)
EndIf

EndIf


EndIf

If on<>0

	zp=MouseZSpeed()
	
	If zp<>0
		scrstep#=g\inval[4]
		val=g\value$
		val=val+zp*scrstep#
		g\value$=Int(val)
		g\xpos=Len(g\value$)
		val=Int(g\value$)
		min=g\inval$[1]
		max=g\inval$[2]
		If min<>0 Or max<>0
		If val#<min Then g\value$=Int(min):g\xpos=Len(g\value$)
		If val#>max Then g\value$=Int(max):g\xpos=Len(g\value$)
		EndIf
		
		
	EndIf
	
	If MouseDown(1)=False And g\xview=1 Then g\xview=0:gadgetinteractscrollnum=0
	
	If MouseDown(1) 
	
		If g\xview=0
		
			ggg.gadget=gadgethit(MouseX(),MouseY(),1,1,w)
			If ggg=g Then g\xview=1:g\yview=MouseY():gadgetinteractscrollnum=1:gadgetinteractscrollgadget=g:gadgetinteractmisc=MouseX()
		
		Else
			scrstep#=g\inval[4]
			val=g\value$
			val=val+Float(g\yview-MouseY())*scrstep#
			MoveMouse gadgetinteractmisc,g\yview
		    g\value$=Int(val)
			g\xpos=Len(g\value$)
			val=Int(g\value$)
			min=g\inval$[1]
			max=g\inval$[2]
			If min<>0 Or max<>0
			If val#<min Then g\value$=Int(min):g\xpos=Len(g\value$)
			If val#>max Then g\value$=Int(max):g\xpos=Len(g\value$)
			EndIf
			
		
		
		
		EndIf
	
	
	EndIf

EndIf



Case 5,6 ; if it has to be deselected immediatly

gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null
gadgetinteractstate=0


Case 7
g=gadgetinteract

dfg.window=windowhit(winmx,winmy,1,1)

If dfg=g\window Or dfg=Null Or (dfg<>g\window And windowinfronttest(g\window,dfg))
gadgetinteractcycle=0
For l=0 To (gadgetinteractx-1)
If RectsOverlap(winmx,winmy,1,1,g\window\x+g\x,g\window\y+g\y+g\hei+l*FontHeight(),g\wid,FontHeight())
;Rect x+1,y+hei+bn*FontHeight(),wid-2,FontHeight(),0
g\inval$[4]=l
gadgetinteractcycle=1
EndIf
Next
If gadgetinteractcycle=0 Then g\inval$[4]=-1
EndIf


;gadgetinteractstate=2

Case 8
gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null

Case 9

g=gadgetinteract
maxchar=g\inval$[0]
ltr = GetKey()										
;If ltr > 46 And ltr < 123
If ltr > 31 And ltr < 255  And ltr<>124 ;And Len(g\value$)<maxchar
g\value$=Left$(g\value$,g\xpos)+Chr$(ltr)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos+1:gadgetinteractmisc=1
EndIf

If KeyDown(14) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+100:gadgetinteractmisc=1
;If Len(te\t$)=0 Then bn.tex=Before te: :If bn<>Null Then Delete te : yt=yt-1:xt=Len(bn\t$):If yt<0 : yt=0 : EndIf :Exit

If Len(g\value$)>0 And g\xpos>0
g\value$=Left$(g\value$,g\xpos-1)+Right$(g\value$,Len(g\value$)-g\xpos)
g\xpos=g\xpos-1:gadgetinteractmisc=1
EndIf
EndIf

If KeyDown(211) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+100
If Len(g\value$)>0 And g\xpos<Len(g\value$)

g\value$=Left$(g\value$,g\xpos)+Right$(g\value$,Len(g\value$)-g\xpos-1)
gadgetsetviewsizefortexteditor(g,gadgetinteract\value$)
EndIf
EndIf


If KeyDown(203) And MilliSecs()>gadgetinteracttimer Then gadgetinteracttimer=MilliSecs()+50:g\xpos=g\xpos-1:gadgetinteractmisc=1:If g\xpos<0 Then g\xpos=0
If KeyDown(205) And MilliSecs()>gadgetinteracttimer Then gadgetinteracttimer=MilliSecs()+50:g\xpos=g\xpos+1:gadgetinteractmisc=1:If g\xpos>Len(g\value$) Then g\xpos=Len(g\value$)



If KeyDown(200) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+50:gadgetinteractmisc=1
cv=0:r=0:r3=0
For l=g\xpos To 1 Step -1
If Mid$(g\value$,l,1)="|"

cv=cv+1
If cv=1 Then r2=r:r3=l
If cv>1 Then g\xpos=l+r2 : If g\xpos>r3-1 : g\xpos=r3-1:EndIf :Exit
r=0
EndIf
r=r+1
If l=1

g\xpos=l+r2-1 : If g\xpos>r3-1 : g\xpos=r3-1:EndIf :Exit

;g\xpos=r3-1 ; : If g\xpos>r3-1 : g\xpos=r3-1:EndIf :Exit

EndIf
Next
If g\xpos<0 Then g\xpos=0



;g\ypos=g\ypos-1

EndIf


If KeyDown(208) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+50:gadgetinteractmisc=1
If g\xpos=<0 Then g\xpos=1

cv=0:r=0:r3=0
For l=g\xpos To 1 Step -1
If Mid$(g\value$,l,1)="|"
r3=l:Exit
EndIf
r=r+1
Next

For l=g\xpos+1 To Len(g\value$)
If Mid$(g\value$,l,1)="|"
cv=cv+1
If cv=1 Then r2=l
If cv>1

g\xpos=r2+r:If g\xpos>l-1:g\xpos=l-1:EndIf:Exit

EndIf

EndIf
Next


If g\xpos>Len(g\value$) Then g\xpos=Len(g\value$)

EndIf

If KeyHit(28)
If gadgetsetviewsizefortexteditor(g,gadgetinteract\value$)=False

g\value$=Left$(g\value$,g\xpos)+"|"+Right$(g\value$,Len(g\value$)-g\xpos)

g\xpos=g\xpos+1
EndIf


;g\ypos=g\ypos+1
EndIf

f=-MouseZSpeed()*20
If f<>0
g\yview=g\yview+f

If g\yview<0 Then g\yview=0
If g\yview>g\viewhei-g\hei-4 Then g\yview=g\viewhei-g\hei-4

EndIf








Case 10
;gadgetinteract\activate=0
;gadgetinteract\release=1
;gadgetinteract=Null
g=gadgetinteract
gadgetinteract\release=1
;If MouseDown(1)=False Then g\release=1

f=-MouseZSpeed()*20
If f<>0
g\yview=g\yview+f

If g\yview<0 Then g\yview=0
If g\yview>g\viewhei-g\hei-4 Then g\yview=g\viewhei-g\hei-4

EndIf

If KeyDown(200) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+100
val=g\value$
val=val-1
If val<0 Then val=0
g\value$=val
down=val*FontHeight()
If g\yview>=down And g\yview<=down+g\hei

Else
g\yview=down-g\hei Shr 1

If g\yview<0 Then g\yview=0
If g\yview>g\viewhei-g\hei-4 Then g\yview=g\viewhei-g\hei-4

EndIf

gadgetupdatetarget(g)

EndIf


If KeyDown(208) And MilliSecs()>gadgetinteracttimer
gadgetinteracttimer=MilliSecs()+100

val=g\value$
val=val+1
num=(g\viewhei/FontHeight())-2
If val>num Then val=num
g\value$=val
down=val*FontHeight()
If g\yview>=down And g\yview<=down+g\hei

Else

g\yview=down-g\hei Shr 1

If g\yview<0 Then g\yview=0
If g\yview>g\viewhei-g\hei-4 Then g\yview=g\viewhei-g\hei-4

EndIf

gadgetupdatetarget(g)

EndIf


Case 11 

a=gadgetinteract\value$

gadgetinteract\value$=1-a

gadgetinteract\activate=0
gadgetinteract\release=1
gadgetinteract=Null


End Select



EndIf


gadgetinteractdelay=gadgetinteractdelay+1
EndIf

If MouseDown(1) And gadgetinteract<>Null 


gadgetupdatetarget(gadgetinteract)



Select gadgetinteract\typ


;gadgethscroller.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,value,min,max,ste,size)

Case 5
g=gadgetinteract

winmx=MouseX()
winmy=MouseY()

;If MouseDown(1) And gadgethit(winmx,winmy,1,1,w)=g Then g\value$=winmx-g\x


tem#=g\inval$[2]
tem1#=g\inval$[0]
tem2#=g\inval$[1]
siz=g\inval$[3]
val#=g\value$

If gadgetinteractx>=0 And gadgetinteractx<=siz

g\xpos=(winmx-(g\window\x+g\x+2))-gadgetinteractx

;Stop
If g\xpos<0 Then g\xpos=0
If g\xpos>g\wid-siz-4 Then g\xpos=g\wid-siz-4

val#=Float(g\xpos)*Float( Float(tem2#-tem1#) / Float(g\wid-siz-4) )


Else

	If gadgetinteractx<0
	val#=val#-tem#
	Else
	val#=val#+tem#
	EndIf

g\xpos=Float(val#)/(Float( Float(tem2#-tem1#) / Float(g\wid-siz-4) ))
;g\xpos=(winmx-(g\window\x+g\x+2))-siz Shr 1
EndIf




If val#<tem1# Then val#=tem1#
If val#>tem2# Then val#=tem2#





temp#=Int(val#/tem#)

val#=temp#*tem#
g\value$=val#


Case 6

g=gadgetinteract

winmx=MouseX()
winmy=MouseY()

tem#=g\inval$[2]
tem1#=g\inval$[0]
tem2#=g\inval$[1]
siz=g\inval$[3]
val#=g\value$

If gadgetinteracty>=0 And gadgetinteracty<=siz

g\ypos=(winmy-(g\window\y+g\y+2))-gadgetinteracty


If g\ypos<0 Then g\ypos=0
If g\ypos>g\hei-siz-4 Then g\ypos=g\hei-siz-4

val#=Float(g\ypos)*Float( Float(Abs(tem2#-tem1#)) / Float(g\hei-siz-4) )

Else

	If gadgetinteracty<0
	val#=val#-tem#
	Else
	val#=val#+tem#
	EndIf

g\ypos=Float(val#)/(Float( Float(Abs(tem2#-tem1#)) / Float(g\hei-siz-4) ))
EndIf

If val#<tem1# Then val#=tem1#
If val#>tem2# Then val#=tem2#


temp#=Int(val#/tem#)

val#=temp#*tem#
g\value$=val#

Case 8
g=gadgetinteract

;g\xpos=-(winmx-(g\window\x+g\x))
;g\ypos=-(winmy-(g\window\y+g\y))

ima=g\inval$[0]
bnm=g\inval$[1]

If ima  ;And MouseDown(2);And bnm

If bnm=1

gadgetinteractxp#=gadgetinteractxp#-Float(Float(gadgetinteractx2-winmx)/8) ;((ImageWidth(ima)/g\wid)*4)
gadgetinteractyp#=gadgetinteractyp#-Float(Float(gadgetinteracty2-winmy)/8) ;((ImageHeight(ima)/g\hei)*4)

g\xpos#=gadgetinteractxp 
g\ypos#=gadgetinteractyp 

If g\xpos<0 Then g\xpos=0:gadgetinteractxp=0
If g\xpos>ImageWidth(ima)-g\wid Then g\xpos=ImageWidth(ima)-g\wid:gadgetinteractxp=ImageWidth(ima)-g\wid

If g\ypos<0 Then g\ypos=0:gadgetinteractyp=0
If g\ypos>ImageHeight(ima)-g\hei Then g\ypos=ImageHeight(ima)-g\hei:gadgetinteractyp=ImageHeight(ima)-g\hei

;MoveMouse g\window\x+g\x+2+gadgetinteractx2,g\window\y+g\y+2+gadgetinteracty2
;MoveMouse gadgetinteractx2,gadgetinteracty2

EndIf
EndIf




Case 10

g=gadgetinteract

val2=g\inval$[1]


off=(val2*FontHeight())-g\yview

val=(winmy-(g\y+g\window\y+off+2))/FontHeight()+val2

g\value$=val

;If MouseDown(1)=False
;gadgetinteract\activate=0
;gadgetinteract\release=1
;gadgetinteract=Null
;gadgetinteractstate=0
;EndIf




End Select

EndIf
EndIf



End Function

;Function gadgetpress.gadget()
;Return gadgetinteract
;End Function

Function gadgetrelease.gadget()
If MouseDown(1)=False
Return gadgetinteract 
EndIf
End Function

Function gadgetpressed(g.gadget)
If g=Null Then Return
Return g=gadgetinteract
End Function

;Function gadgetreleased(g.gadget)
;If g=Null Then Return
;;If g\release=0 Then Return
;g\release=0
;;g1.gadget=gadgetinteract
;;gadgetinteract=Null
;gadgetinteractstate=0
;Return g=g1 And MouseDown(1)=False
;End Function

Function gadgetreleased(g.gadget,dontflush=0)
If g=Null Then Return
yes=0
If g\release=1 Then yes=1:g\release=dontflush:gadgetinteractstate=0
Return yes
;If g=gadgetinteract And MouseDown(1)=False Then yes=1
;Return yes
End Function

Function gadgetflushstate(g.gadget)
If g=Null Then Return
g\release=0:If g=gadgetinteract Then gadgetinteractstate=0
End Function

Function gadgetflushstateall()
For g.gadget=Each gadget
g\release=0
Next
gadgetinteractstate=0
End Function


Function gadgettext.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,fit=0,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return
typ=0

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)

If fit
If font Then SetFont font
g\wid=StringWidth(tex$)
g\hei=StringHeight(tex$)
EndIf

g\help$=help$

Return g

End Function

Function gadgetbutton.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=1

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$


Return g

End Function

Function gadgettextbox.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,intex$="",maxchar=256,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=2

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$


g\value$=intex$
g\inval$[0]=maxchar


Return g

End Function

Function gadgetfloat.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,intex$="",min#=0,max#=0,scroll=0,scrollstep#=1,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=3

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$

g\value$=intex$
g\inval$[0]=maxchar
g\inval$[1]=min#
g\inval$[2]=max#
g\inval$[3]=scroll
g\inval$[4]=scrollstep#
g\xpos=Len(g\value)

Return g

End Function

Function gadgetinteger.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,intex$="",min=0,max=0,scroll=0,scrollstep#=1,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=4

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$


g\value$=intex$
g\inval$[0]=maxchar
g\inval$[1]=min
g\inval$[2]=max
g\inval$[3]=scroll
g\inval$[4]=scrollstep#
g\xpos=Len(g\value)


Return g

End Function


Function gadgethscroller.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,size=20,value#=0,min#=0.0,max#=1.0,ste#=0.0001,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=5

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$


g\value$=value
g\inval$[0]=min
g\inval$[1]=max
g\inval$[2]=ste
g\inval$[3]=size
If Str(g\value$)<min Then g\value$=min
If Str(g\value$)>max Then g\value$=max

Return g

End Function

Function gadgetvscroller.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,size=20,value#=0,min#=0.0,max#=1.0,ste#=0.0001,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=6

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$


g\value$=value#
g\inval$[0]=min#
g\inval$[1]=max#
g\inval$[2]=ste#
g\inval$[3]=size
If Str(g\value$)<min# Then g\value$=min#
If Str(g\value$)>max# Then g\value$=max#

Return g

End Function

Function gadgetcycle.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,value,view$,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=7

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$

g\value$=value
g\inval$[0]=view$
g\inval$[3]=""

Return g

End Function



Function gadgetimage.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,image,frame=0,drag=0,xpos#=0.5,ypos#=0.5,fit=0,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Or image=0 Then Return

typ=8

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$

g\value$=frame
g\inval$[0]=image
g\inval$[1]=drag

If fit=0

g\inval$[2]=xpos#
g\inval$[3]=ypos#
If (xpos#<=1 And xpos#>=0)  
g\inval$[4]=1 
g\xpos=(Float(xpos#)*Float(ImageWidth(image)-wid))
Else
g\xpos=xpos-wid Shr 1
g\inval$[4]=0

EndIf

If (ypos#<=1 And ypos#>=0)
g\ypos=ypos-hei Shr 1
Else
g\ypos=(Float(ypos#)*Float(ImageHeight(image)-hei))
EndIf


If g\xpos<0 Then g\xpos=0
If g\xpos>ImageWidth(image)-wid Then g\xpos=ImageWidth(image)-wid

If g\ypos<0 Then g\ypos=0
If g\ypos>ImageHeight(image)-hei Then g\ypos=ImageHeight(image)-hei


Else

ResizeImage image,g\wid,g\hei





EndIf





Return g

End Function

Function gadgettexteditor.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,intex$,maxline=-1,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=9

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$

g\value$=intex$
g\inval$[0]=maxline

gadgetsetviewsizefortexteditor(g,g\value$)

Return g

End Function

Function gadgettextselection.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,intex$,selected=-1,center=0,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return
 
typ=10

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$

g\value$=selected
g\inval$[0]=intex$
;[1] is reserved
g\inval$[2]=center


gadgetsetviewsizefortexteditor(g,g\inval$[0])

Return g

End Function


Function gadgetcheckbox.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,state=0,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=11

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$
g\value=state


Return g

End Function

Function gadgetborder.gadget(w.window,x,y,wid,hei,tex$,place,style.guidesign,font,state=0,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1,show=1,lock=0)
If w=Null Or style=Null Then Return

typ=12

g.gadget=gadget.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,typ,scaleon,scalex,scaley,scalew,scaleh,show,lock)
g\help$=help$
g\value=state

Return g

End Function





Type windowfilerequesttype 

Field file$

End Type



Function windowfilerequest$(x,y,wid,hei,style.guidesign,font,title$,filter$="",path$="",pointer=0)
If style=Null Or font=0 Then Return ""

dir$=windowgetdir$(path$)
file$=windowgetfile$(path$)

SetFont font


windowfilerequesttokenize(filter$)

If dir$="" Then dir$=CurrentDir$()


tempdir$=CurrentDir$()

filerequestbackground=CreateImage(GraphicsWidth(),GraphicsHeight())
GrabImage filerequestbackground,0,0

ChangeDir dir$

For w.window=Each window
w\lock=1
Next

w.window=window(x,y,wid,hei,style,font,1,title$,0,1,0,1)

;gadgettextselection.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,intex$,selected=-1,center,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1)

fileview.gadget=gadgettextselection(w,10,20,Float(wid)*0.6,Float(hei)*0.565,"File view:",1,style,font,windowgetfiledir$(dir$),-1,0,"Click to select a file")

scroller.gadget=gadgetvscroller(w,10+Float(wid)*0.6+10,20,20,Float(hei)*0.565,"",0,style,font,20,0,0,1,0.01)

xhen=(wid-(wid-(10+Float(wid)*0.6+10+20)) Shr 1)-40

parent.gadget=gadgetbutton(w,xhen,20,80,FontHeight()+4,"Parent",0,style,font," Go to parent directory ")

drives.gadget=gadgetbutton(w,xhen,20+FontHeight()*1+4,80,FontHeight()+4,"Drives",0,style,font," Show drives ")

filterg.gadget=gadgettextbox(w,xhen,20+FontHeight()*4+4,80,FontHeight()+4,"Filter :",1,style,font,filter$,1024,"Filter for files  | to separate")

pathbox.gadget=gadgettextbox(w,10,20+Float(hei)*0.565+4,Float(wid)*0.6,FontHeight()+4,"",0,style,font,dir$,1024," The full path ")

filebox.gadget=gadgettextbox(w,10,20+Float(hei)*0.565+4+(FontHeight()+6)*1,Float(wid)*0.6,FontHeight()+4,"",0,style,font,file$,1024," The filename ")

ok.gadget=gadgetbutton(w,(wid/3)-80/2,20+Float(hei)*0.565+4+(FontHeight()+6)*2+6,80,FontHeight()+6,"Ok",0,style,font," Accept the file ")
cancel.gadget=gadgetbutton(w,((wid/3)*2)-80/2,20+Float(hei)*0.565+4+(FontHeight()+6)*2+6,80,FontHeight()+6,"Cancel",0,style,font," Cancel and return without a file name ")



quit=0


Repeat 
mx=MouseX()
my=MouseY()

DrawBlock filerequestbackground,0,0

;If gadgetreleased(fileview) Then Text 10,10,"RELEASED"

Text 10,10,fileview\release

windowinteractall(0,0,GraphicsWidth(),GraphicsHeight())
gadgetinteractall(0,0,GraphicsWidth(),GraphicsHeight())
windowdraw(w,0,0,GraphicsWidth(),GraphicsHeight(),BackBuffer())



If gadgetreleased(filterg)

filter$=filterg\value$
windowfilerequesttokenize(filter$)
gadgetupdatetextselection$(fileview,windowgetfiledir$(dir$))

EndIf

If gadgetreleased(drives)
gadgetsetvalue(filebox,"")
file$=""
dir$=""
driv$=""
For drive=Asc("A") To Asc("Z")  
  dri$=Chr(drive)+":\"
If ReadDir(dri$)
  driv$=driv$+" - "+Left$(dri$,2)+"|"
EndIf
Next
If driv$<>"" Then driv$=Left$(driv$,Len(driv$)-1)
If driv$<>"" Then gadgetupdatetextselection$(fileview,driv$):gadgetsettexteditorpos(fileview,0,0)

EndIf


If gadgetpressed(scroller)

gadgetsettexteditorpos(fileview,0,Float(gadgetgetvalue(scroller)))

EndIf

If gadgetreleased(fileview) 
gadgetsetvalue(scroller,gadgetgettexteditorypos#(fileview))
file$=gadgetgettextselected$(fileview)
If file$<>""
bfil$=file$
file$=Right$(file$,Len(file$)-3)
If Left$(bfil$,3)=" - "
gadgetsetvalue(filebox,"")
	If Len(file$)=2
	dir$=file$
	file$=""
	EndIf


Else
gadgetsetvalue(filebox,file$)
EndIf

If FileType(dir$+file$)=2
dir$=dir$+file$+"\"
file$=""
;gadgetsetvalue(filebox,file$)

gadgetupdatetextselection$(fileview,windowgetfiledir$(dir$))
gadgetinactive(fileview)
gadgetsetvalue(pathbox,dir$)
gadgetsetvalue(filebox,file$)
gadgetsettexteditorpos(fileview,0,0)
gadgetsetvalue(scroller,0)
;gadgetsetvalue(fileview,-1)

EndIf
EndIf
EndIf



file$=gadgetgetvalue$(filebox)
;If FileType(dir$+file$)=2
;file$=file2$+"\"
;Else
;file$=file2$
;EndIf

If gadgetreleased(filebox)

file2$=gadgetgetvalue$(filebox)

file$=file2$+"\"

If FileType(dir$+file$)=2
dir$=dir$+file$
file$=""
s$=windowgetfiledir$(dir$)
gadgetupdatetextselection$(fileview,s$)
gadgetsetvalue(pathbox,dir$)
gadgetsetvalue(filebox,file$)
gadgetsettexteditorpos(fileview,0,0)
gadgetsetvalue(scroller,0)
Else
;file$=""
file$=file2$
gadgetsetvalue(filebox,file$)
EndIf
EndIf

If gadgetreleased(pathbox)
dir$=gadgetgetvalue$(pathbox)

If Right$(dir$,1)<>"\" Then dir$=dir$+"\"

If FileType(dir$)=2

s$=windowgetfiledir$(dir$)
gadgetupdatetextselection$(fileview,s$)
gadgetsetvalue(pathbox,dir$)
gadgetsettexteditorpos(fileview,0,0)
gadgetsetvalue(scroller,0)
Else
file$=""
gadgetsetvalue(filebox,file$)
EndIf
EndIf



If gadgetreleased(parent) And Len(dir$)>6


gh=0
Repeat
;If KeyDown(1) Then Exit
gh=gh+1
Until Mid$(dir$,Len(dir$)-gh,1)="\"

dir$=Left$(dir$,Len(dir$)-gh)
file$=""

s$=windowgetfiledir$(dir$)
gadgetupdatetextselection$(fileview,s$)
gadgetsetvalue(pathbox,dir$)
gadgetsetvalue(filebox,file$)
gadgetsettexteditorpos(fileview,0,0)
gadgetsetvalue(scroller,0)

EndIf




If gadgetreleased(ok) Then quit=2
If gadgetreleased(cancel) Or windowcheckifclosed(w) Then quit=1






If pointer=0
Color 255,255,255
Line mx-3,my,mx+3,my
Line mx,my-3,mx,my+3

Else

DrawImage pointer,mx,my

EndIf


Flip

Until KeyDown(1) Or quit<>0 

FreeImage filerequestbackground

Delete Each token

windowdelete(w)

For w.window=Each window
w\lock=0
Next

ChangeDir tempdir$

If quit=2
If Right$(dir$,1)<>"\" Then dir$=dir$+"\"
Return dir$+file$
Else
Return ""
EndIf

End Function

Function windowgetfiledir$(dir$)
	If dir$="" Then Return
	If FileType(dir$)=0 Then Return dir$
	
	If Right$(dir$,1)<>"\" Then dir$=dir$+"\"
	
	path=ReadDir(dir$)
	If path=0 Then Return 
	Repeat
		file$=NextFile$(path)
		If file$="" Then Exit
		
		If file$<>"." And file$<>".."
			f$=dir$+file$
			If FileType(f$)=2
				tem.windowfilerequesttype=New windowfilerequesttype
				tem\file$=file$
			EndIf
		EndIf		
	Forever 	

	CloseDir path

	sortwindowfilerequesttype()
	
	For tem.windowfilerequesttype=Each windowfilerequesttype
		s$=s$+" - "+tem\file$+"|"
	Next
	Delete Each windowfilerequesttype
	
	path=ReadDir(dir$) 
	Repeat
	file$=NextFile$(path)
	If file$="" Then Exit
	
	If file$<>"." And file$<>".."
		f$=dir$+file$
		If FileType(f$)=1				
			If windowfilerequestisfiltered(file$)  
				tem.windowfilerequesttype=New windowfilerequesttype
				tem\file$=file$
			End If 
		EndIf
	EndIf
	
	Forever 
	
	CloseDir path

	sortwindowfilerequesttype()
	
	For tem.windowfilerequesttype=Each windowfilerequesttype
		s$=s$+"   "+tem\file$+"|"
	Next
	Delete Each windowfilerequesttype	
	If s$<>"" Then s$=Left$(s$,Len(s$)-1)
	Return s$
End Function

Type token
Field value$
End Type


Function windowfilerequesttokenize(filter$, delimiter$="|")
Delete Each token
start=1
pos=1
If filter$="" Then Return
filter$=Lower$(filter)
Repeat
pos=Instr(filter,delimiter$,start)
If pos<>0
If pos<>start
s$=Mid$( filter$,start,pos-start)
start=pos+1
fil.token = New token
fil\value = s$
End If
Else
pos=Len(filter$)+1
s$=Mid$(filter$,start,pos-start)
fil.token=New token
fil\value=s$
Exit		
End If
Forever
End Function


Function sortwindowfilerequesttype()

b.windowfilerequesttype=First windowfilerequesttype
If b=Null Then Return
flag=True
    While flag
        flag=False
        bb.windowfilerequesttype=Last windowfilerequesttype
        While bb<>b
            bbb.windowfilerequesttype=Before bb
            If bbb=Null Exit
            If Lower$(bb\file$)<Lower$(bbb\file$)
                Insert bbb After bb
                flag=True
            Else
                bb=bbb
            EndIf
        Wend
        b=After bb
    Wend

End Function

Function windowfilerequestisfiltered(s$)
If s$="" Then Return False
If s$="." Or s$=".." Then Return True
s$=Lower(s$)
For f.token = Each token	
tokens=tokens+1
If Instr(s$,f\value$) Then
Return True
End If
Next
If tokens
Return False
Else
Return True
End If
End Function

Function windowgetdir$(path$) 
For a = Len(path$) To 1 Step -1 
byte$ = Mid(path$,a,1) 
If byte$="\" 
Return Left(path$,a) 
EndIf 
Next 
Return
End Function 


Function windowgetfile$(path$) 
For a = Len(path$) To 1 Step -1 
byte$ = Mid(path$,a,1) 
If byte$="\" 
Return Right(path$,Len(path$)-a) 
EndIf 
Next 
Return path$ 
End Function




Type guidesign

Field typ
Field r[38],r2[38]
Field g[38],g2[38]
Field b[38],b2[38]
Field bimage[1],bimagexoff[1],bimageyoff[1]
Field himage[1],himagexoff[1],himageyoff[1]
Field gimage[1],gimagexoff[1],gimageyoff[1]
Field cimage[5]


Field image[100]





End Type


Function windowmessage(style.guidesign,font,title$,tex$,but1$,but2$="",but3$="",pointer=0,x=-1,y=-1,wid=0,hei=0)
If style=Null Or font=0 Then Return 0

SetFont font

filerequestbackground=CreateImage(GraphicsWidth(),GraphicsHeight())
GrabImage filerequestbackground,0,0
windowmessagenumberofbuttons=1


filerequestwidtest1=StringWidth(but1$)+30
filerequestwidtest2=StringWidth(but2$)+30
filerequestwidtest3=StringWidth(but3$)+30
filerequestbutwid=filerequestwidtest1

If filerequestwidtest1>=filerequestwidtest2 And filerequestwidtest1>=filerequestwidtest3 Then filerequestbutwid=filerequestwidtest1
If filerequestwidtest2>=filerequestwidtest1 And filerequestwidtest2>=filerequestwidtest3 Then filerequestbutwid=filerequestwidtest2
If filerequestwidtest3>=filerequestwidtest1 And filerequestwidtest3>=filerequestwidtest2 Then filerequestbutwid=filerequestwidtest3

If but2$<>"" Then windowmessagenumberofbuttons=windowmessagenumberofbuttons+1 
If but3$<>"" Then windowmessagenumberofbuttons=windowmessagenumberofbuttons+1

If wid=0 Or hei=0


filerequestwid1=(filerequestbutwid*windowmessagenumberofbuttons)+20
filerequestwid2=StringWidth(tex$)+20
If filerequestwid1>filerequestwid2 Then wid=filerequestwid1 Else wid=filerequestwid2:xhen=filerequestwid2/2-filerequestwid1/2

hei=FontHeight()*6

If x=-1 And y=-1
x=GraphicsWidth() Shr 1-wid Shr 1
y=GraphicsHeight() Shr 1-hei Shr 1
EndIf

EndIf

For w.window=Each window
w\lock=1
Next
w.window=window(x,y,wid,hei,style,font,1,title$,0,1,0,1)

;gadgettextselection.gadget(x,y,wid,hei,tex$,place,style.guidesign,w.window,font,intex$,selected=-1,center,help$="",scaleon=0,scalex=1,scaley=1,scalew=1,scaleh=1)

buttonnr1.gadget=gadgetbutton(w,10+xhen,FontHeight()*3-6,filerequestbutwid,FontHeight()+6,but1$,0,style,font)
If but2$<>"" Then buttonnr2.gadget=gadgetbutton(w,10+xhen+filerequestbutwid+2,FontHeight()*3-6,filerequestbutwid,FontHeight()+6,but2$,0,style,font)
If but3$<>"" Then buttonnr3.gadget=gadgetbutton(w,10+xhen+filerequestbutwid*2+4,FontHeight()*3-6,filerequestbutwid,FontHeight()+6,but3$,0,style,font)


;ok.gadget=gadgetbutton(w,(wid/3)-80/2,20+Float(hei)*0.565+4+(FontHeight()+6)*2+6,80,FontHeight()+6,"Ok",0,style,font," Accept the file ")
;cancel.gadget=gadgetbutton(w,((wid/3)*2)-80/2,20+Float(hei)*0.565+4+(FontHeight()+6)*2+6,80,FontHeight()+6,"Cancel",0,style,font," Cancel and return without a file name ")



quit=0

FlushKeys
Repeat 
mx=MouseX()
my=MouseY()

DrawBlock filerequestbackground,0,0

windowinteractall(0,0,GraphicsWidth(),GraphicsHeight())
gadgetinteractall(0,0,GraphicsWidth(),GraphicsHeight())
windowdraw(w,0,0,GraphicsWidth(),GraphicsHeight(),BackBuffer())

Color 0,0,0
Text w\x+w\wid Shr 1,w\y+FontHeight() Shl 1,tex$,1,0




If pointer=0
Color 255,255,255
Line mx-3,my,mx+3,my
Line mx,my-3,mx,my+3

Else

DrawImage pointer,mx,my

EndIf

Flip

If gadgetreleased(buttonnr1) Then quit=1
If but2$<>"" Then If gadgetreleased(buttonnr2) Then quit=2 
If but3$<>"" Then If gadgetreleased(buttonnr3) Then quit=3 

If KeyHit(1) Or windowcheckifclosed(w) Then quit=windowmessagenumberofbuttons


Until quit>0
FreeImage filerequestbackground

windowdelete(w)

For w.window=Each window
w\lock=0
Next


Return quit-1

End Function

Function guidesigndefault.guidesign(defaultdesign)

d.guidesign=New guidesign


Select defaultdesign

Case 0 ; windows style ;-)

d\r[0]=192:d\g[0]=192:d\b[0]=193:d\r[1]=223:d\g[1]=223:d\b[1]=223:d\r[2]=0:d\g[2]=0:d\b[2]=0:d\r[3]=0:d\g[3]=0:d\b[3]=0:d\r[4]=223:d\g[4]=223:d\b[4]=223:d\r[5]=255:d\g[5]=255:d\b[5]=255:d\r[6]=128:d\g[6]=128:d\b[6]=128:d\r[7]=128:d\g[7]=128:d\b[7]=128
d\r[8]=255:d\g[8]=255:d\b[8]=255:d\r[9]=255:d\g[9]=255:d\b[9]=255:d\r[10]=128:d\g[10]=128:d\b[10]=128:d\r[11]=128:d\g[11]=128:d\b[11]=128:d\r[12]=255:d\g[12]=255:d\b[12]=255:d\r[13]=175:d\g[13]=175:d\b[13]=175:d\r[14]=0:d\g[14]=0:d\b[14]=0:d\r[15]=255:d\g[15]=255:d\b[15]=255
d\r[16]=128:d\g[16]=128:d\b[16]=128:d\r[17]=128:d\g[17]=128:d\b[17]=128:d\r[18]=255:d\g[18]=255:d\b[18]=255:d\r[19]=148:d\g[19]=148:d\b[19]=138:d\r[20]=203:d\g[20]=203:d\b[20]=203:d\r[21]=138:d\g[21]=138:d\b[21]=138:d\r[22]=138:d\g[22]=138:d\b[22]=138:d\r[23]=133:d\g[23]=133:d\b[23]=133:d\r[24]=135:d\g[24]=135:d\b[24]=135:d\r[25]=195:d\g[25]=195:d\b[25]=195:d\r[26]=36:d\g[26]=36:d\b[26]=36:d\r[27]=0:d\g[27]=0:d\b[27]=0:d\r[28]=195:d\g[28]=195:d\b[28]=195
d\r[28]=195:d\g[28]=195:d\b[28]=195:d\r[29]=166:d\g[29]=166:d\b[29]=166:d\r[30]=0:d\g[30]=0:d\b[30]=0:d\r[31]=0:d\g[31]=0:d\b[31]=0:d\r[32]=174:d\g[32]=174:d\b[32]=174:d\r[33]=96:d\g[33]=96:d\b[33]=96:d\r[34]=96:d\g[34]=96:d\b[34]=96:d\r[35]=174:d\g[35]=174:d\b[35]=174:d\r[36]=138:d\g[36]=138:d\b[36]=138:d\r[37]=255:d\g[37]=30:d\b[37]=30:d\r[38]=255:d\g[38]=255:d\b[38]=255
d\r2[0]=192:d\g2[0]=192:d\b2[0]=193:d\r2[1]=200:d\g2[1]=200:d\b2[1]=200:d\r2[2]=0:d\g2[2]=0:d\b2[2]=0:d\r2[3]=0:d\g2[3]=0:d\b2[3]=0:d\r2[4]=200:d\g2[4]=200:d\b2[4]=200:d\r2[5]=224:d\g2[5]=224:d\b2[5]=224:d\r2[6]=104:d\g2[6]=104:d\b2[6]=104:d\r2[7]=104:d\g2[7]=104:d\b2[7]=104
d\r2[8]=224:d\g2[8]=224:d\b2[8]=224:d\r2[9]=255:d\g2[9]=255:d\b2[9]=255:d\r2[10]=128:d\g2[10]=128:d\b2[10]=128:d\r2[11]=128:d\g2[11]=128:d\b2[11]=128:d\r2[12]=255:d\g2[12]=255:d\b2[12]=255:d\r2[13]=150:d\g2[13]=150:d\b2[13]=150:d\r2[14]=0:d\g2[14]=0:d\b2[14]=0:d\r2[15]=141:d\g2[15]=141:d\b2[15]=141
d\r2[16]=203:d\g2[16]=203:d\b2[16]=203:d\r2[17]=206:d\g2[17]=203:d\b2[17]=203:d\r2[18]=141:d\g2[18]=141:d\b2[18]=141:d\r2[19]=148:d\g2[19]=148:d\b2[19]=138:d\r2[20]=255:d\g2[20]=255:d\b2[20]=255:d\r2[21]=180:d\g2[21]=180:d\b2[21]=180:d\r2[22]=180:d\g2[22]=180:d\b2[22]=180:d\r2[23]=180:d\g2[23]=180:d\b2[23]=180:d\r2[24]=180:d\g2[24]=180:d\b2[24]=180:d\r2[25]=0:d\g2[25]=0:d\b2[25]=0:d\r2[26]=174:d\g2[26]=174:d\b2[26]=174:d\r2[27]=174:d\g2[27]=174:d\b2[27]=174:d\r2[28]=0:d\g2[28]=0:d\b2[28]=0
d\r2[28]=0:d\g2[28]=0:d\b2[28]=0:d\r2[29]=166:d\g2[29]=166:d\b2[29]=166:d\r2[30]=47:d\g2[30]=47:d\b2[30]=47:d\r2[31]=75:d\g2[31]=75:d\b2[31]=73:d\r2[32]=114:d\g2[32]=114:d\b2[32]=114:d\r2[33]=156:d\g2[33]=156:d\b2[33]=156:d\r2[34]=156:d\g2[34]=156:d\b2[34]=156:d\r2[35]=114:d\g2[35]=114:d\b2[35]=114:d\r2[36]=138:d\g2[36]=138:d\b2[36]=138:d\r2[37]=30:d\g2[37]=0:d\b2[37]=0:d\r2[38]=0:d\g2[38]=0:d\b2[38]=0

guidesigncreatedefaultcornerimage(d,0)

Case 1 ; Darker grey ;-)
d\r[0]=101:d\g[0]=101:d\b[0]=101:d\r[1]=161:d\g[1]=161:d\b[1]=161:d\r[2]=0:d\g[2]=0:d\b[2]=0:d\r[3]=0:d\g[3]=0:d\b[3]=0:d\r[4]=161:d\g[4]=161:d\b[4]=161:d\r[5]=130:d\g[5]=130:d\b[5]=130:d\r[6]=73:d\g[6]=73:d\b[6]=73:d\r[7]=73:d\g[7]=73:d\b[7]=73
d\r[8]=130:d\g[8]=130:d\b[8]=130:d\r[9]=167:d\g[9]=167:d\b[9]=167:d\r[10]=60:d\g[10]=60:d\b[10]=60:d\r[11]=60:d\g[11]=60:d\b[11]=60:d\r[12]=167:d\g[12]=167:d\b[12]=167:d\r[13]=62:d\g[13]=73:d\b[13]=83:d\r[14]=138:d\g[14]=138:d\b[14]=138:d\r[15]=101:d\g[15]=101:d\b[15]=101
d\r[16]=29:d\g[16]=29:d\b[16]=29:d\r[17]=29:d\g[17]=29:d\b[17]=29:d\r[18]=101:d\g[18]=101:d\b[18]=101:d\r[19]=60:d\g[19]=60:d\b[19]=60:d\r[20]=16:d\g[20]=16:d\b[20]=16:d\r[21]=86:d\g[21]=86:d\b[21]=86:d\r[22]=112:d\g[22]=112:d\b[22]=112:d\r[23]=112:d\g[23]=112:d\b[23]=112:d\r[24]=86:d\g[24]=86:d\b[24]=86:d\r[25]=120:d\g[25]=120:d\b[25]=120:d\r[26]=36:d\g[26]=36:d\b[26]=36:d\r[27]=36:d\g[27]=36:d\b[27]=36:d\r[28]=120:d\g[28]=120:d\b[28]=120
d\r[28]=120:d\g[28]=120:d\b[28]=120:d\r[29]=55:d\g[29]=60:d\b[29]=73:d\r[30]=36:d\g[30]=36:d\b[30]=36:d\r[31]=36:d\g[31]=36:d\b[31]=36:d\r[32]=101:d\g[32]=101:d\b[32]=101:d\r[33]=39:d\g[33]=39:d\b[33]=39:d\r[34]=39:d\g[34]=39:d\b[34]=39:d\r[35]=99:d\g[35]=101:d\b[35]=101:d\r[36]=47:d\g[36]=55:d\b[36]=60:d\r[37]=255:d\g[37]=255:d\b[37]=255:d\r[38]=255:d\g[38]=255:d\b[38]=255
d\r2[0]=101:d\g2[0]=101:d\b2[0]=101:d\r2[1]=161:d\g2[1]=161:d\b2[1]=161:d\r2[2]=0:d\g2[2]=0:d\b2[2]=0:d\r2[3]=0:d\g2[3]=0:d\b2[3]=0:d\r2[4]=161:d\g2[4]=161:d\b2[4]=161:d\r2[5]=130:d\g2[5]=130:d\b2[5]=130:d\r2[6]=73:d\g2[6]=73:d\b2[6]=73:d\r2[7]=73:d\g2[7]=73:d\b2[7]=73
d\r2[8]=130:d\g2[8]=130:d\b2[8]=130:d\r2[9]=167:d\g2[9]=167:d\b2[9]=167:d\r2[10]=60:d\g2[10]=60:d\b2[10]=60:d\r2[11]=60:d\g2[11]=60:d\b2[11]=60:d\r2[12]=167:d\g2[12]=167:d\b2[12]=167:d\r2[13]=62:d\g2[13]=73:d\b2[13]=83:d\r2[14]=138:d\g2[14]=138:d\b2[14]=138:d\r2[15]=101:d\g2[15]=101:d\b2[15]=101
d\r2[16]=29:d\g2[16]=29:d\b2[16]=29:d\r2[17]=29:d\g2[17]=29:d\b2[17]=29:d\r2[18]=101:d\g2[18]=101:d\b2[18]=101:d\r2[19]=60:d\g2[19]=60:d\b2[19]=60:d\r2[20]=16:d\g2[20]=16:d\b2[20]=16:d\r2[21]=81:d\g2[21]=94:d\b2[21]=109:d\r2[22]=81:d\g2[22]=94:d\b2[22]=109:d\r2[23]=81:d\g2[23]=94:d\b2[23]=109:d\r2[24]=81:d\g2[24]=91:d\b2[24]=109:d\r2[25]=47:d\g2[25]=60:d\b2[25]=70:d\r2[26]=125:d\g2[26]=125:d\b2[26]=125:d\r2[27]=125:d\g2[27]=125:d\b2[27]=125:d\r2[28]=47:d\g2[28]=60:d\b2[28]=70
d\r2[28]=47:d\g2[28]=60:d\b2[28]=70:d\r2[29]=55:d\g2[29]=60:d\b2[29]=73:d\r2[30]=36:d\g2[30]=36:d\b2[30]=36:d\r2[31]=36:d\g2[31]=36:d\b2[31]=36:d\r2[32]=39:d\g2[32]=39:d\b2[32]=39:d\r2[33]=101:d\g2[33]=101:d\b2[33]=101:d\r2[34]=101:d\g2[34]=101:d\b2[34]=101:d\r2[35]=39:d\g2[35]=39:d\b2[35]=39:d\r2[36]=60:d\g2[36]=70:d\b2[36]=75:d\r2[37]=73:d\g2[37]=88:d\b2[37]=104:d\r2[38]=0:d\g2[38]=0:d\b2[38]=0

guidesigncreatedefaultcornerimage(d,0)

Case 2 ; red style
d\r[0]=120:d\g[0]=0:d\b[0]=0:d\r[1]=177:d\g[1]=0:d\b[1]=0:d\r[2]=60:d\g[2]=0:d\b[2]=0:d\r[3]=60:d\g[3]=0:d\b[3]=0:d\r[4]=177:d\g[4]=0:d\b[4]=0:d\r[5]=151:d\g[5]=0:d\b[5]=0:d\r[6]=101:d\g[6]=0:d\b[6]=0:d\r[7]=101:d\g[7]=0:d\b[7]=0
d\r[8]=151:d\g[8]=0:d\b[8]=0:d\r[9]=148:d\g[9]=0:d\b[9]=0:d\r[10]=47:d\g[10]=0:d\b[10]=0:d\r[11]=44:d\g[11]=0:d\b[11]=0:d\r[12]=148:d\g[12]=0:d\b[12]=0:d\r[13]=94:d\g[13]=0:d\b[13]=0:d\r[14]=164:d\g[14]=0:d\b[14]=0:d\r[15]=133:d\g[15]=0:d\b[15]=0
d\r[16]=42:d\g[16]=0:d\b[16]=0:d\r[17]=42:d\g[17]=0:d\b[17]=0:d\r[18]=133:d\g[18]=0:d\b[18]=0:d\r[19]=78:d\g[19]=0:d\b[19]=0:d\r[20]=112:d\g[20]=0:d\b[20]=0:d\r[21]=0:d\g[21]=0:d\b[21]=0:d\r[22]=0:d\g[22]=0:d\b[22]=0:d\r[23]=0:d\g[23]=0:d\b[23]=0:d\r[24]=0:d\g[24]=0:d\b[24]=0:d\r[25]=135:d\g[25]=0:d\b[25]=0:d\r[26]=91:d\g[26]=0:d\b[26]=0:d\r[27]=91:d\g[27]=0:d\b[27]=0:d\r[28]=135:d\g[28]=0:d\b[28]=0
d\r[28]=135:d\g[28]=0:d\b[28]=0:d\r[29]=94:d\g[29]=0:d\b[29]=0:d\r[30]=161:d\g[30]=0:d\b[30]=0:d\r[31]=161:d\g[31]=0:d\b[31]=0:d\r[32]=182:d\g[32]=0:d\b[32]=0:d\r[33]=73:d\g[33]=0:d\b[33]=0:d\r[34]=73:d\g[34]=0:d\b[34]=0:d\r[35]=182:d\g[35]=0:d\b[35]=0:d\r[36]=107:d\g[36]=0:d\b[36]=0:d\r[37]=255:d\g[37]=255:d\b[37]=255:d\r[38]=255:d\g[38]=255:d\b[38]=255
d\r2[0]=114:d\g2[0]=0:d\b2[0]=0:d\r2[1]=177:d\g2[1]=0:d\b2[1]=0:d\r2[2]=60:d\g2[2]=0:d\b2[2]=0:d\r2[3]=60:d\g2[3]=0:d\b2[3]=0:d\r2[4]=177:d\g2[4]=0:d\b2[4]=0:d\r2[5]=151:d\g2[5]=0:d\b2[5]=0:d\r2[6]=101:d\g2[6]=0:d\b2[6]=0:d\r2[7]=101:d\g2[7]=0:d\b2[7]=0
d\r2[8]=151:d\g2[8]=0:d\b2[8]=0:d\r2[9]=70:d\g2[9]=0:d\b2[9]=0:d\r2[10]=109:d\g2[10]=0:d\b2[10]=0:d\r2[11]=109:d\g2[11]=0:d\b2[11]=0:d\r2[12]=70:d\g2[12]=0:d\b2[12]=0:d\r2[13]=94:d\g2[13]=0:d\b2[13]=0:d\r2[14]=208:d\g2[14]=0:d\b2[14]=0:d\r2[15]=203:d\g2[15]=0:d\b2[15]=0
d\r2[16]=122:d\g2[16]=0:d\b2[16]=0:d\r2[17]=122:d\g2[17]=0:d\b2[17]=0:d\r2[18]=203:d\g2[18]=0:d\b2[18]=0:d\r2[19]=146:d\g2[19]=0:d\b2[19]=0:d\r2[20]=0:d\g2[20]=0:d\b2[20]=0:d\r2[21]=203:d\g2[21]=0:d\b2[21]=0:d\r2[22]=203:d\g2[22]=0:d\b2[22]=0:d\r2[23]=203:d\g2[23]=0:d\b2[23]=0:d\r2[24]=203:d\g2[24]=0:d\b2[24]=0:d\r2[25]=75:d\g2[25]=0:d\b2[25]=0:d\r2[26]=52:d\g2[26]=0:d\b2[26]=0:d\r2[27]=52:d\g2[27]=0:d\b2[27]=0:d\r2[28]=68:d\g2[28]=0:d\b2[28]=0
d\r2[28]=68:d\g2[28]=0:d\b2[28]=0:d\r2[29]=104:d\g2[29]=0:d\b2[29]=0:d\r2[30]=189:d\g2[30]=0:d\b2[30]=0:d\r2[31]=195:d\g2[31]=0:d\b2[31]=0:d\r2[32]=55:d\g2[32]=0:d\b2[32]=0:d\r2[33]=109:d\g2[33]=0:d\b2[33]=0:d\r2[34]=109:d\g2[34]=0:d\b2[34]=0:d\r2[35]=55:d\g2[35]=0:d\b2[35]=0:d\r2[36]=126:d\g2[36]=0:d\b2[36]=0:d\r2[37]=211:d\g2[37]=0:d\b2[37]=0:d\r2[38]=133:d\g2[38]=0:d\b2[38]=0

guidesigncreatedefaultcornerimage(d,0)

Case 3 ; Blue

d\r[0]=0:d\g[0]=0:d\b[0]=75:d\r[1]=0:d\g[1]=0:d\b[1]=177:d\r[2]=0:d\g[2]=0:d\b[2]=36:d\r[3]=0:d\g[3]=0:d\b[3]=36:d\r[4]=0:d\g[4]=0:d\b[4]=177:d\r[5]=0:d\g[5]=0:d\b[5]=146:d\r[6]=0:d\g[6]=0:d\b[6]=62:d\r[7]=0:d\g[7]=0:d\b[7]=62
d\r[8]=0:d\g[8]=0:d\b[8]=146:d\r[9]=0:d\g[9]=0:d\b[9]=96:d\r[10]=0:d\g[10]=0:d\b[10]=42:d\r[11]=0:d\g[11]=0:d\b[11]=42:d\r[12]=0:d\g[12]=0:d\b[12]=99:d\r[13]=0:d\g[13]=18:d\b[13]=96:d\r[14]=0:d\g[14]=0:d\b[14]=180:d\r[15]=0:d\g[15]=0:d\b[15]=122
d\r[16]=0:d\g[16]=0:d\b[16]=0:d\r[17]=0:d\g[17]=0:d\b[17]=0:d\r[18]=0:d\g[18]=0:d\b[18]=122:d\r[19]=36:d\g[19]=55:d\b[19]=73:d\r[20]=0:d\g[20]=0:d\b[20]=185:d\r[21]=0:d\g[21]=0:d\b[21]=156:d\r[22]=0:d\g[22]=0:d\b[22]=83:d\r[23]=0:d\g[23]=0:d\b[23]=83:d\r[24]=0:d\g[24]=0:d\b[24]=156:d\r[25]=0:d\g[25]=0:d\b[25]=42:d\r[26]=0:d\g[26]=0:d\b[26]=65:d\r[27]=0:d\g[27]=0:d\b[27]=0:d\r[28]=0:d\g[28]=0:d\b[28]=42
d\r[28]=0:d\g[28]=0:d\b[28]=42:d\r[29]=0:d\g[29]=0:d\b[29]=91:d\r[30]=0:d\g[30]=0:d\b[30]=140:d\r[31]=0:d\g[31]=0:d\b[31]=180:d\r[32]=0:d\g[32]=0:d\b[32]=125:d\r[33]=0:d\g[33]=0:d\b[33]=60:d\r[34]=0:d\g[34]=0:d\b[34]=60:d\r[35]=0:d\g[35]=0:d\b[35]=125:d\r[36]=0:d\g[36]=0:d\b[36]=130:d\r[37]=0:d\g[37]=0:d\b[37]=0:d\r[38]=0:d\g[38]=0:d\b[38]=114
d\r2[0]=0:d\g2[0]=0:d\b2[0]=79:d\r2[1]=0:d\g2[1]=0:d\b2[1]=177:d\r2[2]=0:d\g2[2]=0:d\b2[2]=36:d\r2[3]=0:d\g2[3]=0:d\b2[3]=36:d\r2[4]=0:d\g2[4]=0:d\b2[4]=177:d\r2[5]=0:d\g2[5]=0:d\b2[5]=146:d\r2[6]=0:d\g2[6]=0:d\b2[6]=62:d\r2[7]=0:d\g2[7]=0:d\b2[7]=62
d\r2[8]=0:d\g2[8]=0:d\b2[8]=146:d\r2[9]=0:d\g2[9]=0:d\b2[9]=96:d\r2[10]=0:d\g2[10]=0:d\b2[10]=42:d\r2[11]=0:d\g2[11]=0:d\b2[11]=42:d\r2[12]=0:d\g2[12]=0:d\b2[12]=99:d\r2[13]=0:d\g2[13]=36:d\b2[13]=114:d\r2[14]=0:d\g2[14]=0:d\b2[14]=255:d\r2[15]=0:d\g2[15]=0:d\b2[15]=122
d\r2[16]=0:d\g2[16]=0:d\b2[16]=0:d\r2[17]=0:d\g2[17]=0:d\b2[17]=0:d\r2[18]=0:d\g2[18]=0:d\b2[18]=122:d\r2[19]=36:d\g2[19]=55:d\b2[19]=104:d\r2[20]=0:d\g2[20]=0:d\b2[20]=245:d\r2[21]=0:d\g2[21]=0:d\b2[21]=216:d\r2[22]=0:d\g2[22]=0:d\b2[22]=150:d\r2[23]=0:d\g2[23]=0:d\b2[23]=150:d\r2[24]=0:d\g2[24]=0:d\b2[24]=216:d\r2[25]=0:d\g2[25]=0:d\b2[25]=133:d\r2[26]=0:d\g2[26]=0:d\b2[26]=117:d\r2[27]=0:d\g2[27]=0:d\b2[27]=96:d\r2[28]=0:d\g2[28]=0:d\b2[28]=133
d\r2[28]=0:d\g2[28]=0:d\b2[28]=133:d\r2[29]=0:d\g2[29]=0:d\b2[29]=101:d\r2[30]=0:d\g2[30]=0:d\b2[30]=199:d\r2[31]=0:d\g2[31]=0:d\b2[31]=255:d\r2[32]=0:d\g2[32]=0:d\b2[32]=68:d\r2[33]=0:d\g2[33]=0:d\b2[33]=128:d\r2[34]=0:d\g2[34]=0:d\b2[34]=150:d\r2[35]=0:d\g2[35]=0:d\b2[35]=29:d\r2[36]=0:d\g2[36]=0:d\b2[36]=143:d\r2[37]=0:d\g2[37]=0:d\b2[37]=255:d\r2[38]=0:d\g2[38]=0:d\b2[38]=178

guidesigncreatedefaultcornerimage(d,0)

Case 4 ; sandy

d\r[0]=164:d\g[0]=138:d\b[0]=101:d\r[1]=135:d\g[1]=96:d\b[1]=52:d\r[2]=101:d\g[2]=78:d\b[2]=49:d\r[3]=96:d\g[3]=75:d\b[3]=55:d\r[4]=135:d\g[4]=96:d\b[4]=52:d\r[5]=169:d\g[5]=141:d\b[5]=112:d\r[6]=135:d\g[6]=114:d\b[6]=70:d\r[7]=135:d\g[7]=114:d\b[7]=70
d\r[8]=169:d\g[8]=141:d\b[8]=112:d\r[9]=143:d\g[9]=112:d\b[9]=81:d\r[10]=75:d\g[10]=57:d\b[10]=42:d\r[11]=75:d\g[11]=57:d\b[11]=42:d\r[12]=143:d\g[12]=112:d\b[12]=81:d\r[13]=128:d\g[13]=107:d\b[13]=86:d\r[14]=88:d\g[14]=70:d\b[14]=60:d\r[15]=130:d\g[15]=109:d\b[15]=86
d\r[16]=130:d\g[16]=109:d\b[16]=86:d\r[17]=130:d\g[17]=109:d\b[17]=86:d\r[18]=130:d\g[18]=109:d\b[18]=86:d\r[19]=86:d\g[19]=68:d\b[19]=49:d\r[20]=211:d\g[20]=190:d\b[20]=161:d\r[21]=135:d\g[21]=120:d\b[21]=83:d\r[22]=187:d\g[22]=151:d\b[22]=125:d\r[23]=187:d\g[23]=151:d\b[23]=125:d\r[24]=135:d\g[24]=120:d\b[24]=83:d\r[25]=0:d\g[25]=0:d\b[25]=0:d\r[26]=130:d\g[26]=94:d\b[26]=62:d\r[27]=130:d\g[27]=94:d\b[27]=62:d\r[28]=0:d\g[28]=0:d\b[28]=0
d\r[28]=0:d\g[28]=0:d\b[28]=0:d\r[29]=128:d\g[29]=117:d\b[29]=86:d\r[30]=49:d\g[30]=49:d\b[30]=49:d\r[31]=49:d\g[31]=49:d\b[31]=49:d\r[32]=167:d\g[32]=135:d\b[32]=104:d\r[33]=114:d\g[33]=86:d\b[33]=60:d\r[34]=114:d\g[34]=86:d\b[34]=60:d\r[35]=167:d\g[35]=135:d\b[35]=104:d\r[36]=114:d\g[36]=99:d\b[36]=73:d\r[37]=0:d\g[37]=0:d\b[37]=0:d\r[38]=0:d\g[38]=0:d\b[38]=114
d\r2[0]=164:d\g2[0]=138:d\b2[0]=101:d\r2[1]=135:d\g2[1]=96:d\b2[1]=52:d\r2[2]=101:d\g2[2]=78:d\b2[2]=49:d\r2[3]=96:d\g2[3]=75:d\b2[3]=55:d\r2[4]=135:d\g2[4]=96:d\b2[4]=52:d\r2[5]=169:d\g2[5]=141:d\b2[5]=112:d\r2[6]=135:d\g2[6]=114:d\b2[6]=70:d\r2[7]=135:d\g2[7]=114:d\b2[7]=70
d\r2[8]=169:d\g2[8]=141:d\b2[8]=112:d\r2[9]=143:d\g2[9]=112:d\b2[9]=81:d\r2[10]=75:d\g2[10]=57:d\b2[10]=42:d\r2[11]=75:d\g2[11]=57:d\b2[11]=42:d\r2[12]=143:d\g2[12]=112:d\b2[12]=81:d\r2[13]=128:d\g2[13]=107:d\b2[13]=86:d\r2[14]=88:d\g2[14]=70:d\b2[14]=60:d\r2[15]=81:d\g2[15]=62:d\b2[15]=36
d\r2[16]=81:d\g2[16]=62:d\b2[16]=36:d\r2[17]=81:d\g2[17]=62:d\b2[17]=36:d\r2[18]=81:d\g2[18]=62:d\b2[18]=36:d\r2[19]=0:d\g2[19]=0:d\b2[19]=0:d\r2[20]=211:d\g2[20]=190:d\b2[20]=161:d\r2[21]=0:d\g2[21]=0:d\b2[21]=0:d\r2[22]=187:d\g2[22]=151:d\b2[22]=125:d\r2[23]=187:d\g2[23]=151:d\b2[23]=125:d\r2[24]=0:d\g2[24]=0:d\b2[24]=0:d\r2[25]=130:d\g2[25]=94:d\b2[25]=62:d\r2[26]=0:d\g2[26]=0:d\b2[26]=0:d\r2[27]=0:d\g2[27]=0:d\b2[27]=0:d\r2[28]=130:d\g2[28]=94:d\b2[28]=62
d\r2[28]=130:d\g2[28]=94:d\b2[28]=62:d\r2[29]=128:d\g2[29]=117:d\b2[29]=86:d\r2[30]=49:d\g2[30]=49:d\b2[30]=49:d\r2[31]=94:d\g2[31]=68:d\b2[31]=55:d\r2[32]=167:d\g2[32]=135:d\b2[32]=104:d\r2[33]=114:d\g2[33]=86:d\b2[33]=60:d\r2[34]=114:d\g2[34]=86:d\b2[34]=60:d\r2[35]=167:d\g2[35]=135:d\b2[35]=104:d\r2[36]=114:d\g2[36]=99:d\b2[36]=73:d\r2[37]=148:d\g2[37]=130:d\b2[37]=109:d\r2[38]=0:d\g2[38]=0:d\b2[38]=0

guidesigncreatedefaultcornerimage(d,0)

Case 5
d\r[0]=68:d\g[0]=128:d\b[0]=109:d\r[1]=81:d\g[1]=148:d\b[1]=117:d\r[2]=73:d\g[2]=114:d\b[2]=114:d\r[3]=73:d\g[3]=114:d\b[3]=114:d\r[4]=83:d\g[4]=148:d\b[4]=117:d\r[5]=75:d\g[5]=133:d\b[5]=112:d\r[6]=39:d\g[6]=133:d\b[6]=91:d\r[7]=39:d\g[7]=133:d\b[7]=91
d\r[8]=75:d\g[8]=133:d\b[8]=112:d\r[9]=143:d\g[9]=112:d\b[9]=81:d\r[10]=75:d\g[10]=57:d\b[10]=42:d\r[11]=75:d\g[11]=57:d\b[11]=42:d\r[12]=143:d\g[12]=112:d\b[12]=81:d\r[13]=73:d\g[13]=109:d\b[13]=91:d\r[14]=0:d\g[14]=52:d\b[14]=42:d\r[15]=55:d\g[15]=109:d\b[15]=78
d\r[16]=0:d\g[16]=0:d\b[16]=0:d\r[17]=0:d\g[17]=0:d\b[17]=0:d\r[18]=55:d\g[18]=109:d\b[18]=78:d\r[19]=26:d\g[19]=55:d\b[19]=34:d\r[20]=164:d\g[20]=211:d\b[20]=172:d\r[21]=44:d\g[21]=114:d\b[21]=91:d\r[22]=104:d\g[22]=128:d\b[22]=96:d\r[23]=60:d\g[23]=107:d\b[23]=94:d\r[24]=44:d\g[24]=114:d\b[24]=91:d\r[25]=44:d\g[25]=86:d\b[25]=68:d\r[26]=0:d\g[26]=0:d\b[26]=0:d\r[27]=0:d\g[27]=0:d\b[27]=0:d\r[28]=44:d\g[28]=86:d\b[28]=68
d\r[28]=44:d\g[28]=86:d\b[28]=68:d\r[29]=39:d\g[29]=122:d\b[29]=88:d\r[30]=18:d\g[30]=55:d\b[30]=31:d\r[31]=18:d\g[31]=49:d\b[31]=31:d\r[32]=62:d\g[32]=141:d\b[32]=107:d\r[33]=62:d\g[33]=81:d\b[33]=55:d\r[34]=62:d\g[34]=81:d\b[34]=55:d\r[35]=62:d\g[35]=141:d\b[35]=107:d\r[36]=0:d\g[36]=99:d\b[36]=78:d\r[37]=0:d\g[37]=99:d\b[37]=78:d\r[38]=0:d\g[38]=0:d\b[38]=114
d\r2[0]=68:d\g2[0]=128:d\b2[0]=109:d\r2[1]=81:d\g2[1]=148:d\b2[1]=117:d\r2[2]=73:d\g2[2]=114:d\b2[2]=114:d\r2[3]=73:d\g2[3]=114:d\b2[3]=114:d\r2[4]=83:d\g2[4]=148:d\b2[4]=117:d\r2[5]=75:d\g2[5]=133:d\b2[5]=112:d\r2[6]=39:d\g2[6]=133:d\b2[6]=91:d\r2[7]=39:d\g2[7]=133:d\b2[7]=91
d\r2[8]=75:d\g2[8]=133:d\b2[8]=112:d\r2[9]=143:d\g2[9]=112:d\b2[9]=81:d\r2[10]=75:d\g2[10]=57:d\b2[10]=42:d\r2[11]=75:d\g2[11]=57:d\b2[11]=42:d\r2[12]=143:d\g2[12]=112:d\b2[12]=81:d\r2[13]=73:d\g2[13]=109:d\b2[13]=91:d\r2[14]=0:d\g2[14]=52:d\b2[14]=42:d\r2[15]=55:d\g2[15]=109:d\b2[15]=78
d\r2[16]=0:d\g2[16]=0:d\b2[16]=0:d\r2[17]=0:d\g2[17]=0:d\b2[17]=0:d\r2[18]=55:d\g2[18]=109:d\b2[18]=78:d\r2[19]=26:d\g2[19]=55:d\b2[19]=34:d\r2[20]=117:d\g2[20]=167:d\b2[20]=135:d\r2[21]=44:d\g2[21]=114:d\b2[21]=91:d\r2[22]=68:d\g2[22]=146:d\b2[22]=78:d\r2[23]=68:d\g2[23]=146:d\b2[23]=107:d\r2[24]=44:d\g2[24]=114:d\b2[24]=91:d\r2[25]=0:d\g2[25]=0:d\b2[25]=0:d\r2[26]=44:d\g2[26]=114:d\b2[26]=91:d\r2[27]=44:d\g2[27]=114:d\b2[27]=91:d\r2[28]=0:d\g2[28]=0:d\b2[28]=0
d\r2[28]=0:d\g2[28]=0:d\b2[28]=0:d\r2[29]=39:d\g2[29]=122:d\b2[29]=88:d\r2[30]=0:d\g2[30]=36:d\b2[30]=26:d\r2[31]=0:d\g2[31]=36:d\b2[31]=26:d\r2[32]=39:d\g2[32]=122:d\b2[32]=88:d\r2[33]=62:d\g2[33]=133:d\b2[33]=101:d\r2[34]=83:d\g2[34]=135:d\b2[34]=101:d\r2[35]=39:d\g2[35]=122:d\b2[35]=88:d\r2[36]=0:d\g2[36]=99:d\b2[36]=78:d\r2[37]=0:d\g2[37]=133:d\b2[37]=117:d\r2[38]=47:d\g2[38]=91:d\b2[38]=73
guidesigncreatedefaultcornerimage(d,0)

Case 6

d\r[0]=192:d\g[0]=192:d\b[0]=193:d\r[1]=223:d\g[1]=223:d\b[1]=223:d\r[2]=0:d\g[2]=0:d\b[2]=0:d\r[3]=0:d\g[3]=0:d\b[3]=0:d\r[4]=223:d\g[4]=223:d\b[4]=223:d\r[5]=255:d\g[5]=255:d\b[5]=255:d\r[6]=128:d\g[6]=128:d\b[6]=128:d\r[7]=128:d\g[7]=128:d\b[7]=128
d\r[8]=255:d\g[8]=255:d\b[8]=255:d\r[9]=255:d\g[9]=255:d\b[9]=255:d\r[10]=128:d\g[10]=128:d\b[10]=128:d\r[11]=128:d\g[11]=128:d\b[11]=128:d\r[12]=255:d\g[12]=255:d\b[12]=255:d\r[13]=100:d\g[13]=100:d\b[13]=100:d\r[14]=0:d\g[14]=0:d\b[14]=0:d\r[15]=255:d\g[15]=255:d\b[15]=255
d\r[16]=128:d\g[16]=128:d\b[16]=128:d\r[17]=128:d\g[17]=128:d\b[17]=128:d\r[18]=255:d\g[18]=255:d\b[18]=255:d\r[19]=148:d\g[19]=148:d\b[19]=138:d\r[20]=203:d\g[20]=203:d\b[20]=203:d\r[21]=138:d\g[21]=138:d\b[21]=138:d\r[22]=138:d\g[22]=138:d\b[22]=138:d\r[23]=133:d\g[23]=133:d\b[23]=133:d\r[24]=135:d\g[24]=135:d\b[24]=135:d\r[25]=195:d\g[25]=195:d\b[25]=195:d\r[26]=36:d\g[26]=36:d\b[26]=36:d\r[27]=0:d\g[27]=0:d\b[27]=0:d\r[28]=195:d\g[28]=195:d\b[28]=195
d\r[28]=195:d\g[28]=195:d\b[28]=195:d\r[29]=109:d\g[29]=96:d\b[29]=96:d\r[30]=0:d\g[30]=0:d\b[30]=0:d\r[31]=185:d\g[31]=185:d\b[31]=185:d\r[32]=174:d\g[32]=174:d\b[32]=174:d\r[33]=96:d\g[33]=96:d\b[33]=96:d\r[34]=96:d\g[34]=96:d\b[34]=96:d\r[35]=174:d\g[35]=174:d\b[35]=174:d\r[36]=138:d\g[36]=138:d\b[36]=138:d\r[37]=255:d\g[37]=255:d\b[37]=255:d\r[38]=255:d\g[38]=255:d\b[38]=255
d\r2[0]=192:d\g2[0]=192:d\b2[0]=193:d\r2[1]=200:d\g2[1]=200:d\b2[1]=200:d\r2[2]=0:d\g2[2]=0:d\b2[2]=0:d\r2[3]=0:d\g2[3]=0:d\b2[3]=0:d\r2[4]=200:d\g2[4]=200:d\b2[4]=200:d\r2[5]=224:d\g2[5]=224:d\b2[5]=224:d\r2[6]=104:d\g2[6]=104:d\b2[6]=104:d\r2[7]=104:d\g2[7]=104:d\b2[7]=104
d\r2[8]=224:d\g2[8]=224:d\b2[8]=224:d\r2[9]=255:d\g2[9]=255:d\b2[9]=255:d\r2[10]=128:d\g2[10]=128:d\b2[10]=128:d\r2[11]=128:d\g2[11]=128:d\b2[11]=128:d\r2[12]=255:d\g2[12]=255:d\b2[12]=255:d\r2[13]=100:d\g2[13]=100:d\b2[13]=100:d\r2[14]=0:d\g2[14]=0:d\b2[14]=0:d\r2[15]=141:d\g2[15]=141:d\b2[15]=141
d\r2[16]=203:d\g2[16]=203:d\b2[16]=203:d\r2[17]=206:d\g2[17]=203:d\b2[17]=203:d\r2[18]=141:d\g2[18]=141:d\b2[18]=141:d\r2[19]=148:d\g2[19]=148:d\b2[19]=138:d\r2[20]=255:d\g2[20]=255:d\b2[20]=255:d\r2[21]=180:d\g2[21]=180:d\b2[21]=180:d\r2[22]=180:d\g2[22]=180:d\b2[22]=180:d\r2[23]=180:d\g2[23]=180:d\b2[23]=180:d\r2[24]=180:d\g2[24]=180:d\b2[24]=180:d\r2[25]=0:d\g2[25]=0:d\b2[25]=0:d\r2[26]=174:d\g2[26]=174:d\b2[26]=174:d\r2[27]=174:d\g2[27]=174:d\b2[27]=174:d\r2[28]=0:d\g2[28]=0:d\b2[28]=0
d\r2[28]=0:d\g2[28]=0:d\b2[28]=0:d\r2[29]=112:d\g2[29]=112:d\b2[29]=112:d\r2[30]=47:d\g2[30]=47:d\b2[30]=47:d\r2[31]=185:d\g2[31]=185:d\b2[31]=185:d\r2[32]=114:d\g2[32]=114:d\b2[32]=114:d\r2[33]=156:d\g2[33]=156:d\b2[33]=156:d\r2[34]=156:d\g2[34]=156:d\b2[34]=156:d\r2[35]=114:d\g2[35]=114:d\b2[35]=114:d\r2[36]=138:d\g2[36]=138:d\b2[36]=138:d\r2[37]=193:d\g2[37]=193:d\b2[37]=193:d\r2[38]=159:d\g2[38]=159:d\b2[38]=159

guidesigncreatedefaultcornerimage(d,0)

End Select

Return d


End Function


Function guidesigncreatedefaultcornerimage(d.guidesign,pic)
buf=GraphicsBuffer()

Select pic
Case 0

d\cimage[0]=CreateImage(12,12)
MidHandle d\cimage[0]
SetBuffer ImageBuffer(d\cimage[0])
Color d\r[20],d\g[20],d\b[20]
Line 3,3,8,8
Line 8,3,3,8
d\cimage[1]=CreateImage(12,12)
MidHandle d\cimage[1]
SetBuffer ImageBuffer(d\cimage[1])
Color d\r2[20],d\g2[20],d\b2[20]
Line 3,3,8,8
Line 8,3,3,8

d\cimage[2]=CreateImage(12,12)
MidHandle d\cimage[2]
SetBuffer ImageBuffer(d\cimage[2])
Color d\r[20],d\g[20],d\b[20]
Rect 3,3,6,6,0
Rect 5,5,5,5,1
d\cimage[3]=CreateImage(12,12)
MidHandle d\cimage[3]
SetBuffer ImageBuffer(d\cimage[3])
Color d\r2[20],d\g2[20],d\b2[20]
Rect 3,3,6,6,0
Rect 5,5,5,5,1


Case 1



End Select


SetBuffer buf
End Function



Function guifreeall()

Delete Each window
Delete Each gadget
Delete Each windowfilerequesttype

windowinteract.window=Null:windowinteractstate=0:windowinteractx=0:windowinteracty=0:windowinteractwid=0:windowinteracthei=0
windowinteractright=0:windowinteractdown=0:windowinteractleft=0:windowinteractup=0
windowhelpon=1:windowhelpdelay=2000
windowinteractclosed.window=Null

gadgetinteractstate=0:gadgetinteract.gadget=Null:gadgetinteractdelay=0:gadgetinteractx=0:gadgetinteracty=0:gadgetinteractx2=0:gadgetinteracty2=0:gadgetinteractxp#=0:gadgetinteractyp#=0
gadgetinteracthelpon=0:gadgetinteracthelptime=0:gadgetinteracthelpx=0:gadgetinteracthelpy=0:gadgetinteracthelptext$=0:gadgetinteracthelpgadget.gadget=Null
gadgetinteracttimer=0:gadgetinteractmisc=0:gadgetinteractcycle=0

For g.guidesign=Each guidesign
For k=0 To 1
If g\bimage[k] Then FreeImage g\bimage[k] 
If g\himage[k] Then FreeImage g\himage[k] 
If g\gimage[k] Then FreeImage g\gimage[k] 
Next
For k=0 To 5
If g\cimage[k] Then FreeImage g\cimage[k] 
Next
Next

Delete Each guidesign


End Function


Function guidesignload.guidesign(filename$)
If FileType(filename$)<>1 Then Return Null

file=ReadFile(filename$)

If ReadLine(file)<>"BBGuiGuidesign" Then Return Null
d.guidesign=New guidesign
For n=0 To 38
d\r[n]=ReadByte(file)
d\g[n]=ReadByte(file)
d\b[n]=ReadByte(file)
d\r2[n]=ReadByte(file)
d\g2[n]=ReadByte(file)
d\b2[n]=ReadByte(file)
Next
CloseFile file
guidesigncreatedefaultcornerimage(d,0)
Return d
End Function




Function guidesigncreatedesign.guidesign(main$,wid1,hei1,back$,cr,cg,cb)


d.guidesign=New guidesign
d\typ=1
d\image[0]=LoadAnimImage(main$,wid1,hei1,0,27)
MaskImage d\image[0],cr,cg,cb
MidHandle d\image[0]

If back$<>""
d\image[1]=LoadImage(back$)
EndIf

;guidesigncreatedefaultcornerimage(d,0)

d\r[30]=0
d\g[30]=128
d\b[30]=200
d\r2[30]=0
d\g2[30]=128
d\b2[30]=205

d\r[31]=0
d\g[31]=128
d\b[31]=200
d\r2[31]=0
d\g2[31]=128
d\b2[31]=205



Return d
End Function


Function guidesignskin.guidesign(file$,r1=0,g1=0,b1=0,r2=0,g2=0,b2=0,mr=255,mg=0,mb=255)
d.guidesign=New guidesign
d\typ=1
ima=LoadImage(file$)
wid=ImageWidth(ima)/3
hei=ImageHeight(ima)/9
FreeImage ima
d\image[0]=LoadAnimImage(file$,wid,hei,0,27)
MaskImage d\image[0],mr,mg,mb
MidHandle d\image[0]

d\r[14]=r1
d\g[14]=g1
d\b[14]=b1
d\r2[14]=r1
d\g2[14]=g1
d\b2[14]=b1

d\r[30]=r1
d\g[30]=g1
d\b[30]=b1
d\r2[30]=r2
d\g2[30]=g2
d\b2[30]=b2

d\r[31]=r1
d\g[31]=g1
d\b[31]=b1
d\r2[31]=r2
d\g2[31]=g2
d\b2[31]=b2


Return d
End Function