;INCLUDE
Const TEXCNT = 3
Const SPACECHAR=65

.FTglobal
.FTtext
.FTchars
;Include "tester8include.bb"

Global HUDeventType$, HUDeventID$
Global HUDprevX#, HUDprevY#, HUDprevAng#
Global HUDitalic#=0.0

Type HUD
	Field cam
	Field ent
End Type

Type HUDlayer
	Field mesh
	Field surf[TEXCNT-1]
	Field H.HUD
	Field cursx#,cursy#
	Field Zorder
	Field spareSurf
	Field font.HUDfont
;	Field pickable
End Type

Type HUDfont
	Field bru[TEXCNT-1]
	Field texwidth
	Field texheight
	Field charhite#
	Field charx#[255]
	Field chary#[255]
	Field charwid#[255]
	Field texused[255]
	Field xs#,ys#
	Field blocksize
	Field pack
	Field mask
	Field r,g,b, alfa#
End Type

Type iconset
	Field fname$
	Field tex
	Field x#,y#
;	Field hi.HUDimage
	Field ic.icon
	Field xstep#,ystep#
	Field count
	Field iconsize
	Field names$
End Type

Type icon
	Field hi.HUDimage
	Field x#,y#
	Field clickID
	Field name$
	Field nxt.icon
End Type

Type HUDimage
	Field mesh
	Field piv
	Field surf
	Field tex
	Field x#,y#
	Field Zorder
	Field frame
;	Field pickable
End Type

Type HUDcounter
;	Field txt$
	Field layer.HUDlayer
	Field x#,y#
	Field just,centy
	Field mult#
	Field charcnt
	Field pad
End Type


Global defaultHUD.HUD
Global currHUD.HUD
Global printLayer.HUDlayer
Global currLayer.HUDlayer
Global currfont.HUDfont


Function SaveLayerToB3D(layer.HUDlayer,fname$)
	Local mesh = layer\mesh
	Local c_surf = GetSurface(mesh,1)
	Local c_brush=GetSurfaceBrush( c_surf )
	Local c_tex=GetBrushTexture( c_brush )
	Local c_tex_name$=Lower$(TextureName$( c_tex )) ; Full (!) Texture Path
	Local curdir$=Lower$(CurrentDir$())
	c_tex_name$= Replace$(c_tex_name$,curdir$,"") ;<<<<<<<<<<<<<<<<<<<

	WriteBB3D( fname$,mesh,c_tex_name )

	FreeBrush c_brush; release memory
	FreeTexture c_tex
End Function


; get this from http://www.blitzbasic.com/sdkspecs/sdkspecs/b3dfile_utils.zip
Include "data\includes\b3dfile.bb"

;B3D file writing courtesy of jfk
Function WriteBB3D( f_name$,mesh,c_tex_name$ )
	file=WriteFile( f_name$ )

	b3dSetFile( file )

	b3dBeginChunk( "BB3D" )
		b3dWriteInt( 1 )	;version

		b3dBeginChunk( "TEXS" ) ; list all textures used by the mesh
			b3dWriteString( c_tex_name$ ) 	;texture file
			b3dWriteInt( 2 )					;flags
			b3dWriteInt( 2 )					;blend
			b3dWriteFloat( 0 )					;x in tex 0 (hu?)
			b3dWriteFloat( 0 )					;y in tex 0
			b3dWriteFloat( 1 )					;x scale 1
			b3dWriteFloat( 1 )					;y scale 1
			b3dWriteFloat( 0 )					;rotation 0
		b3dEndChunk()	;end of TEXS chunk

		b3dBeginChunk( "BRUS" ) ; describe all brushes used by the mesh
			b3dWriteInt( 1 )					;number of textures per brush ; (eg 2 with lightmap)
			b3dWriteString( "brush"+(2) )		;brushname
			b3dWriteFloat( 1 )					;red
			b3dWriteFloat( 1 )					;green
			b3dWriteFloat( 1 )					;blue
			b3dWriteFloat( 1 )					;alpha
			b3dWriteFloat( 0 )					;shininess
			b3dWriteInt( 1 )					;blendmode
			b3dWriteInt( 0 )					;FX
			b3dWriteInt( 0 )					;used texture index
		b3dEndChunk()	;end of BRUS chunk

		b3dBeginChunk( "NODE" )
			b3dWriteString( "entity_name_here!" )
			b3dWriteFloat( 0 )	;x_pos
			b3dWriteFloat( 0 )	;y_pos
			b3dWriteFloat( 0 )	;z_pos
			b3dWriteFloat( 100 )	;x_scale
			b3dWriteFloat( 100 )	;y_scale
			b3dWriteFloat( 100 )	;z_scale
			b3dWriteFloat( 1 )	;rot_w
			b3dWriteFloat( 0 )	;rot_x
			b3dWriteFloat( 0 )	;rot_y
			b3dWriteFloat( 0 )	;rot_z
			WriteMESH( mesh )
		b3dEndChunk()	;end of NODE chunk

	b3dEndChunk()	;end of BB3D chunk

	CloseFile file
End Function

Function WriteMESH( mesh )
	n_surfs=CountSurfaces( mesh )

	b3dBeginChunk( "MESH" )
		b3dWriteInt( -1 )				;no 'entity' brush -1

		b3dBeginChunk( "VRTS" )
			b3dWriteInt( 0 )			;flags - 0=no normal/color
			b3dWriteInt( 1 )			;number of tex_coord sets (eg: 2 with lightmap)
			b3dWriteInt( 2 )			;coords per set (u,v,w?) 2 with uv, 3 with uvw

			For k=1 To n_surfs
				surf=GetSurface( mesh,k )
				n_verts=CountVertices( surf )-1

				For j=0 To n_verts
					b3dWriteFloat( VertexX( surf,j ) )
					b3dWriteFloat( VertexY( surf,j ) )
					b3dWriteFloat( VertexZ( surf,j ) )
					b3dWriteFloat( VertexU#( surf,j,0 ) )
					b3dWriteFloat( VertexV#( surf,j,0 ) )
				Next
			Next
		b3dEndChunk()	;end of VRTS chunk

		first_vert=0
		For k=1 To n_surfs
			surf=GetSurface( mesh,k )
			n_tris=CountTriangles( surf )-1

			b3dBeginChunk( "TRIS" )
				b3dWriteInt( k-1 )		;brush for these triangles (surf -1 !!!)

				For j=0 To n_tris
					b3dWriteInt( first_vert+TriangleVertex( surf,j,0 ) )
					b3dWriteInt( first_vert+TriangleVertex( surf,j,1 ) )
					b3dWriteInt( first_vert+TriangleVertex( surf,j,2 ) )
				Next

			b3dEndChunk()	;end of TRIS chunk

			first_vert=first_vert+CountVertices( surf )

		Next
	b3dEndChunk()	;end of MESH chunk
End Function



Function HUDmoveTo(x2#,y2#)
	HUDprevX = x2
	HUDprevY = y2
End Function


Function HUDdrawTo(x2#,y2#, layer.HUDlayer, width#=20.0, char$="")
	Local x1# ;= HUDprevX
	Local y1# ;= HUDprevY

	x1# = HUDprevX
	y1# = HUDprevY

	HUDprevX = x2
	HUDprevY = y2


	If char<>""
		scii% = Asc(char)
	Else
		scii% = 0
	EndIf

	Local ang#, norm#, surf

	ang = ATan2((y2-y1),(x2-x1))
	newang# = (ang+HUDprevAng) / 2
	norm = 90.0 - newang
	norm2 = 90.0 - HUDprevAng
	HUDprevAng = newang

	width = 0.5 * width
	cosnorm# = Cos(norm)*width
	sinnorm# = Sin(norm)*width

	cosnorm2# = Cos(norm2)*width
	sinnorm2# = Sin(norm2)*width


	x3# = x1 + cosnorm2
	y3# = y1 - sinnorm2

	x4# = x2 + cosnorm
	y4# = y2 - sinnorm

;	Line x3,y3,x4,y4

	x5# = x1 - cosnorm2
	y5# = y1 + sinnorm2

	x6# = x2 - cosnorm
	y6# = y2 + sinnorm

;	Line x5,y5,x6,y6

;	Line x3,y3,x5,y5
;	Line x4,y4,x6,y6

	x3 = (x3-400.0)*0.002
	y3 = (600.0 - y3 - 300.0)*0.002
	x4 = (x4-400.0)*0.002
	y4 = (600.0 - y4 - 300.0)*0.002
	x5 = (x5-400.0)*0.002
	y5 = (600.0 - y5 - 300.0)*0.002
	x6 = (x6-400.0)*0.002
	y6 = (600.0 - y6 - 300.0)*0.002

	If scii
		surf = layer\surf[layer\font\texused[scii]]
		v0 = AddVertex(surf,x3,y3,0, layer\font\charx[scii],layer\font\chary[scii])
		v1 = AddVertex(surf,x4,y4,0, layer\font\charx[scii]+layer\font\charwid[scii],layer\font\chary[scii])
		v2 = AddVertex(surf,x5,y5,0, layer\font\charx[scii],layer\font\chary[scii]+layer\font\charhite)
		v3 = AddVertex(surf,x6,y6,0, layer\font\charx[scii]+layer\font\charwid[scii],layer\font\chary[scii]+layer\font\charhite)
	Else
		surf = layer\surf[0]
		v0 = AddVertex(surf,x3,y3,0, 0,0)
		v1 = AddVertex(surf,x4,y4,0, 0,1)
		v2 = AddVertex(surf,x5,y5,0, 1,1)
		v3 = AddVertex(surf,x6,y6,0, 1,0)
	EndIf

	VertexColor surf,v0, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v1, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v2, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v3, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa


	AddTriangle (surf,v0,v1,v2)
	AddTriangle (surf,v1,v3,v2)
End Function



Function HUDrect(x1#,y1#,wid#,hite#,layer.HUDlayer)
	HUDplot(x1#,y1#, layer, wid,hite)
End Function

Function HUDtextCircle (txt$,layer.HUDlayer,rad#=200.0,rad2#=250.0)
	Local scii, f, ang#, x3#,y3#,x4#,y4#,x5#,y5#,x6#,y6#

	Local font.HUDfont = layer\font

	Local totalcharwid# = 0.0
	For f = 1 To Len(txt)
		scii = Asc(Mid(txt,f,1))
		If scii <> 32
			totalcharwid = totalcharwid + layer\font\charwid[scii]
		Else
			totalcharwid = totalcharwid + (layer\font\charwid[SPACECHAR])
		EndIf
	Next

	lastcharwid# =0.0

	currcharwid# = 0.0
	For f = 1 To Len(txt);-1
		scii = Asc(Mid(txt,f,1))
		If scii <> 32
			currcharwid = currcharwid + layer\font\charwid[scii]
		Else
			currcharwid = currcharwid + (layer\font\charwid[SPACECHAR])
		EndIf

		ang# = lastcharwid/totalcharwid * 360.0	-90;Float(f)/Len(txt)
		ang2# = currcharwid/totalcharwid * 360.0 -90	;Float(f)/Len(txt)

		lastcharwid = currcharwid

		x3 = Cos(ang)*rad2 + 400
		y3 = Sin(ang)*rad2 + 300

		x4 = Cos(ang2)*rad2 + 400
		y4 = Sin(ang2)*rad2 + 300

		x5 = Cos(ang)*rad + 400
		y5 = Sin(ang)*rad + 300

		x6 = Cos(ang2)*rad + 400
		y6 = Sin(ang2)*rad + 300

		x3 = (x3-400.0)*0.002
		y3 = (600.0 - y3 - 300.0)*0.002
		x4 = (x4-400.0)*0.002
		y4 = (600.0 - y4 - 300.0)*0.002
		x5 = (x5-400.0)*0.002
		y5 = (600.0 - y5 - 300.0)*0.002
		x6 = (x6-400.0)*0.002
		y6 = (600.0 - y6 - 300.0)*0.002


		If scii <> 32
			surf = layer\surf[font\texused[scii]]
			v0 = AddVertex(surf,x3,y3,0, font\charx[scii],font\chary[scii])
			v1 = AddVertex(surf,x4,y4,0, font\charx[scii]+font\charwid[scii],font\chary[scii])
			v2 = AddVertex(surf,x5,y5,0, font\charx[scii],font\chary[scii]+font\charhite)
			v3 = AddVertex(surf,x6,y6,0, font\charx[scii]+font\charwid[scii],font\chary[scii]+font\charhite)

			VertexColor surf,v0, font\r,font\g,font\b, font\alfa
			VertexColor surf,v1, font\r,font\g,font\b, font\alfa
			VertexColor surf,v2, font\r,font\g,font\b, font\alfa
			VertexColor surf,v3, font\r,font\g,font\b, font\alfa

			AddTriangle (surf,v0,v1,v2)
			AddTriangle (surf,v1,v3,v2)
		EndIf


	Next

End Function


Function HUDtextCurve (txt$,x0#,y0#, x1#,y1#, x2#,y2#, layer.HUDlayer, width# = 1.0, width2#=-900000.0, width3#=-900000.0)
	Local ang#, norm#, surf, scii%, prevsinnorm#, prevcosnorm#
	width = 0.5 * width

	Local font.HUDfont = layer\font

	x1b# = Bezier(x0,x1,x2, 0)
	y1b# = Bezier(y0,y1,y2, 0)
	x2b# = Bezier(x0,x1,x2, 1.0/Len(txt))
	y2b# = Bezier(y0,y1,y2, 1.0/Len(txt))

	If width2 < -800000.0
		width2# = width
		width3# = width
	EndIf
	width4# = Bezier(width,width2,width3, 0)

	ang = ATan2((y2b-y1b),(x2b-x1b))
	norm = 90.0 - ang

	prevcosnorm# = Cos(norm)*width
	prevsinnorm# = Sin(norm)*width

	totalcharwid# = 0.0
	For f = 1 To Len(txt)
		scii = Asc(Mid(txt,f,1))
		Local xoff# = layer\font\charwid[scii]
		If scii <> 32
			totalcharwid = totalcharwid + (xoff)
		Else
			totalcharwid = totalcharwid + (layer\font\charwid[SPACECHAR])
		EndIf
	Next


	currcharwid# = 0.0
	For f = 1 To Len(txt);-1
		scii = Asc(Mid(txt,f,1))
		If scii <> 32
			currcharwid = currcharwid + layer\font\charwid[scii]
		Else
			currcharwid = currcharwid + (layer\font\charwid[SPACECHAR])
		EndIf

		mu2# = currcharwid/totalcharwid	;Float(f)/Len(txt)



		x2b# = Bezier(x0,x1,x2, mu2)
		y2b# = Bezier(y0,y1,y2, mu2)

	;	================================
;		scii = Asc(Mid(txt,f,1))

		ang = ATan2((y2b-y1b),(x2b-x1b))
		norm = 90.0 - ang

		cosnorm# = Cos(norm)*width4
		sinnorm# = Sin(norm)*width4



		usecosnorm# = (cosnorm + prevcosnorm) * 0.5
		usesinnorm# = (sinnorm + prevsinnorm) * 0.5

		x3# = x1b + prevcosnorm
		y3# = y1b - prevsinnorm

		x4# = x2b + usecosnorm
		y4# = y2b - usesinnorm

	;	Line x3,y3,x4,y4

		x5# = x1b - prevcosnorm
		y5# = y1b + prevsinnorm

		x6# = x2b - usecosnorm
		y6# = y2b + usesinnorm

		x1b# = x2b;Bezier(x0,x1,x2, mu)
		y1b# = y2b;Bezier(y0,y1,y2, mu)
		width4# = Bezier(width,width2,width3, mu2)
		prevcosnorm = cosnorm
		prevsinnorm = sinnorm
	;	Line x5,y5,x6,y6

	;	Line x3,y3,x5,y5
	;	Line x4,y4,x6,y6

		x3 = (x3-400.0)*0.002
		y3 = (600.0 - y3 - 300.0)*0.002
		x4 = (x4-400.0)*0.002
		y4 = (600.0 - y4 - 300.0)*0.002
		x5 = (x5-400.0)*0.002
		y5 = (600.0 - y5 - 300.0)*0.002
		x6 = (x6-400.0)*0.002
		y6 = (600.0 - y6 - 300.0)*0.002

		If scii <> 32
			surf = layer\surf[font\texused[scii]]
			v0 = AddVertex(surf,x3,y3,0, font\charx[scii],font\chary[scii])
			v1 = AddVertex(surf,x4,y4,0, font\charx[scii]+font\charwid[scii],font\chary[scii])
			v2 = AddVertex(surf,x5,y5,0, font\charx[scii],font\chary[scii]+font\charhite)
			v3 = AddVertex(surf,x6,y6,0, font\charx[scii]+font\charwid[scii],font\chary[scii]+font\charhite)

			VertexColor surf,v0, font\r,font\g,font\b, font\alfa
			VertexColor surf,v1, font\r,font\g,font\b, font\alfa
			VertexColor surf,v2, font\r,font\g,font\b, font\alfa
			VertexColor surf,v3, font\r,font\g,font\b, font\alfa

			AddTriangle (surf,v0,v1,v2)
			AddTriangle (surf,v1,v3,v2)
		EndIf
	Next
End Function



Function Bezier#(x1#,x2#,x3#, mu# = 0.5)
   Local mum1#,mum12#,mu2#

   mu2 = mu * mu
   mum1 = 1.0 - mu
   mum12 = mum1 * mum1
   newx# = x1 * mum12 + 2.0 * x2 * mum1 * mu + x3 * mu2

   Return (newx)
End Function


Function HUDcurve (x0,y0, x1,y1, cpx,cpy, layer.HUDlayer, width# = 1.0)
;	FontColor currfont ,Rand(255),Rand(255),Rand(255)
	divideCurve(x0,y0, x1,y1, cpx,cpy, layer, width)
End Function


Function divideCurve(x0,y0, x1,y1, cpx,cpy, layer.HUDlayer, width#=1.0,counter=4)		; last num shouldn't go much above 6
	If counter = 0
		HUDline x0, y0, x1, y1,layer,width,"",True
	Else
		xsplit = 0.5 * (x0+cpx)
		ysplit = 0.5 * (y0+cpy)

		xsplit2 = 0.5 * (cpx+x1)
		ysplit2 = 0.5 * (cpy+y1)

		sendX = 0.5 * (xsplit + xsplit2)
		sendY = 0.5 * (ysplit + ysplit2)
		divideCurve (x0,y0, sendX,sendY, xsplit,ysplit, layer,width,counter-1)
		divideCurve (x1,y1, sendX,sendY, xsplit2,ysplit2, layer,width,counter-1)
	EndIf
End Function


Function HUDline(x1#,y1#,x2#,y2#, layer.HUDlayer, width#=1.0, char$="", roundends=False)
	If char<>""
		scii% = Asc(char)
	Else
		scii% = 0
	EndIf

	Local ang#, norm#, surf

	ang = ATan2((y2-y1),(x2-x1))
	norm = 90.0 - ang

	width = 0.5 * width
	cosnorm# = Cos(norm)*width
	sinnorm# = Sin(norm)*width

	x3# = x1 + cosnorm
	y3# = y1 - sinnorm

	x4# = x2 + cosnorm
	y4# = y2 - sinnorm

;	Line x3,y3,x4,y4

	x5# = x1 - cosnorm
	y5# = y1 + sinnorm

	x6# = x2 - cosnorm
	y6# = y2 + sinnorm

;	Line x5,y5,x6,y6

;	Line x3,y3,x5,y5
;	Line x4,y4,x6,y6

	x3 = (x3-400.0)*0.002
	y3 = (600.0 - y3 - 300.0)*0.002
	x4 = (x4-400.0)*0.002
	y4 = (600.0 - y4 - 300.0)*0.002
	x5 = (x5-400.0)*0.002
	y5 = (600.0 - y5 - 300.0)*0.002
	x6 = (x6-400.0)*0.002
	y6 = (600.0 - y6 - 300.0)*0.002

	If scii
		surf = layer\surf[layer\font\texused[scii]]
		v0 = AddVertex(surf,x3,y3,0, layer\font\charx[scii],layer\font\chary[scii])
		v1 = AddVertex(surf,x4,y4,0, layer\font\charx[scii]+layer\font\charwid[scii],layer\font\chary[scii])
		v2 = AddVertex(surf,x5,y5,0, layer\font\charx[scii],layer\font\chary[scii]+layer\font\charhite)
		v3 = AddVertex(surf,x6,y6,0, layer\font\charx[scii]+layer\font\charwid[scii],layer\font\chary[scii]+layer\font\charhite)
	Else
		surf = layer\surf[0]
		v0 = AddVertex(surf,x3,y3,0, 0,0)
		v1 = AddVertex(surf,x4,y4,0, 0,1)
		v2 = AddVertex(surf,x5,y5,0, 1,1)
		v3 = AddVertex(surf,x6,y6,0, 1,0)

		If roundends
			cosang# = Cos(ang)*width
			sinang# = Sin(ang)*width

			x7# = x1 - cosang
			y7# = y1 - sinang
			x7 = (x7-400.0)*0.002
			y7 = (600.0 - y7 - 300.0)*0.002

			x8# = x2 + cosang
			y8# = y2 + sinang
			x8 = (x8-400.0)*0.002
			y8 = (600.0 - y8 - 300.0)*0.002

			v4 = AddVertex(surf,x7,y7,0, 0,0)
			v5 = AddVertex(surf,x8,y8,0, 0,0)

			AddTriangle (surf,v0,v2,v4)
			AddTriangle (surf,v1,v3,v5)
			AddTriangle (surf,v0,v4,v2)
			AddTriangle (surf,v1,v5,v3)

			VertexColor surf,v4, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
			VertexColor surf,v5, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
		EndIf
	EndIf

	VertexColor surf,v0, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v1, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v2, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v3, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa


	AddTriangle (surf,v0,v1,v2)
	AddTriangle (surf,v1,v3,v2)
End Function

Function HUDloadCanvasImage.HUDimage(texfile$,zord=-50)
	Local image.HUDimage = HUDdrawimage(LoadTexture(texfile$), 0, 0, zord)
	Local par = GetParent(image\mesh)
	FreeEntity image\mesh
	image\mesh = CreateMesh(par)
	image\surf = CreateSurface(image\mesh)

	Local x1#=0.0, y1# = 0.0

	Local x2# = x1 +800.0
	Local y2# = y1 +600.0
	x1 = (x1-400.0)*0.002
	y1 = (600.0 - y1 - 300.0)*0.002
	x2 = (x2-400.0)*0.002
	y2 = (600.0 - y2 - 300.0)*0.002

	v0 = AddVertex(image\surf,x1,y1,0, 0,0)
	v1 = AddVertex(image\surf,x2,y1,0, 1,0)
	v2 = AddVertex(image\surf,x1,y2,0, 0,1)
	v3 = AddVertex(image\surf,x2,y2,0, 1,1)

	AddTriangle (image\surf,v0,v1,v2)
	AddTriangle (image\surf,v1,v3,v2)

	EntityTexture image\mesh,image\tex
	EntityOrder image\mesh, zord
	image\zorder = zord
	EntityFX image\mesh,1
	ScaleEntity image\mesh,250,250,1;2.5,2.5,1

	Return image
End Function


Function HUDplot(x1#,y1#, layer.HUDlayer , xsize#=2.0,ysize#=2.0)
	Local x2# = x1 +xsize
	Local y2# = y1 +ysize
	x1 = (x1-400.0)*0.002
	y1 = (600.0 - y1 - 300.0)*0.002
	x2 = (x2-400.0)*0.002
	y2 = (600.0 - y2 - 300.0)*0.002

	Local surf = layer\surf[0]
	v0 = AddVertex(surf,x1,y1,0, 0,0)
	v1 = AddVertex(surf,x2,y1,0, 0,1)
	v2 = AddVertex(surf,x1,y2,0, 1,1)
	v3 = AddVertex(surf,x2,y2,0, 1,0)

	VertexColor surf,v0, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v1, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v2, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa
	VertexColor surf,v3, layer\font\r,layer\font\g,layer\font\b, layer\font\alfa

	AddTriangle (surf,v0,v1,v2)
	AddTriangle (surf,v1,v3,v2)
End Function




Function HUDClearAll()
 	For hl.HUDlayer = Each HUDlayer
 		FreeEntity hl\mesh
 	Next
	Delete Each HUDlayer

 	Delete Each HUDcounter

	For hi.HUDimage = Each HUDimage
		HUDfreeImage hi
;		FreeEntity hi\mesh
;		FreeTexture hi\tex
	Next
;	Delete Each HUDimage

	For hood.HUD = Each HUD
		FreeEntity hood\ent
	Next
	Delete Each HUD

	For hf.HUDfont = Each HUDfont
		For f = 0 To TEXCNT-1
			FreeBrush hf\bru[f]
		Next
	Next
	Delete Each HUDfont
End Function


Function HUDfreeFont(hf.HUDfont)
	For f = 0 To TEXCNT-1
		FreeBrush hf\bru[f]
	Next
	Delete hf
End Function


Function HUDfreeImage(hi.hudimage, all=True)
	If hi = Null Then Return 0
	If all
		For hi2.HUDimage = Each HUDimage
			If hi2<>hi
				If hi2\tex = hi\tex
					FreeEntity hi2\mesh
					Delete hi2
				EndIf
			EndIf
		Next
	EndIf
	FreeEntity hi\mesh
	If all Then FreeTexture hi\tex
	ret=1
	If hi\mesh = 0 Then ret=0
	If hi\tex = 0 Then ret=0
	Delete hi
	Return ret
End Function

Function LoadIcons.iconset(fname$,names$,x#,y#,xstep#=1.0,ystep#=0, totcnt=-1)
	Local img = LoadImage(fname$)
	Local imgx = ImageWidth(img)
	Local imgy = ImageHeight(img)
	FreeImage img

	Local is.iconset = New iconset
	is\fname = fname
	is\x = x
	is\y = y
	is\xstep = xstep
	is\ystep = ystep
	is\names = names
	If Right(names,1) <>"|" Then names = names +"|"

	If imgx<imgy
		is\iconsize = imgx
		is\count = imgy/imgx
	Else
		is\iconsize = imgy
		is\count = imgx/imgy
	EndIf

	If totcnt > -1 Then count = totcnt

	is\tex = LoadAnimTexture(fname,2,is\iconsize,is\iconsize,0,is\count )
	For f = 1 To count
		ic.icon = New icon
		ic\nxt = is\ic
		is\ic = ic

		ic\name = Left(names,Instr(names,"|")-1)
		names = Right(names,Len(names)-Instr(names,"|"))

;		DebugLog Left(names,Instr(names,"|")-1)
;		DebugLog Right(names,Len(names)-Instr(names,"|"))
;		DebugLog ""
;		names = Right(names,Len(names)-Instr(names,"|"))


		ic\hi = HUDdrawimage (is\tex,x,y, -99, False, False, f-1)
		ic\clickID = MakeImageButton (ic\hi)
		x = x + xstep
		y = y + ystep
	Next
	Return is
End Function

Function FreeIcons(is.iconset)
	ic.icon = is\ic
	While ic<>Null
		temp.icon = ic\nxt
		HUDfreeImage ic\hi
		Delete ic
		ic=temp
	Wend
	FreeTexture is\tex
	Delete is
End Function


Function HUDdrawframe.hudimage(tex,x#,y#,frame=0)
	Return HUDdrawimage (tex,x,y, -199, False, False, frame)
End Function

Function HUDdrawimage.hudimage(tex,x#,y#, zord = -99, cent_x = False, cent_y = False, frame=0,alpha#=1.0)
;	If tex = 0 Then Return
	Local hi.hudimage = New hudimage
	hi\tex = tex
	hi\mesh = CreateMesh(currHUD\ent);(hi\piv)
	hi\surf = CreateSurface(hi\mesh)
	surf = hi\surf

	If cent_x Then x = x - (0.5 * TextureWidth(tex))
	If cent_y Then y = y - (0.5 * TextureHeight(tex))

	hi\x = (x-400.0)*0.002
	hi\y = (600.0 - y - 300.0)*0.002
	xoff# = 0.002* TextureWidth(tex)
	yoff# = 0.002* TextureHeight(tex)


	v0 = AddVertex ( surf,0,0,0 ,0,0 )
	v1 = AddVertex ( surf,xoff,0,0, 1,0 )
	v2 = AddVertex ( surf,0,-yoff,0, 0,1 )
	v3 = AddVertex ( surf,xoff,-yoff,0, 1,1 )

;	VertexColor surf,v0, currfont\r,currfont\g,currfont\b, currfont\alfa
;	VertexColor surf,v1, currfont\r,currfont\g,currfont\b, currfont\alfa
;	VertexColor surf,v2, currfont\r,currfont\g,currfont\b, currfont\alfa
;	VertexColor surf,v3, currfont\r,currfont\g,currfont\b, currfont\alfa

	AddTriangle ( surf,v0,v1,v2)
	AddTriangle ( surf,v1,v3,v2)

	EntityTexture hi\mesh,tex,frame
	hi\frame = frame

	PositionMesh hi\mesh, hi\x,hi\y,0
	ScaleEntity hi\mesh,250,250,1;2.5,2.5,1

	EntityFX hi\mesh,1
	EntityOrder hi\mesh,zord
	hi\zorder = zord

	EntityAlpha hi\mesh,alpha#

	Return hi
End Function


Function MakeImageButton(hi.hudimage)
	EntityPickMode hi\mesh,2
	Return hi\mesh
End Function

Function MakeTextButton(l.HUDlayer)
	EntityPickMode l\mesh,2
	Return l\mesh
End Function


Function HUDevent()
	Local picked = CameraPick(currHUD\cam,MouseX(),MouseY())
	If picked
		For ic.icon = Each icon
			If ic\clickID = picked
				HUDeventID = ic\name
				Exit
			EndIf
		Next
		If MouseDown(1)
			HUDeventType = "mousedown"
		Else
			HUDeventType = "mouseover"
		EndIf
		Return picked
	EndIf
	HUDeventType = ""
	HUDeventID = 0
End Function


Function HUDscaleImage(hi.HUDimage,xs#,ys#)
	PositionMesh hi\mesh, -hi\x,-hi\y,0
	ScaleMesh hi\mesh,xs,ys,1
	PositionMesh hi\mesh, hi\x,hi\y,0
End Function


Function HUDturnImage(hi.HUDimage,ang#)
	PositionMesh hi\mesh, -hi\x,-hi\y,0
	RotateMesh hi\mesh,0,0,ang
	PositionMesh hi\mesh, hi\x,hi\y,0
End Function

;Function HUDrotateImage(hi.HUDimage,ang#)
;	PositionMesh hi\mesh, -hi\x,-hi\y,0
;	RotateEntity hi\mesh,0,0,ang
;	PositionMesh hi\mesh, hi\x,hi\y,0
;End Function


Function HUDloadImage.hudimage(texfile$, x#, y#, zord = -99)
	Return HUDdrawimage(LoadTexture(texfile$), x#, y#, zord)
End Function

Function CreateHUD.HUD(cam)
	h.HUD = New HUD
	h\ent = CreatePivot(cam)
	PositionEntity h\ent,0,0,290;200	;PositionEntity h\ent,0,0,2
	h\cam = cam
	currHUD = h

	printLayer = CreateLayer(h)
	printLayer\cursx = (-400.0)*0.002
	printLayer\cursy = (300.0)*0.002

	Return h
End Function


Function CreateLayer.HUDlayer(h.HUD, zord=-99, draw=False)
	l.HUDlayer = New HUDlayer
	l\mesh = CreateMesh(h\ent)
;	If pickable Then EntityPickMode l\mesh,2
;	EntityBlend l\mesh, 3
	ScaleEntity l\mesh,250,250,1	;	ScaleEntity l\mesh,2.5,2.5,1
	EntityFX l\mesh,1+2+32+16
	EntityOrder l\mesh,zord
	l\zorder = zord
	l\font = currfont
	If draw
;		Local bru = CreateBrush($FF,$FF,$FF)
;		BrushFX bru,1+2+32
		l\surf[0] = CreateSurface(l\mesh);, bru)
;		FreeBrush bru
	Else
		For f = 0 To TEXCNT-1
			l\surf[f] = CreateSurface(l\mesh)
			If currfont\bru[f] <> 0 Then PaintSurface l\surf[f], currfont\bru[f]
		Next
		currLayer = l
	EndIf
	Return l
End Function


Function HUDsetLayer(layer.HUDlayer)
	If layer <> Null Then currLayer = layer
End Function


Function HUDLoadFont.HUDfont(font$, font2$="",font3$="", flags = 1+2+512+8, ini$="");
	hf.HUDfont = New HUDfont
	hf\bru[0] = LoadBrush (font,flags)
	If hf\bru[0]=0 Then RuntimeError "HUDinclude error: cannot find font image"
	hf\xs = 1.0
	hf\ys = 1.0
	hf\r = 255
	hf\g = 255
	hf\b = 255
	hf\alfa = 1.0

	If ini=""
		If Right(font2,4) = "data"
			UseInclude(hf,0)
		Else
			loadINI(Left(font,Len(font)-4)+".ini",hf,0)
		EndIf
	Else
		If Right(font2,4) = "data"
			UseInclude(hf,0)
		Else
			loadINI(ini,hf,0)
		EndIf
	EndIf
	currfont = hf

	If (font2 <> "") And (Right(font2,4) <> "data")
		hf\bru[1] = LoadBrush (font2,flags)
		If ini=""
			loadINI(Left(font2,Len(font2)-4)+".ini",hf, 1)
		Else
			loadINI(ini,hf,1)
		EndIf

		If font3 <> ""
			hf\bru[2] = LoadBrush (font3,flags)
			If ini=""
				loadINI(Left(font3,Len(font3)-4)+".ini",hf, 2)
			Else
				loadINI(ini,hf,2)
			EndIf
		EndIf
	EndIf

	Return hf
End Function


Function HUDsetFont(font.HUDfont)
	If font <> Null Then currfont = font
End Function


Function ScaleFont (hf.HUDfont, xs#,ys#)
	hf\xs = xs
	hf\ys = ys
End Function

Function FontColor (hf.HUDfont, r,g,b, alfa#=1.0)
	hf\r = r
	hf\g = g
	hf\b = b
	hf\alfa = alfa
End Function


Function UseInclude(hf.HUDfont,texused=0)
		Restore FTglobal
			Read hf\texwidth ;= HUDchunk(txt,2,"=")
			Read hf\texheight ;= HUDchunk(txt,2,"=")
			Read hf\mask ;= HUDchunk(txt,2,"=")
			Read hf\pack ;= HUDchunk(txt,2,"=")

		Restore FTtext
			Read hf\blocksize
			Read temp
;			Read temp

		Restore FTchars
			Read char$
			While char <> "END"
				Read hf\charx[Asc(char)]
				Read hf\chary[Asc(char)]
				Read hf\charwid[Asc(char)]
				hf\charx[Asc(char)] = hf\charx[Asc(char)] / hf\texwidth
				hf\chary[Asc(char)] = hf\chary[Asc(char)] / hf\texheight
				hf\charwid[Asc(char)] = hf\charwid[Asc(char)] / hf\texwidth
				hf\texused[Asc(char)] = texused
				Read char
			Wend
		hf\charhite = Float(hf\blocksize)/hf\texheight
End Function



Function loadINI(fname$,hf.HUDfont,texused=0)
	Local file = ReadFile(fname)
	If file
		Local txt$ = ""
		Local section$ = "[global]"
		While (Not Eof(file))
			txt$ = ReadLine(file)
;			If Left(txt,1) = "[" And Left(txt,2) <> "[="
			If Left(txt,1) = "[" And Right(txt,1) = "]"
				section = txt
			Else
				txt2$ = HUDchunk(txt,1,"=")
				Select section
					Case "[global]"
						Select txt2
							Case "width"
								hf\texwidth = HUDchunk(txt,2,"=")
							Case "height"
								hf\texheight = HUDchunk(txt,2,"=")
							Case "maskcolor"
								hf\mask = HUDchunk(txt,2,"=")
							Case "pack"
								hf\pack = HUDchunk(txt,2,"=")
						End Select
					Case "[text]"
						Select txt2
							Case "blocksize"
								hf\blocksize = HUDchunk(txt,2,"=")
						End Select
					Case "[charset]"
						If Left(txt,1) = "=" Then
							char$ = "="
							txt = "?"+Right(txt,Len(txt)-1)
						Else
							char$ = HUDchunk(txt,1,"=")
						EndIf
						params$ = HUDchunk(txt,2,"=")
						hf\charx[Asc(char)] = HUDchunk(params,1)
						hf\chary[Asc(char)] = HUDchunk(params,2)
						hf\charwid[Asc(char)] = HUDchunk(params,3)
						hf\charx[Asc(char)] = hf\charx[Asc(char)] / hf\texwidth
						hf\chary[Asc(char)] = hf\chary[Asc(char)] / hf\texheight
						hf\charwid[Asc(char)] = hf\charwid[Asc(char)] / hf\texwidth
						hf\texused[Asc(char)] = texused
				End Select
			EndIf
		Wend
		hf\charhite = Float(hf\blocksize)/hf\texheight
		CloseFile file
	Else
		RuntimeError "Font ini file missing: "+fname
	EndIf
End Function


Function HUDprint(txt$, mult#=1.0)
	Local yoff# = printlayer\font\ys * printlayer\font\charhite
	For f = 1 To Len(txt)
		Local scii = Asc(Mid(txt,f,1))
		Local xoff# = printlayer\font\xs * printlayer\font\charwid[scii]
		If scii <> 32
			HUDchar(scii,xoff,yoff,printlayer)
			printlayer\cursx = printlayer\cursx + (xoff * mult)
		Else
			printlayer\cursx = printlayer\cursx + (printlayer\font\xs * printlayer\font\charwid[SPACECHAR] * mult)
		EndIf
	Next
	printlayer\cursy = printlayer\cursy - yoff
	printlayer\cursx = (-400.0)*0.002
	; added
	If printlayer\cursy < ((-300.0)*0.002)
		HUDbumpLayer(printlayer, ((-300.0)*0.002) - printlayer\cursy)
	EndIf
End Function

Function HUDbumpLayer(l.HUDlayer, offset#)	;thanks to Dan_Upright
	topy# = (300.0)*0.002

	For f = 0 To TEXCNT-1
		If l\surf[f] <> 0
			If l\spareSurf = 0 Then l\spareSurf = CreateSurface(l\mesh)
			If printlayer\font\bru[f] <> 0 Then PaintSurface l\spareSurf, printlayer\font\bru[f]
			For t = 0 To CountTriangles(l\surf[f]) - 1
				ly# = VertexY(l\surf[f], TriangleVertex(l\surf[f], t, 0))
				For v = 1 To 2
					If VertexY(l\surf[f], TriangleVertex(l\surf[f], t, i)) < ly Then ly = VertexY(l\surf[f], TriangleVertex(l\surf[f], t, i))
				Next
				If (ly + offset) < topy
					v0 = TriangleVertex(l\surf[f], t, 0)
					v1 = TriangleVertex(l\surf[f], t, 1)
					v2 = TriangleVertex(l\surf[f], t, 2)
					vert0 = AddVertex(l\spareSurf, VertexX(l\surf[f], v0), VertexY(l\surf[f], v0) + offset, VertexZ(l\surf[f], v0), VertexU(l\surf[f], v0), VertexV(l\surf[f], v0))
					VertexColor l\spareSurf, vert0, VertexRed(l\surf[f], v0), VertexGreen(l\surf[f], v0), VertexBlue(l\surf[f], v0), VertexAlpha(l\surf[f], v0)
					vert1 = AddVertex(l\spareSurf, VertexX(l\surf[f], v1), VertexY(l\surf[f], v1) + offset, VertexZ(l\surf[f], v1), VertexU(l\surf[f], v1), VertexV(l\surf[f], v1))
					VertexColor l\spareSurf, vert1, VertexRed(l\surf[f], v1), VertexGreen(l\surf[f], v1), VertexBlue(l\surf[f], v1), VertexAlpha(l\surf[f], v1)
					vert2 = AddVertex(l\spareSurf, VertexX(l\surf[f], v2), VertexY(l\surf[f], v2) + offset, VertexZ(l\surf[f], v2), VertexU(l\surf[f], v2), VertexV(l\surf[f], v2))
					VertexColor l\spareSurf, vert2, VertexRed(l\surf[f], v2), VertexGreen(l\surf[f], v2), VertexBlue(l\surf[f], v2), VertexAlpha(l\surf[f], v2)
					AddTriangle l\spareSurf, vert0, vert1, vert2
				EndIf
			Next
			ClearSurface l\surf[f]
			s = l\surf[f]
			l\surf[f] = l\spareSurf
			l\spareSurf = s
		EndIf
	Next
	l\cursy = l\cursy + offset
End Function


Function HUDwrite(txt$, mult#=1.0)
	Local yoff# = printlayer\font\ys * printlayer\font\charhite
	For f = 1 To Len(txt)
		Local scii = Asc(Mid(txt,f,1))
		Local xoff# = printlayer\font\xs * printlayer\font\charwid[scii]
		If scii <> 32
			HUDchar(scii,xoff,yoff,printlayer)
			printlayer\cursx = printlayer\cursx + (xoff * mult)
		Else
			printlayer\cursx = printlayer\cursx + (printlayer\font\xs * printlayer\font\charwid[SPACECHAR] * mult)
		EndIf
	Next
End Function


Function HUDclickText(x#,y#,txt$,centx=0,centy=0,mult#=1.0)
	Local hl.HUDlayer = CreateLayer(defaultHUD)
	Local layerID = MakeTextButton (hl)

	HUDtext x,y,txt, centx,centy, mult, True
	Return layerID
End Function


Function HUDfreeClickText(clickID)
	For hl.HUDlayer = Each HUDlayer
		If hl\mesh = clickID
			FreeEntity hl\mesh
			Delete hl
			Return True
			Exit
		EndIf
	Next
	Return False
End Function


Function HUDtext(x#,y#,txt$,centx=0,centy=0,mult#=0.3,spacemesh=False,lean#=0.0)
	mult=mult*0.01
	lean = (lean+HUDitalic)*0.002 * currlayer\font\xs
	currlayer\cursx = (x-400.0)*0.002
	currlayer\cursy = (600.0 - y - 300.0)*0.002
	totalwid# = 0.0
	Local yoff# = currlayer\font\ys * currlayer\font\charhite
	Select centx
		Case 1
			For f = 1 To Len(txt)
				Local scii = Asc(Mid(txt,f,1))
				Local xoff# = currlayer\font\xs * currlayer\font\charwid[scii]
				If scii <> 32
					totalwid = totalwid + (xoff + mult)
				Else
					totalwid = totalwid + (currlayer\font\xs * currlayer\font\charwid[SPACECHAR] + mult)
				EndIf
			Next
			currlayer\cursx = currlayer\cursx - (totalwid * 0.5)
		Case 2
			For f = 1 To Len(txt)
				scii = Asc(Mid(txt,f,1))
				xoff# = currlayer\font\xs * currlayer\font\charwid[scii]
				If scii <> 32
					totalwid = totalwid + (xoff + mult)
				Else
					totalwid = totalwid + (currlayer\font\xs * currlayer\font\charwid[SPACECHAR] + mult)
				EndIf
			Next
			totalwid = totalwid + lean
			currlayer\cursx = currlayer\cursx - (totalwid)
	End Select

	If centy
		currlayer\cursy = currlayer\cursy + (yoff * 0.5)
	EndIf
	For f = 1 To Len(txt)
		scii = Asc(Mid(txt,f,1))
		Local space=False
		If scii = 32 Then
			scii=SPACECHAR
			space=True
		EndIf
		xoff# = currlayer\font\xs * currlayer\font\charwid[scii]

		If space
				If spacemesh Then HUDspaceChar(xoff,yoff,currlayer,lean)
		Else
				HUDchar(scii,xoff,yoff,currlayer,lean)
		EndIf
		currlayer\cursx = currlayer\cursx + (xoff + mult)
	Next
End Function


Function NewHUDCounter.HUDcounter(x#,y#,txt$,centx=2,centy=0,mult#=1.0)
	Local templayer.HUDlayer = currlayer
	hc.HUDcounter = New HUDcounter
	hc\layer = CreateLayer(currHUD,-100)
	hc\layer\cursx = (x-400.0)*0.002
	hc\layer\cursy = (600.0 - y - 300.0)*0.002
	hc\layer\font = currfont

	hc\x = x
	hc\y = y
	hc\just = centx
	hc\centy = centy
	hc\mult = mult
;	hc\pad = Asc(pad)
;	hc\charcnt = charcnt

	totalwid# = 0.0
	Local yoff# = currfont\ys * currfont\charhite
	Select centx
		Case 1
			Local xoff# = currfont\xs * currfont\blocksize *0.002 * mult
			totalwid = (xoff * mult) * Len(txt)
			hc\layer\cursx = hc\layer\cursx - (totalwid * 0.5)
		Case 2
			xoff# = currfont\xs * currfont\blocksize *0.002 * mult
			totalwid = (xoff * mult) * Len(txt)
			hc\layer\cursx = hc\layer\cursx - (totalwid)
	End Select
	If centy
		hc\layer\cursy = hc\layer\cursy + (yoff * 0.5)
	EndIf
	xoff# = currfont\xs * currfont\blocksize  *0.002 * mult
	For f = 1 To Len(txt)
		scii = Asc(Mid(txt,f,1))
		If scii <> 32
			HUDchar(scii,xoff,yoff,hc\layer)
		EndIf
		hc\layer\cursx = hc\layer\cursx + (xoff)
	Next
	currlayer = templayer.HUDlayer
	Return hc
End Function


Function UpdateHUDcounter(hc.HUDcounter,txt$)
	Local templayer.HUDlayer = currlayer
;	If hc\just = 2 Then txt = Right(String(Chr(hc\pad),hc\charcnt-Len(txt))+txt,hc\charcnt)
	For f = 0 To TEXCNT-1
		If hc\layer\surf[f] <> 0 Then ClearSurface hc\layer\surf[f]
	Next

	hc\layer\cursx = (hc\x-400.0)*0.002
	hc\layer\cursy = (600.0 - hc\y - 300.0)*0.002
	totalwid# = 0.0
	Local yoff# = hc\layer\font\ys * hc\layer\font\charhite
	Select hc\just
		Case 1
			Local xoff# = hc\layer\font\xs * hc\layer\font\blocksize * 0.002 * hc\mult
			totalwid = (xoff * hc\mult) * Len(txt)
			hc\layer\cursx = hc\layer\cursx - (totalwid * 0.5)
		Case 2
			xoff# = hc\layer\font\xs * hc\layer\font\blocksize * 0.002 * hc\mult
			totalwid = (xoff * hc\mult) * Len(txt)
			hc\layer\cursx = hc\layer\cursx - (totalwid)
	End Select
	If hc\centy
		hc\layer\cursy = hc\layer\cursy + (yoff * 0.5)
	EndIf
	xoff# = hc\layer\font\xs * hc\layer\font\blocksize * 0.002 * hc\mult
	For f = 1 To Len(txt)
		scii = Asc(Mid(txt,f,1))
		If scii <> 32
			HUDchar(scii,xoff,yoff,hc\layer)
		EndIf
		hc\layer\cursx = hc\layer\cursx + (xoff)
	Next
	currlayer = templayer.HUDlayer
End Function




Function HUDchar(scii%,xoff#=1.0,yoff#=1.0, layer.HUDlayer, lean#=0.0)
	Local font.HUDfont = layer\font
	Local surf = layer\surf[font\texused[scii]]
	Local x# = layer\cursx
	Local y# = layer\cursy
	v0 = AddVertex ( surf,x+lean,y,0 ,font\charx[scii],font\chary[scii] )
	v1 = AddVertex ( surf,x + xoff+lean,y,0 ,font\charx[scii]+font\charwid[scii],font\chary[scii] )
	v2 = AddVertex ( surf,x,y-yoff,0 ,font\charx[scii],font\chary[scii]+font\charhite )
	v3 = AddVertex ( surf,x + xoff,y-yoff,0 ,font\charx[scii]+font\charwid[scii],font\chary[scii]+font\charhite )

	VertexColor surf,v0, font\r,font\g,font\b, font\alfa
	VertexColor surf,v1, font\r,font\g,font\b, font\alfa
	VertexColor surf,v2, font\r,font\g,font\b, font\alfa
	VertexColor surf,v3, font\r,font\g,font\b, font\alfa

	AddTriangle (surf,v0,v1,v2)
	AddTriangle (surf,v1,v3,v2)
End Function

Function HUDspaceChar(xoff#=1.0,yoff#=1.0, layer.HUDlayer,lean#=0.0)
	Local font.HUDfont = layer\font
	Local surf = layer\surf[font\texused[SPACECHAR]]
	Local x# = layer\cursx
	Local y# = layer\cursy
	v0 = AddVertex ( surf,x+lean,y,0 ,font\charx[SPACECHAR],font\chary[SPACECHAR] )
	v1 = AddVertex ( surf,x + xoff+lean,y,0 ,font\charx[SPACECHAR]+font\charwid[SPACECHAR],font\chary[SPACECHAR] )
	v2 = AddVertex ( surf,x,y-yoff,0 ,font\charx[SPACECHAR],font\chary[SPACECHAR]+font\charhite )
	v3 = AddVertex ( surf,x + xoff,y-yoff,0 ,font\charx[SPACECHAR]+font\charwid[SPACECHAR],font\chary[SPACECHAR]+font\charhite )

	VertexColor surf,v0, font\r,font\g,font\b,0;font\alfa
	VertexColor surf,v1, font\r,font\g,font\b,0;font\alfa
	VertexColor surf,v2, font\r,font\g,font\b,0;font\alfa
	VertexColor surf,v3, font\r,font\g,font\b,0;font\alfa

	AddTriangle (surf,v0,v1,v2)
	AddTriangle (surf,v1,v3,v2)
End Function


Function CreateCharQuad(char$, par=0);, mesh=0);,x#=1.0,y#=-1.0)
	Local scii = Asc(char)
	Local surf,v0,v1,v2,v3
;	If mesh = 0
		mesh = CreateMesh(par)
		surf = CreateSurface(mesh)
;	Else
;		surf = GetSurface(mesh,1)
;	EndIf

	v0 = AddVertex ( surf,-1,1,0 ,currfont\charx[scii],currfont\chary[scii] )
	v1 = AddVertex ( surf,1,1,0 ,currfont\charx[scii]+currfont\charwid[scii],currfont\chary[scii] )
	v2 = AddVertex ( surf,-1,-1,0 ,currfont\charx[scii],currfont\chary[scii]+currfont\charhite )
	v3 = AddVertex ( surf,1,-1,0 ,currfont\charx[scii]+currfont\charwid[scii],currfont\chary[scii]+currfont\charhite )

;	VertexColor surf,v0, currfont\r,currfont\g,currfont\b, currfont\alfa
;	VertexColor surf,v1, currfont\r,currfont\g,currfont\b, currfont\alfa
;	VertexColor surf,v2, currfont\r,currfont\g,currfont\b, currfont\alfa
;	VertexColor surf,v3, currfont\r,currfont\g,currfont\b, currfont\alfa

	AddTriangle (surf,v0,v1,v2)
	AddTriangle (surf,v1,v3,v2)

	EntityFX mesh,1;+2;+32
	PaintSurface surf,currfont\bru[currfont\texused[scii]]

	Return mesh
End Function


Function HUDlayerCLS(l.HUDlayer);, killtex = False)
	For f = 0 To TEXCNT-1
		If l\surf[f] <> 0 Then ClearSurface l\surf[f]
	Next
	l\cursx = 0
	l\cursy = 0
End Function

Function HUDchunk$(txt$,num,delim$=",")
	If Right(txt,1) <> delim Then txt = txt + delim
	If num = 1
		txt = Left(txt,Instr(txt,delim))
		Return Left(txt,Len(txt)-1)
	Else
		Return HUDchunk (Right(txt,Len(txt)-Instr(txt,delim)),num-1,delim)
	EndIf
End Function


