
Const TUIIdleTime=200000

Global TCamera
Global TPivot
Global TMeshTexture,TFontTexture
Global TScreenWidth,TScreenLastWidth
Global TScreenHeight,TScreenLastHeight
Global TOrder
Global TMeshTextureWidth
Global TMeshTextureHeight
Global TDesktopW
Global TDesktopH
Global TWindowHandle,TWindowResizable
Global TWindowSize.twindowsize,TWindowMouse.twindowmouse
Global TShowPointer
Global TUIIsFullScreen

Type twindowsize
	Field x,y,w,h
End Type
Type twindowmouse
	Field x,y
End Type

Const TDefaultFont$="Arial"
Const TDefaultFontSize=14

Const TGadgetMax=19

Dim TGadgetTextureCoordsX#(99,3)
Dim TGadgetTextureCoordsY#(99,3)
Dim TGadgetTextureSize#(99)
Dim TGadgetCount(TGadgetMax)
Dim TGadgetCoords#(TGadgetMax,9,3)
Dim TGadgetBorderSize(TGadgetMax,9)
Dim TGadgetInteract(TGadgetMax,9)
Dim TGadgetPartType(TGadgetMax,9)

Dim TMouseButtonState(2,3)
Dim TGadgetState.tpart(5)
Dim TGadgetStateLast.tpart(5)

Global TGadgetHelpTimer
Global TGadgetHelpDelay=1000
Global TGadgetHelpEntity
Global TGadgetHelpPart.tpart

Const t_resizable=0
Const t_normal=1
Const t_fullscreen=2

Function TInit(title$="",w=0,h=0,mode=t_resizable,x=-1,y=-1)

TWindowSize=New twindowsize
TWindowMouse=New twindowmouse

TDesktopW=T_GetSystemMetrics(0)
TDesktopH=T_GetSystemMetrics(1)

TShowPointer=False

If mode=t_resizable

	ShowPointer

	TWindowResizable=True
	
	Graphics3D TDesktopW,TDesktopH,0,2
	
	AppTitle title$
	
	TWindowHandle=T_GetActiveWindow()
		
	If w=<0 Or h=<0

	w=TDesktopW
	h=TDesktopH
	
		T_SetWindowLong(TWindowHandle,-16,282001408+$1000000)
	
	Else
	
		T_SetWindowLong(TWindowHandle,-16,282001408)	
	
		If w<120
			w=120
		EndIf
		If h<90
			h=90
		EndIf
	
	EndIf
	
	If x=-1
		x=TDesktopW/2-w/2
	EndIf
	If y=-1
		y=TDesktopH/2-h/2
	EndIf
	
	T_MoveWindow(TWindowHandle,x,y,w,h,True)
			
	TScreenWidth=GraphicsWidth()
	TScreenHeight=GraphicsHeight()
	
	T_GetClientRect(TWindowHandle,TWindowSize)
	TScreenWidth = TWindowSize\w
	TScreenHeight = TWindowSize\h
	
	TUIIsFullScreen=False
	
Else

	TWindowResizable=False
	
	If w=-1
		w=TDesktopW-320
	EndIf
	If h=-1
		h=TDesktopH-240
	EndIf
	
	If w<120
		w=120
	EndIf
	If h<90
		h=90
	EndIf
	
	If mode<>0 Or mode<>16 Or mode<>24 Or mode<>32
		
		mode=0
	
	EndIf
	
	If x<0
		x=0
	EndIf
	If x>3
		x=3
	EndIf
	
	Graphics3D w,h,mode,x
	
	AppTitle title$
	
	If x=2
	
		ShowPointer
		
		TUIIsFullScreen=False
		
	Else
	
		HidePointer
		
		Graphics3D w,h,mode,x
		
		TShowPointer=True
		
		TUIIsFullScreen=True

	EndIf
		
	TScreenWidth=GraphicsWidth()
	TScreenHeight=GraphicsHeight()
	
EndIf


End Function


Function TDesign(file$=t_windows,flags=1+2,order=-1,x#=1024,y#=1024,z#=1024)

ClearTextureFilters

TOrder=order

TCamera=CreateCamera()
EntityOrder TCamera,TOrder
CameraRange TCamera,1,2
CameraClsMode TCamera,0,1
TPivot=CreatePivot(TCamera)

a#=Float(GraphicsHeight()) / GraphicsWidth()
w#=2/Float(GraphicsWidth())

;PositionEntity TPivot,x-1,y+a,z+1
PositionEntity TCamera,x,y,z
PositionEntity TPivot,-1,a,1

;ScaleEntity TPivot,w,-w,w
ScaleEntity TPivot,w,-w,w
;TurnEntity TPivot,0,180,0
;TurnEntity TPivot,0,0,180

skin=t_windows


If FileType(file$)=1
	
	tex=LoadTexture(file$)
	TMeshTextureWidth=TextureWidth(tex)
	TMeshTextureHeight=TextureHeight(tex)
	FreeTexture tex
	
	TMeshTexture=LoadBrush(file$,flags)
	
	If file$<>""
		inifile$=Left$(file$,Len(file$)-4)+".ini"
	EndIf
	
	
Else

	If Int(file)<0
		file=t_windows
	EndIf
	
	skin=Int(file)
		
	TMeshTexture=TDefaultImage(True,file)
	
	TMeshTextureWidth=TDefaultImageWidth
	TMeshTextureHeight=TDefaultImageHeight
	
	
EndIf

	
	If FileType(inifile$)<>1
		
		Restore tgadgettexturecoords
		
		dat$=""
		While dat$<>"START"+skin
		
			Read dat$
			
		Wend
		
		While dat$<>"END"+skin
		
			Read dat$
			
			If dat$<>"START"+skin And dat$<>"END"+skin
				
				typ=Int(dat$)
				
				For nn=0 To 1
					Read TGadgetTextureCoordsX#(typ,nn)
					TGadgetTextureCoordsX#(typ,nn)=TGadgetTextureCoordsX#(typ,nn) / TMeshTextureWidth
					Read TGadgetTextureCoordsY#(typ,nn)
					TGadgetTextureCoordsY#(typ,nn)=TGadgetTextureCoordsY#(typ,nn) / TMeshTextureHeight
				Next
				For nn=2 To 3
					Read TGadgetTextureCoordsX#(typ,nn)
					TGadgetTextureCoordsX#(typ,nn)=TGadgetTextureCoordsX#(typ,nn) / TMeshTextureWidth
					Read TGadgetTextureCoordsY#(typ,nn)
					TGadgetTextureCoordsY#(typ,nn)=TGadgetTextureCoordsY#(typ,nn) / TMeshTextureHeight
				Next
				Read TGadgetTextureSize#(typ)
				TGadgetTextureSize#(typ)=TGadgetTextureSize#(typ) / TMeshTextureWidth
			
			EndIf
			
		Wend
				
	Else
	
		ifile=ReadFile(inifile$)
			
			While Eof(ifile)=False
			
				t1=ReadByte(ifile)
				t2=ReadByte(ifile)
				TGadgetTextureCoordsX#(t1,t2*2)=Float(ReadShort(ifile)) / TMeshTextureWidth
				TGadgetTextureCoordsY#(t1,t2*2)=Float(ReadShort(ifile)) / TMeshTextureHeight
				TGadgetTextureCoordsX#(t1,t2*2+1)=Float(ReadShort(ifile)) / TMeshTextureWidth
				TGadgetTextureCoordsY#(t1,t2*2+1)=Float(ReadShort(ifile)) / TMeshTextureHeight
				TGadgetTextureSize#(t1)=Float(ReadShort(ifile)) / TMeshTextureWidth
						
			Wend
		CloseFile ifile
	
	
	EndIf
		

Restore tgadgetdata

For n=0 To TGadgetMax

	Read TGadgetCount(n)
	
	For nn=0 To TGadgetCount(n)
		For nnn=0 To 3
			Read TGadgetCoords#(n,nn,nnn)
		Next
		Read TGadgetBorderSize(n,nn)
		Read TGadgetPartType(n,nn)
		Read TGadgetInteract(n,nn)
		;If skinon=True
			TGadgetBorderSize(n,nn)=TGadgetTextureSize(TGadgetPartType(n,nn))*TMeshTextureWidth
			;If n=t_list
;			TGadgetBorderSize(n,nn)=2
			
			;DebugLog TGadgetBorderSize(n,nn)
			
			;EndIf
		;EndIf
	Next
	
Next

TFont TDefaultFont$,TDefaultFontSize

End Function

Function TClear()

	TWindowResizable=False

	If TWindowSize<>Null
		Delete twindowsize
	EndIf
	If TWindowMouse<>Null
		Delete twindowmouse
	EndIf
	
	If TMeshTexture<>0
	
		tex=GetBrushTexture(TMeshTexture)
		FreeTexture tex
		FreeBrush TMeshTexture		TMeshTexture=0
		
	EndIf
	If TFontTexture<>0
	
		tex=GetBrushTexture(TFontTexture)
		FreeTexture tex
		FreeBrush TFontTexture
		TFontTexture=0
	
	EndIf
	
	TPointerDelete
	
	For g.tgadget=Each tgadget
		TGadgetDelete Handle(g)
	Next
	
	If TMesh<>0 Then FreeEntity TMesh : TMesh=0
	If TPivot<>0 Then FreeEntity TPivot : TPivot=0	
	If TCamera<>0 Then FreeEntity TCamera : TCamera=0



	Delete Each tlist
	Delete Each tlistnode
	Delete Each titem
				
End Function


Const t_windows=0
Const t_fancy=1
Const t_white=2
Const t_grey=3
Const t_hell=4
Const t_pointer=100
Const t_pointer2=101
Const t_blackpointer=102


Const TInitDefaultTempImageFile$="TDefaultImage_@${[]}"

Global TDefaultImageWidth
Global TDefaultImageHeight

Function TDefaultImage(brush=0,imagenum=t_windows)
Restore tdefaultimages
dat$=""
While dat$<>"START"+imagenum

	Read dat$
	
Wend

Read flags

dat$=0
tex=WriteFile(TInitDefaultTempImageFile$)
While dat<>"END"+imagenum

	Read dat$
	For n=1 To Len(dat$) Step 2
		num=0
		For nnn=0 To 1
		nn=Asc(Mid$(dat$,n+nnn,1))	
		Select True
			Case nn>64 And nn<71
				num=num+(nn-55)*16*(nnn=0)+(nn-55)*(nnn=1)
			Default
				num=num+(nn-48)*16*(nnn=0)+(nn-48)*(nnn=1)
		End Select
		Next
		WriteByte tex,num
	
	Next
Wend
CloseFile tex

tex=LoadTexture(TInitDefaultTempImageFile$)
TDefaultImageWidth=TextureWidth(tex)
TDefaultImageHeight=TextureHeight(tex)

FreeTexture tex

If brush=0

	tex=LoadTexture(TInitDefaultTempImageFile$,flags)

Else
	
	tex=LoadBrush(TInitDefaultTempImageFile$,flags)

EndIf

DeleteFile TInitDefaultTempImageFile$

Return tex
End Function


Global TFontRed=255,TFontGreen=255,TFontBlue=255

Global TFontTextureWidth,TFontTextureHeight
Global TFontWidth,TFontHeight
Global TFontBlockWidth,TFontBlockHeight
Global TFontKernX,TFontKernY
Global TFontStartAscii
Global TFontEndAscii
Global TFontU#,TFontV#

Dim TFontOn(255)
Dim TFontX#(255)
Dim TFontY#(255)
Dim TFontW#(255)
Dim TFontWW(255)

Function TFont(file$,flags=1+2,fw=32,fh=32,w=32,h=32,kernx=15,kerny=25,starta=0,enda=255)

If TCamera=0
	
	TDesign
		
EndIf

If TFontTexture<>0

	tex=GetBrushTexture(TFontTexture)
	FreeTexture tex
	FreeBrush TFontTexture
	TFontTexture=0

EndIf

If FileType(file$)=1

	TFontRed=255
	TFontGreen=255
	TFontBlue=255
	
	
	TFontTexture=LoadBrush(file$,flags)

	TFontWidth=fw
	TFontHeight=fh
	TFontKernX=kernx
	TFontKernY=kerny
	TFontStartAscii=starta
	TFontEndAscii=enda
		
	tex=LoadTexture(file$)

	TFontTextureWidth=TextureWidth(tex)
	TFontTextureHeight=TextureHeight(tex)
	
	FreeTexture tex
	
	TFontBlockWidth=fw 
	TFontBlockHeight=fh
	
	TFontWidth=fw
	TFontHeight=fh

	
		
	inifile$=Left$(file$,Len(file$)-4)+".ini"
		
	If FileType(inifile$)=1

		start$=""
	
		rfile=ReadFile(inifile$)
	
		While Not Eof(rfile)
	
			txt$=ReadLine(rfile)
			
			If txt$<>""
	
				If Left$(Lower(txt$),1)="[" And Right$(Lower$(txt$),1)="]"
					
					start$=Lower$(txt$)
						
				Else
											
					Select start$
					
						Case "[text]"
							If Lower$(Left$(txt$,9))="blocksize"
								fontblocksize=TFontString(txt$,1,"=")
								TFontU#=Float( fontblocksize ) / Float( TFontTextureWidth )
								TFontV#=TFontU#
							EndIf
					
						Case "[charset]"
							as=Asc(Left$(txt$,1))
							TFontOn(as)=1
							txt2$=Right$(txt$,Len(txt$)-2)
							TFontX(as)=Float( TFontString(txt2$,0) ) / Float( TFontTextureWidth )
							TFontY(as)=Float( TFontString(txt2$,1) ) / Float( TFontTextureHeight )
								If Int(TFontString(txt2$,2))>0
									;f\w#[as]=(Float( ZFontString(txt2$,2) ) / ( Float( f\twid ) * f\wid))*f\fw
									TFontWW(as)=Float(TFontString(txt2$,2))*(Float(TFontWidth)/Float(fontblocksize))
									
									TFontW(as)=Float( TFontWW(as) ) / Float( TFontTextureWidth  ) ;* TFontU#)) * TFontWidth
								Else
									TFontW(as)=TFontU#
								EndIf
								
								;If TFontW(as)>TFontKernX
								;	TFontKernX=TFontW(as)							
								;EndIf
				
					End Select
				
				EndIf
			
			EndIf
	
		Wend
		
		CloseFile rfile
							
		For n=0 To 255
			If TFontOn(n)=0
				TFontWW(n)=TFontWidth*0.5			
				TFontW(n)=TFontKernX
			EndIf
		Next
		
	Else
	
		TFontBlockWidth=fw 
		TFontBlockHeight=fh
	
		TFontWidth=fw
		TFontHeight=fh
			
		TFontU#=Float( w ) / Float( TFontTextureWidth )
		TFontV#=Float( h ) / Float( TFontTextureHeight )
	
		TFontKernX=(Float(kernx)/Float(w))*TFontWidth 
		TFontKernY=(Float(kerny)/Float(h))*TFontHeight
				
		For n=0 To 255
			TFontOn(n)=0
			TFontW(n)=TFontU#
			TFontWW(n)=TFontKernX
		Next
		
		numx=TFontTextureWidth/w
		numy=TFontTextureHeight/h
		
		For a=0 To (enda-starta)
		
			TFontOn(starta+a)=1
				
			TFontX(starta+a)=Float((a Mod numx))*TFontU#
			TFontY(starta+a)=Float(Floor(a/numy))*TFontV#
		
		Next
			
	EndIf
	
	
Else

	TFontRed=0
	TFontGreen=0
	TFontBlue=0

	;TFontTexture=CreateBrush(0,0,0)
	TFontTextureWidth=512
	TFontTextureHeight=512
	
	fmw=TFontTextureWidth / 16
	fmh=TFontTextureHeight / 16
	
	TFontU#=Float( fmw ) / Float( TFontTextureWidth )
	TFontV#=Float( fmh ) / Float( TFontTextureHeight )

	font=LoadFont(file$,flags)
	SetFont font
	
	TFontBlockWidth=fmw 
	TFontBlockHeight=fmh
	
	TFontWidth=FontWidth() 
	TFontHeight=FontHeight()
	
	Color 255,255,255
	image=CreateImage(TFontTextureWidth,TFontTextureHeight)
	SetBuffer ImageBuffer(image)
		For y=1 To 16
			For x=1 To 16
				as=(y-1)*16+(x-1)
								
				TFontX(as)=Float(x-1)*TFontU
				TFontY(as)=Float(y-1)*TFontV
				
				TFontOn(as)=1
				TFontWW(as)=StringWidth(Chr(as))
				TFontW(as)=Float(fmw) / TFontTextureWidth
				
				Text fmw*(x-1),fmh*(y-1),Chr(as)
			Next
		Next
		TFontOn(32)=0
	SetBuffer BackBuffer()
	
	FreeFont font
	SaveImage image,"ToolUIFontTempImage_1@$5{[]}"
	FreeImage image
		
	TFontTexture=LoadBrush("ToolUIFontTempImage_1@$5{[]}",1+2+16+32)
	DeleteFile "ToolUIFontTempImage_1@$5{[]}"
	
	
EndIf

End Function



Function TFontString$(t$,n=0,d$=",")
Repeat
	p=Instr(t$,d$,1)
	If p>0
		If n=nn
			p=Instr(t$,d$,1)
			If p=0
				Return t$
			Else
				Return Left$(t$,p-1)
			EndIf
		EndIf
		t$=Right(t$,Len(t$)-p)
		nn=nn+1
	EndIf
Until p=0
Return t$
End Function

Function TTextWidth(txt$)
	n=Len(txt$)
	For nn=1 To n
		wid=wid+TFontWW(Asc(Mid$(txt$,nn)))
	Next
	Return wid
End Function

Function TFontTextLineCut(x,y,txt$,z#,pos=0,scalex#=1,scaley#=1,cx=0,cy=0,cw=100,ch=100)
	If txt$="" Then Return

	n=Len(txt$)
	
	For nn=1 To n
	
		wid#=wid+TFontW(Asc(Mid$(txt$,nn)))
	
	Next
	
	
	w=TFontBlockWidth*scalex#
	h=TFontBlockHeight*scaley#
	
	
	For i=1 To n
		
		a=Asc(Mid$(txt$,i,1))
;		If TFontOn(a)=1
			
vert=   AddVertex(TTextSurface,-0.5+x,-0.5+y,z ,TFontX(a),TFontY(a))
    	AddVertex(TTextSurface,-0.5+x+w,-0.5+y,z ,TFontX(a)+TFontU,TFontY(a))
		AddVertex(TTextSurface,-0.5+x+w,-0.5+y+h,z ,TFontX(a)+TFontU,TFontY(a)+TFontV)
		AddVertex(TTextSurface,-0.5+x,-0.5+y+h,z ,TFontX(a),TFontY(a)+TFontV)
		
		AddTriangle(TTextSurface,vert,vert+1,vert+2)
		AddTriangle(TTextSurface,vert,vert+2,vert+3)
		
		;TPolygonClip(TTextSurface,vert,0,0,cw,ch)
			If i=1
				revert=vert
			EndIf
		
;		EndIf
		  
		x=x+TFontWW(a)*scalex#
	Next
	
	Return revert
	
End Function

Function TTextRect(x,y,w,h,txt$,pos=1,clip=0,scrx=0,scry=0,re=0,gr=0,bl=0)
	Select pos
	
		Case 0
			Return TText(x,y,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
		Case 1
			Return TText(x+w*0.5-TTextWidth(txt$)*0.5,y+h*0.5-TFontHeight*0.5,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
		Case 2
			Return TText(x+w*0.5-TTextWidth(txt$)*0.5,y-TFontHeight,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
		Case 3
			Return TText(x+w,y+h*0.5-TFontHeight*0.5,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
		Case 4
			Return TText(x+w*0.5-TTextWidth(txt$)*0.5,y+h,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
		Case 5
			Return TText(x-TTextWidth(txt$),y+h*0.5-TFontHeight*0.5,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
		Case 6
			Return TText(x,y+h*0.5-TFontHeight*0.5,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
		Case 7
			Return TText(x,y-TFontHeight*0.5,txt$,clip,x,y,x+w,y+h,scrx,scry,re,gr,bl)
					
	End Select	
			
End Function

Function TText(x,y,txt$,clip=0,cx1=0,cy1=0,cx2=0,cy2=0,scrx=0,scry=0,re=0,gr=0,bl=0)

	ent=CreateMesh(TPivot)
	EntityFX ent,1+8 ;43;1+2+8+32
	surf=CreateSurface(ent,TFontTexture)
	
	
	n=Len(txt$)
	ix=x

	If clip=0
		
		For i=1 To n
			a=Asc(Mid$(txt$,i,1))
			If a=10 Or a=13
			
				y=y+TFontHeight
				x=ix
			
			Else
			
				If TFontOn(a)=1
					
			   vert=AddVertex(surf,x,y,0 ,TFontX(a),TFontY(a))
			    	AddVertex(surf,x+TFontBlockWidth,y,0 ,TFontX(a)+TFontU,TFontY(a))
					AddVertex(surf,x+TFontBlockWidth,y+TFontBlockHeight,0 ,TFontX(a)+TFontU,TFontY(a)+TFontV)
					AddVertex(surf,x,y+TFontBlockHeight,0 ,TFontX(a),TFontY(a)+TFontV)
					
					AddTriangle(surf,vert,vert+1,vert+2)
					AddTriangle(surf,vert,vert+2,vert+3)
					
					;VertexColor surf,vert,re,gr,bl
					;VertexColor surf,vert+1,re,gr,bl
					;VertexColor surf,vert+2,re,gr,bl
					;VertexColor surf,vert+3,re,gr,bl
				  
				EndIf
					
				x=x+TFontWW(a)
				
			EndIf
		Next
		
	Else
	
		x=x-scrx
		y=y-scry
	
	
	
		For i=1 To n
			a=Asc(Mid$(txt$,i,1))
			If a=10 Or a=13
			
				y=y+TFontHeight
				x=ix
			
			Else
			
				If y>cy1-TFontHeight And y<cy2
			
				If TFontOn(a)=1
					
			   vert=AddVertex(surf,x,y,0 ,TFontX(a),TFontY(a))
			    	AddVertex(surf,x+TFontBlockWidth,y,0 ,TFontX(a)+TFontU,TFontY(a))
					AddVertex(surf,x+TFontBlockWidth,y+TFontBlockHeight,0 ,TFontX(a)+TFontU,TFontY(a)+TFontV)
					AddVertex(surf,x,y+TFontBlockHeight,0 ,TFontX(a),TFontY(a)+TFontV)
					
					AddTriangle(surf,vert,vert+1,vert+2)
					AddTriangle(surf,vert,vert+2,vert+3)
					
					;If y>cy1 And y<cy2
					
						VertexColor surf,vert,TFontRed,TFontGreen,TFontBlue,1
						VertexColor surf,vert+1,TFontRed,TFontGreen,TFontBlue,1
						VertexColor surf,vert+2,TFontRed,TFontGreen,TFontBlue,1
						VertexColor surf,vert+3,TFontRed,TFontGreen,TFontBlue,1
			
						TPolygonClip(surf,vert,vert+1,vert+2,vert+3,cx1,cy1,cx2,cy2)
					
					;Else
	
					;	VertexColor surf,vert,0,0,0,0
					;	VertexColor surf,vert+1,0,0,0,0
					;	VertexColor surf,vert+2,0,0,0,0
					;	VertexColor surf,vert+3,0,0,0,0
					
					;EndIf
						
				EndIf
				
				EndIf
				
				x=x+TFontWW(a)
			EndIf
		Next
			
	
	
	EndIf
		
	Return ent
End Function




Function TTextMove(vert,x,y,w,h,txt$,pos)

	n=Len(txt$)*4-1
	Select pos
		Case 0
			dx=x-Floor(VertexX(TTextSurface,vert))
			dy=y-Floor(VertexY(TTextSurface,vert))
		Case 1
			dx=x+w*0.5-TTextWidth(txt$)*0.5-Floor(VertexX(TTextSurface,vert))
			dy=y+h*0.5-TFontHeight*0.5-Floor(VertexY(TTextSurface,vert))
		Case 2
			dx=x+w*0.5-TTextWidth(txt$)*0.5-Floor(VertexX(TTextSurface,vert))
			dy=y-TFontHeight-Floor(VertexY(TTextSurface,vert))
		Case 3
			dx=x+w-Floor(VertexX(TTextSurface,vert))
			dy=y+h*0.5-TFontHeight*0.5-Floor(VertexY(TTextSurface,vert))
		Case 4
			dx=x+w*0.5-TTextWidth(txt$)*0.5-Floor(VertexX(TTextSurface,vert))
			dy=y+h-Floor(VertexY(TTextSurface,vert))
		Case 5
			dx=x-TTextWidth(txt$)-Floor(VertexX(TTextSurface,vert))
			dy=y+h*0.5-TFontHeight*0.5-Floor(VertexY(TTextSurface,vert))
		Case 6
			dx=x-Floor(VertexX(TTextSurface,vert))
			dy=y+h*0.5-TFontHeight*0.5-Floor(VertexY(TTextSurface,vert))
			
			

	End Select

		
	For nn=0 To n
	
		VertexCoords TTextSurface,vert+nn,-0.5+Floor(VertexX(TTextSurface,vert+nn))+dx,-0.5+Floor(VertexY(TTextSurface,vert+nn))+dy,VertexZ(TTextSurface,vert+nn)
		;VertexCoords TTextSurface,vert+nn,(VertexX(TTextSurface,vert+nn))+dx,(VertexY(TTextSurface,vert+nn))+dy,VertexZ(TTextSurface,vert+nn)
		
	Next
	
	Return
		
	n=Len(txt$)
	
	w=TFontBlockWidth*scalex#
	h=TFontBlockBlock*scaley#
	
	For i=1 To n
		
		a=Asc(Mid$(txt$,i,1))
		;If TFontOn(a)=1
		
			VertexCoords TTextSurface,vert,-0.5+x,-0.5+y,z
			VertexCoords TTextSurface,vert+1,-0.5+x+w,-0.5+y,z
			VertexCoords TTextSurface,vert+2,-0.5+x+w,-0.5+y+h,z
			VertexCoords TTextSurface,vert+3,-0.5+x,-0.5+y+h,z
			
		;ZPolygonClip(TTextSurface,vert,0,0,cw,ch)
	
			vert=vert+4
		
		;EndIf
			  
		x=x+TFontWW(a)*scalex#
	Next

End Function


;vertices alignment
;0---1
;|   |
;3---2

Function TPolygonClip(surf,vert,vert1,vert2,vert3,x1#,y1#,x2#,y2#)
vx1#=VertexX(surf,vert)
vy1#=VertexY(surf,vert)

u1#=VertexU(surf,vert)
v1#=VertexV(surf,vert)

vx2#=VertexX(surf,vert2)
vy2#=VertexY(surf,vert2)

u2#=VertexU(surf,vert2)
v2#=VertexV(surf,vert2)

;If Not (((vx1-x2)<=(vx2-x1) And x2>=vx1 And x1<=vx2) And ((vy1-y2)<=(vy2-y1) And y2>=vy1 And y1<=vy2))
;	VertexCoords surf,vert,0,0,VertexZ(surf,vert)
;	VertexCoords surf,vert+1,0,0,VertexZ(surf,vert+1)
;	VertexCoords surf,vert+2,0,0,VertexZ(surf,vert+2)
;	VertexCoords surf,vert+3,0,0,VertexZ(surf,vert+3)
;	Return True
;EndIf

If Not (((vx1-x2)<=(vx2-x1) And x2>=vx1 And x1<=vx2) And ((vy1-y2)<=(vy2-y1) And y2>=vy1 And y1<=vy2))

	VertexCoords surf,vert,0,0,0
	VertexCoords surf,vert1,0,0,0
	VertexCoords surf,vert2,0,0,0
	VertexCoords surf,vert3,0,0,0

;	VertexCoords surf,vert,VertexX(surf,vert),VertexY(surf,vert),100
;	VertexCoords surf,vert1,VertexX(surf,vert1),VertexY(surf,vert1),100
;	VertexCoords surf,vert2,VertexX(surf,vert2),VertexY(surf,vert2),100
;	VertexCoords surf,vert3,VertexX(surf,vert3),VertexY(surf,vert3),100

	
	Return True

EndIf

If vx1#<=x1
	If vx2#>=x1
		
		d#=(vx2-x1) / (vx2-vx1)
		u1#=u2#+(u1#-u2#)*d#
		vx1#=x1#
		 
	EndIf
EndIf

If vy1#<=y1
	If vy2#=>y1
		
		d#=(vy2-y1) / (vy2-vy1)
		v1#=v2#+(v1#-v2#)*d#
		vy1#=y1#
		 
	EndIf
EndIf

If vx2#=>x2
	If vx1#<=x2
		
		d#=(vx1-x2) / (vx1-vx2)
		u2#=u1#+(u2#-u1#)*d#
		vx2#=x2#
		 
	EndIf
EndIf

If vy2#=>y2
	If vy1#<=y2
		
		d#=(vy1-y2) / (vy1-vy2)
		v2#=v1#+(v2#-v1#)*d#
		vy2#=y2#
		 
	EndIf
EndIf

;VertexCoords surf,vert,0.5+Floor(vx1),0.5+Floor(vy1),VertexZ(surf,vert)
;VertexCoords surf,vert+1,0.5+Floor(vx2),0.5+Floor(vy1),VertexZ(surf,vert+1)
;VertexCoords surf,vert+2,0.5+Floor(vx2),0.5+Floor(vy2),VertexZ(surf,vert+2)
;VertexCoords surf,vert+3,0.5+Floor(vx1),0.5+Floor(vy2),VertexZ(surf,vert+3)

;VertexCoords surf,vert,0.5+Int(vx1),0.5+Int(vy1),VertexZ(surf,vert)
;VertexCoords surf,vert+1,0.5+Int(vx2),0.5+Int(vy1),VertexZ(surf,vert+1)
;VertexCoords surf,vert+2,0.5+Int(vx2),0.5+Int(vy2),VertexZ(surf,vert+2)
;VertexCoords surf,vert+3,0.5+Int(vx1),0.5+Int(vy2),VertexZ(surf,vert+3)
VertexCoords surf,vert,(vx1),(vy1),VertexZ(surf,vert)
VertexCoords surf,vert1,(vx2),(vy1),VertexZ(surf,vert1)
VertexCoords surf,vert2,(vx2),(vy2),VertexZ(surf,vert2)
VertexCoords surf,vert3,(vx1),(vy2),VertexZ(surf,vert3)

VertexTexCoords surf,vert,u1,v1
VertexTexCoords surf,vert1,u2,v1
VertexTexCoords surf,vert2,u2,v2
VertexTexCoords surf,vert3,u1,v2

End Function

Function TPolygonClip2(surf,vert,vert1,vert2,vert3,x1#,y1#,x2#,y2#)
vx1#=VertexX(surf,vert)
vy1#=VertexY(surf,vert)

u1#=VertexU(surf,vert)
v1#=VertexV(surf,vert)

vx2#=VertexX(surf,vert2)
vy2#=VertexY(surf,vert2)

u2#=VertexU(surf,vert2)
v2#=VertexV(surf,vert2)

;If Not (((vx1-x2)<=(vx2-x1) And x2>=vx1 And x1<=vx2) And ((vy1-y2)<=(vy2-y1) And y2>=vy1 And y1<=vy2))
;	VertexCoords surf,vert,0,0,VertexZ(surf,vert)
;	VertexCoords surf,vert+1,0,0,VertexZ(surf,vert+1)
;	VertexCoords surf,vert+2,0,0,VertexZ(surf,vert+2)
;	VertexCoords surf,vert+3,0,0,VertexZ(surf,vert+3)
;	Return True
;EndIf

If Not (((vx1-x2)<=(vx2-x1) And x2>=vx1 And x1<=vx2) And ((vy1-y2)<=(vy2-y1) And y2>=vy1 And y1<=vy2))

;	VertexCoords surf,vert,0,0,0
;	VertexCoords surf,vert1,0,0,0
;	VertexCoords surf,vert2,0,0,0
;	VertexCoords surf,vert3,0,0,0
	;VertexColor surf,vert,0,0,0,0
	;VertexColor surf,vert+1,0,0,0,0
	;VertexColor surf,vert+2,0,0,0,0
	;VertexColor surf,vert+3,0,0,0,0
	VertexCoords surf,vert,VertexX(surf,vert),VertexY(surf,vert),-2
	VertexCoords surf,vert1,VertexX(surf,vert1),VertexY(surf,vert1),-2
	VertexCoords surf,vert2,VertexX(surf,vert2),VertexY(surf,vert2),-2
	VertexCoords surf,vert3,VertexX(surf,vert3),VertexY(surf,vert3),-2

	
	Return True


EndIf

If vx1#<=x1
	If vx2#>=x1
		
		d#=(vx2-x1) / (vx2-vx1)
		u1#=u2#+(u1#-u2#)*d#
		vx1#=x1#
		 
	EndIf
EndIf

If vy1#<=y1
	If vy2#=>y1
		
		d#=(vy2-y1) / (vy2-vy1)
		v1#=v2#+(v1#-v2#)*d#
		vy1#=y1#
		 
	EndIf
EndIf

If vx2#=>x2
	If vx1#<=x2
		
		d#=(vx1-x2) / (vx1-vx2)
		u2#=u1#+(u2#-u1#)*d#
		vx2#=x2#
		 
	EndIf
EndIf

If vy2#=>y2
	If vy1#<=y2
		
		d#=(vy1-y2) / (vy1-vy2)
		v2#=v1#+(v2#-v1#)*d#
		vy2#=y2#
		 
	EndIf
EndIf

;VertexCoords surf,vert,0.5+Floor(vx1),0.5+Floor(vy1),VertexZ(surf,vert)
;VertexCoords surf,vert+1,0.5+Floor(vx2),0.5+Floor(vy1),VertexZ(surf,vert+1)
;VertexCoords surf,vert+2,0.5+Floor(vx2),0.5+Floor(vy2),VertexZ(surf,vert+2)
;VertexCoords surf,vert+3,0.5+Floor(vx1),0.5+Floor(vy2),VertexZ(surf,vert+3)

;VertexCoords surf,vert,0.5+Int(vx1),0.5+Int(vy1),VertexZ(surf,vert)
;VertexCoords surf,vert+1,0.5+Int(vx2),0.5+Int(vy1),VertexZ(surf,vert+1)
;VertexCoords surf,vert+2,0.5+Int(vx2),0.5+Int(vy2),VertexZ(surf,vert+2)
;VertexCoords surf,vert+3,0.5+Int(vx1),0.5+Int(vy2),VertexZ(surf,vert+3)
VertexCoords surf,vert,(vx1),(vy1),VertexZ(surf,vert)
VertexCoords surf,vert1,(vx2),(vy1),VertexZ(surf,vert1)
VertexCoords surf,vert2,(vx2),(vy2),VertexZ(surf,vert2)
VertexCoords surf,vert3,(vx1),(vy2),VertexZ(surf,vert3)

;VertexTexCoords surf,vert,u1,v1
;VertexTexCoords surf,vert1,u2,v1
;VertexTexCoords surf,vert2,u2,v2
;VertexTexCoords surf,vert3,u1,v2

End Function


Function TGadgetPartClip(p.tpart,x1#,y1#,x2#,y2#)

TPolygonClip2 p\g\surf,p\g\vert[p\n],p\g\vert[p\n]+1,p\g\vert[p\n]+12,p\g\vert[p\n]+11,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+1,p\g\vert[p\n]+2,p\g\vert[p\n]+13,p\g\vert[p\n]+12,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+2,p\g\vert[p\n]+3,p\g\vert[p\n]+4,p\g\vert[p\n]+13,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+11,p\g\vert[p\n]+12,p\g\vert[p\n]+15,p\g\vert[p\n]+10,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+12,p\g\vert[p\n]+13,p\g\vert[p\n]+14,p\g\vert[p\n]+15,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+13,p\g\vert[p\n]+4,p\g\vert[p\n]+5,p\g\vert[p\n]+14,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+10,p\g\vert[p\n]+15,p\g\vert[p\n]+8,p\g\vert[p\n]+9,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+15,p\g\vert[p\n]+14,p\g\vert[p\n]+7,p\g\vert[p\n]+8,x1,y1,x2,y2
TPolygonClip2 p\g\surf,p\g\vert[p\n]+14,p\g\vert[p\n]+5,p\g\vert[p\n]+6,p\g\vert[p\n]+7,x1,y1,x2,y2

End Function


Global TPointer,TPointerTexture

Function TPointer(file$=t_pointer,flags=1+2+16+32)
TPointerDelete 

HidePointer 

If TCamera=0
	
	TDesign
		
EndIf

If FileType(file$)<>1

	If Int(file)<100
		file=100+Int(file)
	EndIf

	TPointerTexture=TDefaultImage(False,file)

Else

	TPointerTexture=LoadTexture(file$,flags)
	

EndIf

TPointer=CreateMesh(TPivot)
EntityFX TPointer,1+8
EntityOrder TPointer,TOrder-2

surf=CreateSurface(TPointer)

w=TextureWidth(TPointerTexture)
h=TextureHeight(TPointerTexture)

AddVertex surf,0,0,0,0,0
AddVertex surf,w,0,0,1,0
AddVertex surf,w,h,0,1,1
AddVertex surf,0,h,0,0,1

AddTriangle surf,0,1,2
AddTriangle surf,0,2,3

EntityTexture TPointer,TPointerTexture

End Function

Function TPointerDelete()

	If TPointer<>0 Then FreeEntity TPointer : TPointer=0
	If TPointerTexture<>0 Then FreeTexture TPointerTexture : TPointerTexture=0

End Function

Const t_text=0
Const t_window=1
Const t_button=2
Const t_tab=3
Const t_tabpage=4
Const t_checkbox=5
Const t_textbox=6
Const t_integer=7
Const t_float=8
Const t_slider=9
Const t_hslider=10
Const t_vslider=11
Const t_list=12
Const t_combobox=13
Const t_radio=14
Const t_frame=15
Const t_image=16
Const t_progress=17
Const t_3d=18
Const t_menu=19


Const t_windowbar=20
Const t_windowclose=21
Const t_windowminimize=22
Const t_check=23
Const t_cursor=24
Const t_knot=25
Const t_hknot=26
Const t_vknot=27
Const t_selected=28
Const t_arrowup=29
Const t_arrowdown=30
Const t_comboarrow=31
Const t_combobackground=32
Const t_comboslider=33
Const t_comboknot=34
Const t_progressbar=35
Const t_menuline=36
Const t_menuarrow=37
Const t_menubackground=38
Const t_radiotick=39





.tgadgetdata
;order: back to front

;Data xpos#,ypos#,wid#,hei#,bordersize#,type_const,interact?
;text 
Data 0
Data 0,0,1,1,4,t_window,1

;window
Data 2
Data 0,0,1,1, 16 ,t_window,2
Data 2,2,-4,16 ,16  ,t_windowbar,0
Data -17,3,14,14, 2 ,t_windowclose,3

;button
Data 0
Data 0,0,1,1, 16 ,t_button,3

;tab
Data 0
Data 0,0,1,1,16,t_tab,4

;tabpage
Data 0
Data 0,0,1,1, 16 ,t_tabpage,2

;checkbox
Data 1
Data 0,0,1,1, 4 ,t_checkbox,1
Data 0,0,1,1, 2 ,t_check,0

;textbox
Data 2
Data 0,0,1,1, 8 ,t_textbox,1
Data 0,0,1,1, 2 ,t_text,0
Data 0,0.15,2,0.7, 1 ,t_cursor,0

;integer
Data 4
Data 0,0,-16,1, 16 ,t_integer,1
Data 0,0,-16,1, 2 ,t_text,0
Data 0,0.15,2,0.7, 1 ,t_cursor,0
Data -16,0,16,0.5 ,2 ,t_arrowup,3
Data -16,0.5,16,0.5 ,2 ,t_arrowdown,3

;float
Data 4
Data 0,0,-16,1, 16 ,t_float,1
Data 0,0,-16,1, 2 ,t_text,0
Data 0,0.15,2,0.7, 1 ,t_cursor,0
Data -16,0,16,0.5 ,2 ,t_arrowup,3
Data -16,0.5,16,0.5 ,2 ,t_arrowdown,3

;slider
Data 1
Data 0,0,1,1, 8 ,t_slider,1
Data 0,0,0.4,0.4, 8 ,t_knot,1

;hslider
Data 1
Data 0,0,1,1, 8 ,t_hslider,1
Data 0,0,0.4,1, 8 ,t_hknot,1

;vslider
Data 1
Data 0,0,1,1, 8 ,t_vslider,1
Data 0,0,1,0.4, 8 ,t_vknot,1

;list
Data 4
Data 0,0,1,1, 16 ,t_list,1
Data 0,0,1,0, 2 ,t_selected,0
Data 0,0,1,1, 2 ,t_text,0
Data -16,0,16,1, 3 ,t_vslider,1
Data -16,0,16,0.25, 8 ,t_vknot,1

;combobox
Data 7
Data 0,0,-16,1, 3 ,t_combobox,1
Data -16,0,16,1, 2 ,t_comboarrow,3
Data 0  ,1,1,0, 3 ,t_combobackground,1
Data 0,1,1,0, 2 ,t_selected,0
Data 0,1,1,1, 2 ,t_text,0
Data -16,1,16,0, 2 ,t_comboslider,1
Data -16,1,16,0, 2 ,t_comboknot,1
Data 0,0,1,1, 2 ,t_text,0

;Radio
Data 0
Data 0,0,1,1,16,t_radio,0

;Frame
Data 0
Data 0,0,1,1,3,t_frame,0

;Frame
;Data 1
;Data 0,0,1,1,3,t_frame,0
;Data 0,0,1,1,0,t_window,0

;Image
Data -1

;Progress
Data 2
Data 0,0,1,1,2,t_progress,1
Data 0,0,1,1,0,t_progressbar,0
Data 0,0,1,1, 2 ,t_text,0

;3d
Data -1

;menu
Data 3
Data 0,0,1,1,2,t_menubackground,0
Data 0,0,1,1,2,t_menu,3
Data -16,0.1,14,0.8,2,t_menuarrow,0
Data 0,0,1,1,2,t_menuline,0


;Data xpos#,ypos#,wid#,hei#,bordersize#,type_const,interact?

Type tgadget

Field t

Field parent.tgadget

Field e,surf

Field x,y,w,h

Field dx,dy ;drawing coords

Field vert[9]

Field order

Field r,g,b,a#

Field fontr,fontg,fontb,fonta#

Field txt$,txtpos,txte

Field v$[10] ;values

Field part.tpart[9]

Field partsurf[9]

Field partx[9],party[9],partw[9],parth[9]

Field partstate[9]

Field hide,userhide

Field lock

Field link.tgadget

Field help$

Field hasmenu

Field lastv$

Field layermode ;0=none 1=FrontMost 2=BackMost

Field locka#,lockfa#

Field modal

End Type

Type tpart

	Field g.tgadget
	
	Field n

	Field x,y,w,h ;drawing/collision coords
	
	Field lx,ly ;local coords
	
	Field e;text entity
	
	Field parttype
	
End Type


Function TGadgetNew(t,parent=0,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")

If TCamera=0
	
	TDesign
	If TShowPointer=True
		If TPointer=0
			TPointer
		EndIf
	EndIf
	
EndIf

g.tgadget=New tgadget

g\t=t
g\parent=Object.tgadget(parent)

If g\parent<>Null

	Insert g After g\parent

EndIf

g\e=CreateMesh(TPivot)
EntityFX g\e,1+2+8+32
g\surf=CreateSurface(g\e,TMeshTexture)


g\r=255
g\g=255
g\b=255
g\a=1
g\fontr=TFontRed
g\fontg=TFontGreen
g\fontb=TFontBlue
g\fonta=1
g\w=w
g\h=h


TGadgetReBuild(g)
TGadgetRefresh(g)

If g\t<>t_image
	TGadgetSet Handle(g),t_value,v1$
EndIf

If g\t=t_button Or g\t=t_tabpage Or g\t=t_window Or g\t=t_text
	g\txtpos=1
Else
	g\txtpos=5
EndIf

;default values
Select g\t

	Case t_button
			
		If v1$=""
			v1$=1+2
		EndIf
		g\v[2]=v1$
		
		If FileType(txt$)=1
		
			
		
		EndIf
					
		TGadgetSet Handle(g),t_value,txt$
	
		
	Case t_window
		
		If v1$=""
			g\v[0]=1+4	
		Else
			g\v[0]=v1$
		EndIf
		
		g\v[1]=v2$
		If Int(g\v[1])<1
		
			g\v[1]=TFontHeight+2
				
		EndIf

	Case t_tab
		g\v[2]=20
		
	Case t_tabpage
		g\parent\v[0]=Handle(g)
		TGadgetRefresh(g\parent)
		
	Case t_checkbox
		g\txtpos=3
		TGadgetSet Handle(g),t_value,Int(v1$)

	
	Case t_textbox
		g\partx[2]=-2000
		
		
	Case t_list
		g\txtpos=2
		g\v[2]=v1
		TGadgetSet Handle(g),t_knotsize,1
		TGadgetRefresh(g)
		
	Case t_integer
		g\partx[2]=-2000
		g\v[7]=1
		g\v[9]=10
		TGadgetSet Handle(g),t_value,v1$
	
	Case t_float
		g\partx[2]=-2000
		g\v[7]=0.01
		g\v[8]=2
		g\v[9]=10
		TGadgetSet Handle(g),t_value,v1$

	Case t_slider
		g\v[2]=0
		g\v[3]=1
		TGadgetSet Handle(g),t_knotsize,0.5
		TGadgetSet Handle(g),t_value,v1$
		TGadgetSet Handle(g),t_slidervert,v2$
		
	Case t_slider,t_hslider,t_vslider
		g\v[2]=0
		g\v[3]=1
		TGadgetSet Handle(g),t_knotsize,0.5
		TGadgetSet Handle(g),t_value,v1$
		
	Case t_combobox
	
		g\v[2]=v1
		g\v[7]=4
		g\v[8]=0
		g\partx[3]=-3000
		TGadgetUpdate(g)
		TGadgetRefresh(g)		
		;TGadgetSet Handle(g),t_value,v2
		
	Case t_frame
		g\txtpos=7
		
	Case t_image
		g\txtpos=2
		
		If v2$=""
			v2$=1+2+16+32
			g\v[3]=v2$
		EndIf
	
		g\v[0]=CreateMesh(TPivot)
		EntityFX g\v[0],1+8
		surf=CreateSurface(g\v[0])
						
		AddVertex surf,0,0,0,0,0
		AddVertex surf,1,0,0,1,0
		AddVertex surf,1,1,0,1,1
		AddVertex surf,0,1,0,0,1
		
		AddTriangle surf,0,1,2
		AddTriangle surf,0,2,3
		
		TGadgetSet Handle(g),t_value,v1$
		TGadgetSet Handle(g),t_imageflags,v2$
		TGadgetRedraw()
		
			
	Case t_progress
		g\txtpos=2
		TGadgetSet Handle(g),t_value,v1$
	
	Case t_3d
		g\v[0]=CreateCamera()
		
	
	Case t_menu
		g\txtpos=6
		If g\parent<>Null
			If g\parent\t=t_window
			
				TGadgetMove Handle(g\parent),g\parent\x,g\parent\y
			
			EndIf
		
			g\parent\v[2]=True
			g\parent\v[3]=0
			gg.tgadget=Last tgadget
			While gg<>Null
				If gg\parent=g\parent
					
					g\parent\v[3]=Int(g\parent\v[3])+gg\h
					
				EndIf
				gg=Before gg
			Wend
			
			g\parent\v[3]=Int(g\parent\v[3])+TGadgetBorderSize(g\t,0)/2
				
			If g\parent\parent<>Null
				If g\parent\parent\t=t_menu
					TgadgetUpdate(g\parent)
				EndIf
			EndIf		
			g\parent\hasmenu=g\h
		EndIf
				
		TGadgetRefresh(g)
						
End Select

If g\t<>t_tabpage

	TGadgetMove(Handle(g),x,y)
	TGadgetSize(Handle(g),w,h)
	
Else

	TGadgetMove(Handle(g\parent\parent),g\parent\parent\x,g\parent\parent\y)
	
EndIf

If g\t=t_button

	If Int(g\v[1])=0
	
		TGadgetSet Handle(g),t_text,txt$
		
	Else
		
		TGadgetRedraw()
		
	EndIf

Else

	TGadgetSet Handle(g),t_text,txt$

EndIf

If g\t=t_menu

	TGadgetRefresh(g)
						
EndIf


Return Handle(g)

End Function

Function TGadgetDelete(gadget)

g.tgadget=Object.tgadget(gadget)

Select g\t

	Case t_button
		If Int(g\v[1])>0
			FreeTexture g\v[1]
		EndIf
	Case t_image
		If Int(g\v[0])<>0
			FreeEntity g\v[0]
		EndIf
		If Int(g\v[1])<>0
			FreeTexture g\v[1]
		EndIf
	Case t_tabpage
		par.tgadget=g\parent
		g\parent=Null
		If par<>Null
			TGadgetRefresh(par)
			TGadgetMove Handle(par),par\x,par\y
		EndIf
	Case t_menu
		par.tgadget=g\parent
		par1.tgadget=Object.tgadget(g\v[1])
		g\parent=Null
		If par<>Null
			If par\t=t_window
				For gg.tgadget=Each tgadget
					If gg\t=t_window
						If gg=par
							test=0
							For ggg.tgadget=Each tgadget
								If ggg\parent=gg
									If ggg\t=t_menu
									test=1
									TGadgetRefresh(ggg)
									EndIf
								EndIf
							Next
							If test=0
							
								gg\hasmenu=0
								TGadgetMove Handle(gg),gg\x,gg\y
							
							EndIf
						
						EndIf
					EndIf	
				Next
			EndIf
		EndIf
		
		
		
		For gg.tgadget=Each tgadget
		If gg\parent=par1
		If gg\t=t_menu
		
		TGadgetRefresh(gg)
		
		EndIf
		EndIf
		Next
		
		
	
End Select

For gg.tgadget=Each tgadget
	If gg\parent=g
		TGadgetDelete Handle(gg)
	EndIf
Next

For n=0 To TGadgetCount(g\t)
	
	If TGadgetPartType(g\t,n)=t_text
		If g\part[n]\e<>0
			FreeEntity g\part[n]\e
		EndIf
	EndIf
Next
If g\txte<>0
	FreeEntity g\txte
EndIf
If g\e<>0
	FreeEntity g\e
EndIf

For p.tpart=Each tpart
	If p\g=g
		Delete p
	EndIf
Next



Delete g

End Function

Function TGadgetReBuild(g.tgadget)

	For n=0 To TGadgetCount(g\t)
	
		gp.tpart=New tpart
		gp\g=g
		gp\n=n
		g\part[n]=gp
		gp\parttype=TGadgetPartType(g\t,n)
		
		If g\t=t_checkbox
			If g\parent<>Null
				If g\parent\t=t_radio
					If n=0
						gp\parttype=t_radio
					Else	
						gp\parttype=t_radiotick
					EndIf
				EndIf
			EndIf
		EndIf
			
		
		If TGadgetPartType(g\t,n)<>t_text
			
		state=g\partstate[n]*2
			
		x0#=TGadgetTextureCoordsX#(gp\parttype,0+state)
		x1#=TGadgetTextureCoordsX#(gp\parttype,1+state)
		y0#=TGadgetTextureCoordsY#(gp\parttype,0+state)
		y1#=TGadgetTextureCoordsY#(gp\parttype,1+state)
		siz#=TGadgetTextureSize(gp\parttype)	
		
		g\vert[n]=AddVertex(g\surf,0,0,0,x0,y0);0
		AddVertex(g\surf,0,0,0,x0+siz,y0);1
		AddVertex(g\surf,0,0,0,x1-siz,y0);2
		AddVertex(g\surf,0,0,0,x1,y0);3
		
		AddVertex(g\surf,0,0,0,x1,y0+siz);4
		AddVertex(g\surf,0,0,0,x1,y1-siz);5
		AddVertex(g\surf,0,0,0,x1,y1);6
		AddVertex(g\surf,0,0,0,x1-siz,y1);7
		AddVertex(g\surf,0,0,0,x0+siz,y1);8
		AddVertex(g\surf,0,0,0,x0,y1);9
		AddVertex(g\surf,0,0,0,x0,y1-siz);10
		AddVertex(g\surf,0,0,0,x0,y0+siz);11
		AddVertex(g\surf,0,0,0,x0+siz,y0+siz);12
		AddVertex(g\surf,0,0,0,x1-siz,y0+siz);13
		AddVertex(g\surf,0,0,0,x1-siz,y1-siz);14
		AddVertex(g\surf,0,0,0,x0+siz,y1-siz);15
		If g\t<>g_text
		
			AddTriangle g\surf,g\vert[n]+0,g\vert[n]+1,g\vert[n]+11
			AddTriangle g\surf,g\vert[n]+1,g\vert[n]+12,g\vert[n]+11
			If g\t<>t_frame
				AddTriangle g\surf,g\vert[n]+1,g\vert[n]+2,g\vert[n]+12
				AddTriangle g\surf,g\vert[n]+12,g\vert[n]+2,g\vert[n]+13
			EndIf
			AddTriangle g\surf,g\vert[n]+2,g\vert[n]+3,g\vert[n]+13
			AddTriangle g\surf,g\vert[n]+13,g\vert[n]+3,g\vert[n]+4
			AddTriangle g\surf,g\vert[n]+11,g\vert[n]+12,g\vert[n]+10
			AddTriangle g\surf,g\vert[n]+12,g\vert[n]+15,g\vert[n]+10
			AddTriangle g\surf,g\vert[n]+13,g\vert[n]+4,g\vert[n]+14
			AddTriangle g\surf,g\vert[n]+4,g\vert[n]+5,g\vert[n]+14
			AddTriangle g\surf,g\vert[n]+10,g\vert[n]+15,g\vert[n]+9
			AddTriangle g\surf,g\vert[n]+15,g\vert[n]+8,g\vert[n]+9
			AddTriangle g\surf,g\vert[n]+15,g\vert[n]+14,g\vert[n]+8
			AddTriangle g\surf,g\vert[n]+8,g\vert[n]+14,g\vert[n]+7
			AddTriangle g\surf,g\vert[n]+14,g\vert[n]+5,g\vert[n]+7
			AddTriangle g\surf,g\vert[n]+5,g\vert[n]+6,g\vert[n]+7
	
			If g\t<>t_frame Or n<>0
				AddTriangle g\surf,g\vert[n]+12,g\vert[n]+13,g\vert[n]+15
				AddTriangle g\surf,g\vert[n]+13,g\vert[n]+14,g\vert[n]+15
			EndIf
			If g\t=t_frame
		
				AddVertex(g\surf,0,0,0,x0+siz,y0);1	
				AddVertex(g\surf,0,0,0,x0+siz,y0+siz);12
				
				AddTriangle g\surf,g\vert[n]+16,g\vert[n]+2,g\vert[n]+17
				AddTriangle g\surf,g\vert[n]+2,g\vert[n]+13,g\vert[n]+17
								
			EndIf
		
		
		
		EndIf

		
		For nn=0 To 15
			VertexColor g\surf,g\vert[n]+nn,g\r,g\g,g\b,g\a
		Next

	;Else
	
	;	If g\t<>t_list
		;TTextRect(x,y,w,h,txt$,pos=0,clip=0,scrx=0,scry=0)
	;		g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,n),0,g\w,g\h,g\v[0],6,1,g\v[1],g\v[2])
	;	Else
	;		g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,n),1+TGadgetBorderSize(g\t,n),g\w-TGadgetBorderSize(g\t,n)*2,g\h-TGadgetBorderSize(g\t,n)*2-2,g\v[5],0,1,0,g\v[3])
	;	EndIf
			
	EndIf
		
Next

TGadgetRedraw()

End Function

Global TRedrawOrder
Global TRedrawOrderFront

Function TGadgetRedraw()

TRedrawOrder=TOrder-2

For g.tgadget=Each tgadget

	TRedrawOrder=TRedrawOrder-2
	g\order=TRedrawOrder
	EntityOrder g\e,g\order
	
	For n=0 To TGadgetCount(g\t)
	
		If TGadgetPartType(g\t,n)=t_text
			If g\part[n]\e<>0
				TRedrawOrder=TRedrawOrder-2
				EntityOrder g\part[n]\e,TRedrawOrder
			EndIf
		EndIf
	
	Next
	
	If g\txte<>0
		TRedrawOrder=TRedrawOrder-2
		EntityOrder g\txte,TRedrawOrder
	EndIf
	Select g\t
		Case t_image
			If Int(g\v[0])<>0
				TRedrawOrder=TRedrawOrder-2
				EntityOrder g\v[0],TRedrawOrder			
			EndIf
			
		Case t_3d
			If Int(g\v[0])<>0
				TRedrawOrder=TRedrawOrder-2
				EntityOrder g\v[0],TRedrawOrder			
			EndIf
		
	End Select
		
Next
TRedrawOrder=TRedrawOrder-2
TRedrawOrderFront=TRedrawOrder

If TGadgetHelpEntity<>0
	TRedrawOrder=TRedrawOrder-2
	EntityOrder TGadgetHelpEntity,TRedrawOrder
EndIf

If TPointer<>0
	TRedrawOrder=TRedrawOrder-2
	EntityOrder TPointer,TRedrawOrder-10
EndIf


End Function

Function TGadgetMove(gadget,x,y)

g.tgadget=Object.tgadget(gadget)

g\x=x
g\y=y


	If g\parent=Null

		g\dx=g\x
		g\dy=g\y
	
	Else
	
		Select g\parent\t
			Case t_window
			
				g\dx=g\parent\dx+g\x
				If g\t<>t_menu
					g\dy=g\parent\dy+g\parent\part[1]\h+2+g\parent\hasmenu+g\y
				Else
					If Int(g\parent\v[0]) And 1
						g\dy=g\parent\dy+g\parent\part[1]\h+2+g\y
					Else
						g\dy=g\parent\dy+g\parent\part[1]\h+g\y
					EndIf
					
				EndIf
				;+TGadgetCoords(g\parent\t,1,1)+TGadgetCoords(g\parent\t,1,3)+g\y
			
			Case t_tabpage
	
				g\dx=g\parent\parent\dx+g\x
				n=g\parent\parent\v[2]
				g\dy=g\parent\parent\dy+n+g\y
				
			Default
	
				g\dx=g\parent\dx+g\x
				g\dy=g\parent\dy+g\y
		
		End Select

	EndIf
	
	PositionEntity g\e,g\dx-0.5,g\dy-0.5,0
	For n=0 To TGadgetCount(g\t)

		g\part[n]\x=g\dx+g\part[n]\lx
		g\part[n]\y=g\dy+g\part[n]\ly
		
		If TGadgetPartType(g\t,n)=t_text
			If g\part[n]\e<>0
				PositionEntity g\part[n]\e,g\part[n]\x-0.5,g\part[n]\y-0.5,0
			EndIf
		EndIf
	Next
	If g\txte<>0
		PositionEntity g\txte,g\dx-0.5,g\dy-0.5,0
	EndIf
	Select g\t
		Case t_image
			PositionEntity g\v[0],g\dx-0.5,g\dy-0.5,0
		Case t_3d
			CameraViewport g\v[0],g\dx,g\dy,g\w,g\h		
		
	End Select
	
	For gg.tgadget=Each tgadget
		If gg\parent=g
			TGadgetMove(Handle(gg),gg\x,gg\y)
		EndIf
	Next

End Function 

Function TGadgetSize(gadget,w,h)

g.tgadget=Object.tgadget(gadget)

g\w=w
g\h=h

If g\t=t_tab
	TGadgetRefresh(g)
	TGadgetMove gadget,g\x,g\y
EndIf

TGadgetUpdate(g)
TGadgetSet gadget,t_text,g\txt$


End Function

Function TGadgetHide(gadget,uhide=1)

g.tgadget=Object.tgadget(gadget)

g\hide=1
If uhide=1
g\userhide=uhide
EndIf

HideEntity g\e

For n=0 To TGadgetCount(g\t)

	If TGadgetPartType(g\t,n)=t_text
		If g\part[n]\e<>0
			HideEntity g\part[n]\e
		EndIf
		
	EndIf
	
Next
If g\txte<>0

	HideEntity g\txte
	
EndIf

Select g\t
	Case t_image
		If Int(g\v[0])<>0
			HideEntity g\v[0]
		EndIf
	Case t_3d
	
End Select

For gg.tgadget=Each tgadget
	If gg\parent=g
		TGadgetHide Handle(gg),0 ;uhide
	EndIf
Next


End Function

Function TGadgetShow(gadget,ushow=1,children=1);,ushow=1,children=1)

g.tgadget=Object.tgadget(gadget)

If ushow=1
	g\userhide=0
	If g\t=t_menu
		If g\parent<>Null
			If g\parent\t=t_menu
				Return
			EndIf
		EndIf
	EndIf
Else
	If ushow<>g\userhide
		Return
	EndIf
EndIf

If g\parent<>Null
	If g\parent\hide=1
		Return 
	EndIf
EndIf

g\hide=0

ShowEntity g\e

For n=0 To TGadgetCount(g\t)

	If TGadgetPartType(g\t,n)=t_text
		If g\part[n]\e<>0
			ShowEntity g\part[n]\e
			EntityAlpha g\part[n]\e,g\fonta
		EndIf
		
	EndIf
	
Next
If g\txte<>0

	ShowEntity g\txte
	EntityAlpha g\txte,g\fonta
	
EndIf
Select g\t
	Case t_image
		If Int(g\v[0])<>0
			ShowEntity g\v[0]
		EndIf
	Case t_3d
	
End Select

If g\parent<>Null
If g\parent\t=t_tabpage

	If Int(g\parent\parent\v[0])<>Handle(g\parent)
	
		TGadgetHide Handle(g),0
		
	EndIf

EndIf
EndIf

If children=1
For gg.tgadget=Each tgadget
	If gg\parent=g
		If gg\userhide=0
			TGadgetShow Handle(gg),ushow,children
		EndIf
	EndIf
Next
EndIf



End Function

Function TGadgetLock(gadget,fade=True)

g.tgadget=Object.tgadget(gadget)
If g\lock<>0
If fade=True
	TGadgetAlpha gadget,g\locka
	TGadgetFontAlpha gadget,g\lockfa
EndIf
EndIf
g\lock=1
g\locka=g\a
g\lockfa=g\fonta

If fade=True
	TGadgetAlpha gadget,g\a*0.5
	TGadgetFontAlpha gadget,g\fonta*0.5
EndIf

For gg.tgadget=Each tgadget
	If gg\parent=g
		TGadgetLock Handle(gg),fade
	EndIf
Next

End Function

Function TGadgetUnLock(gadget,fade=True)

g.tgadget=Object.tgadget(gadget)

If g\lock<>0
If fade=True
	TGadgetAlpha gadget,g\locka
	TGadgetFontAlpha gadget,g\lockfa
EndIf
EndIf

g\lock=0


For gg.tgadget=Each tgadget
	If gg\parent=g
		TGadgetUnLock Handle(gg),fade
	EndIf
Next

End Function

Function TGadgetToFront(g.tgadget,rec=0)

If g\layermode=2
	Return
EndIf

If rec<>1
	Insert g After Last tgadget
EndIf

gg.tgadget=Last tgadget
While gg<>Null
	If gg\parent=g
		Insert gg After g
		TGadgetToFront gg,1
	EndIf
	gg=Before gg
Wend

If rec=0
	For gg.tgadget=Each tgadget
		If gg\layermode=1
			TGadgetToFront(gg,2)
		EndIf
	Next
EndIf

End Function 

Function TGadgetToBack(g.tgadget,rec=0)

If g\layermode=1
	Return
EndIf

If rec<>1
	Insert g Before First tgadget
EndIf

gg.tgadget=Last tgadget
While gg<>Null
	If gg\parent=g
		Insert gg After g
		TGadgetToBack gg,1
	EndIf
	gg=Before gg
Wend

If rec=0
	For gg.tgadget=Each tgadget
		If gg\layermode=2
			TGadgetToBack(gg,2)
		EndIf
	Next
EndIf

End Function


Function TGadgetColor(gadget,r,gr,b)

g.tgadget=Object.tgadget(gadget)

g\r=r
g\g=gr
g\b=b

For n=0 To TGadgetCount(g\t)
	If TGadgetPartType(g\t,n)<>t_text
		For nn=0 To 15
			VertexColor g\surf,g\vert[n]+nn,g\r,g\g,g\b,g\a#
		Next
	EndIf
Next

Select g\t
	Case t_button
		If g\txte<>0
			If Int(g\v[1])<>0
				
				EntityColor g\txte,g\r,g\g,g\b
				
			EndIf
		EndIf
		
	Case t_image
		EntityColor g\v[0],g\r,g\g,g\b

End Select

End Function

Function TGadgetFontColor(gadget,r,gr,b)

g.tgadget=Object.tgadget(gadget)

g\fontr=r
g\fontg=gr
g\fontb=b

For n=0 To TGadgetCount(g\t)
	If TGadgetPartType(g\t,n)=t_text
		If g\part[n]\e<>0
			EntityColor g\part[n]\e,g\fontr,g\fontg,g\fontb
		EndIf
	EndIf
Next
If g\txte<>0
	EntityColor g\txte,g\fontr,g\fontg,g\fontb
EndIf

End Function

Function TGadgetAlpha(gadget,a#)

g.tgadget=Object.tgadget(gadget)

g\a=a

For n=0 To TGadgetCount(g\t)
	If TGadgetPartType(g\t,n)<>t_text
		For nn=0 To 15
			VertexColor g\surf,g\vert[n]+nn,g\r,g\g,g\b,g\a#
		Next
	EndIf
Next

End Function

Function TGadgetFontAlpha(gadget,a#)

g.tgadget=Object.tgadget(gadget)

g\fonta=a

For n=0 To TGadgetCount(g\t)
	If TGadgetPartType(g\t,n)=t_text
		If g\part[n]\e<>0
			EntityAlpha g\part[n]\e,g\fonta
		EndIf
	EndIf
Next
If g\txte<>0
	EntityAlpha g\txte,g\fonta
EndIf

End Function 

Function TGadgetRefresh(g.tgadget)

If g\t=t_button

	If g\v[1]=0
		TGadgetSet Handle(g),t_text,g\txt$
	EndIf

Else

	TGadgetSet Handle(g),t_text,g\txt$

EndIf

Select g\t
	
	Case t_tab
	
		For gg.tgadget=Each tgadget
			If gg\parent=g
				TGadgetRefresh(gg)
			EndIf
		Next
	
	Case t_tabpage

		num=0
		For gg.tgadget=Each tgadget
			If gg\parent=g\parent
				num=num+1
			EndIf
		Next
		widf#=Float(g\parent\w)/num
		;number=num
		num=0
		For gg.tgadget=Each tgadget
			If gg\parent=g\parent
				If g\parent\v[0]=Handle(gg)
					g\parent\v[1]=num
					TGadgetPartState(gg\part[0],1)
				Else
					TGadgetPartState(gg\part[0],0)
				EndIf
				num=num+1
				gg\x=g\parent\w-widf#*num
				gg\y=0
				gg\w=Ceil(widf)
				gg\h=g\parent\v[2]
				
				;If num=number
				;gg\x=0	
				;EndIf

				TGadgetUpdate(g)
				
			EndIf
		Next

		For gg.tgadget=Each tgadget
			If gg\parent=g
				TGadgetRefresh(gg)
				TGadgetMove Handle(gg),gg\x,gg\y
			EndIf
		Next
		
	Case t_checkbox
	
		If Int(g\v[0])=0
		
			TGadgetPartState(g\part[1],0)
		
		Else

			TGadgetPartState(g\part[1],1)		
		
		EndIf
		
	Case t_textbox,t_integer,t_float
		g\part[2]\w=2
		

	
		
		
	Case t_slider
		g\partx[1]=Float(g\v[0])*(g\w-g\part[1]\w)
		g\party[1]=Float(g\v[1])*(g\h-g\part[1]\h)
		TGadgetUpdate(g)
	
	Case t_hslider
		g\partx[1]=Float(g\v[0])*(g\w-g\part[1]\w)
		TGadgetUpdate(g)
			
	Case t_vslider
		g\party[1]=Float(g\v[0])*(g\h-g\part[1]\h)
		TGadgetUpdate(g)
		
	Case t_list
		
		;g\party[4]=Float(Float(g\v[3])/Float(Int(g\v[4])-g\part[0]\h))*(g\h-g\part[4]\h)		
		
		ll.tlist=Object.tlist(g\v[2])
		If ll<>Null
			
			g\v[5]=TListString$(ll,g\w)
			g\v[6]=TListStringCount
			test=0
			num=g\v[0]
			ln2.tlistnode=Null
			For ln.tlistnode=Each tlistnode
				If ln\l=ll
					If ln\i\num=num
						g\v[1]=Handle(ln\i)
						ln2.tlistnode=ln
						;
											
						g\party[1]=TGadgetBorderSize(t_list,0)-TGadgetBorderSize(t_list,1)+ln\y-Int(g\v[3])
						g\partw[1]=0
						g\parth[1]=TFontHeight+TGadgetBorderSize(t_list,1)*2
						g\partx[1]=TGadgetBorderSize(g\t,0)-TGadgetBorderSize(t_list,1)
						test=1
						Exit
											
					EndIf
				EndIf
			Next
					
			g\v[4]=TListStringCount*TFontHeight
			If g\v[0]=0 Or test=0
		
				g\partw[1]=0
				g\parth[1]=-TFontHeight-2
				g\partx[1]=-2000
				
				
			EndIf
			
			numm#=Float(g\part[2]\h-TGadgetBorderSize(t_list,0)*2)/Float(g\v[4])
			If numm#>1
				numm#=1
				
				g\partx[3]=-2000
				g\partx[4]=-2000
				g\partw[1]=-TGadgetBorderSize(t_list,0)*2+TGadgetBorderSize(t_list,1)*2
				g\partw[2]=0
											
			Else
			
				g\partx[3]=0 ;-2000
				g\partx[4]=0
				g\partw[1]=-16 ;-TGadgetBorderSize(t_list,0)
				g\partw[2]=-16 ;-TGadgetBorderSize(t_list,0)
								
			EndIf
			TGadgetSet Handle(g),t_knotsize,numm
			
			
			If Int(g\v[3])>(Int(g\v[4])-(g\part[2]\h-TGadgetBorderSize(t_list,0)*2))
			
				g\v[3]=0 ;Int(Int(g\v[4])-(g\part[2]\h-TGadgetBorderSize(t_list,2)*2))
				
				If ln2<>Null
				
				g\party[1]=TGadgetBorderSize(t_list,0)-TGadgetBorderSize(t_list,1)+ln2\y-Int(g\v[3])
			
				EndIf
				
			
			EndIf
			
			g\party[4]=Float(Float(g\v[3])/Float(Int(g\v[4])-(g\part[0]\h-TGadgetBorderSize(t_list,0)*2)))*(g\h-g\part[4]\h)
			
			
			
			
			;TGadgetBorderSize(g\t,n),1+TGadgetBorderSize(g\t,n),g\w-TGadgetBorderSize(g\t,n)*2,g\h-TGadgetBorderSize(g\t,n)*2-2			
			;TGadgetPartClip(g\part[1],g\part[0]\x+TGadgetBorderSize(g\t,1),g\part[0]\y+TGadgetBorderSize(g\t,1),g\part[0]\x+g\part[0]\w-TGadgetBorderSize(g\t,1)*2,g\part[2]\y+g\part[2]\h-+TGadgetBorderSize(g\t,1)*2)	
			
			TGadgetUpdate(g)
			TGadgetPartClip(g\part[1],0,0,g\part[2]\w,g\part[2]\h)	
			
		EndIf
		
	Case t_combobox

	;list
;Data 4
;Data 0,0,1,1, 16 ,t_list,1   		0
;Data 0,0,0.9,0, 8 ,t_selected,0	1
;Data 0,0,1,1, 2 ,t_text,0			2
;Data 0.9,0,0.1,1, 8 ,t_vslider,1	3
;Data 0.9,0,0.1,0.25, 8 ,t_vknot,1	4

;combobox
;Data 5
;Data 0,0,1,1, 16 ,t_combobox,1			0
;Data -16,0,16,1, 8 ,t_comboarrow,3		1
;Data 0  ,1,1,0, 2 ,t_combobackground,0	2
;Data 0,1,0.9,0, 8 ,t_selected,0		3
;Data 0,1,1,1, 2 ,t_text,0				4
;Data -16,1,16,0, 8 ,t_comboslider,1	5
;Data -16,1,16,0, 8 ,t_comboknot,1		6

				
		g\party[6]=Float(Float(g\v[3])/Float(Int(g\v[4])-(g\part[2]\h-TGadgetBorderSize(t_combobox,2)*2)))*(g\part[2]\h-g\part[6]\h)		
		
		ll.TList=Object.TList(g\v[2])
		If ll<>Null
			
			g\v[5]=TListString$(ll,g\w)
			g\v[6]=TListStringCount
			test=0
			num=g\v[0]
			For ln.tlistnode=Each tlistnode
				If ln\l=ll
					If ln\i\num=num
						g\v[1]=Handle(ln\i)
													
						g\party[3]=TGadgetBorderSize(t_combobox,2)-TGadgetBorderSize(t_combobox,3)+ln\y-Int(g\v[3])
						;g\partx[3]=TGadgetBorderSize(g\t,2)-1
						
						
						;g\partw[3]=-TGadgetBorderSize(g\t,2)*2
						g\v$[9]=ln\i\d$
						test=1
						
					EndIf
				EndIf
			Next
			g\parth[3]=TFontHeight+TGadgetBorderSize(t_combobox,3)*2
					
			g\v[4]=TListStringCount*TFontHeight
			If g\v[4]=0 Or test=0
		
				
				;g\parth[3]=-TFontHeight-2
				g\partx[3]=-2000
				
			EndIf
			
			
			If Int(g\v[3])>(Int(g\v[4])-(g\part[2]\h-TGadgetBorderSize(t_combobox,2)*2))
			
				g\v[3]=0 ;Int(Int(g\v[4])-(g\part[2]\h-TGadgetBorderSize(t_list,2)*2))
				;ln.tlistnode=Object.tlistnode(g\v[1])
				;If ln<>Null
				;g\party[1]=1+TGadgetBorderSize(g\t,1)/4+ln\y-Int(g\v[3])
				;EndIf
				
			
			EndIf
			
			g\party[6]=Float(Float(g\v[3])/Float(Int(g\v[4])-(g\part[2]\h-TGadgetBorderSize(t_combobox,2)*2)))*(g\part[2]\h-g\part[6]\h)
			;TGadgetBorderSize(g\t,n),1+TGadgetBorderSize(g\tn),g\w-TGadgetBorderSize(g\t,n)*2,g\h-TGadgetBorderSize(g\t,n)*2-2			
			;TGadgetPartClip(g\part[1],g\part[0]\x+TGadgetBorderSize(g\t,1),g\part[0]\y+TGadgetBorderSize(g\t,1),g\part[0]\x+g\part[0]\w-TGadgetBorderSize(g\t,1)*2,g\part[2]\y+g\part[2]\h-+TGadgetBorderSize(g\t,1)*2)	
								
			TGadgetUpdate(g)
			TGadgetPartClip(g\part[3],0,g\h,g\part[2]\w,g\h+g\part[2]\h)	
			
		EndIf
	
		
	Case t_menu
	
		If g\parent<>Null
			g\parent\v[2]=True
			g\parent\v[3]=0
			gg.tgadget=Last tgadget
			While gg<>Null
				If gg\parent=g\parent
					
					g\parent\v[3]=Int(g\parent\v[3])+gg\h
					
				EndIf
				gg=Before gg
			Wend
			
			g\parent\v[3]=Int(g\parent\v[3])+TGadgetBorderSize(g\t,0)/2
				
			If g\parent\parent<>Null
				If g\parent\parent\t=t_menu
					TgadgetUpdate(g\parent)
				EndIf
			EndIf		
			g\parent\hasmenu=g\h
		EndIf

	
		If g\parent<>Null
		
			Select g\parent\t
			
				Case t_menu
				
					test=0
					If g\parent\parent<>Null
						test=1
						If g\parent\parent\t<>t_menu	
							test=0
						EndIf
					EndIf
					If test=1
						x=g\parent\w ;parent\w
						y=0
						g\v[1]=g\parent\parent\v[1]
					Else
						x=0
						y=g\parent\h
						g\v[1]=g\parent\v[1]
					EndIf
													
					gg.tgadget=Last tgadget
					ggg.tgadget=Null		
					While gg<>Null
						If gg\parent=g\parent
							If gg\t=t_menu
							gg\v[1]=g\v[1]
							TGadgetMove Handle(gg),x,y
							TGadgetHide Handle(gg),0
							y=y+gg\h
							ggg=gg
							gg\v[4]=0
							TGadgetUpdate(gg)
							EndIf
						EndIf
						gg=Before gg
					Wend
					If ggg<>Null
						
						ggg\v[4]=1
						TGadgetUpdate(ggg)
		
					EndIf
				Default
				
					g\v[1]=Handle(g)
					x=0
					gg.tgadget=Last tgadget		
					While gg<>Null
						If gg\parent=g\parent
							If gg\t=t_menu
							TGadgetMove Handle(gg),x,0
							x=x+gg\w
							EndIf
						EndIf
						gg=Before gg
					Wend
								
			End Select
			
		Else
		
			g\v[1]=Handle(g)
			x=0
			gg.tgadget=Last tgadget		
			While gg<>Null
				If gg\parent=g\parent
					TGadgetMove Handle(gg),x,0
					x=x+gg\w
				EndIf
				gg=Before gg
			Wend			
		EndIf
		
				
		TGadgetUpdate(g)
			
End Select

For n=0 To TGadgetCount(g\t)

	If TGadgetPartType(g\t,n)=t_text
		If g\part[n]\e<>0
			FreeEntity g\part[n]\e
		EndIf
		
		Select g\t

			Case t_float
				find=Instr(g\v[0],".")
				If find>0 And TGadgetState(3)<>g\part[0]
				
					txt$=Left$(g\v[0],find+Int(g\v[8]))					
					num=Int(g\v[8])-Len(Mid$(g\v[0],find+1,Int(g\v[8])))
					If num>0
						txt$=txt$+String("0",num)
					EndIf
					g\v[0]=txt$
					g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,0),0,g\w-TGadgetBorderSize(g\t,0)*2-16,g\h,txt$,6,1,g\v[1],g\v[2])
					
				Else
				
					g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,0),0,g\w-TGadgetBorderSize(g\t,0)*2-16,g\h,g\v[0],6,1,g\v[1],g\v[2])
		
				EndIf
			
			Case t_progress

				g\part[n]\e=TTextRect(0,0,g\w,g\h,g\v[1])
					;TTextRect(x,y,w,h,txt$,pos=1,clip=0,scrx=0,scry=0)

			Case t_list				
				g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,0),TGadgetBorderSize(g\t,0),g\w-TGadgetBorderSize(g\t,0)*2+g\partw[2],g\h-TGadgetBorderSize(g\t,0)*2,g\v[5],0,1,0,g\v[3])

				
			Case t_combobox
			
			If n=7
			
g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,0),TGadgetBorderSize(g\t,0),g\w-TGadgetBorderSize(g\t,0)*2,g\h-TGadgetBorderSize(g\t,0)*2,g\v[9],6,1,0,0)
			
			Else
			
g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,2),TGadgetBorderSize(g\t,2),g\part[2]\w-TGadgetBorderSize(g\t,2)*2,g\part[2]\h-TGadgetBorderSize(g\t,2)*2,g\v[5],0,1,0,g\v[3])
	
			EndIf
			
			Case t_integer
				g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,0),0,g\w-TGadgetBorderSize(g\t,0)*2-16,g\h,g\v[0],6,1,g\v[1],g\v[2])
		
			Default
				g\part[n]\e=TTextRect(TGadgetBorderSize(g\t,0),0,g\w-TGadgetBorderSize(g\t,0)*2,g\h,g\v[0],6,1,g\v[1],g\v[2])
		
		
		
		End Select
		If g\hide=True
			HideEntity g\part[n]\e
		EndIf
		EntityColor g\part[n]\e,g\fontr,g\fontg,g\fontb
		PositionEntity g\part[n]\e,-0.5+g\part[n]\x,-0.5+g\part[n]\y,0
		TGadgetRedraw()
		
	EndIf
Next

If g\parent<>Null

	If g\parent\t=t_tabpage
	
		If g\parent\parent\v[0]=Handle(g\parent)
	
			TGadgetShow Handle(g),0,1
			
		Else
		
			TGadgetHide Handle(g),0
			
		EndIf

	EndIf

EndIf

Return


If g\parent<>Null

	Select g\parent\t
	
	Case t_tab

		num=0
		For gg.tgadget=Each tgadget
			If gg\parent=g\parent
				num=num+1
			EndIf
		Next
		wid=g\parent\w/num
		num=0
		For gg.tgadget=Each tgadget
			If gg\parent=g\parent
				If num=0
					g\parent\v[0]=Handle(gg)		
				EndIf
				num=num+1
				gg\w=wid
				gg\h=g\parent\v[2]
				TGadgetMove(Handle(gg),g\parent\w-wid*num,0)
				
			EndIf
		Next

	Case t_tabpage	
		
		If g\parent\parent\v[0]=Handle(g\parent)
		
			TGadgetHide Handle(g),0
		
		Else
		
			TGadgetHide Handle(g),0
		
		EndIf

		Return
		If g\parent\v[0]=Handle(g) And 5=2
		
			For gg.tgadget=Each tgadget
				If gg\parent=g
					TGadgetShow Handle(gg),0,1
				EndIf
			Next
					
		EndIf
		
		
	End Select

EndIf

End Function

Function TGadgetUpdate(g.tgadget)


For n=0 To TGadgetCount(g\t)

	If TGadgetCoords#(g\t,n,0)<=1
		If TGadgetCoords#(g\t,n,0)>=0
			x=g\w*TGadgetCoords#(g\t,n,0)+g\partx[n]
		Else
			x=g\w+TGadgetCoords#(g\t,n,0)+g\partx[n]
		EndIf
	Else
		x=TGadgetCoords#(g\t,n,0)+g\partx[n]
	EndIf
	
	If TGadgetCoords#(g\t,n,1)<=1
		If TGadgetCoords#(g\t,n,1)>=0
			y=g\h*TGadgetCoords#(g\t,n,1)+g\party[n]
		Else
			y=g\h+TGadgetCoords#(g\t,n,1)+g\party[n]
		EndIf
	Else
		y=TGadgetCoords#(g\t,n,1)+g\party[n]
	EndIf

	If TGadgetCoords#(g\t,n,2)<=1
		If TGadgetCoords#(g\t,n,2)>=0
			w=g\w*TGadgetCoords#(g\t,n,2)+g\partw[n]
		Else
			w=g\w+TGadgetCoords#(g\t,n,2)+g\partw[n]
		EndIf
	Else
		w=TGadgetCoords#(g\t,n,2)+g\partw[n]
	EndIf

	If TGadgetCoords#(g\t,n,3)<=1
		If TGadgetCoords#(g\t,n,3)>=0
			h=g\h*TGadgetCoords#(g\t,n,3)+g\parth[n]
		Else
			h=g\h+TGadgetCoords#(g\t,n,3)+g\parth[n]
		EndIf
	Else
		h=TGadgetCoords#(g\t,n,3)+g\parth[n]
	EndIf
	
	bor=TGadgetBorderSize(g\t,n)
	
Select g\t
	
	Case t_window
		
		Select TGadgetPartType(g\t,n)
		
			Case t_windowbar
				
				If Int(g\v[0]) And 1
											
					h=g\v[1]
					y=2
					
				Else
				
					x=0
					y=0
					w=0
					h=0
					bor=0
				
				EndIf
				
			Case t_windowclose
			
				If Int(g\v[0]) And 2
		
					h=Int(g\v[1])-2
					w=h
					x=g\w-w-2
					
				Else
					
					x=0
					y=0
					w=0
					h=0
					bor=0
				
				EndIf
					
						
		End Select
		
	;Case t_frame
		
	;	If n=1
			
	;		x=TGadgetBorderSize(t_frame,0)
	;		y=-TFontHeight*0.5
	;		If g\txt$<>""
	;			w=TTextWidth(g\txt$)+5
	;		Else
	;			w=0
	;		EndIf
	;		h=TFontHeight
	;			
	;	EndIf
		
	Case t_progress
	
		Select TGadgetPartType(g\t,n)
		
			Case t_progressbar
				
				x=TGadgetBorderSize(g\t,0)
				y=TGadgetBorderSize(g\t,0)
								
				w=Float(g\v[0])*(w-TGadgetBorderSize(g\t,0)*2)
				h=g\h-TGadgetBorderSize(g\t,0)*2

			
		End Select
		
	Case t_menu
			
		Select TGadgetPartType(g\t,n)
		
			Case t_menuarrow
			test=0
				If g\parent=Null
					test=1
				Else
					If g\parent\t<>t_menu
						test=1
					EndIf
				EndIf
				
				
				;only show arrow if menu has children
				If Int(g\v[2])=False Or test=1
				
					w=0
											
				EndIf
			
			Case t_menubackground
			
				If Int(g\v[4])=1
				
					y=-Int(g\parent\v[3])+g\h+TGadgetBorderSize(g\t,0)/2
					h=Int(g\parent\v[3])
					
				Else
				
					h=0			
					
				EndIf
			Case t_menuline
			
				If g\txt$<>""
				
					h=0
								
				EndIf
			
			Case t_menu
				If g\parent<>Null
					If g\parent\t=t_menu
							
						x=TGadgetBorderSize(g\t,0)/2
						y=TGadgetBorderSize(g\t,0)/2
					
						w=g\w-TGadgetBorderSize(g\t,0)
						h=g\h-TGadgetBorderSize(g\t,0)
											
						
					EndIf
				EndIf
						
		End Select
		
	Case t_slider,t_hslider,t_vslider
			
		Select TGadgetPartType(g\t,n)
		
			Case t_knot
				w=g\w*Float(g\v[4])
				h=g\h*Float(g\v[5])
				x=(g\w-w)*Float(g\v[0])
				y=(g\h-h)*Float(g\v[1])
				
				;x=g\w*Float(g\v[4]) ;+g\partx[n]
				;y=g\h*Float(g\v[5]) ;+g\party[n]

			Case t_hknot
				w=g\w*Float(g\v[4])
				x=(g\w-w)*Float(g\v[0])
				
				
			
			Case t_vknot
				h=g\h*Float(g\v[5])
				y=(g\h-h)*Float(g\v[0])
				;y=g\h*Float(g\v[5]) ;+g\party[n]
				
			
		End Select
		
	Case t_list
			
		Select TGadgetPartType(g\t,n)
		
			Case t_vknot
				h=g\h*Float(g\v[7])
				
				
		End Select
	

		
End Select
	
	
	
	If bor>w/2
		bor=w/2
	EndIf
	If bor>h/2
		bor=h/2
	EndIf

	
	g\part[n]\lx=x
	g\part[n]\ly=y
	g\part[n]\x=g\dx+x
	g\part[n]\y=g\dy+y
	g\part[n]\w=w
	g\part[n]\h=h
		
	If TGadgetPartType(g\t,n)<>t_text
			
		VertexCoords g\surf,g\vert[n]+0,x,y,0
		VertexCoords g\surf,g\vert[n]+1,x+bor,y,0
		VertexCoords g\surf,g\vert[n]+2,x+w-bor,y,0
		VertexCoords g\surf,g\vert[n]+3,x+w,y,0
		VertexCoords g\surf,g\vert[n]+4,x+w,y+bor,0
		VertexCoords g\surf,g\vert[n]+5,x+w,y+h-bor,0
		VertexCoords g\surf,g\vert[n]+6,x+w,y+h,0
		VertexCoords g\surf,g\vert[n]+7,x+w-bor,y+h,0
		VertexCoords g\surf,g\vert[n]+8,x+bor,y+h,0
		VertexCoords g\surf,g\vert[n]+9,x,y+h,0
		VertexCoords g\surf,g\vert[n]+10,x,y+h-bor,0
		VertexCoords g\surf,g\vert[n]+11,x,y+bor,0
		VertexCoords g\surf,g\vert[n]+12,x+bor,y+bor,0
		VertexCoords g\surf,g\vert[n]+13,x+w-bor,y+bor,0
		VertexCoords g\surf,g\vert[n]+14,x+w-bor,y+h-bor,0
		VertexCoords g\surf,g\vert[n]+15,x+bor,y+h-bor,0
				
	EndIf
			
Next

Select g\t
	Case t_button
		If g\txte<>0
			If Int(g\v[1])<>0
				
				surf=GetSurface(g\txte,1)
				VertexCoords surf,0,2,2,0
				VertexCoords surf,1,g\w-2,2,0
				VertexCoords surf,2,g\w-2,g\h-2,0
				VertexCoords surf,3,2,g\h-2,0
		
			EndIf
		EndIf
		
	Case t_frame
	
		w=TTextWidth(g\txt$)
		If w>0
					
			VertexCoords g\surf,g\vert[n]+16,x+bor+w+3,y,0
			VertexCoords g\surf,g\vert[n]+17,x+bor+w+3,y+bor,0
			
		Else
		
			VertexCoords g\surf,g\vert[n]+16,x+bor,y,0
			VertexCoords g\surf,g\vert[n]+17,x+bor,y+bor,0
		
		EndIf
	
	
	Case t_image
		ScaleEntity g\v[0],g\w,g\h,1
	
	Case t_3d
		CameraViewport g\v[0],g\dx,g\dy,g\w,g\h
	
End Select



End Function

Function TGadgetPartState(p.tpart,state=0)

		p\g\partstate[p\n]=state

		x0#=TGadgetTextureCoordsX#(p\parttype,0+state*2)
		x1#=TGadgetTextureCoordsX#(p\parttype,1+state*2)
		y0#=TGadgetTextureCoordsY#(p\parttype,0+state*2)
		y1#=TGadgetTextureCoordsY#(p\parttype,1+state*2)
		siz#=TGadgetTextureSize(p\parttype)
		
		VertexTexCoords p\g\surf,p\g\vert[p\n]+0,x0,y0
		VertexTexCoords p\g\surf,p\g\vert[p\n]+1,x0+siz,y0
		VertexTexCoords p\g\surf,p\g\vert[p\n]+2,x1-siz,y0
		VertexTexCoords p\g\surf,p\g\vert[p\n]+3,x1,y0
		VertexTexCoords p\g\surf,p\g\vert[p\n]+4,x1,y0+siz
		VertexTexCoords p\g\surf,p\g\vert[p\n]+5,x1,y1-siz
		VertexTexCoords p\g\surf,p\g\vert[p\n]+6,x1,y1
		VertexTexCoords p\g\surf,p\g\vert[p\n]+7,x1-siz,y1
		VertexTexCoords p\g\surf,p\g\vert[p\n]+8,x0+siz,y1
		VertexTexCoords p\g\surf,p\g\vert[p\n]+9,x0,y1
		VertexTexCoords p\g\surf,p\g\vert[p\n]+10,x0,y1-siz
		VertexTexCoords p\g\surf,p\g\vert[p\n]+11,x0,y0+siz
		VertexTexCoords p\g\surf,p\g\vert[p\n]+12,x0+siz,y0+siz
		VertexTexCoords p\g\surf,p\g\vert[p\n]+13,x1-siz,y0+siz
		VertexTexCoords p\g\surf,p\g\vert[p\n]+14,x1-siz,y1-siz
		VertexTexCoords p\g\surf,p\g\vert[p\n]+15,x0+siz,y1-siz

End Function

;Const t_text=0
Const t_caption=0
Const t_value=1,t_default=1
;Const t_list=12 

Const t_textpos=18,t_txtpos=18


Const t_infront=20,t_tofront=20
Const t_inback=30,t_toback=30

Const t_alwaystofront=32,t_alwaysinfront=32
Const t_alwaystoback=33,t_alwaysinback=33




;Const t_selected=38

Const t_tabnumber=40
Const t_tabheight=41

Const t_lowlimit=42,t_min=42,t_low=42
Const t_highlimit=43,t_max=43,t_high=43
Const t_step=44
Const t_decimals=45
Const t_maxcharacters=46,t_maxchar=46

Const t_dragspeed=46

Const t_slidervert=50

Const t_listscroll=60

Const t_comboscroll=61
Const t_comboitems=62,t_comboboxitems=62

Const t_link=70

Const t_windowbarheight=80
Const t_windowflags=81

Const t_x=100,t_xpos=100
Const t_y=101,t_ypos=101
Const t_w=102,t_width=102
Const t_h=103,t_height=103
Const t_a=104,t_alpha=104
Const t_r=105,t_red=105
Const t_g=106,t_green=106
Const t_b=107,t_blue=107

Const t_hide=110,t_hidden=110,t_closed=110
Const t_show=111,t_shown=111
Const t_parent=120,t_owner=120

Const t_help=130

Const t_imageflags=150,t_buttonflags=150

Const t_imagetexture=151,t_buttontexture=151



Const t_knotsize=180
Const t_knotwidth=181,t_knotwid=181,t_knotw=181
Const t_knotheight=182,t_knothei=182,t_knoth=182

;position/alignment constants:

Const t_topleft=0
Const t_center=1,t_middle=1
Const t_top=2,t_above=2
Const t_right=3
Const t_bottom=4,t_below=4
Const t_left=5
Const t_leftcenter=6


Const t_fonta=204,t_fontalpha=204
Const t_fontr=205,t_fontred=205
Const t_fontg=206,t_fontgreen=206
Const t_fontb=207,t_fontblue=207

Const t_modal=300


Global TGadgetSetLinkValue

Function TGadgetSet(gadget,property,value$="")

g.tgadget=Object.tgadget(gadget)



Select property

	Case t_value
			
		Select g\t
		
			Case t_button
											
				If Int(g\v[1])>0
				
					FreeTexture g\v[1]
					g\v[1]=""
															
				EndIf
				If g\txte<>0
					FreeEntity g\txte
					g\txte=0
				EndIf
				
				g\txt$=value$	
					
				If FileType(value$)=1
				
					g\txte=CreateMesh(TPivot)
					EntityFX g\txte,1+8
					surf=CreateSurface(g\txte)
									
					AddVertex surf,0,0,0,0,0
					AddVertex surf,0,0,0,1,0
					AddVertex surf,0,0,0,1,1
					AddVertex surf,0,0,0,0,1
					
					AddTriangle surf,0,1,2
					AddTriangle surf,0,2,3
							
					g\v[1]=LoadTexture(g\txt$,g\v[2])
		
					EntityTexture g\txte,g\v[1]
					TGadgetUpdate(g)
					PositionEntity g\txte,g\dx-0.5,g\dy-0.5,0
					TGadgetRedraw()
										
				Else
				
					TGadgetSet Handle(g),t_text,value$
				
				EndIf

		
			Case t_textbox
				g\v[0]=value
				
				If Int(g\v[4])>0
					If Len(g\v[0])>Int(g\v[4])
						g\v[0]=Left(g\v[0],Int(g\v[4]))
					EndIf
				EndIf
				num=Len(g\v[0])
				If Int(g\v[3])>num
					g\v[3]=num
				EndIf
					
			Case t_integer
				g\v[1]=0
				If value$<>""
					If value$<>"-"
					g\v[0]=Int(value)
					Else
					g\v[0]=value$
					EndIf
				Else
					g\v[0]=""
				EndIf
				If value$<>""
					num=Int(value)				
					If g\v[5]<>""
						If num<Int(g\v[5])
							
							num=Int(g\v[5])
							g\v[0]=num
						EndIf
					EndIf
					If g\v[6]<>""
						If num>Int(g\v[6])
							
							num=Int(g\v[6])
							g\v[0]=num
						EndIf
					EndIf
				EndIf		
				num=Len(g\v[0])
				If Int(g\v[3])>num
					g\v[3]=num
				EndIf
				
			Case t_float
				g\v[1]=0
				
				If value$<>""
					If value$<>"-"
					g\v[0]=Float(value)
					Else
					
					EndIf
				Else
					g\v[0]=""
				EndIf
				
				g\v[0]=value$
				
				numf#=Float(value)
				If value$<>""
					If g\v[5]<>""
						If numf#<Float(g\v[5])
							
							numf#=Float(g\v[5])
							g\v[0]=numf#
						
						EndIf
					EndIf
					If g\v[6]<>""
						If numf#>Float(g\v[6])
							
							numf#=Float(g\v[6])
							g\v[0]=numf#
						
						EndIf
					EndIf
				EndIf				
				num=Len(g\v[0])
				If Int(g\v[3])>num
					g\v[3]=num
				EndIf
			
			Case t_slider,t_hslider,t_vslider 
			
				dist#=(Float(value)-Float(g\v[2]))/(Float(g\v[3])-Float(g\v[2]))
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
							
				g\v[0]=dist
			
			Case t_radio
			
				g\v[0]=0
				g\v[1]=0
				num=0
				gg.tgadget=Last tgadget
				While gg<>Null
					If gg\parent=g
						num=num+1
						If gg\t=t_button
							
							If num=Int(value$)
							
								g\v[0]=num
								g\v[1]=Handle(gg)
				
								gg\v[0]=1
								TGadgetPartState(gg\part[0],1)
									
							Else
							
								gg\v[0]=0
								TGadgetPartState(gg\part[0],0)
							
							EndIf
						Else
							If num=Int(value$)
							
								g\v[0]=num
								g\v[1]=Handle(gg)
				
								TGadgetSet Handle(gg),t_value,1
									
							Else
															TGadgetSet Handle(gg),t_value,0
							
							EndIf
						
						EndIf
					EndIf
					gg=Before gg
				Wend
				
			Case t_progress
				numf#=Float(value$)
				
				If numf>1
					numf=1
				EndIf
				If numf<0
					numf=0
				EndIf
				g\v[0]=numf
				g\v[1]=Int(Float(g\v[0])*100)+" %"
				TGadgetRefresh(g)
				TGadgetUpdate(g)
				
			Case t_image
		
				If Int(g\v[1])<>0
					
					FreeTexture g\v[1]
					
					g\v[1]=""
				
				EndIf
		
				g\v[2]=value$
				If FileType(g\v[2])=1
								
					g\v[1]=LoadTexture(g\v[2],g\v[3])
					
					EntityTexture g\v[0],g\v[1]
					;TGadgetUpdate(g)
					
				EndIf
				
			Case t_checkbox
			
				If g\parent<>Null
					If g\parent\t=t_radio
						num=0
						If value$=True
							num=0
							For gg.tgadget=Each tgadget
								If gg\parent=g\parent
									;num=num+1
									;If gg=g
			 							;g\parent\v[0]=num
										;g\parent\v[1]=Handle(gg)
							
									;EndIf
									TGadgetSet Handle(gg),t_value,0			
									
								EndIf
							Next					
													
						EndIf
						;EndIf
						
						g\v[0]=value
																				
					Else
			
						g\v[0]=value
						
					EndIf
							
				Else
							
					g\v[0]=value
					
					
				EndIf

				If Int(g\v[0])>1
					g\v[0]=1
				ElseIf Int(g\v[0])<0
					g\v[0]=0
				EndIf				
				
			Default
		
				g\v[0]=value
				
		End Select
					
		TGadgetRefresh(g)
		If TGadgetSetLinkValue=0
		If g\link<>Null
		
			TGadgetSetLinkValue=1
			TGadgetSet Handle(g\link),t_value,TGadgetGet(Handle(g))
			
		EndIf
		EndIf
		TGadgetSetLinkValue=0
		
		If g\lastv$<>g\v[0]
		
			TGadgetState(5)=g\part[0]
			
			g\lastv$=g\v[0]			
			
		EndIf
			
	Case t_text
		
		g\txt$=value$
		If g\t=t_button
			If g\txte<>0
				If Int(g\v[1])=0
					FreeEntity g\txte
					g\txte=0
				Else
					If FileType(g\txt$)=1
					
						Return
					Else
					
						FreeEntity g\txte
						g\txte=0
	
					
					EndIf
					
				EndIf
			EndIf
		Else
			If g\txte<>0
				FreeEntity g\txte
				g\txte=0
			EndIf
		EndIf
		If g\t=t_checkbox
		
			g\part[0]\w=TTextWidth(g\txt$)+g\w
		
		EndIf
		
		If g\txt$<>""
			Select g\t
				
				Case t_window
					g\txte=TTextRect(0,0,g\w,g\part[1]\h,g\txt$,g\txtpos)
					
				Case t_frame
				
					g\txte=TTextRect(TGadgetBorderSize(t_frame,0)+2,0,g\w,g\h,g\txt$,g\txtpos)
					
				Case t_menu
				
					g\txte=TTextRect(TGadgetBorderSize(t_frame,0)+2,0,g\w,g\h,g\txt$,g\txtpos)
		
				
		
				Default 
				
					g\txte=TTextRect(0,0,g\w,g\h,g\txt$,g\txtpos)
				
			End Select
			EntityColor g\txte,g\fontr,g\fontg,g\fontb
			PositionEntity g\txte,-0.5+g\dx,-0.5+g\dy,0 
			If g\hide=1
				HideEntity g\txte
			EndIf
			TGadgetRedraw()
	
		EndIf
		
		If g\t=t_frame
			TGadgetUpdate(g)
		EndIf
		
	Case t_textpos
	
		g\txtpos=value
		TGadgetRefresh(g)
		
	Case t_lowlimit
		Select g\t
			Case t_integer,t_float
				g\v[5]=value
				
			Case t_slider,t_hslider,t_vslider
				g\v[2]=value
		End Select
		TGadgetSet Handle(g),t_value,g\v[0]
		
	Case t_highlimit
			Select g\t
			Case t_integer,t_float
				g\v[6]=value
				
			Case t_slider,t_hslider,t_vslider
				g\v[3]=value
		End Select
		TGadgetSet Handle(g),t_value,g\v[0]

	Case t_maxcharacters
	
		g\v[4]=value
		TGadgetSet Handle(g),t_value,g\v[0]

	Case t_step
	
		g\v[7]=value
		
	Case t_decimals
	
		g\v[8]=value
		TGadgetSet Handle(g),t_value,g\v[0]
	
	Case t_dragspeed
		g\v[9]=value
						
	Case t_slidervert
		g\v[1]=value
		If g\lastv$<>g\v[1]
		
			TGadgetState(5)=g\part[0]
			
			g\lastv$=g\v[1]			
			
		EndIf
		TGadgetRefresh(g)
	
	Case t_comboitems
		g\v[7]=value
		
		TGadgetRefresh(g)
		TGadgetUpdate(g)
		

	Case t_infront
		TGadgetToFront(g)
		TGadgetRedraw
		
	Case t_inback
		TGadgetToBack(g)
		TGadgetRedraw
		
	Case t_alwaysinfront
	
		If value$=True
			g\layermode=1
			TGadgetToFront(g)
			TGadgetRedraw
		Else
			g\layermode=0
		EndIf

		
	Case t_alwaysinback

		If value$=True
			g\layermode=2
			TGadgetToBack(g)
			TGadgetRedraw
		Else
			g\layermode=0
		EndIf
	
	
	Case t_tabpage
		g\v[0]=value
		If g\lastv$<>g\v[0]
		
			TGadgetState(5)=g\part[0]
			
			g\lastv$=g\v[0]			
			
		EndIf
		TGadgetRefresh(g)
		
	Case t_tabnumber
		g\v[1]=value
		num=0
		num2=g\v[1]
		gg.tgadget=Last tgadget
		While gg<>Null
		If gg\parent=g
			If num=num2
				g\v[0]=Handle(gg)
				Exit
			EndIf
			num=num+1
		EndIf
		gg=Before gg
		Wend
		TGadgetRefresh(g)
		If g\lastv$<>g\v[0]
		
			TGadgetState(5)=g\part[0]
			
			g\lastv$=g\v[0]			
			
		EndIf
	
	Case t_tabheight
		g\v[2]=value
		TGadgetRefresh(g)
		
		;list
;Data 4
;Data 0,0,1,1, 16 ,t_list,1
;Data 0,0,-16,0, 2 ,t_selected,0
;Data 0,0,1,1, 2 ,t_text,0
;Data -16,0,16,1, 3 ,t_vslider,1
;Data -16,0,16,0.25, 8 ,t_vknot,1
		
	Case t_listscroll
		
		If Int(g\v[4])>=(g\part[0]\h-TGadgetBorderSize(g\t,0)*2)
															;[0]
			g\v[3]=Int(Float(value)*Float(Int(g\v[4])-(g\part[0]\h-TGadgetBorderSize(g\t,0)*2)))
			TGadgetRefresh(g)
	
		EndIf
	
	Case t_comboscroll
;Data 7
;Data 0,0,1,1, 3 ,t_combobox,1
;Data -16,0,16,1, 2 ,t_comboarrow,3
;Data 0  ,1,1,0, 3 ,t_combobackground,1
;Data 0,1,1,0, 2 ,t_selected,0
;Data 0,1,1,1, 2 ,t_text,0
;Data -16,1,16,0, 2 ,t_comboslider,1
;Data -16,1,16,0, 2 ,t_comboknot,1
;Data 0,0,1,1, 2 ,t_text,0
	
	;	DebugLog "List height : "+g\v[4]
	;	DebugLog "Part height : "+g\part[4]\h
	;	DebugLog "Border*2    : "+TGadgetBorderSize(g\t,4)*2
	
		If Int(g\v[4])>=(g\part[2]\h-TGadgetBorderSize(g\t,2)*2)
		
			g\v[3]=Int(Float(value)*Float(Int(g\v[4])-(g\part[2]\h-TGadgetBorderSize(g\t,2)*2)))
			TGadgetRefresh(g)
	
		EndIf
	

	Case t_list
		
		g\v[2]=value
		TGadgetRefresh(g)
		
	Case t_selected
	
		Select g\t
		
			Case t_list
				
				g\v[1]=value
				ll.TList=Object.TList(g\v[2])
				If ll<>Null
				
					ii.titem=Object.titem(g\v[1])
					If ii<>Null
					TItemUnFoldToItem(ii)
				
					g\v[0]=ii\num
					
					EndIf
				
				EndIf	
				TGadgetRefresh(g)
				
			Case t_radio
			
				gg.tgadget=Object.tgadget(g\v[1])
				If gg<>Null
					If gg\t=t_button
						gg\v[0]=0
						TGadgetPartState(gg\part[0],0)
					Else
						TGadgetSet Handle(gg),t_value,0				
					EndIf
				EndIf
				g\v[1]=value			
				gg.tgadget=Object.tgadget(g\v[1])
				num=0
				ggg.tgadget=Last tgadget
				While ggg<>Null
					If ggg\parent=g
					num=num+1
						If ggg=gg
							g\v[0]=num
						EndIf
					
					EndIf
					ggg=Before ggg
				Wend
								
				If gg<>Null
					If gg\t=t_button
						gg\v[0]=1
						TGadgetPartState(gg\part[0],1)
					Else
						TGadgetSet Handle(gg),t_value,1
					EndIf
				EndIf
		
		End Select
		
		If g\lastv$<>g\v[0]
	
			TGadgetState(5)=g\part[0]
			
			g\lastv$=g\v[0]			
			
		EndIf
		
	Case t_link
		If g\link<>Null
			g\link\link=Null
		EndIf
		g\link=Object.tgadget(value)
		If g\link<>Null
			g\link\link=g
		EndIf
		
	Case t_windowbarheight
		g\v[1]=Int(value$)
		TGadgetUpdate(g)
		TGadgetRefresh(g)
		TGadgetMove Handle(g),g\x,g\y
		
	Case t_windowflags
		g\v[0]=Int(value$)
		TGadgetUpdate(g)
		TGadgetRefresh(g)
		
	Case t_imageflags
		Select g\t
			Case t_image
			
				If value$=""
					g\v[3]=Int(1+2+16+32)
				Else
					g\v[3]=value$
				EndIf
				TGadgetSet Handle(g),t_value,g\v[2]
			
			Case t_button
			
				If value$=""
					g\v[2]=Int(1+2+16+32)
				Else
					g\v[2]=value$
				EndIf
				TGadgetSet Handle(g),t_value,g\txt$
			
			
		End Select
	Case t_imagetexture
		Select g\t
			Case t_image
			
				If Int(g\v[1])<>0
					
					FreeTexture g\v[1]
					
					g\v[1]=""
				
				EndIf
		
				If Int(value$)<>0					
					
					EntityTexture g\v[0],Int(value$)
					;TGadgetUpdate(g)
					
				EndIf
				
			Case t_button
				
				If Int(value$)<>0
								
							
					If Int(g\v[1])>0
						FreeTexture g\v[1]
						g\v[1]=""
					EndIf
					If g\txte<>0
						FreeEntity g\txte
						g\txte=0
					EndIf
					
					;g\txt$="Gfx\design2.png"
												
					g\v[1]=-1
					
					g\txte=CreateMesh(TPivot)
					EntityFX g\txte,1+8
					surf=CreateSurface(g\txte)
									
					AddVertex surf,0,0,0,0,0
					AddVertex surf,0,0,0,1,0
					AddVertex surf,0,0,0,1,1
					AddVertex surf,0,0,0,0,1
					
					AddTriangle surf,0,1,2
					AddTriangle surf,0,2,3
					
					EntityTexture g\txte,Int(value$)
					
					TGadgetUpdate(g)
					PositionEntity g\txte,g\dx-0.5,g\dy-0.5,0
					
					TGadgetRedraw()
					
				
				EndIf
			
		End Select		
	Case t_knotsize
		Select g\t
			
			Case t_slider,t_hslider,t_vslider
		
				g\v[4]=value$
				g\v[5]=value$
			
			Case t_list
				g\v[7]=value$
			
		End Select
		
		TGadgetUpdate(g)	
		
	Case t_knotwidth
		g\v[4]=value$
		TGadgetUpdate(g)

	Case t_knotheight
		g\v[5]=value$
		TGadgetUpdate(g)
		
	Case t_x
		TGadgetMove Handle(g),value,g\y
	Case t_y
		TGadgetMove Handle(g),g\x,value
	Case t_w
		TGadgetSize Handle(g),value,g\h
	Case t_h
		TGadgetSize Handle(g),g\w,value
	Case t_a
		TGadgetAlpha Handle(g),value
	Case t_r
		TGadgetColor Handle(g),value,g\g,g\b
	Case t_g
		TGadgetColor Handle(g),g\r,value,g\b
	Case t_b
		TGadgetColor Handle(g),g\r,g\g,value
	Case t_fonta
		TGadgetFontAlpha Handle(g),value
	Case t_fontr
		TGadgetFontColor Handle(g),value,g\fontg,g\fontb
	Case t_fontg
		TGadgetFontColor Handle(g),g\fontr,value,g\fontb
	Case t_fontb
		TGadgetFontColor Handle(g),g\fontr,g\fontg,value
	Case t_hide
		TGadgetHide Handle(g),0
	Case t_show
		TGadgetShow Handle(g),0,1
	Case t_parent
		g\parent=Object.tgadget(value)
		TGadgetMove Handle(g),g\x,g\y
	Case t_help
		g\help$=value$
		
	Case t_modal

		If value=True
		
			g\modal=1
		
			For gg.tgadget=Each tgadget
				If gg\lock=False
					gg\lock=True
					gg\modal=2
				EndIf
			Next
			
			TGadgetUnLock Handle(g),False
					
		Else
		
			For gg.tgadget=Each tgadget
				If gg\modal=2
					gg\lock=False
					gg\modal=0
				EndIf
			Next
			
			g\modal=0
		
		EndIf
		
End Select

End Function


Function TGadgetGet$(gadget,property=t_value)

g.tgadget=Object.tgadget(gadget)

Select property

	Case t_value
		Select g\t
			Case t_text
				Return g\txt$
			Case t_slider,t_hslider,t_vslider
				Return Float(g\v[2])+(Float(g\v[3])-Float(g\v[2]))*Float(g\v[0])
			Case t_image
				Return g\v[2]
			Default
				Return g\v[0]
		End Select
	Case t_text
		Return g\txt$		
	
	Case t_textpos
		Return g\txtpos
		
	Case t_lowlimit
		Select g\t
			Case t_integer,t_float
				Return g\v[5]
				
			Case t_slider,t_hslider,t_vslider
				Return g\v[2]
		End Select
		
	Case t_highlimit
			Select g\t
			Case t_integer,t_float
				Return g\v[6]
				
			Case t_slider,t_hslider,t_vslider
				Return g\v[3]
		End Select
		
	Case t_maxcharacters
		Return g\v[4]
	
	Case t_step
		Return g\v[7]
		
	Case t_decimals
		Return g\v[8]
		
	Case t_slidervert
		Return g\v[1]
		
	Case t_infront
		Return g=Last tgadget
		
	Case t_inback
		Return g=First tgadget
		
	Case t_alwaysinfront
		Return g\layermode=1
		
	Case t_alwaysinback
		Return g\layermode=2
		
	Case t_tabpage
		Return g\v[0]
		
	Case t_tabnumber
		Return g\v[1]
		
	Case t_tabheight
		Return g\v[2]

	Case t_listscroll
		
		If Int(g\v[4])>(g\part[2]\h-TGadgetBorderSize(g\t,0)*2)
			Return Float(g\v[3])/Float(Int(g\v[4])-(g\part[0]\h-TGadgetBorderSize(g\t,0)*2))
		EndIf
	
	Case t_list
		Return g\v[2]
				
	Case t_selected
		Return g\v[1]
		
	Case t_link
		Return Handle(g\link)
		
	Case t_windowbarheight
		Return g\v[1]
		
	Case t_windowflags
		Return g\v$[0]
	
	Case t_imageflags
		Select g\t
			Case t_image
				Return g\v[3]
					
			Case t_button
				Return g\v[2]
				
		End Select

	Case t_knotsize
		Select g\t
			
			Case t_slider,t_hslider,t_vslider
				Return g\v[4]
			
			Case t_list
				Return g\v[7]
			
		End Select
	
	Case t_knotwidth
		Return g\v[4]

	Case t_knotheight
		Return g\v[5]
		
	Case t_comboitems
		Return g\v[7]

	Case t_x
		Return g\x
	Case t_y
		Return g\y	
	Case t_w
		Return g\w
	Case t_h
		Return g\h
	Case t_a
		Return g\a
	Case t_r
		Return g\r
	Case t_g
		Return g\g
	Case t_b
		Return g\b
	Case t_fonta
		Return g\fonta
	Case t_fontr
		Return g\fontr
	Case t_fontg
		Return g\fontg
	Case t_fontb
		Return g\fontb
	Case t_hide
		Return g\hide=1
	Case t_show
		Return g\hide=0
	Case t_parent
		Return Handle(g\parent)
	Case t_help
		Return g\help$
	Case t_modal
		Return g\modal=1
		
		
End Select

End Function



Function TLabel(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_label,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Const t_titlebar=1
Const t_closebutton=2
Const t_movable=4,t_moveable=4
Const t_limitpos=8

Function TWindow(x=-1,y=-1,w=64,h=32,txt$="",flags=t_titlebar+t_movable,v2$="")
	If x=-1
		x=TScreenWidth/2-w/2
	EndIf
	If y=-1
		y=TScreenHeight/2-h/2
	EndIf
	Return TGadgetNew(t_window,parent,x,y,w,h,txt$,flags,v2$)
End Function

Function TButton(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_button,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TTab(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_tab,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TTabPage(parent,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_tabpage,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TCheckBox(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_checkbox,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TTextBox(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_textbox,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TInteger(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_integer,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TFloat(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_float,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TSlider(parent,x=0,y=0,w=64,h=32,txt$="",dir=0,v1$="0.5",v2$="")

	Select dir
		Case 0
			Return TGadgetNew(t_hslider,parent,x,y,w,h,txt$,v1$,v2$)
		Case 1
			Return TGadgetNew(t_vslider,parent,x,y,w,h,txt$,v1$,v2$)		
		Default
			Return TGadgetNew(t_slider,parent,x,y,w,h,txt$,v1$,v2$)			
	End Select
	
End Function

;Function THSlider(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
;	Return TGadgetNew(t_hslider,parent,x,y,w,h,txt$,v1$,v2$)
;End Function

;Function TVSlider(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
;	Return TGadgetNew(t_vslider,parent,x,y,w,h,txt$,v1$,v2$)
;End Function

Function TListBox(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_list,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TComboBox(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_combobox,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TRadio(parent,x=0,y=0)
	Return TGadgetNew(t_radio,parent,x,y,0,0,"")
End Function

Function TFrame(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_frame,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TImage(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_image,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TProgress(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_progress,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function T3d(parent,x=0,y=0,w=64,h=32,txt$="",v1$="",v2$="")
	Return TGadgetNew(t_3d,parent,x,y,w,h,txt$,v1$,v2$)
End Function

Function TMenu(parent,txt$="",w=64,v1$="",v2$="")
	w=TTextWidth(txt$)+TTextWidth("    ")
	g.tgadget=Object.tgadget(parent)
	If g<>Null
		If g\t=t_menu
			;g\userhide=1
			;g\hide=1
			If w<128
				w=128
			EndIf
		EndIf
	EndIf


	If txt$<>""

		Return TGadgetNew(t_menu,parent,x,y,w,TFontHeight*1.25,txt$,v1$,v2$)
	
	Else
	
		Return TGadgetNew(t_menu,parent,x,y,w,TFontHeight*0.25,txt$,v1$,v2$)
	
	EndIf
End Function

Function TFileRequest$(filepath$,txt$="",filter$="",x=-1,y=-1)

If TUIIsFullScreen=False

	Return TFileRequestWin$(filepath$,txt$,filter$)

EndIf

If FileType(filepath$)=2
	If Right$(filepath$,1)<>"\" Then filepath$=filepath$+"\"
EndIf

list=TListNew()

file$=TFileGetFile$(filepath$)
path$=TFileGetDir$(filepath$)

If path$=""

	path$=CurrentDir()

EndIf

If txt$=""
	txt$="Select a file..."
EndIf

window=TWindow( 0 , 0 , 360 , 296 , txt$, 1+2+4)
	
	filelist=TListBox( window , 8 , 16 , 272 , 192 , "Files:" , list)
		
	parent=TButton( window , 288 , 16 , 64 , 32 , "Parent" )
		
	drives=TButton( window , 288 , 64 , 64 , 32 , "Drives" )
		
	okbutton=TButton( window , 8 , 240 , 104 , 32 , "Ok" )
		
	filename=TTextBox( window , 8 , 216 , 272 , 16 )
	
		TGadgetSet filename,t_value,file$
		
	cancel=TButton( window , 248 , 240 , 104 , 32 , "Cancel" )
		
	filtergad=TTextBox( window , 288 , 112 , 64 , 16 , "Filter:" )
		TGadgetSet filtergad,t_textpos,t_above
		TGadgetSet filtergad,t_value,filter$
		
	preview=TLabel(window,288,140,64,16,"Preview:")
		
	image=TButton(window,288,160,64,64,"")
	
	Select Lower$(Right$(file$,3))
		Case "bmp","jpg"
			TGadgetSet image,t_value,path$+file$
			TGadgetShow image
			TGadgetSet image,t_imageflags,1
			TGadgetShow preview
		Case "png","tga"
			TGadgetSet image,t_value,path$+file$
			TGadgetShow image
			TGadgetSet image,t_imageflags,1+2
			TGadgetShow preview
		Default 	
			TGadgetHide image	
			TGadgetSet image,t_value,""
			TGadgetHide preview
	End Select
		

If x=-1
	x=TScreenWidth/2-360/2
EndIf

If y=-1
	y=TScreenHeight/2-296/2
EndIf

TGadgetMove window,x,y

TFileRequestDir(list,path$,filter$)

ll.TList=Object.TList(list)

For i.titem=Each titem
	If i\l=ll
		If Lower$(i\d$)=Lower$(file$)
			TGadgetSet filelist,t_selected,Handle(i)
			Exit
		EndIf
	EndIf
Next

TGadgetSet window,t_modal,True

quit=False
Repeat
Cls

TUI

Select TEvent(t_release)

	Case filelist
	
		item=TGadgetGet(filelist,t_selected)
			If item<>0
				ge$=TItemGet(item)
				If ge$<>""
					If Left$(ge$,3)=" * "
						f$=Right$(ge$,Len(ge$)-3)
						TFileRequestDir(list,path$+f$,filter$)
						path$=path$+f$+"\"
						TGadgetSet filelist,t_value,0
					Else
						file$=ge$
						TGadgetSet filename,t_value,file$
					EndIf
				EndIf
			EndIf
			
		Select Lower$(Right$(file$,3))
		Case "bmp","jpg"
			TGadgetSet image,t_value,path$+file$
			TGadgetShow image
			TGadgetSet image,t_imageflags,1
			TGadgetShow preview
		Case "png","tga"
			TGadgetSet image,t_value,path$+file$
			TGadgetShow image
			TGadgetSet image,t_imageflags,1+2
			TGadgetShow preview
		Default 	
			TGadgetHide image	
			TGadgetSet image,t_value,""
			TGadgetHide preview
		End Select

		If FileType(path$+file)<>1
		
			TGadgetHide image	
			TGadgetSet image,t_value,""
			TGadgetHide preview
		
		EndIf
		

End Select

Select TEvent()

	Case okbutton
		quit=1
		
	Case cancel
		quit=2
	


	
	Case parent
			
		If Len(path$)>6
			n=0
			Repeat
				n=n+1
			Until Mid$(path$,Len(path$)-n,1)="\"
			
			path$=Left$(path$,Len(path$)-n)
			TFileRequestDir(list,path$,filter$)

			TGadgetSet filelist,t_value,0

		EndIf
		
	Case filtergad
	
		;TFileRequestDir(list,path$,filter$)
		
	Case drives
		
		TListClear list
		For drive=Asc("A") To Asc("Z")  
			dri$=Chr(drive)+":\"
			If ReadDir(dri$)
				TItemNew list," * "+Left$(dri$,2)
			EndIf
		Next
		path$=""
		
	Case image	
	
		Select Lower$(Right$(file$,3))
			Case "bmp","jpg"
				TFileRequestPreview(path$+file$,1,"Image preview")
			Case "png","tga"
				TFileRequestPreview(path$+file$,1+2,"Image preview")
		End Select
		
		
		
					
End Select

Select TEvent(t_change) ;t_active)

	Case filename
	
		file$=TGadgetGet(filename)
	
		For i.titem=Each titem
		If i\l=ll
			If Lower$(i\d$)=Lower$(file$)
				TGadgetSet filelist,t_selected,Handle(i)
				Exit
			EndIf
		EndIf
		Next
		
		Select Lower$(Right$(file$,3))
			Case "bmp","jpg"
				TGadgetSet image,t_value,path$+file$
				TGadgetShow image
				TGadgetSet image,t_imageflags,1
				TGadgetShow preview
			Case "png","tga"
				TGadgetSet image,t_value,path$+file$
				TGadgetShow image
				TGadgetSet image,t_imageflags,1+2
				TGadgetShow preview
			Default 	

		End Select
		If FileType(path$+file)<>1
		
			TGadgetHide image	
			TGadgetSet image,t_value,""
			TGadgetHide preview
		
		EndIf
		
	Case filtergad
		filter$=TGadgetGet(filtergad)
		TFileRequestDir(list,path$,filter$)
		
End Select

If KeyDown(1)
quit=-1
EndIf
If quit=-1
If KeyDown(1)=False
quit=2
EndIf
EndIf

If TGadgetGet(window,t_closed)
quit=2
EndIf

RenderWorld

Flip

Until quit>0 

TGadgetSet window,t_modal,False

TGadgetDelete window

TListDelete list

If quit=1
Return path$+file$
EndIf

End Function

Type TFileRequestFilter

Field d$

End Type

Function TFileRequestDir(list,path$,filter$="",delimiter$="|")

TListClear list

If filter$<>""
	
	start=1
	pos=1
	filter$=Lower$(filter)
	Repeat
		pos=Instr(filter,delimiter$,start)
		If pos>1
			If pos<>start
				s$=Mid$( filter$,start,pos-start)
				start=pos+1
				tt.TFileRequestFilter=New TFileRequestFilter
				tt\d = s$
			EndIf
		Else
			pos=Len(filter$)+1
			s$=Mid$(filter$,start,pos-start)
				tt.TFileRequestFilter=New TFileRequestFilter
				tt\d = s$
			Exit		
		EndIf
	Forever
	
EndIf


	If Right$(path$,1)<>"\" Then path$=path$+"\"

	dir=ReadDir(path$)
	
	If dir<>0
	
		Repeat
	
			f$=NextFile$(dir)
			If f$="" Then Exit
			If f$<>"." And f$<>".."
				If FileType(path$+f$)=1
					If First TFileRequestFilter<>Null
						test=False
						For tt.TFileRequestFilter=Each TFileRequestFilter
							find=Instr(f$,tt\d$)
							If find>0
								test=True
								Exit
							EndIf
						Next
						If test=True
							TItemNew list,f$,False
						EndIf
					Else
						TItemNew list,f$,False				
					EndIf
				Else
					TItemNew list," * "+f$,False
				EndIf
				
			EndIf
				
		Forever
		
	EndIf
	
	TListSort list
	
	Delete Each TFileRequestFilter

End Function

Function TFileGetDir$(path$) 
For a = Len(path$) To 1 Step -1 
byte$ = Mid(path$,a,1) 
If byte$="\" 
Return Left(path$,a) 
EndIf 
Next 
Return
End Function 

Function TFileGetFile$(path$) 
For a = Len(path$) To 1 Step -1 
byte$ = Mid(path$,a,1) 
If byte$="\" 
Return Right(path$,Len(path$)-a) 
EndIf 
Next 
Return path$ 
End Function

Function TFileRequestPreview(file$,flags=1+2,txt$="",button$="Ok")

If FileType(file$)<>1

	Return

EndIf



i=LoadImage(file$)
If i=0
	Return
EndIf
wid=ImageWidth(i)
hei=ImageHeight(i)
FreeImage i
owid=wid
ohei=hei

If wid>TScreenWidth*0.9
	wid=TScreenWidth*0.9
EndIf

If hei>(TScreenHeight-96)*0.9
	hei=(TScreenHeight-96)*0.9
EndIf

wwid=wid+16
whei=hei+16+64+8
If wwid<128
	wwid=128
EndIf
If whei<128
	whei=128
EndIf


w=TWindow(TScreenWidth/2-wwid/2,TScreenHeight/2-whei/2,wwid,whei,txt$,1+2+4)

TImage(w,wwid/2-wid/2,(whei-64+8)/2-hei/2,wid,hei,TFileGetFile$(file$)+"  "+Str(owid)+"x"+Str(ohei),file$,flags)

ok=TButton(w,wwid/2-80/2,whei-48-8,80,32,button$)


TGadgetSet w,t_modal,True

Repeat
Cls

TUI

If KeyDown(1)
quit=-1
EndIf
If quit=-1
If KeyDown(1)=False
quit=2
EndIf
EndIf

If TEvent()=ok Or TGadgetGet(w,t_closed)

quit=1

EndIf



RenderWorld

Flip

Until quit>0 

TGadgetSet w,t_modal,False

TGadgetDelete w

End Function

Function TFileRequestWin$(path$,title$="",filter$="",flags=256+4+8)
RenderWorld
Flip

	If TFileGetFile$(path$)=""
		
		path$=path$+"-"
	
	EndIf

	nextOffset%=0 
	theBank=CreateBank(76)
	lStructSize=76
	PokeInt theBank,nextOffset%,lStructSize
	nextOffset%=nextOffset%+4 
		
	hwndOwner=0
	PokeInt theBank,nextOffset%,hwndOwner
	nextOffset%=nextOffset%+4 
		
	hInstance=0
	PokeInt theBank,nextOffset%,hInstance
	nextOffset%=nextOffset%+4 

	If filter$ = "" Then
		filter$ = "All Files (*.*)" + Chr$(0) + "*.*" + Chr$(0)+ Chr$(0)
	Else	
		;filter$ = Replace(filter$,Chr(0),Chr(1))
		filter$=Replace$(filter$,".","*.")
		pos=0
		While pos<=Len(filter$)
			pos=pos+1
			If Mid$(filter$,pos,1)="|"
				lef$=Left$(filter$,pos-1)
				rig$=Right(filter$,Len(filter$)-pos)
				filter$=lef+Chr(0)+rig$+Chr(0)
			EndIf
		Wend
		
		filter$ = filter$ + Chr$(0)	
	End If
	lpstrFilter_ = CreateBank(Len(filter$)) 
	TFileRequestWin3(filter$,lpstrFilter_)
	PokeInt theBank,nextOffset%,TFileRequestWin2(lpstrFilter_)
	nextOffset%=nextOffset%+4
		
	lpstrCustomFilter=0
	PokeInt theBank,nextOffset%,lpstrCustomFilter
	nextOffset%=nextOffset%+4 
	
	nMaxCustFilter=0
	PokeInt theBank,nextOffset%,nMaxCustFilter
	nextOffset%=nextOffset%+4 
	
	nFilterIndex=0
	PokeInt theBank,nextOffset%,nFilterIndex
	nextOffset%=nextOffset%+4 

	lpstrFile_ = CreateBank(255) 
	
	
	TFileRequestWin3(path$+Chr(0),lpstrFile_)
	
	
	
	PokeInt theBank,nextOffset%,TFileRequestWin2(lpstrFile_)
	nextOffset%=nextOffset%+4
	
	nMaxFile=255
	PokeInt theBank,nextOffset%,nMaxFile
	nextOffset%=nextOffset%+4 
	
	lpstrFileTitle$=String$ (" ", 254)
	lpstrFileTitle_ = CreateBank(Len(lpstrFileTitle$)) 
	TFileRequestWin3(lpstrFileTitle$,lpstrFileTitle_)
	PokeInt theBank,nextOffset%,TFileRequestWin2(lpstrFileTitle_)
	nextOffset%=nextOffset%+4  
	
	nMaxFileTitle=255
	PokeInt theBank,nextOffset%,nMaxFileTitle
	nextOffset%=nextOffset%+4 
	
	lpstrInitialDir$=" "+Chr$(0)
	lpstrInitialDir_ = CreateBank(Len(lpstrInitialDir$)) 
	TFileRequestWin3(lpstrInitialDir$,lpstrInitialDir_)
	PokeInt theBank,nextOffset%,TFileRequestWin2(lpstrInitialDir_)
	nextOffset%=nextOffset%+4 
	
	If title$="" Then
		title$="-"+Chr$(0) 
	Else
		title$ = title$ + Chr$(0)
	End If	
	lpstrTitle_ = CreateBank(Len(title$)) 
	TFileRequestWin3(title$,lpstrTitle_)	
	PokeInt theBank,nextOffset%,TFileRequestWin2(lpstrTitle_)
	nextOffset%=nextOffset%+4 

	PokeInt theBank,nextOffset%,flags
	nextOffset%=nextOffset%+4 
	
	nFileOffset=0
	PokeShort theBank,nextOffset%,nFileOffset
	nextOffset%=nextOffset%+2
	
	nFileExtension=0
	PokeShort theBank,nextOffset%,nFileExtension
	nextOffset%=nextOffset%+2
	
	lpstrDefExt=0
	PokeInt theBank,nextOffset%,lpstrDefExt
	nextOffset%=nextOffset%+4 
	
	lCustData=0
	PokeInt theBank,nextOffset%,lCustData
	nextOffset%=nextOffset%+4 
	
	lpfnHook=0
	PokeInt theBank,nextOffset%,lpfnHook
	nextOffset%=nextOffset%+4 

	lpTemplateName$="dgfergherh"+Chr$(0)
	lpTemplateName_ = CreateBank(Len(lpTemplateName$)) 
	TFileRequestWin3(lpTemplateName$,lpTemplateName_)
	PokeInt theBank,nextOffset%,TFileRequestWin2(lpTemplateName_)

	If T_GetOpenFileName (theBank) Then
		path$ = TFileRequestWin4$(lpstrFile_)
	Else
		path$ =""
	End If
	FreeBank theBank
	FreeBank lpstrFilter_
	FreeBank lpstrFile_
	FreeBank lpstrFileTitle_
	FreeBank lpstrInitialDir_
	FreeBank lpstrTitle_
	FreeBank lpTemplateName_
	Return path$
End Function

Function TFileRequestWin2(Bank)
	Local Address = CreateBank(4) 
	T_RtlMoveMemory(Address,Bank+4,4) 
	Return PeekInt(Address,0) 
End Function

Function TFileRequestWin3(s$,bankhandle)
	pos=1
	Repeat
		PokeByte(bankhandle,pos2,Asc(Mid(s$,pos,Len(s$))))
		pos=pos+1
		pos2=pos2+1
	Until pos=Len(s$)+1
End Function

Function TFileRequestWin4$(bankhandle)
	Repeat
		s$=s$+Chr(PeekByte(bankhandle,pos))
		pos=pos+1
	Until pos=BankSize(bankhandle)
	s$=Replace$(s$,Chr(0)," ")
	Return s$
End Function





Function TMessage(mes$,top$="",but1$="Ok",but2$="",but3$="")

wwid=200

num=1
If but2$<>""
	num=2
EndIf
If but3$<>""
	num=3
	wwid=300
EndIf

tw=TTextWidth(mes$)
If tw>wwid-20

	wwid=tw+20
	
EndIf


x=TScreenWidth/2-wwid/2
y=TScreenHeight/2-150/2

window=TWindow(x,y,wwid,150,top$,1+2+4)

	label=TLabel(window,wwid/2-(wwid-20)/2,10,wwid-20,16,mes$)

Local button[2]

	wid=64
	ww=wwid/(num+1)
	y=150-45-TFontHeight
	x=ww-wid/2
	For n=0 To (num-1)
		Select n
			Case 0
				button[n]=TButton(window,x+ww*n,y,wid,32,but1$)
			Case 1
				button[n]=TButton(window,x+ww*n,y,wid,32,but2$)
			Case 2
				button[n]=TButton(window,x+ww*n,y,wid,32,but3$)
		End Select
				
	Next
quit=0	
If KeyDown(1)
quit=-2
EndIf	

TGadgetSet window,t_modal,True

Repeat
Cls

TUI

ev=TEvent()
For n=0 To num-1
If ev=button[n]
quit=n+1
EndIf
Next
If quit=-2
If KeyDown(1)=False
quit=0
EndIf
EndIf
If quit=0
If KeyDown(1)
quit=-1
EndIf
EndIf
If quit=-1
If KeyDown(1)=False
quit=num
EndIf
EndIf

If TGadgetGet(window,t_closed)
quit=num
EndIf

RenderWorld

Flip

Until quit>0 

TGadgetSet window,t_modal,False

TGadgetDelete window

Return quit
End Function


Function TInputMessage$(mes$,top$="",inpu$="",but1$="Ok",but2$="Cancel")

wwid=200

tw=TTextWidth(mes$)
If tw>wwid-20

	wwid=tw+20
	
EndIf


x=TScreenWidth/2-wwid/2
y=TScreenHeight/2-150/2

window=TWindow(x,y,wwid,150,top$,1+2+4)

	label=TLabel(window,wwid/2-(wwid-20)/2,10,wwid-20,16,mes$)

Local button[1]
	
	num=2
	wid=64
	ww=wwid/(num+1)
	y=150-45-TFontHeight
	x=ww-wid/2
	For n=0 To (num-1)
		Select n
			Case 0
				button[n]=TButton(window,x+ww*n,y,wid,32,but1$)
			Case 1
				button[n]=TButton(window,x+ww*n,y,wid,32,but2$)
			Case 2
				button[n]=TButton(window,x+ww*n,y,wid,32,but3$)
		End Select
				
	Next
	
	inp=TTextBox(window,wwid/2-(wwid-50)/2,40,wwid-50,TfontHeight*1.33,"",inpu$)
;	tgadgetset inp,t_value,inpu$
	
quit=0	
If KeyDown(1)
quit=-2
EndIf	

TGadgetSet window,t_modal,True

Repeat
Cls

TUI

ev=TEvent()
For n=0 To num-1
If ev=button[n]
quit=n+1
EndIf
Next
If quit=-2
If KeyDown(1)=False
quit=0
EndIf
EndIf
If quit=0
If KeyDown(1)
quit=-1
EndIf
EndIf
If quit=-1
If KeyDown(1)=False
quit=num
EndIf
EndIf

If TGadgetGet(window,t_closed)
quit=num
EndIf

inpu$=TGadgetGet(inp)

RenderWorld

Flip

Until quit>0 

TGadgetSet window,t_modal,False

TGadgetDelete window

For g.tgadget=Each tgadget
	TGadgetUnLock Handle(g)
Next

If quit=1
	Return inpu$
EndIf
End Function


Const t_gadgetevent=1

Const t_over=0
Const t_down=1
Const t_release=2,t_released=2
Const t_active=3,t_activated=3
Const t_deactive=4,t_deactivated=4,t_deactivate=4
Const t_change=5,t_changed=5

Const t_screenchange=100,t_windowsize=100



Function TEvent( event=t_change )
	
	Select event
	
		Case 0,1,2,3,4,5
			If TGadgetState(event)<>Null
				Return Handle(TGadgetstate(event)\g)
			EndIf
		Case t_windowsize
			Return TScreenWidth<>TScreenLastWidth Or TScreenHeight<>TScreenLastHeight
	
	End Select
	
End Function

Type tlist

	;Field flags

End Type


Function TListNew()
l.tlist=New tlist

Return Handle(l)
End Function

Function TListDelete(list)
l.tlist=Object.tlist(list)

TListClear list

For ln.tlistnode=Each tlistnode
	If ln\l=l
		Delete ln
	EndIf
Next

For g.tgadget=Each tgadget
	If g\t=t_list Or g\t=t_combobox
		ll.tlist=Object.tlist(g\v[2])
		If ll=l
			g\v[2]=0
			If g\t=t_combobox
				g\parth[3]=-0
			EndIf
		EndIf
	EndIf
Next

Delete l
End Function

Function TListClear(list)
l.tlist=Object.tlist(list)

For i.titem=Each titem
	If i\l=l
		Delete i
	EndIf
Next

For g.tgadget=Each tgadget
	If g\t=t_list
		ll.tlist=Object.tlist(g\v[2])
		If ll=l
			g\v[1]=0
			TGadgetSet Handle(g),t_value,0
			TGadgetRefresh(g)
		EndIf
	ElseIf g\t=t_combobox
	
		ll.tlist=Object.tlist(g\v[2])
		If ll=l
			g\v[9]=""
			g\v[1]=0
			TGadgetSet Handle(g),t_value,0
			TGadgetRefresh(g)
		EndIf
	
	EndIf

Next

End Function

Function TListSort(list)
l.TList=Object.TList(list)

	    b.titem=First titem
		While b<>Null
			If b\l<>l
				b=After b
			Else
				Exit
			EndIf
		Wend
		If b<>Null
	    flag=True
	    While flag
	        flag=False
			
	        bb.titem=Last titem
			While bb<>Null
				If bb\l<>l
					bb=Before bb
				Else
					Exit
				EndIf
			Wend
			If bb<>Null
	        While bb<>b
			    bbb.titem=Before bb
				While bbb<>Null
					If bbb\l<>l
						bbb=Before bbb
					Else
						Exit
					EndIf
				Wend
	            If bbb=Null Exit
				If Lower$(bb\d$)<Lower$(bbb\d$)
				    Insert bbb After bb
	                flag=True
	            Else
	                bb=bbb
	            EndIf
				
			Wend
			b=After bb
			EndIf
			        
	    Wend
		EndIf
For g.tgadget=Each tgadget
	If g\t=t_list Or g\t=t_combobox
		ll.TList=Object.TList(g\v[2])
		If ll=l
			TGadgetRefresh(g)
		EndIf
	EndIf
Next

End Function







Global TListStringCount
Global TListStringMove


Type tlistnode

Field l.tlist

Field i.titem

Field x,y,w,h

Field num

End Type

Function TListString$(l.tlist,w,s$="")

For n.tlistnode=Each tlistnode
	If n\l=l
		Delete n
	EndIf
Next

TListStringCount=0

For i.titem=Each titem
	If i\l=l
		If i\p=Null
			TListStringMove=-3
				
			n.tlistnode=New tlistnode
			n\l=l
			n\i=i
			n\x=0
			n\y=TListStringCount*TFontHeight
			n\w=w
			n\h=TFontHeight
			
			TListStringCount=TListStringCount+1
					
			If i\subs=0	
			
				s$=s$+i\d$+Chr$(10)				
			
			Else	
			
				TListStringMove=TListStringMove+3
					
				If i\unfold=0
				
					s$=s$+" + "+i\d$+Chr$(10)
					
				Else
					
					s$=s$+" - "+i\d$+Chr$(10)+TListStringSub$(i)
					
				EndIf
				
			EndIf
		EndIf
	EndIf
Next
Return s$
End Function

Function TListStringSub$(i.titem,s$="")

For ii.titem=Each titem
	If ii\p=i
	

		
		n.tlistnode=New tlistnode
		n\l=ii\l
		n\i=ii
		n\x=TListStringMove*12
		n\y=TListStringCount*TFontHeight
		n\w=w
		n\h=TFontHeight
		
		TListStringCount=TListStringCount+1

		num=TListStringMove
		If ii\subs=0	
		
			s$=s$+String(" ",TListStringMove)+" | "+ii\d$+Chr$(10)				
		
		Else	
			
			TListStringMove=TListStringMove+3
			
			If ii\unfold=0
			
				s$=s$+String(" ",TListStringMove)+" + "+ii\d$+Chr$(10)
				
			Else
			
				
				s$=s$+String(" ",TListStringMove)+" - "+ii\d$+Chr$(10)+TListStringSub$(ii)
				
			EndIf
			
		EndIf
		
		TListStringMove=num
		
	EndIf
Next

Return s$
End Function



Type titem

Field l.tlist ;list

Field p.titem ;parent
 
Field d$ ;data, usually text

Field unfold ;unfolded ?

Field subs ;true if item has sub items

Field num ;number in list

End Type

Function TItemNew(parent,d$="",upd=1)

i.titem=New titem

i\l=Object.tlist(parent)

If i\l=Null

	i\p=Object.titem(parent)
	i\l=i\p\l
	i\p\subs=1

EndIf
	
i\d=d
n=0
For ii.titem=Each titem
If ii\l=i\l
n=n+1
ii\num=n
EndIf
Next

If upd=1
	For g.tgadget=Each tgadget
		If g\t=t_list Or g\t=t_combobox
			ll.TList=Object.TList(g\v[2])
			If ll=i\l
				TGadgetRefresh(g)
			EndIf
		EndIf
	Next
EndIf

Return Handle(i)
End Function

Function TItemGet$(item)
	i.titem=Object.titem(item)
	If i<>Null
	Return i\d
	EndIf
End Function

Function TItemSet(item,d$,upd=1)
	i.titem=Object.titem(item)
	If i<>Null
	i\d=d
	EndIf
	If upd=1
	For g.tgadget=Each tgadget
		If g\t=t_list Or g\t=t_combobox
			ll.TList=Object.TList(g\v[2])
			If ll=i\l
				TGadgetRefresh(g)
			EndIf
		EndIf
	Next
	EndIf
	
End Function

Function TItemDelete(item,rec=0)

i.titem=Object.titem(item)

For ii.titem=Each titem
	If ii\p=i
		TItemDelete(Handle(ii),1)
	EndIf
Next

l.tlist=i\l
ip.titem=i\p

Delete i

If ip<>Null
	sub=ip\subs
	ip\subs=0
	For iii.titem=Each titem
		If iii\p=ip
			ip\subs=1
			Exit
		EndIf
	Next
	If sub<>ip\subs
		ip\unfold=0
	EndIf
EndIf

If rec=0
For g.tgadget=Each tgadget
	If g\t=t_list Or g\t=t_combobox
		ll.tlist=Object.tlist(g\v[2])
		If ll=l
			g\v[9]=""
			If g\v[1]=item
				g\v[1]=0
				TGadgetSet Handle(g),t_value,0
			EndIf
			TGadgetRefresh(g)
		EndIf
	EndIf
Next
EndIf


End Function

Function TItemUnFold(item,unfold=False)

	i.titem=Object.titem(item)

	i\unfold=unfold

End Function

Function TItemUnFoldToItem(i.titem);,unfold=False)

If i\p<>Null
	i\p\unfold=1
	TItemUnFoldToItem(i\p)
EndIf

End Function


Global TMousex,TMousey,TMouseLastx,TMouseLasty,TMouseDownX,TMouseDownY,TMouseDx,TMouseDy
Global TScroll,TScrollDir,TScrollRemember
Global TGadgetTimer

Global TGadgetCursorBlinkTimer
Const TGadgetCursorBlinkTime=800

Const TGadgetTextTime=100
Const TGadgetTextScrollTime=50
Global TGadgetIntegerTimeEvent
Const TGadgetIntegerTime=500
Global TGadgetIntegerMouseX,TGadgetIntegerMouseY
Global TGadgetIntegerValue$

Global TGadgetMenuHandle.tgadget
Global TGadgetMenuHandle2.tgadget


Global TUIIdleTimer
Global TUIIsIdle
Global TIdleMousex,TIdleMousey,TIdleMouseLastx,TIdleMouseLasty


Function TUI(upddelay=1,idledelay=200)

If TWindowResizable=True

	TScreenLastWidth=TScreenWidth
	TScreenLastHeight=TScreenHeight

	T_GetClientRect(TWindowHandle,TWindowSize)
	TScreenWidth = TWindowSize\w
	TScreenHeight = TWindowSize\h
	
	If TScreenWidth<>TScreenLastWidth Or TScreenHeight<>TScreenLastHeight
	
		Viewport 0,0,TScreenWidth,TScreenHeight
	
	EndIf
	
	T_GetCursorPos(TWindowMouse)
	T_ScreenToClient(TWindowHandle,TWindowMouse)

	TMousex=TWindowMouse\x
	TMousey=TWindowMouse\y
	
Else
	
	TMousex=MouseX()
	TMousey=MouseY()
	
EndIf

TIdleMousex=MouseX()
TIdleMousey=MouseY()


milli=MilliSecs()

If TPointer<>0

	PositionEntity TPointer,TMousex-0.5,TMousey-0.5,0

EndIf

	TScroll=MouseZ()
	
	TScrollDir=0
	
	If TScroll>TScrollRemember
	
		TScrollDir=1
	
	ElseIf TScroll<TScrollRemember
	
		TScrollDir=-1
	
	EndIf
	
	TScrollRemember=TScroll

	TGadgetState(2)=Null
	TGadgetState(4)=Null
	TGadgetState(5)=Null	
	
	For n=0 To 0 ;2
	
		TMouseButtonState(n,1)=0
		If TMouseButtonState(n,0)=1
			If MouseDown(1+n)=False
				TMouseButtonState(n,1)=1
			EndIf
		EndIf
		
		
		If TMouseButtonState(n,2)=0
		
			If MouseDown(1+n)=1
			
			 	TMouseButtonState(n,2)=1
				TMouseDownX=TMouseX
				TMouseDownY=TMouseY
					
			EndIf
			
		Else
			
			If TMouseButtonState(n,2)=1
			
				TMouseButtonState(n,2)=2
			
			Else
			
				If MouseDown(1+n)=False
				
				TMouseButtonState(n,2)=0
			
				EndIf
			
			EndIf
		
		EndIf
			
		TMouseButtonState(n,0)=MouseDown(1+n)
		
	Next
	
If milli>TUIIdleTimer

	TUIIdleTimer=milli+TUIIdleTime
	
	TUIIsIdle=True
	
EndIf

If TIdleMouseX<>TIdleMouseLastx Or TIdleMouseY<>TIdleMouseLasty

	TUIIdleTimer=milli+TUIIdleTime
	TUIIsIdle=False

EndIf

If TMouseX<>TMouseLastX Or TMouseY<>TMouseLastY



g.tgadget=First tgadget
TGadgetState(0)=Null

While g<>Null
	If g\hide=0
		
			For n=TGadgetCount(g\t) To 0 Step -1
		
				If TGadgetInteract(g\t,n)>0
					If TMouseX>=g\part[n]\x
						If TMouseY>=g\part[n]\y
							If TMouseX<=g\part[n]\x+g\part[n]\w
								If TMouseY<=g\part[n]\y+g\part[n]\h
							
									TGadgetState(0)=g\part[n]
									
									Exit
								EndIf
							EndIf
						EndIf
					EndIf
				EndIf
				
			Next
	EndIf

g=After g

Wend

TGadgetHelpTimer=milli+TGadgetHelpDelay

If TGadgetHelpEntity<>0

	If TGadgetState(0)<>TGadgetHelpPart
		FreeEntity TGadgetHelpEntity
		TGadgetHelpEntity=0
	EndIf
	
EndIf

EndIf

If TGadgetHelpEntity=0
	If milli>TGadgetHelpTimer
	
	TGadgetHelpPart=TGadgetState(0)
	
	If TGadgetHelpPart<>Null
		If TGadgetHelpPart\g\lock=False
			If TGadgetHelpPart\g\help$<>""
				w=TTextWidth(TGadgetHelpPart\g\help$)+2
				h=TFontHeight+2
				TGadgetHelpEntity=CreateMesh(TPivot)
					EntityFX TGadgetHelpEntity,1+8
					surf=CreateSurface(TGadgetHelpEntity)
					AddVertex surf,0,0,0
					AddVertex surf,w,0,0
					AddVertex surf,w,h,0
					AddVertex surf,0,h,0
					AddTriangle surf,0,1,2
					AddTriangle surf,0,2,3
			
				EntityOrder TGadgetHelpEntity,TRedrawOrder
				ent=TText(1,1,TGadgetHelpPart\g\help$)
				EntityColor ent,0,0,0
				EntityOrder ent,TRedrawOrder-2
				EntityParent ent,TGadgetHelpEntity
				PositionEntity TGadgetHelpEntity,-0.5+TMousex,-0.5+TMousey+24,0
				
			EndIf
		EndIf
	EndIf
	
	EndIf
EndIf

TMouseLastx=TMousex
TMouseLasty=TMousey
TIdleMouseLastx=TIdleMousex
TIdleMouseLasty=TIdleMousey

;TMouseButtonState(button#,0=down , 1=released, 2=click)
;TGadgetState(0=over, 1=down, 2=release, 3=active, 4=deactive)
					

If TMouseButtonState(0,2)=1
	TGadgetState(1)=TGadgetState(0)
	;TGadgetState(3)=TGadgetState(0)
	If TGadgetState(1)<>Null

		TMouseDx=TMouseDownX-TGadgetState(1)\x
		TMouseDy=TMouseDownY-TGadgetState(1)\y
		If TGadgetState(1)\g\lock=1
			TGadgetState(1)=Null
		EndIf	
		
	EndIf
ElseIf TMouseButtonState(0,1)=1				
	If TGadgetState(1)=TGadgetState(0)
		TGadgetState(2)=TGadgetState(1)
	EndIf
	TGadgetState(1)=Null
EndIf

If TMouseButtonState(0,1)=1
	If TGadgetState(2)<>TGadgetState(3)
		TGadgetState(4)=TGadgetState(3)
	EndIf

	TGadgetState(3)=TGadgetState(2)
EndIf


If tgadgetstate(1)<>tgadgetstatelast(1)

	If tgadgetstate(1)<>Null
		If TGadgetInteract(tgadgetstate(1)\g\t,tgadgetstate(1)\n)=3
			TGadgetPartState(TGadgetState(1),1)
		EndIf
	EndIf		
	
	If tgadgetstatelast(1)<>Null
		If TGadgetInteract(tgadgetstatelast(1)\g\t,tgadgetstatelast(1)\n)=3
			TGadgetPartState(TGadgetStateLast(1),0)
		EndIf
	EndIf

EndIf

If tgadgetstate(3)<>tgadgetstatelast(3)

	If tgadgetstate(3)<>Null
		If TGadgetInteract(tgadgetstate(3)\g\t,tgadgetstate(3)\n)=1
			TGadgetPartState(TGadgetState(3),1)
		EndIf
	EndIf		
	
	If tgadgetstatelast(3)<>Null
		If TGadgetInteract(tgadgetstatelast(3)\g\t,tgadgetstatelast(3)\n)=1
			TGadgetPartState(TGadgetStateLast(3),0)
		EndIf
	EndIf

EndIf

If TGadgetState(1)<>Null

Select TGadgetState(1)\g\t

	Case t_window
		If TGadgetPartType(t_window,TGadgetState(1)\n)<>t_windowclose
		If TMouseButtonState(0,2)=1
			TGadgetSet Handle(TGadgetState(1)\g),t_infront
		EndIf

		For g.tgadget=Each tgadget
			If g\t=t_window
				TGadgetPartState(g\part[0],0)
				TGadgetPartState(g\part[1],0)
			EndIf
		Next
	
		TGadgetPartState(TGadgetState(1)\g\part[0],1)
		TGadgetPartState(TGadgetState(1)\g\part[1],1)
		
		If Int(TGadgetState(1)\g\v[0]) And 4
			
			TGadgetMove Handle(TGadgetState(1)\g),TMouseX-TMouseDx,TMouseY-TMouseDy
			
			If Int(TGadgetState(1)\g\v[0]) And 8
			
				If TGadgetState(1)\g\x<0
					TGadgetMove Handle(TGadgetState(1)\g),0,TGadgetState(1)\g\y
				EndIf
				
				If TGadgetState(1)\g\y<0
					TGadgetMove Handle(TGadgetState(1)\g),TGadgetState(1)\g\x,0
				EndIf
						
				If TGadgetState(1)\g\x+TGadgetState(1)\g\w>TScreenWidth
					TGadgetMove Handle(TGadgetState(1)\g),TScreenWidth-TGadgetState(1)\g\w,TGadgetState(1)\g\y
				EndIf
				
				If TGadgetState(1)\g\y+TGadgetState(1)\g\h>TScreenHeight
					TGadgetMove Handle(TGadgetState(1)\g),TGadgetState(1)\g\x,TScreenHeight-TGadgetState(1)\g\h
				EndIf	
				
			EndIf
			
		EndIf
	
	;	Select TGadgetPartType(t_window,TGadgetState(1)\n)

	;		Case t_window
			
			
	;		Case t_windowbar
	;			TGadgetMove Handle(TGadgetState(1)\g),TMouseX-TMouseDx,TMouseY-TMouseDy


	;	End Select
		EndIf
	
	Case t_tabpage
		TGadgetState(3)=Null
		TGadgetState(2)=Null
		TGadgetState(4)=Null
		
		TGadgetSet Handle(TGadgetState(1)\g\parent),t_tabpage,Handle(TGadgetState(1)\g)
		
	Case t_textbox
	
		FlushKeys
		
		TGadgetState(1)\g\v[3]=Int(Len(TGadgetState(1)\g\v[0]))
		
		disti=TTextWidth(TGadgetState(1)\g\v[0])
		
		If disti>TGadgetState(1)\g\part[0]\w-TGadgetBorderSize(TGadgetState(1)\g\t,0)*2
		
			TGadgetState(1)\g\v[1]=disti-TGadgetState(1)\g\w+TGadgetBorderSize(TGadgetState(1)\g\t,0)*4 ;TGadgetState(1)\g\w*0.8
			TGadgetRedraw()
			
			TGadgetRefresh(TGadgetState(1)\g)
		
		EndIf
		
		;If Int(TGadgetState(1)\g\v[3])>Len(TGadgetState(1)\g\v[0])
			
			;TGadgetState(1)\g\v[1]=TTextWidth(TGadgetState(1)\g\v[0])+TGadgetBorderSize(TGadgetState(1)\g\t,0)*3
			

			;TGadgetRedraw()
		;EndIf
		
	
	Case t_integer,t_float
	
		FlushKeys
		
		TGadgetState(1)\g\v[3]=Len(TGadgetState(1)\g\v[0])
		
		
		If TGadgetState(0)=TGadgetState(1)
		
		Select TGadgetIntegerTimeEvent
		
		Case 0
			
			TGadgetIntegerTimeEvent=1
			
			TGadgetTimer=milli+TGadgetIntegerTime
			TGadgetIntegerMouseX=TMouseX
			TGadgetIntegerMouseY=TMouseY
			TGadgetIntegerValue$=TGadgetState(1)\g\v[0]
			
			
		Case 1
					
			If milli>TGadgetTimer
			
				TGadgetIntegerTimeEvent=2
			
			EndIf	
				
		Case 2
			
			Select TGadgetState(1)\g\t
		
				Case t_integer
					Select TGadgetPartType(t_integer,TGadgetState(1)\n)
						Case t_arrowup
							TGadgetSet Handle(TGadgetState(1)\g),t_value,Int(TGadgetState(1)\g\v[0])+Int(TGadgetState(1)\g\v[7])
						Case t_arrowdown
							TGadgetSet Handle(TGadgetState(1)\g),t_value,Int(TGadgetState(1)\g\v[0])-Int(TGadgetState(1)\g\v[7])
					End Select
				
				Case t_float
				
					Select TGadgetPartType(t_float,TGadgetState(1)\n)
						Case t_arrowup
							TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[0])+Float(TGadgetState(1)\g\v[7])
						Case t_arrowdown
							TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[0])-Float(TGadgetState(1)\g\v[7])
					End Select
		
			End Select
		
		End Select
		
		Else
			TGadgetIntegerTimeEvent=0
		
			disti=(TGadgetIntegerMouseY-TMouseY) / Int(TGadgetState(1)\g\v[9])
			
			Select TGadgetState(1)\g\t
		
				Case t_integer
					TGadgetSet Handle(TGadgetState(1)\g),t_value,Int(TGadgetIntegerValue$)+Int(TGadgetState(1)\g\v[7])*disti
				
				Case t_float
					TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetIntegerValue$)+Float(TGadgetState(1)\g\v[7])*disti
		
			End Select
			
		EndIf
		
		
	Case t_slider
			
		Select TGadgetPartType(t_slider,TGadgetState(1)\n)

			Case t_slider
			
				dist#=TGadgetState(1)\g\v[0]
				If TMouseX>TGadgetState(1)\g\part[1]\x+(TGadgetState(1)\g\part[1]\w)/2.0
					
					dist#=dist+1.0/Float(TGadgetState(1)\g\part[0]\w)
					
				ElseIf TMouseX<TGadgetState(1)\g\part[1]\x+(TGadgetState(1)\g\part[1]\w)/2.0
				
					dist#=dist-1.0/Float(TGadgetState(1)\g\part[0]\w)
					
				EndIf
				
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
				
				dist#=TGadgetState(1)\g\v[1]
				If TMouseY>TGadgetState(1)\g\part[1]\y+(TGadgetState(1)\g\part[1]\h)/2.0
					
					dist#=dist+1.0/Float(TGadgetState(1)\g\part[0]\h)
					
				ElseIf TMouseY<TGadgetState(1)\g\part[1]\y+(TGadgetState(1)\g\part[1]\h)/2.0
				
					dist#=dist-1.0/Float(TGadgetState(1)\g\part[0]\h)
					
				EndIf
				
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_slidervert,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
			
				TMouseLastX=-1
			
			Case t_knot
				
				dist#=Float((TMouseX-TMouseDx)-TGadgetState(1)\g\part[0]\x)/(TGadgetState(1)\g\part[0]\w-TGadgetState(1)\g\part[1]\w)
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
				
				dist#=Float((TMouseY-TMouseDy)-TGadgetState(1)\g\part[0]\y)/(TGadgetState(1)\g\part[0]\h-TGadgetState(1)\g\part[1]\h)
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_slidervert,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
				

		End Select	
	
	Case t_hslider
	
			
		Select TGadgetPartType(t_hslider,TGadgetState(1)\n)

			Case t_hslider
			
				dist#=TGadgetState(1)\g\v[0]
				If TMouseX>TGadgetState(1)\g\part[1]\x+(TGadgetState(1)\g\part[1]\w)/2.0
					
					dist#=dist+1.0/Float(TGadgetState(1)\g\part[0]\w)
					
				ElseIf TMouseX<TGadgetState(1)\g\part[1]\x+(TGadgetState(1)\g\part[1]\w)/2.0
				
					dist#=dist-1.0/Float(TGadgetState(1)\g\part[0]\w)
					
				EndIf
				
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
			
				TMouseLastX=-1
			
			Case t_hknot
				
				dist#=Float((TMouseX-TMouseDx)-TGadgetState(1)\g\part[0]\x)/(TGadgetState(1)\g\part[0]\w-TGadgetState(1)\g\part[1]\w)
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
				

		End Select
	
	Case t_vslider
	
			
		Select TGadgetPartType(t_vslider,TGadgetState(1)\n)

			Case t_vslider
			
				dist#=TGadgetState(1)\g\v[0]
				If TMouseY>TGadgetState(1)\g\part[1]\y+(TGadgetState(1)\g\part[1]\h)/2.0
					
					dist#=dist+1.0/Float(TGadgetState(1)\g\part[0]\h)
					
				ElseIf TMouseY<TGadgetState(1)\g\part[1]\y+(TGadgetState(1)\g\part[1]\h)/2.0
				
					dist#=dist-1.0/Float(TGadgetState(1)\g\part[0]\h)
					
				EndIf
				
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
			
				TMouseLastX=-1
			
			Case t_vknot
				
				dist#=Float((TMouseY-TMouseDy)-TGadgetState(1)\g\part[0]\y)/(TGadgetState(1)\g\part[0]\h-TGadgetState(1)\g\part[1]\h)
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_value,Float(TGadgetState(1)\g\v[2])+dist*(Float(TGadgetState(1)\g\v[3])-Float(TGadgetState(1)\g\v[2]))
				

		End Select
	

	Case t_list
	
					
		Select TGadgetPartType(t_list,TGadgetState(1)\n)

			Case t_list
						
				ll.tlist=Object.tlist(TGadgetState(1)\g\v[2])
				
				ydown=TMousey-(TGadgetState(1)\g\part[0]\y+TGadgetBorderSize(TGadgetState(1)\g\t,0))+Int(TGadgetState(1)\g\v[3])
				
				
				
				For ln.tlistnode=Each tlistnode
					If ln\l=ll
						If ydown>=ln\y
							If ydown<=ln\y+ln\h
								TGadgetState(1)\g\v[1]=Handle(ln\i)
								;If ln\i\subs=1
								;	ln\i\unfold=1-ln\i\unfold
								;EndIf
								TGadgetSet Handle(TGadgetState(1)\g),t_value,ln\i\num
								Exit
							EndIf
						EndIf
					EndIf
				Next
	
			Case t_vslider
				dist#=Float(TGadgetState(1)\g\v[3])/Float(Int(TGadgetState(1)\g\v[4])-(TGadgetState(1)\g\part[0]\h-TGadgetBorderSize(TGadgetState(1)\g\t,0)*2))
		
				If TMouseY>TGadgetState(1)\g\part[4]\y+(TGadgetState(1)\g\part[4]\h+1)/2.0
					
					dist#=dist+1.0/(TGadgetState(1)\g\part[0]\h-TGadgetState(1)\g\part[4]\h) ;Float(TGadgetState(1)\g\part[4]\h-5);Float(TGadgetState(1)\g\part[0]\h)/Float(TGadgetState(1)\g\v[4]) ;1.0/Float(TGadgetState(1)\g\part[4]\h)
					
				ElseIf TMouseY<TGadgetState(1)\g\part[4]\y+(TGadgetState(1)\g\part[4]\h)/2.0
				
					dist#=dist-1.0/(TGadgetState(1)\g\part[0]\h-TGadgetState(1)\g\part[4]\h) ;Float(TGadgetState(1)\g\part[0]\h)/Float(TGadgetState(1)\g\v[4])  ;0.1 ;1.0/Float(TGadgetState(1)\g\part[4]\h)
					
				EndIf
				
				TMouseLastX=-1
				
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_listscroll,dist
			
			Case t_vknot
						
				dist#=Float((TMouseY-TMouseDy)-TGadgetState(1)\g\part[0]\y)/(TGadgetState(1)\g\part[0]\h-TGadgetState(1)\g\part[4]\h) ;-TGadgetBorderSize(t_list,2)*2)

				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_listscroll,dist
					
	
		End Select
		
		
	Case t_combobox

		;combobox
;Data 6
;Data 0,0,1,1, 16 ,t_combobox,1
;Data -16,0,16,1, 8 ,t_comboarrow,3
;Data 0  ,1,1,0, 2 ,t_combobackground,0
;Data 0,1,0.9,0, 8 ,t_selected,0
;Data 0,1,1,1, 2 ,t_text,0
;Data -16,1,16,0, 8 ,t_comboslider,1
;Data -16,1,16,0, 8 ,t_comboknot,1
	
		Select TGadgetPartType(t_combobox,TGadgetState(1)\n)

			Case -100 ;t_combobackground
												
				ll.TList=Object.TList(TGadgetState(1)\g\v[2])
				
				ydown=TMousey-TGadgetState(1)\g\part[4]\y+Int(TGadgetState(1)\g\v[3])
				
				For ln.tlistnode=Each tlistnode
					If ln\l=ll
						If ydown>=ln\y
							If ydown<=ln\y+ln\h
								TGadgetState(1)\g\v[1]=Handle(ln\i)
								;If ln\i\subs=1
								;	ln\i\unfold=1-ln\i\unfold
								;EndIf
								TGadgetSet Handle(TGadgetState(1)\g),t_value,ln\i\num
								Exit
							EndIf
						EndIf
					EndIf
				Next
	
			Case t_comboslider
			
;g\party[6]=Float(Float(g\v[3])/Float(Int(g\v[4])-g\part[2]\h))*(g\part[2]\h-g\part[6]\h)

				 dist#=Float(Float(TGadgetState(1)\g\v[3])/Float(Int(TGadgetState(1)\g\v[4])-(TGadgetState(1)\g\part[2]\h-TGadgetBorderSize(t_combobox,2)*2)))
				

				If TMouseY>TGadgetState(1)\g\part[6]\y+(TGadgetState(1)\g\part[6]\h+1)/2.0
					
					dist#=dist+1.0/Float(TGadgetState(1)\g\part[5]\h-TGadgetState(1)\g\part[6]\h) ;Float(TGadgetState(1)\g\part[6]\h)
					
					;1.0/(TGadgetState(1)\g\part[0]\h-TGadgetState(1)\g\part[4]\h)
					
				ElseIf TMouseY<TGadgetState(1)\g\part[6]\y+(TGadgetState(1)\g\part[6]\h)/2.0
				
					dist#=dist-1.0/Float(TGadgetState(1)\g\part[5]\h-TGadgetState(1)\g\part[6]\h) ;Float(TGadgetState(1)\g\part[6]\h)
	
				EndIf
				
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_comboscroll,dist
				
			Case t_comboknot
			
;dist#=Float(Float(TGadgetState(3)\g\v[3])/Float(Int(TGadgetState(3)\g\v[4])-(TGadgetState(3)\g\part[2]\h-TGadgetBorderSize(t_combobox,4)*2)))
				
dist#=Float((TMouseY-TMouseDy)-TGadgetState(1)\g\part[5]\y)/(TGadgetState(1)\g\part[5]\h-(TGadgetState(1)\g\part[6]\h)) ;-TGadgetBorderSize(t_combobox,4)*2))
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(1)\g),t_comboscroll,dist
				

	
	
	
	
	
	
		End Select
	
	
	
	

End Select

EndIf

;released
If TGadgetState(2)<>Null

Select TGadgetState(2)\g\t


	Case t_button
	
		If TGadgetState(2)\g\parent<>Null
		
			If TGadgetState(2)\g\parent\t=t_radio
			
				If TGadgetGet(Handle(TGadgetState(2)\g\parent),t_selected)=Handle(TGadgetState(2)\g)
				
					TGadgetSet Handle(TGadgetState(2)\g\parent),t_value,0
				
				Else
			
					TGadgetSet Handle(TGadgetState(2)\g\parent),t_selected,Handle(TGadgetState(2)\g)
				
				EndIf
						
				TGadgetState(2)=TGadgetState(2)\g\parent\part[0]
										
			EndIf
						
		EndIf
		
		TGadgetstate(5)=TGadgetState(2)
	

	Case t_window
		If TGadgetPartType(t_window,TGadgetState(2)\n)=t_windowclose
		
			TGadgetHide Handle(TGadgetState(2)\g),0
			
			TGadgetstate(5)=TGadgetState(2)
		
		EndIf
		
	Case t_textbox
		TGadgetCursorBlinkTimer=milli+TGadgetCursorBlinkTime
		TGadgetPartState(TGadgetState(2)\g\part[2],1)
		
	Case t_integer
		If TGadgetState(2)\n=0
			TGadgetCursorBlinkTimer=milli+TGadgetCursorBlinkTime
			TGadgetPartState(TGadgetState(2)\g\part[2],1)
		EndIf
		TGadgetIntegerTimeEvent=0
		Select TGadgetPartType(t_integer,TGadgetState(2)\n)
			Case t_arrowup
				TGadgetSet Handle(TGadgetState(2)\g),t_value,Int(TGadgetState(2)\g\v[0])+Int(TGadgetState(2)\g\v[7])
			Case t_arrowdown
				TGadgetSet Handle(TGadgetState(2)\g),t_value,Int(TGadgetState(2)\g\v[0])-Int(TGadgetState(2)\g\v[7])
		End Select
	
	Case t_float
		If TGadgetState(2)\n=0
			TGadgetCursorBlinkTimer=milli+TGadgetCursorBlinkTime
			TGadgetPartState(TGadgetState(2)\g\part[2],1)
		EndIf
		TGadgetIntegerTimeEvent=0
		Select TGadgetPartType(t_float,TGadgetState(2)\n)
			Case t_arrowup
				TGadgetSet Handle(TGadgetState(2)\g),t_value,Float(TGadgetState(2)\g\v[0])+Float(TGadgetState(2)\g\v[7])
			Case t_arrowdown
				TGadgetSet Handle(TGadgetState(2)\g),t_value,Float(TGadgetState(2)\g\v[0])-Float(TGadgetState(2)\g\v[7])
		End Select
		
	Case t_checkbox
	
		If TGadgetState(2)\g\parent<>Null
			If TGadgetState(2)\g\parent\t=t_radio
			
				TGadgetSet Handle(TGadgetState(2)\g\parent),t_selected,Handle(TGadgetState(2)\g)
			
				TGadgetState(2)=TGadgetState(2)\g\parent\part[0]
						
			Else
	
				TGadgetSet Handle(TGadgetState(2)\g),t_value,1-Int(TGadgetState(2)\g\v[0])
				
			EndIf
					
		Else	

			TGadgetSet Handle(TGadgetState(2)\g),t_value,1-Int(TGadgetState(2)\g\v[0])
			
		EndIf
			
		
	Case t_list
						
		If TGadgetPartType(t_list,TGadgetState(2)\n)=t_list
					
			ii.titem=Object.titem(TGadgetState(2)\g\v[1])
			
			If ii<>Null
						
				If ii\subs=1
					ii\unfold=1-ii\unfold
					TGadgetRefresh(TGadgetState(2)\g)
				EndIf
								
			EndIf

		EndIf
		
	Case t_combobox
	
	;combobox
;Data 6
;Data 0,0,1,1, 16 ,t_combobox,1
;Data -16,0,16,1, 8 ,t_comboarrow,3
;Data 0  ,1,1,0, 2 ,t_combobackground,0
;Data 0,1,0.9,0, 8 ,t_selected,0
;Data 0,1,1,1, 2 ,t_text,0
;Data -16,1,16,0, 8 ,t_comboslider,1
;Data -16,1,16,0, 8 ,t_comboknot,1

		Select TGadgetPartType(t_combobox,TGadgetState(2)\n)
		
			Case t_combobox,t_comboarrow
	
				TGadgetState(2)\g\v[8]=1-Int(TGadgetState(2)\g\v[8])
				
		End Select
		
				If Int(TGadgetState(2)\g\v[8])=1
					num1=Int(TGadgetState(2)\g\v[7])
					num2=Int(TGadgetState(2)\g\v[6])
					
					If num1>num2
						num1=num2
					EndIf	
								
					num=TFontHeight*num1+TGadgetBorderSize(TGadgetState(2)\g\t,2)*2
					
					
				;Else
				
				;	num=0
					
				;EndIf
					
				TGadgetState(2)\g\parth[2]=num
				TGadgetState(2)\g\parth[4]=num
				TGadgetState(2)\g\partx[4]=0
				;TGadgetState(2)\g\parth[3]=TFontHeight+2
				
				
				If num2>num1
					TGadgetState(2)\g\parth[5]=num 
					TGadgetState(2)\g\parth[6]=num/2 ;*TGadgetCoords#(t_combobox,6,3)
					
					TGadgetState(2)\g\partw[3]=-TGadgetBorderSize(TGadgetState(2)\g\t,2)*2-TGadgetState(2)\g\part[5]\w+TGadgetBorderSize(t_combobox,3)
					
				Else
				
					TGadgetState(2)\g\partw[3]=-TGadgetBorderSize(TGadgetState(2)\g\t,2)*2+TGadgetBorderSize(t_combobox,3)
								
				EndIf
				
				
;TGadgetState(2)\g\parth[3]=TFontHeight
				;TGadgetState(2)\g\partx[3]=TGadgetBorderSize(TGadgetState(2)\g\t,2)
				
				TGadgetState(2)\g\partx[3]=TGadgetBorderSize(TGadgetState(2)\g\t,2)-TGadgetBorderSize(t_combobox,3)

				
				;TGadgetState(2)\g\parth[3]=TFontHeight+TGadgetBorderSize(t_combobox,3)*2
				
					
				TGadgetUpdate(TGadgetState(2)\g)		
				TGadgetRefresh(TGadgetState(2)\g)
				TGadgetSet Handle(TGadgetState(2)\g),t_tofront
				;EntityOrder TGadgetState(2)\g\e,TRedrawOrderFront
				
				Else
				
				
			TGadgetState(2)\g\parth[2]=0
			TGadgetState(2)\g\partx[3]=-3000
			TGadgetState(2)\g\parth[4]=0
			TGadgetState(2)\g\parth[5]=0
			TGadgetState(2)\g\parth[6]=0
			TGadgetState(2)\g\partx[4]=-3000
		
			TGadgetRefresh(TGadgetState(2)\g)		
			TGadgetUpdate(TGadgetState(2)\g)
			;TgadgetState(2)=Null
			TgadgetState(3)=Null
			TgadgetState(4)=Null

				
				
				
				
				EndIf
				
				
		;End Select
		
		
	Case t_menu
	
	ggg.tgadget=TGadgetState(2)\g
	
	gg.tgadget=Object.tgadget(ggg\v[1])
		
	;If gg\parent=TGadgetMenuHandle Or TGadgetMenuHandle=Null
	;*******
	
		If TGadgetState(2)\g\v[2]=True;TGadgetState(2)\g\parent\t<>t_menu
					
					test=0
					If ggg\parent<>Null
						If ggg\parent\t<>t_menu
							test=1
						EndIf
					Else
						test=1
					EndIf
					
					If test=1	
					
						For gggg.tgadget=Each tgadget
							If gggg\t=t_menu
								If gggg\parent<>Null
									If gggg\parent\t=t_menu
								TGadgetHide Handle(gggg),0
	
									If gggg\hide=1
										gggg\v[0]=0
									EndIf
									EndIf
								EndIf
							EndIf
						Next
						
						
					EndIf	
			
			TGadgetMenuHandle=gg\parent
			TGadgetPartState(TGadgetState(2)\g\part[1],1)
						
			If ggg<>Null 				
									
				;TGadgetSet Int(ggg\v[1]),t_tofront
				If ggg\parent=Null
					TGadgetSet Handle(ggg),t_tofront
					;TGadgetPartState(ggg\part[1],1)
				Else
					If ggg\parent\t<>t_menu
						TGadgetSet Handle(ggg),t_tofront
					;	TGadgetPartState(ggg\part[1],1)
					EndIf
				EndIf
				
				ggg\v[0]=1-Int(ggg\v[0])
				
				If Int(ggg\v[0])=1
					For gg.tgadget=Each tgadget
						If gg\parent=ggg
							TGadgetShow Handle(gg),0,False
						EndIf
					Next
					;If TGadgetState(2)\g\parent\t=t_menu
					;	TGadgetShow Handle(TGadgetState(2)\g\parent),False
					;EndIf
				Else
					For gg.tgadget=Each tgadget
						If gg\parent=ggg
							TGadgetHide Handle(gg),0
						EndIf
					Next
					For gggg.tgadget=Each tgadget
						If gggg\t=t_menu
							If gggg\v[1]=ggg\v[1]
								If gggg\hide=1
									gggg\v[0]=0
								EndIf
							EndIf
						EndIf
					Next
					
					TGadgetState(3)=Null
					TGadgetState(4)=TGadgetState(2)
					For gggg.tgadget=Each tgadget
						If gggg\t=t_menu
							gggg\v[0]=0
						EndIf
					Next
					
							
							
					
				EndIf
				
				
				
				
			EndIf
			
			
		
		Else
			
			TGadgetHide TGadgetState(2)\g\v[1],0	
			TGadgetShow TGadgetState(2)\g\v[1],0,False
			For gggg.tgadget=Each tgadget
				If gggg\t=t_menu
					gggg\v[0]=0
				EndIf
			Next
			
			TGadgetState(3)=Null
			TGadgetState(4)=TGadgetState(2)
			TGadgetstate(5)=TGadgetState(2)
			;TGadgetMenuHandle=Null
			
			TMouseLastX=-1
				
		EndIf
		
	;EndIf
		
End Select

EndIf

;active
If TGadgetState(3)<>Null

Select TGadgetState(3)\g\t

	Case t_textbox,t_integer,t_float
	
		If TGadgetPartType(TGadgetState(3)\g\t,TGadgetState(3)\n)<>t_arrowup
		If TGadgetPartType(TGadgetState(3)\g\t,TGadgetState(3)\n)<>t_arrowdown

	
			txt$=TGadgetState(3)\g\v[0]
			txtpos=TGadgetState(3)\g\v[3]
			txtmax=TGadgetState(3)\g\v[4]

			ltr = GetKey()
			If (KeyHit(82)>0) Then ltr=48
			If (KeyHit(79)>0) Then ltr=49
			If (KeyHit(80)>0) Then ltr=50
			If (KeyHit(81)>0) Then ltr=51
			If (KeyHit(75)>0) Then ltr=52
			If (KeyHit(76)>0) Then ltr=53
			If (KeyHit(77)>0) Then ltr=54
			If (KeyHit(71)>0) Then ltr=55
			If (KeyHit(72)>0) Then ltr=56
			If (KeyHit(73)>0) Then ltr=57
			If (KeyHit(181)>0) Then ltr=47
			If (KeyHit(83)>0) Then ltr=44
											
			test=0
			Select TGadgetState(3)\g\t
				
				Case t_textbox
					test=ltr > 31 And ltr <= 255
				
				Case t_integer
					test=((ltr > 47 And ltr <= 57 And (Left$(txt$,1)<>"-" Or txtpos>0)) Or (ltr=45 And txtpos=0 And Left$(txt$,1)<>"-"))
					txtmax=0
				
				Case t_Float
					test=((ltr > 47 And ltr <= 57 And (Left$(txt$,1)<>"-" Or txtpos>0)) Or (ltr=45 And txtpos=0 And Left$(txt$,1)<>"-")) Or (ltr=46 And (Left$(txt$,1)<>"-" Or txtpos>0))
					txtmax=0
				
			End Select
		
			If test=1
					
				If Len(txt$)<txtmax Or txtmax=0
					txt$=Left$(txt$,txtpos)+Chr$(ltr)+Right$(txt$,Len(txt$)-txtpos)
					txtpos=txtpos+1
				EndIf
					
			EndIf
			
			;back space
			If KeyDown(14) 
				If milli>TGadgetTimer
					TGadgetTimer=milli+TGadgetTextTime
					If Len(txt$)>0 
						If txtpos>0
							txt$=Left$(txt$,txtpos-1)+Right$(txt$,Len(txt$)-txtpos)
							txtpos=txtpos-1
						EndIf
					EndIf
				EndIf
			EndIf
			
			;delete 
			If KeyDown(211)
				If milli>TGadgetTimer
					TGadgetTimer=milli+TGadgetTextTime
					If Len(txt$)>0 
						If txtpos<Len(txt$)
							txt$=Left$(txt$,txtpos)+Right$(txt$,Len(txt$)-txtpos-1)
						EndIf
					EndIf
				EndIf
			EndIf
			
			If KeyHit(207) 
				txtpos=Len(txt$)
				TGadgetState(3)\g\v[1]=TTextWidth(txt$)-TGadgetState(3)\g\w+TGadgetBorderSize(TGadgetState(3)\g\t,0)*4 ;TGadgetState(3)\g\w*0.8
				TGadgetRedraw()
			EndIf
			If KeyHit(199)
				txtpos=0
				TGadgetState(3)\g\v[1]=0
				TGadgetRedraw()
			EndIf
			If KeyDown(203)
				If milli>TGadgetTimer
					TGadgetTimer=milli+TGadgetTextScrollTime
					
					txtpos=txtpos-1
					If txtpos<0 
						txtpos=0
					EndIf
				EndIf
			EndIf
			If KeyDown(205)
				If milli>TGadgetTimer
					TGadgetTimer=milli+TGadgetTextScrollTime
 
					txtpos=txtpos+1
					If txtpos>Len(txt$)
						txtpos=Len(txt$)
					EndIf
				EndIf
			EndIf
			
			If milli>TGadgetCursorBlinkTimer
			
				TGadgetCursorBlinkTimer=milli+TGadgetCursorBlinkTime
				
				TGadgetPartState(TGadgetState(3)\g\part[2],1-TGadgetState(3)\g\partstate[2])
				
			EndIf
			
				If txtpos<>Int(TGadgetState(3)\g\v[3])
				
					TGadgetPartState(TGadgetState(3)\g\part[2],1)
					If TTextWidth(txt$)<=TGadgetState(3)\g\part[0]\w-TGadgetBorderSize(TGadgetState(3)\g\t,0)*2
					
						TGadgetState(3)\g\v[1]=0
						TGadgetRedraw()
					
					EndIf
					TGadgetRefresh(TGadgetState(3)\g)
					TGadgetRedraw()
				
				EndIf
			
				If txtpos>0
								
					TGadgetState(3)\g\partx[2]=TGadgetBorderSize(TGadgetState(3)\g\t,0)+TTextWidth(Left$(txt$,txtpos))-Int(TGadgetState(3)\g\v[1])
				
				Else
				
					TGadgetState(3)\g\partx[2]=TGadgetBorderSize(TGadgetState(3)\g\t,0)-Int(TGadgetState(3)\g\v[1])
				
				EndIf
				
								
				If TTextWidth(txt$)>TGadgetState(3)\g\part[0]\w-TGadgetBorderSize(TGadgetState(3)\g\t,0)*2
																	
					If TGadgetState(3)\g\partx[2]>(TGadgetState(3)\g\part[0]\w-TGadgetState(3)\g\part[2]\w)-TGadgetBorderSize(TGadgetState(3)\g\t,0)*2
						
						TGadgetState(3)\g\v[1]=Int(Int(TGadgetState(3)\g\v[1])+TGadgetBorderSize(TGadgetState(3)\g\t,0)*4)
						TGadgetRedraw()
						TGadgetRefresh(TGadgetState(3)\g)
					
					ElseIf TGadgetState(3)\g\partx[2]<TGadgetBorderSize(TGadgetState(3)\g\t,0)*2
					
						TGadgetState(3)\g\v[1]=Int(Int(TGadgetState(3)\g\v[1])-TGadgetBorderSize(TGadgetState(3)\g\t,0)*4)
						If TGadgetState(3)\g\v[1]<0
						TGadgetState(3)\g\v[1]=0
						EndIf
						TGadgetRedraw()
						TGadgetRefresh(TGadgetState(3)\g)
					
					EndIf
											
				EndIf
				

				
				TGadgetState(3)\g\v[3]=txtpos
				TGadgetUpdate(TGadgetState(3)\g)
				;TGadgetRefresh(TGadgetState(3)\g)
				
				
			;EndIf
												
			If txt$<>TGadgetState(3)\g\v[0]
												
				;TGadgetState(3)\g\v[0]=txt$
				TGadgetSet Handle(TGadgetState(3)\g),t_value,txt$
				TGadgetRefresh(TGadgetState(3)\g)
				TGadgetRedraw()
				;TGadgetState(5)=TGadgetState(3)
					
			EndIf
														
			If KeyHit(28) Or KeyHit(156)
								
				TGadgetPartState(TGadgetState(3)\g\part[2],0)
				TGadgetSet Handle(TGadgetState(3)\g),t_value,TGadgetState(3)\g\v[0]
				
				TGadgetState(4)=TGadgetState(3)
				TGadgetState(2)=TGadgetState(3)
				TGadgetState(3)=Null
													
			EndIf
			
		EndIf
		EndIf
		
		If TScrollDir<>0
		If TGadgetState(0)<>Null
		If TGadgetState(0)\g=TGadgetState(3)\g
			TGadgetPartState(TGadgetState(3)\g\part[2],0)
			TGadgetCursorBlinkTimer=milli+TGadgetCursorBlinkTime
			Select TGadgetState(3)\g\t
		
				Case t_integer
					TGadgetSet Handle(TGadgetState(3)\g),t_value,Int(TGadgetState(3)\g\v[0])+Int(TGadgetState(3)\g\v[7])*TScrollDir
					TGadgetState(3)\g\v[3]=Len(TGadgetState(3)\g\v[0])
				Case t_float
					TGadgetSet Handle(TGadgetState(3)\g),t_value,Float(TGadgetState(3)\g\v[0])+Float(TGadgetState(3)\g\v[7])*TScrollDir
					TGadgetState(3)\g\v[3]=Len(TGadgetState(3)\g\v[0])
			End Select
			
		EndIf
		EndIf
		EndIf
		
	
	Case t_slider,t_hslider,t_vslider
	
		If TScrollDir<>0
			If TGadgetState(0)<>Null
				If TGadgetState(0)\g=TGadgetState(3)\g
				
					dist#=Float(TGadgetState(3)\g\v[0])-0.05*TScrollDir
			
					If dist<0
						dist=0
					EndIf
					If dist>1
						dist=1
					EndIf
					TGadgetSet Handle(TGadgetState(3)\g),t_value,Float(TGadgetState(3)\g\v[2])+dist*(Float(TGadgetState(3)\g\v[3])-Float(TGadgetState(3)\g\v[2]))
				EndIf
				
			EndIf
		EndIf
	
	Case t_list
	
		If TScrollDir<>0
			If TGadgetState(0)<>Null
				If TGadgetState(0)\g=TGadgetState(3)\g
				
;dist#=Float(Float(TGadgetState(3)\g\v[3])/Float(Int(TGadgetState(3)\g\v[4])-(TGadgetState(3)\g\part[2]\h-TGadgetBorderSize(t_list,0)*2)))-0.05*TScrollDir
dist#=(Float(TGadgetState(3)\g\v[3])/(Float(TGadgetState(3)\g\v[4])-(TGadgetState(3)\g\part[0]\h-TGadgetBorderSize(TGadgetState(3)\g\t,0)*2)))


sc#=((TGadgetState(3)\g\part[0]\h-TGadgetBorderSize(TGadgetState(3)\g\t,0)*2)/Float(TGadgetState(3)\g\v[4]))/2.0

			dist#=dist#-sc*TScrollDir ;(1.0/Float(TGadgetState(3)\g\part[4]\h))*TScrollDir

					If dist<0
						dist=0
					EndIf
					If dist>1
						dist=1
					EndIf
					TGadgetSet Handle(TGadgetState(3)\g),t_listscroll,dist
				
				EndIf		
			EndIf
		EndIf
		
	Case t_combobox
	
		If TScrollDir<>0
				
				dist#=Float(Float(TGadgetState(3)\g\v[3])/Float(Int(TGadgetState(3)\g\v[4])-(TGadgetState(3)\g\part[2]\h-TGadgetBorderSize(t_combobox,2)*2)))-0.05*TScrollDir
	
				If dist<0
					dist=0
				EndIf
				If dist>1
					dist=1
				EndIf
				TGadgetSet Handle(TGadgetState(3)\g),t_comboscroll,dist		
						
		EndIf
		
		If TGadgetState(0)<>Null
		If TGadgetState(0)\g=TGadgetState(3)\g
		
	
		Select TGadgetPartType(t_combobox,TGadgetState(0)\n)

			Case t_combobackground
												
				ll.TList=Object.TList(TGadgetState(0)\g\v[2])
				
				ydown=TMousey-(TGadgetState(0)\g\part[2]\y+TGadgetBorderSize(TGadgetState(0)\g\t,2))+Int(TGadgetState(0)\g\v[3])
				
				For ln.tlistnode=Each tlistnode
					If ln\l=ll
						If ydown>=ln\y
							If ydown<=ln\y+ln\h
								TGadgetState(0)\g\v[1]=Handle(ln\i)
								;If ln\i\subs=1
								;	ln\i\unfold=1-ln\i\unfold
								;EndIf
								;TGadgetState(0)\g\party[3]=ln\y
								;TGadgetSet Handle(TGadgetState(0)\g),t_value,ln\i\num
								
			
								
								If ln\i<>Null
								
								TGadgetState(0)\g\v[10]=ln\i\num
						
						TGadgetState(0)\g\party[3]=TGadgetBorderSize(TGadgetState(0)\g\t,2)-TGadgetBorderSize(t_combobox,3)+ln\y-Int(TGadgetState(0)\g\v[3])
						TGadgetState(0)\g\partx[3]=TGadgetBorderSize(TGadgetState(0)\g\t,2)-TGadgetBorderSize(t_combobox,3)
						;TGadgetState(0)\g\parth[3]=TFontHeight+2
						;TGadgetState(0)\g\v$[9]=ln\i\d$
								TGadgetUpdate(TGadgetState(0)\g)
								TGadgetPartClip(TGadgetState(0)\g\part[3],0,TGadgetState(0)\g\h,TGadgetState(0)\g\part[2]\w,TGadgetState(0)\g\h+TGadgetState(0)\g\part[2]\h)
								
								Else
								
								TGadgetState(0)\g\v[9]=""
								TGadgetRefresh(TGadgetState(0)\g)
								TGadgetUpdate(TGadgetState(0)\g)
								TGadgetSet Handle(TGadgetState(0)\g),t_value,0

								TgadgetState(4)=TGadgetState(3)
								TgadgetState(2)=Null
								TgadgetState(3)=Null
								
									
			
			
								EndIf
								
								TMouseLastX=-1	
								
								Exit
							EndIf
						EndIf
					EndIf
				Next
	
		End Select
		
		EndIf
		EndIf
		
		
		
	Case t_menu

		If TGadgetState(0)<>TGadgetStateLast(0)
		
			If TGadgetStateLast(0)<>Null
				ggg.tgadget=TGadgetStateLast(0)\g
				
				
				If ggg\t=t_menu
				
					;If TGadgetState(0)<>Null
					;If TGadgetState(0)\g\t=t_menu
			
					;	gggg.tgadget=Object.tgadget(ggg\v[1])
					;	TGadgetPartState(gggg\part[1],0)
					;EndIf
					
					;EndIf
					;EndIf
					
					;If ggg\parent<>Null
					;If ggg\parent\t=t_menu
					If ggg\txt$<>""
					;TgadgetSet Handle(ggg),t_tofront
					TGadgetPartState(ggg\part[1],0)
					TGadgetPartState(ggg\part[2],0)
					EndIf
					;EndIf
					;EndIf
				EndIf
			EndIf
		
			If TGadgetState(0)<>Null
											
				ggg.tgadget=TGadgetState(0)\g
				
				If ggg<>Null
				If ggg\t=t_menu	
				
				
				
				For gggg.tgadget=Each tgadget
					If gggg\t=t_menu
						
						TGadgetPartState(gggg\part[1],0)
						
					EndIf
				Next
										
					
					;If Int(ggg\v[1])<>0
					;
				;	
						gggg.tgadget=Object.tgadget(ggg\v[1])
						TGadgetPartState(gggg\part[1],1)
						
					;EndIf
					
						If ggg\txt$<>""
						;***************
						
						
							ggggg.tgadget=Object.tgadget(ggg\v[1])
							TGadgetMenuHandle2=ggggg
													
							If ggggg\parent=TGadgetMenuHandle
							
								TGadgetSet Handle(ggggg),t_tofront
							
								TGadgetPartState(ggg\part[1],1)
								TGadgetPartState(ggg\part[2],1)
							
								;has children ??
								For gg.tgadget=Each tgadget
									If gg\t=t_menu
									If gg\parent=ggg\parent
										TGadgetHide Handle(gg),0
									EndIf
									EndIf
								Next
								For gg.tgadget=Each tgadget
									If gg\t=t_menu
									If gg\parent=ggg\parent
										TGadgetShow Handle(gg),0,False
									EndIf
									EndIf
								Next
							
								If ggg\v[2]=True
									ggg\v[0]=1
									
									For gg.tgadget=Each tgadget
										If gg\parent=ggg
											TGadgetShow Handle(gg),0,False
										EndIf
									Next
								Else
									
									
										
								EndIf
							EndIf
						
							
						;-***********	
						EndIf	
					EndIf
				EndIf
			
			EndIf
		EndIf
		
		If 2=4
	
		If ggg<>Null
			ggg\v[0]=1-Int(ggg\v[0])
			
			If Int(ggg\v[0])=1
				For gg.tgadget=Each tgadget
					If gg\parent=ggg
						TGadgetShow Handle(gg),0,False
					EndIf
				Next
				;If TGadgetState(2)\g\parent\t=t_menu
				;	TGadgetShow Handle(TGadgetState(2)\g\parent),False
				;EndIf
			Else
				For gg.tgadget=Each tgadget
					If gg\parent=ggg
						TGadgetHide Handle(gg),0
					EndIf
				Next
				For gggg.tgadget=Each tgadget
					If gggg\t=t_menu
						If gggg\v[1]=ggg\v[1]
							If gggg\hide=1
								gggg\v[0]=0
							EndIf
						EndIf
					EndIf
				Next
			EndIf
		EndIf

		EndIf
			
End Select

EndIf





;deactivate
If TGadgetState(4)<>Null

Select TGadgetState(4)\g\t

	Case t_textbox,t_integer,t_float
		TGadgetSet Handle(TGadgetState(4)\g),t_value,TGadgetState(4)\g\v[0]
		TGadgetPartState(TGadgetState(4)\g\part[2],0)
		
		
	Case t_combobox
	
		test=1
		If TGadgetState(2)<>Null
			If TGadgetState(4)\g=TGadgetState(2)\g
				test=0
				If TGadgetPartType(t_combobox,TGadgetState(2)\n)<>t_comboslider
					If TGadgetPartType(t_combobox,TGadgetState(2)\n)<>t_comboknot
						test=1
						TGadgetSet Handle(TGadgetState(4)\g),t_value,TGadgetState(4)\g\v[10]
					EndIf
				EndIf
				
			EndIf
		EndIf

		If test=1
				
			TGadgetState(4)\g\v[8]=0
			
			TGadgetState(4)\g\parth[2]=0
			TGadgetState(4)\g\partx[3]=-3000
			TGadgetState(4)\g\parth[4]=0
			TGadgetState(4)\g\parth[5]=0
			TGadgetState(4)\g\parth[6]=0
			TGadgetState(4)\g\partx[4]=-3000
		
			TGadgetRefresh(TGadgetState(4)\g)		
			TGadgetUpdate(TGadgetState(4)\g)
			;TgadgetState(2)=Null
			TgadgetState(3)=Null
			TgadgetState(4)=Null
			
		EndIf

		
	Case t_menu
		
;		g.tgadget=Object.tgadget(TGadgetState(4)\g\v[1])
gg=Null
		test=0
		If TGadgetState(0)<>Null
			ggg.tgadget=TGadgetState(0)\g
			If ggg<>Null
				If ggg\t=t_menu
					gggg.tgadget=Object.tgadget(ggg\v[1])
					gg.tgadget=gggg\parent
				Else
					test=1
				EndIf
			Else
				test=1
			EndIf
			
		Else
			test=1
		EndIf
		

		If TGadgetMenuHandle<>gg Or test=1
		
			If TGadgetMenuHandle2<>Null
			
				TGadgetHide Handle(TGadgetMenuHandle2),0
				TGadgetShow Handle(TGadgetMenuHandle2),0,False
				
			EndIf

			For ggg.tgadget=Each tgadget
				If ggg\t=t_menu
					ggg\v[0]=0
					TGadgetPartState(ggg\part[1],0)
				EndIf
			Next
			
			TgadgetState(4)=Null
			TGadgetMenuHandle=Null

		EndIf
		
		For ggg.tgadget=Each tgadget
			If ggg\t=t_menu
				TGadgetPartState(ggg\part[1],0)
			EndIf
		Next
		

End Select

EndIf












TGadgetStateLast(0)=TGadgetState(0)
TGadgetStateLast(1)=TGadgetState(1)
TGadgetStateLast(2)=TGadgetState(2)
TGadgetStateLast(3)=TGadgetState(3)
TGadgetStateLast(4)=TGadgetState(4)

If TUIIsIdle=True

	Delay idledelay
	
Else
	
	Delay upddelay

EndIf

End Function
.tgadgettexturecoords

Data "START"+t_windows
Data 0,0,0,16,16,0,0,16,16,0,1,0,32,32,64,32,32,64,64,3,2,0,0,32,32,32,0,64,32,4,3,0,0,32,32,32,0,64,32,4
Data 4,0,96,32,128,32,96,64,128,4,5,64,0,80,16,64,0,80,16,2,6,64,32,96,64,96,32,128,64,2,7,64,32,96,64,96,32,128,64,2
Data 8,64,32,96,64,96,32,128,64,2,9,112,0,128,16,112,0,128,16,3,10,112,0,128,16,112,0,128,16,3,11,112,0,128,16,112,0,128,16,3
Data 12,64,32,96,64,96,32,128,64,3,13,64,32,96,64,96,32,128,64,3,14,96,16,112,32,96,16,112,32,2,15,64,112,80,128,64,112,80,128,2
Data 16,0,0,16,16,0,0,16,16,0,17,80,112,96,128,80,112,96,128,2,18,0,0,16,16,0,0,16,16,0,19,97,0,111,7,112,112,128,128,2
Data 20,0,64,32,96,32,64,64,96,1,21,64,64,80,80,80,64,96,80,2,22,0,0,16,16,0,0,16,16,0,23,64,0,80,16,80,0,96,16,2
Data 24,112,16,128,32,80,16,96,32,2,25,0,0,32,32,0,0,32,32,4,26,0,0,32,32,0,0,32,32,4,27,0,0,32,32,0,0,32,32,4
Data 28,97,113,110,127,97,113,110,127,2,29,96,64,112,80,112,64,128,80,2,30,80,80,96,96,96,80,112,96,2,31,80,80,96,96,96,80,112,96,2
Data 32,64,32,96,64,96,32,128,64,3,33,112,0,128,16,112,0,128,16,3,34,0,0,32,32,0,0,32,32,3,35,112,112,128,128,112,112,128,128,4
Data 36,100,7,108,11,100,7,108,11,1,37,114,81,127,96,114,97,127,112,1,38,0,0,32,32,32,0,64,32,3,39,96,16,112,32,112,16,128,32,2
Data "END"+t_windows

Data "START"+t_fancy
Data 0,0,0,16,16,0,0,16,16,0,1,3,2,85,84,3,2,85,84,4,2,3,89,42,127,45,89,84,127,4,3,3,2,85,84,3,2,85,84,4
Data 4,111,51,144,84,146,51,179,84,4,5,3,2,85,84,3,2,85,84,4,6,3,2,85,84,3,2,85,84,4,7,3,2,85,84,3,2,85,84,4
Data 8,3,2,85,84,3,2,85,84,4,9,3,2,85,84,3,2,85,84,4,10,3,2,85,84,3,2,85,84,4,11,3,2,85,84,3,2,85,84,4
Data 12,3,2,85,84,3,2,85,84,4,13,3,2,85,84,3,2,85,84,4,14,6,182,28,204,6,182,28,204,1,15,4,130,52,178,4,130,52,178,3
Data 16,3,89,42,127,45,89,84,127,1,17,54,130,90,167,54,130,90,167,2,18,3,89,42,127,45,89,84,127,1,19,128,34,136,42,89,2,171,13,1
Data 20,89,2,171,13,89,2,171,13,1,21,88,14,101,27,101,14,114,27,2,22,0,0,16,16,0,0,16,16,0,23,134,27,140,34,117,14,134,33,1
Data 24,168,18,174,24,175,16,186,27,2,25,92,87,136,131,92,87,136,131,4,26,92,87,136,131,92,87,136,131,4,27,92,87,136,131,92,87,136,131,4
Data 28,89,2,171,13,89,2,171,13,1,29,143,16,154,27,156,16,167,27,2,30,143,30,154,41,156,30,167,41,2,31,143,30,154,41,156,30,167,41,2
Data 32,3,2,85,84,3,2,85,84,4,33,3,2,85,84,3,2,85,84,4,34,92,87,136,131,92,87,136,131,4,35,89,2,171,13,89,2,171,13,1
Data 36,55,164,89,169,55,164,89,169,1,37,94,137,107,152,94,137,107,152,2,38,3,2,85,84,3,2,85,84,4,39,6,182,28,204,29,182,51,204,1
Data "END"+t_fancy

Data "START"+t_white
Data 0,0,0,16,16,0,0,16,16,0,1,7,6,139,138,7,6,139,138,7,2,8,147,63,202,72,147,127,202,4,3,8,145,63,202,72,145,127,202,5
Data 4,133,149,188,202,197,147,252,202,7,5,150,28,166,44,150,28,166,44,1,6,8,147,63,202,72,147,127,202,4,7,8,147,63,202,72,147,127,202,4
Data 8,8,147,63,202,72,147,127,202,4,9,8,147,63,202,72,147,127,202,4,10,8,147,63,202,72,147,127,202,4,11,8,147,63,202,72,147,127,202,4
Data 12,8,147,63,202,72,147,127,202,4,13,8,147,63,202,72,147,127,202,4,14,216,58,230,72,216,58,230,72,1,15,152,89,184,121,152,89,184,121,3
Data 16,8,147,63,202,72,147,127,202,4,17,72,147,127,202,72,147,127,202,4,18,8,147,63,202,72,147,127,202,4,19,61,204,73,216,72,147,127,202,4
Data 20,152,7,248,22,152,7,248,22,4,21,152,30,164,42,167,29,180,42,1,22,0,0,16,16,0,0,16,16,0,23,172,23,178,29,180,27,196,43,1
Data 24,187,58,194,66,197,58,210,71,2,25,152,49,184,81,152,49,184,81,3,26,152,49,184,81,152,49,184,81,3,27,152,49,184,81,152,49,184,81,3
Data 28,152,49,184,81,152,49,184,81,3,29,197,28,212,40,212,28,227,40,1,30,197,42,212,54,212,42,227,54,1,31,197,42,212,54,212,42,227,54,1
Data 32,8,147,63,202,72,147,127,202,4,33,8,147,63,202,72,147,127,202,4,34,152,49,184,81,152,49,184,81,3,35,152,49,184,81,152,49,184,81,3
Data 36,194,86,222,93,194,86,222,93,2,37,205,104,217,116,204,103,218,117,1,38,8,147,63,202,72,147,127,202,4,39,216,58,230,72,231,58,245,72,1
Data "END"+t_white

Data "START"+t_grey
Data 0,0,0,16,16,0,0,16,16,0,1,2,2,55,55,2,2,55,55,2,2,2,58,34,90,40,58,72,90,4,3,2,56,34,90,40,56,72,90,4
Data 4,40,94,72,126,78,94,110,126,4,5,2,58,34,90,40,58,72,90,4,6,2,58,34,90,40,58,72,90,4,7,2,58,34,90,40,58,72,90,4
Data 8,2,58,34,90,40,58,72,90,4,9,2,58,34,90,40,58,72,90,4,10,2,58,34,90,40,58,72,90,4,11,2,58,34,90,40,58,72,90,4
Data 12,2,58,34,90,40,58,72,90,4,13,2,58,34,90,40,58,72,90,4,14,1,108,20,127,1,108,20,127,1,15,75,69,92,86,75,69,92,86,2
Data 16,2,58,34,90,40,58,72,90,4,17,40,58,72,90,40,58,72,90,4,18,2,58,34,90,40,58,72,90,4,19,29,91,35,97,40,58,72,90,4
Data 20,63,2,116,18,63,2,116,18,2,21,4,94,19,109,20,94,35,109,2,22,0,0,16,16,0,0,16,16,0,23,110,21,122,33,110,36,122,48,1
Data 24,57,29,62,35,59,37,69,47,2,25,2,58,34,90,40,58,72,90,4,26,2,58,34,90,40,58,72,90,4,27,2,58,34,90,40,58,72,90,4
Data 28,75,53,126,65,75,53,126,65,2,29,73,21,85,33,90,21,102,33,2,30,73,36,85,48,90,36,102,48,2,31,73,36,85,48,90,36,102,48,2
Data 32,2,58,34,90,40,58,72,90,4,33,2,58,34,90,40,58,72,90,4,34,2,58,34,90,40,58,72,90,4,35,2,58,34,90,40,58,72,90,4
Data 36,76,84,91,88,76,84,91,88,1,37,96,69,111,85,97,70,110,84,2,38,40,58,72,90,40,58,72,90,4,39,1,108,20,127,19,108,38,127,1
Data "END"+t_grey


Data "START"+t_hell
Data 0,0,0,16,16,0,0,16,16,0,1,3,3,47,45,3,3,47,45,6,2,4,47,34,76,38,47,68,76,3,3,4,47,34,76,38,47,68,76,3
Data 4,4,47,34,76,38,79,68,108,3,5,4,47,34,76,38,47,68,76,3,6,4,47,34,76,38,47,68,76,3,7,4,47,34,76,38,47,68,76,3
Data 8,4,47,34,76,38,47,68,76,3,9,4,47,34,76,38,47,68,76,3,10,4,47,34,76,38,47,68,76,3,11,4,47,34,76,38,47,68,76,3
Data 12,4,47,34,76,38,47,68,76,3,13,4,47,34,76,38,47,68,76,3,14,5,108,20,123,5,108,20,123,1,15,1,78,20,97,1,78,20,97,2
Data 16,4,47,34,76,38,47,68,76,3,17,38,47,68,76,38,47,68,76,3,18,4,47,34,76,38,47,68,76,3,19,52,38,58,44,38,47,68,76,3
Data 20,48,4,128,20,48,4,128,20,1,21,49,26,62,39,48,25,63,40,2,22,72,51,97,76,101,51,126,76,2,23,72,22,97,47,101,22,126,47,2
Data 24,67,111,71,125,73,111,76,125,1,25,4,47,34,76,38,47,68,76,3,26,4,47,34,76,38,47,68,76,3,27,4,47,34,76,38,47,68,76,3
Data 28,48,4,128,20,48,4,128,20,1,29,72,80,97,105,101,80,126,105,2,30,72,51,97,76,101,51,126,76,2,31,72,51,97,76,101,51,126,76,2
Data 32,4,47,34,76,38,47,68,76,3,33,4,47,34,76,38,47,68,76,3,34,4,47,34,76,38,47,68,76,3,35,72,22,97,47,72,22,97,47,2
Data 36,3,94,18,98,3,94,18,98,1,37,78,106,103,128,78,106,103,128,2,38,4,4,47,45,4,4,47,45,5,39,5,108,20,123,21,108,36,123,1
Data "END"+t_hell


.tdefaultimages

Data "START"+t_windows
Data 1+2
Data "89504E470D0A1A0A0000000D4948445200000080000000800806000000C33E61CB0000002B744558744372656174696F6E2054"
Data "696D65006CF8203236206A756C20323030332030313A35393A3139202B303130301075B54E0000000774494D4507D3071B1216"
Data "17EDAF8FA1000000097048597300001EC100001EC101C36954530000000467414D410000B18F0BFC6105000005504944415478"
Data "DAED9DBF8E1331108713948E9E0ED173488790101414392A4A0AFE143C021434202A36E9906828780AB88292EE4277748774F0"
Data "26D447669123CBF26E6CCFEC8E6FE7F74940B8C4EB24F3D9BBDEB17DF38B2D33258E8E8EB4AADEB15C2E8BCB364D335BAFD7AC"
Data "F2F32D9CF7CF8DDF82FEFAFDEB27E718451C7FFBBE7BCC09020717C0CD66935DF6F3A70FBBC7DCF25C4A25A4CFBF107B174C9E"
Data "3C7EA45AFFC9C949D6EBC346C32DCFA5F4FBBB22FA2EC0A503021807028C08F37A6F1020C048D4187C020208130B74ADC127AA"
Data "19054C090AB81B9EFBC14F19B2AF56AB86FEE9787AB97DFE87E47B85000311B6FAD4FB353436EF632B80E8FBC429409858A073"
Data "6ED66DC559CFBB116DFD040418003FE08A77DA93C02960206A0FBC033D8071D003CCFE276638F7E6B9E535312FC0BEABEEA1CB"
Data "6B7F06F30270D19ED3C09D4F806B00E3A007A894D56A7511FC3FABA5A796870095E10217CE32723FDF27426E79085011142417"
Data "B8708691BBD6A039805DE7FD92F210A04262D3CBE867A943CD9CF2B808AC04D77AFBE6161E1CDE6B83189B091C2B4F0DDDEF2C"
Data "62E521C044F103DF37528400C681001325352309012A818667B440A6EFCE229DBFE93C1E1B05C4CA53E0FDE0C7CA4380CAE84A"
Data "2CA58E0072CB63185811D48A9BA6699B6C18306AB944DFBDFF92F210A0325C80C2A15E6AD227B77C2B80BF5013D40137CB975A"
Data "7EA19DCE246AC8A95B657E7E76AA3679EDD5EB77A2CBA44BEAD75A9A4E70F71790A8BF3D05B80B8431F13FB8F629A8647D3F17"
Data "EEFE0252F5EF2E02B5E7B48DBD3F0049EF7FF1B9EBFBB970F71790AA1FF7018C03018C03018C03018C03018C03018C03018C03"
Data "018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03018C03"
Data "018C03018C03018CD3AE0DD45CA1EAD058A0EAD0DEEF5FB37EDA58E872FC6E9381187B51666D2CAEDD7DA9FA061EDCB9A1FD1D"
Data "14C3DD5C2367FBD71812FB1B608FA059D9D2787F4F839220F8CBE14B4E7FFE69BB74693D7D06082004777F03AD6B008C028C03"
Data "01026EDDBEDFFE49FDF9650702049C9F9DB6FFFAC1768FDD7353020244F0252809BE542F32468F03013AF0039EDBF2257A11F7"
Data "7AAE04FBCA43800E62C1CB81D38B84F5954A9022110488E0072CD69A5329E945BAEAC9AD3F5522DC070888B5567AEC5A72EEB5"
Data "80FF38A5ACC485669F44E1F121404057007203138A542290F467888153C00074F522FE73B5801E6000A47A9131800033FE66D5"
Data "DC3C80E67C0CF30248A47439504A970B4760F302707F5F81763E9FDBFB98174002CD7C3E17082084F6EF5B2805C3C089923ADC"
Data "840013264502083071F649806B0061FABE706E4228E718E1F1BACAA1071046E22EE0107712BBA48200031006AA247012C70889"
Data "49000106C2058C13388963C48EE703010644227043069F800006E89308024C9C7D3D0804983029A70FDC0710A086FD154252AF"
Data "1D200013ED7C3E97C5FB17D7D52A270E0EEFAAD54D93411E32E60368E7F3A9FE3F7F0F58F557D10368A452FD56A79DCFE7D6CF"
Data "A10A016A403B9FAF55FF426B73263278B3D998DFA3479BB607D0B61FE881FB0013E6CBC7A77B5F836B80801AF3F91C4882676F"
Data "BE763E8F1E20A0D67C3E87BE9E000244A8359FCFA14B0208D0418DF97C0E5DA70108D0434DF97C0EB806304C5FF009083061F6"
Data "059F8000C6C17D80997E3E1FFB0328A29DCF97A89F83790138F9FCA66958AD97CA73E70370312F004181C845623E8003F3012A"
Data "403B23FAFCED71D6EB6F5E95A917A300E34000E34000E34000E34000E34000E34000E34000E34000E34000E34000E3B4B900CD"
Data "E5C93550C37C00A97BFBB9B402D01A3DAB9464024338EB2BB5E703FC0306357C93AE129E650000000049454E44AE426082"
Data "END"+t_windows

Data "START"+t_fancy
Data 1+2+512
Data "89504E470D0A1A0A0000000D49484452000001000000010008060000005C72A8660000002A744558744372656174696F6E2054"
Data "696D650074692038206A756C20323030332032323A32353A3431202B3031303033C1236B0000000774494D4507D3071B15182C"
Data "C7685D8E000000097048597300001EC100001EC101C36954530000000467414D410000B18F0BFC610500003E284944415478DA"
Data "ED7D09981C55D5F6A9DEA667CB9E908460200101650F101021EC082E20A0EC8B08C2C70F082882B288A8A0A888A082425410D9"
Data "45D90910594441F62D09843D81242421C92499A5D7FAEBCED4997EEBF4AD9EEE9E24333D73DEE7B9D3D35577EBAABAE79EBD88"
Data "140A8542A1500C3E38E2BBDBD7131A20D0EBBA76E0F4BE0B0522260FE472EE07F035EA959457D2E614151E64C73FE7F87D98FF"
Data "335EC9431DD7FF9EF33F137EC131B35E69F3C7C8FAFDC5FD4F2EA66DC41F03FBE331E27E89C1987C3EEFF79BF6C7888A39B850"
Data "27E2171E97DB67E0B8EB8FDFE0F7E3F89F51EE2B1A7536B15DE82BCE73FFEEF7D5E1F711F3E7CD6D23FE67C63FEFC09C781E19"
Data "BF0DF9BFA915FA30E7E67BA5D92B23FC394661CEFCBB72FE1C96FA6D4C9D7ABFBF34DCAB9C7FCD5AFDEF23FC52E7B76BF70BDF"
Data "0F179E89217E49FBC76370BD72FE716E9BF4E7BADABF0F497F9CA4DFAF9943FBD93F734E28E3795654882202E0E63B2F383F78"
Data "E6E6999B8237991FD698FF49545874B69D0E17B2E9871F60970A04244F8505168176047321E8C3B58C1106AE1B1385CFF1983C"
Data "7F49E878BE39BF603B17EA721F56340F0D1096A85F0C98C03001C5B92001E07BC0C48A1713DF0BB3888751D762AA8731F83A67"
Data "E17FB38813E237E3DC65DD245C07BC277C5F98386760AE3C3E6F20E6B391821B03B78DFB73660287F793371BC55A401101C8E7"
Data "3B77645E24E6E29B9B92E5D3145C1CB82BE6A978F7C47AFCE022876090A0C2C3E68AF3C869F043830B941F4009478CC18B8439"
Data "054930F8E1350F6987B83EF53076960A9C06EFAA7918239410350D2D2218BC10F83BEFF0755420A8BCC09130214794F0DB66FD"
Data "E34C00B80FBC76593896F47F570E8E47A84014D270AC89BA162E13159E2F8F8F0429EE7FE7451CF1C768A7026781D78C39833A"
Data "BF6E1AEE15DE4B65FDD7128A3900B79B1DC787871723DE8C8CFF2977037CC07101E6A8B0C888828B940B3F90BCFBF12EC20F70"
Data "4ECC07771387829C02F7CD3B0C59CE3B300EF79DA6E02EE4C23C2437C3D790895FE84EE571006D305E1EDA48CEC185E3F25ABA"
Data "302E2F5866DD99BB62224550173908FEBD0DFE3869B89F78EDC9EF7F0815C4265EE82CCE99FA2BA9B0E847F975582C33759B28"
Data "48182497C4F796FC79B14829B900C55A808D0330E085C56C26CAA8DD552928A7225B4D14DCD15D689386F37C6399E810054500"
Data "DC2D2401E2FEB2302E139A1CD4C1FA7277E13EF8E137E7CC2E8A7A8888688BD786FCB62CCA94E200DAA920AFF3B54170FFBC48"
Data "F17AA3F8C5F7040921D76742C67A0AD41FE0B5611D441D8CC3F2769BB87669BF2ECBF34C38F837F0EF37042109EDF8BEB18E81"
Data "7F5F9B7FAE9E0A5C19DE6B9E0B3E4F287E28D6206C3A00A908EB3E45057611E54F9BF28CEBE3E297A201D7913B40C432AE23EA"
Data "A3924F1604F6871C052E2C564A19B0AC8B4A3FDE15F94195DC06D7210A17490C07C04A4E949723FE98C8096428B8DBE2B544E0"
Data "EF453181EF4F331508021337AE9F83B970DF861874F87579AE7C3C09C7EB617C54C2D65361A7975C1A839587E67A0FF3FB8E8A"
Data "79F1F5C4FB54F49C2AD60C6C1C002E6A5EE49DA7A8B07BF0032B7749DEE1888A65752997737FAC8966F91C773B7C78F8016776"
Data "97FB40F6BDCDEFA70E7E1F13015E544C440CD842603E1BA9B0234A0E82DB27A0BD2BFE47AEA008BE12906176DAD554D885F161"
Data "678223596154583221421D410ADA3271402E82EF35124B14ED5809B78A0A323BCE19F505A8BB18EA5FF384FFC9560CBEEF788D"
Data "5DBF7FD657A045037F0F7240AA03588BB0710086DAF30D300F156AA79BA02A9B895014200AB27E92B5C39BC90F2A9BD1B83E12"
Data "0EE60EB2701C890F2E10240C92C8A03E232FCE9B7366B744931C2E7096AD6D7A0EA2E08E170A4F04400267E46643AC783765EE"
Data "224B05C59E5C044C58D13A823A072448E65AB4F8BF0B09099A45B15FEEC78CDD40053D8DB9DFA3FCFAA84B6125211219BC6E48"
Data "A4782E2D54200475FE35E0B9F1FD658E81391126DEA1D61545EF10C601E0E265F0C38237DCA6A8C15D5F9AF424EBCC373C26EA"
Data "4893A02BC6C44580E7F97F2922D81E529C032E129BE20DE725D9DA0815732B45681E1AE893891ECBC178CD12542C8274DF1E31"
Data "172628BC8008EE115B15785C5EB461BF87AF135B3DCC71F625E03EA33037DEDD33302EFF0664E9D904683ECDEECF26486E8FA2"
Data "0BF761FE5F4E5DA2076E3A8A350C9B1580811AF2CE53F0E98A73F86054CAB6852D2C12DFE5EE4F1464E94BED1236E2516A6C57"
Data "D4B1CD59FE6F9B7F379A87392796793D148A7586300E80175A1D1534C0868AA34719EF6244417615155344C1854B14DCC59095"
Data "37C88AE948FF00DC21196C5ACC50507EC43E888AE54B9E232A0A252B2FB9036E83DC8E3423DAA032ACA25FC24600D89483BBA6"
Data "140B70A767160E8903C2661920E857EEE292BD36C7D07C16466C50CBCD60C595696B8898616F13A20EDAE4798EA8F760B9573A"
Data "39C979229153286A02616640B9505901241733CA8F2CC345C579AC8F0B546AB7F3E213171B731C36369BC78C5BDAA292D23607"
Data "A9873060CB042B0FD1D1079D7824A7209D57488C532E9C5EB4A918D148FCA4583479297F4F675B6F73DDFC69D5F6A7A82DD838"
Data "0074393590CA3FA2E200133E26957104FFCBC5E98A719055C776EC1F8ECA2D9B7350447CE7DF872EBB6891200A2A0891006429"
Data "A8C84262287D0ED0C418AA87282718E8EC9F395FEF6D9B4A118F379C7FC8DE7F18357ECC36F49B9BA664BCC57F4705CDFB9AB0"
Data "AD1322399061E300CCC3860B4ABAA04AEF335C78588FC471B96B4A739B8D98B068C1DC87E420A4198CA89835272A7027F89B88"
Data "82723DFE3E147758B7802EC7E870839C47B8127028391F7DFC7AD3ACB90F8DDB77D7EFBE67C6C8E533CE9D0F9CB3F1A107FC62"
Data "AEB713A76C6D608E610144BDC1B4782C397AEAB687D1B3AFDEE07103B179DEB1272AE9A0BF1236457908730596B2BEDCADB98E"
Data "8CD4435B3C7B88B1A7173A1291681BB38C852633E99C63B3C7131573215C1717349AD66C6ECB187064D3F623C7622326569860"
Data "A095EFBF9DBC6BC60F3E3F7AF47AEDBB4E3D66C96FAE3F6ADB37DFFDEFB8C3BFFAC3771A1B86B7DBDA98FE673EF5C7092DAB3E"
Data "AEDB6FDA691F5E73E3F1534E3FE1E6E7EB12C66FA977042059D77CD6DEBB9C99ACAB277AF4E99FB5B7A75A7E58691FD510A975"
Data "40D81465C2660644965AEEAA36D75EA2C2CE8A6EBD31E887EBE3E2C350D552A638F4E0432713839CE843122A5460A2E2508E83"
Data "04457AF6C97EB16FA22047542A1CB86DCFDD0E6A5FBCECA2A7A7DF7ACA9E6FBE37F38D57E63CB4D165E73FF6D0D871C3D3616D"
Data "4CDF1B4E9CDCFEE32BCEDAEDD9976FDF6448D3A88E51A31BD78463CCC86C36B5FF1EBB7C23F2EE873369D98A79660EB756DA89"
Data "8C727CFA85DBC6EC3CE5B0C5708D333DB5B1DC172500EB08611C00C2E618538E3CE596798C8FDB64C452635622FF5532C75275"
Data "D1FA51517B0E063AF1B80BDE7DF3ED7F8F9DF9E40D5B7DE7B43FCCDC669B29ABFC2A91B0369FDF65AFE55366EEF5DE7F9FBD77"
Data "D39BAF7FFBF6A6A1DD554A5A1D9A1A4774CAF3996CAA3D956A3DCBFBF7133E178DC64ED8E6B35FC8ADB7DE7A34FDB6E352B97C"
Data "FAE714E4B2CA0246395E7FD3D99BDD33E3AA1D9B9AE3333EB7C3C126E148BEA736A6CE5DF7FFF25393266EBB729B2DF66A21A2"
Data "3541DC1465A2E80172F394F14ACE2BAE57C8FF34DFB35E59ED9516FF33E215C73F9FF5EB907FDC94BC5FB88FBC5F27ED978C7F"
Data "CCF1EB10D47561FC9C5F370D7D64FD92176DA3303E17732C01E7708E0473CAF973897B250625EA8F9F32FA11BF5E1E3E1D28A5"
Data "3880AC291F2E7AA179D61BFF9D307AD4F815F73CF8BBCDEA1B339D5E825E8984B599F3F6CCE12FBE3A73A3491B7E66C12FAEFE"
Data "C614EF981BD606F0D95C2EF3D5E30FBBFCD0295BED7F587DB2F9063C198FD57DF74BFB9E5AFFC98A3769D6DCC79C5C2EFBFB6A"
Data "1E2043A4BC9299FDF643A3EE79E8373BE4F339E7B7D3BFB55B7B667E9D21544D43ED84CDB4F18AF3CEFC2786FFF58E0B3E77C5"
Data "B547EFEE4697C7C2DA28D60E8A2EB4C701E4FD92F34AD62F19BFA4BC92F6FF37755D28A68DE395A85F727EDD94FFBF3917F34A"
Data "C22F1131560EBEE7FD3EC972DC568FFB76FDF33C5F57CC93FCBA112804BF31EBD78BF8BF2102F509FACFC16FC66B55520998A7"
Data "65B1EFFCE0C03D77D9799FB9F7DDF5CA5F56AEFA24F9FD1F1DBAA359C82258A8BB8D59E84B97BFDB78E2F1E73C75CB8D4FDCDE"
Data "D8D8D01A4BB446C2DA00DE884422735299E5F973BFFD97447D7DD35EDEB1E3FC73FB35350E6BDA79EA7E74DFCC2B72F158623A"
Data "75F9EA570C43A0D2B94591CB7E7DEC348F1A763E4FDEEF6AB8E8B2AFEED213617323CB63975E71CCB44C26155FB67C51F3C53F"
Data "3F78A732089B620DC26605C0105D4C24812633E988C30F3EDAC231728FB5F8E63C47EAB1AD9DCD7AE8075E342D0A9AF25CCBB8"
Data "9C7E8ABD02898A75100C7CC05879C9BEF27514D409983962E61DF65F9766CB928E402618E8CEBB6F99386EDCF895D7FFF1D687"
Data "E2F144EB9FA7FFE3F693FFEFEB87756417378C1A39C6A604EC0C20FAE6092719EDFCC75E69BBFD96871EF03EC7539753532902"
Data "906B6D6B39E8A63B2E7E6D979DF7AFFFE905FF489E71DEB46BBCC5F67863C39033BEF6D5B31A52D94FE891C76FC87BC77E55C6"
Data "B362852142B3E7BED178DCD167BC92CD6653D96C26E5449C485D22D9B462D5BB0D1B4C98D46A6B633EBF7DEE11533F5E3C7F38"
Data "1F7FE1A5C7379CFED70B179F79DA8FDFAC763E8ACA502457BF33DB7D89C2BDED78B1B28BACCCAD87DA5DD6A673A08A5CE03299"
Data "24E69743608E3CDB038FA1A826C2AC9D0A04C02C922415026E6C4945CC3C5653210EBF11CE717C3E67B5E108484CDC893E0A91"
Data "C99F713E6BBBAEAB56B8D75341F1D9E2B737F31BEE8F9B6B1EE61C016DAB69538458347EFA84F527FFFCE6E9AFD7FFFEFAEFA7"
Data "FF7EF7EFE7647399CDEFBB7D41E21FF75E4B37DDF68B4756B7B6EC5BD5D3E3CD6BC1079D73E4E7A09348F9736422951D3F31F8"
Data "BBB8CDEC39AF36A533A925F95CAE23128D26EBE275631275C9BAC9933EBD4AB4091DBF82B9AA1F80053625202E7ACC0D881163"
Data "ACCDC7C5247740B426F0CE2923047981B5522139868C44949687B0D05B3431F2EF9244471212FE5D71388EE1C3980508CD970C"
Data "69720CCF07504530D09A0820F216FBD54B972D3CF6C65B7FBCDDD9675C9678EAE97B369E3C698BFCF0914DF4B73B7ED5E12DFE"
Data "1FF5A6FF32A31CAD6DA6EEB49521D8EC0BC019892A56442AAA47D14E35F735F7590AB2EBB6C492BC7071A1A0A38D01DF544E43"
Data "8D892719CC7E1B02601E164E118D3B352698409F0219B0E4F8FDE0038429C09188D9E21530F5990CF809136D3058A8B3DDA7B7"
Data "74B6A4FEB7DB4CACAB4BBE71E3F58F27BD4F4AA53AE8BDF7DFA09F5EFEED3757AD6AD9AC17FDAA27608DC3C601F0CEDEF9954A"
Data "47F9613E3C9BFC2B036824C7C0FD7182490CC2E1BA98C0025359A3179E4C1612F849D057D80313B5F465E33A64361D4950FAAB"
Data "09EB835C2EF7BDEF7EFF88CB673E34279948D4D179171ED3E12DFE8A1D7F04AA59546B7221EAA2EE256C4A40C50044369BB9BA"
Data "A565D9B1BFBEEAFCED76DB6D9FC8E2250B8DFFC19D7D3D2F45DFC2C601F04E88996678A7C3AC39AC14943BA44D7647B65A6AF0"
Data "A59FBFCCAE2BDD8489EC3B2EC6E3637B69A990323BBA34239B4F96BEB04E983762BFC5CA552D87FEF9C6DFBDF1C08CBBE2A954"
Data "EA3252797BD0C3C60160524F3401B2B2AC54BA6A19128B8A43B9B051CE976EC1D89E1591E6FF141CC7392211B2E51F90ACBF2D"
Data "53B074F995CAC2B03C07F88E807E4D00A84B1438F5A38FE65F95CD66FFB406FAEB6B1D80A29708B302A06F3B266C44931C2A03"
Data "D92AC0048228288B63424999930E6DF9E84F2FB9071E0395824C206C598789EC094B7131B30951BA1C4B0E02B914C901C800A2"
Data "7E8D4C26F367EFC3F8EA57E5F823A1D180B58DB08420BCC865C65B5410A2A20E89011FC32C3EB69D141759D8CB3218B823635D"
Data "F63390FDD9A2FC705C4C6586CA46F45B907D48A722CC39101573A906C638B60D55188EEBE130AFDC56619BFB7B31CF00341AB0"
Data "B651CC01B881B05D4CBE21E55FB493CB883DA2E2856703B3E052BBCEEDF3A22FA2E0CB3D505CC1394ACB03C326622047C31607"
Data "4C6F8D39FBE55CB84F7E6740B52AD4A98D8D8DF7B4B6B61A7FFC4A09C0AD4D4DCD5F58BD7AD529541091D6194C64DF7F9EBB79"
Data "CC13CFFC6542E7C57022DD9CDFD7BE78F19C8D37DA69B1AD4D2E97A18F16CDF69DAE9CA8696962511DC7896E307ECB4FCA1D5F"
Data "D13BD8380066B17927441B3CEEE89810C4F6EA6E64B765AC3F411F86534889B644C5C945B88D7C4D14A7BFC6FCFDD887CC1844"
Data "300EF6CFE2052E22F92E009B8E80FB96C94ACB4232993CDF93CB7F3469A34DA2AFBDFE72553771D34F6F7EC49B73E74CF388C0"
Data "97BDAFB3AAEAA44A98C8BEDD773D307DC77DE76FFDF192F747F0F1EDB6DAEF9D6DB7D96945581BEF5639975CF9ADDDE7BEF3EC"
Data "043CB7DF1E27BE7AFA89D729015847B00503C9C018070A06E370D00FB749433B0C24C2FE3250385008DBC8763C160719C5FDA0"
Data "1F2C8E08CCC95BFA20681B117531F0C8F5E783C71C110084C144785DCC6FE9A8E0DA8FF476EE27860D1D79D1BDFF783ABAEF3E"
Data "07557D13FF79E77FEB8E3BE6D4898978E2C5783CFE8D75F90099C8BE51631A3B2E39FFCE27E2F1BA4ED67DCCE84FADF8D10F6E"
Data "79AEA768C09F5C78E77F9A9B4774C70A6C3C699B85E79CF9FBD7341A70DDC1160E8C61C054A26018AF0CE17545FB72CFD9FAC2"
Data "F1649161C4B679BA21730EFB3D3DFDEE52EDCA5502EE525FDF3877EA0EBB7FEEA17B672536993C85B2BD907AD3A9289D7DC6CF"
Data "227FF8FD3D8964B2E10F4D4D434C628FC6EA7B2C1F1CD9B7FD9429AB4E3DE9C74F253C22F0E30B6F7874FCFAC3333D45034E9E"
Data "BC41EAC2EFFDE1F14824926F6A1CDAF6ABCBEE7C6AF888B8ABD180EB0E362B002AD8586186EC33C1797CE0C3D26849A55F583F"
Data "A59285605F528C600B837C1F0023EC65A73847567CA29251FA33A09BB0D42DD87C0C6C8836D4375D92CD65CEF9DE59BF8A7FFD"
Data "90933B0F76780CB14F002EF64B45E8F0DFE7BBE376FBD1DDB7CF8A9F7BC1515F9D35E785CFB5B5AD3622C12B95F657093024F9"
Data "FF9D72CE1BDB6CBDCDFBBBECBCBB61FD4752B1FEA4A8CD41071E3AEF8557BEF9E4565B4CFD64F3CD279B40AED01802C59A4751"
Data "2CC0D38FBAFFA12E39D8DC0C0CEC90CE3168F337F2B389A843871A7E873C12195B5E4199650709820B7DC5C579A282EE01AD14"
Data "A84BE045CB2FE194E3A3F989E5FF0E2A2630AC7BE06017244298EFD0DD796F670AD989CD7A0D0DCD77793BDDB6BFBAEC9F6D9B"
Data "6F3AA537168392C8E57274EDF48B1A6FBAF59709D775CFCC6633D7ACA5A17A150D58411BC55A42982B303FF0CD144C978DBB22"
Data "2F3C0E91E5175BCA05C3ED51B948D097CDBB0E777A3427227140E71FE9972FDF58C44145329E413A1145FD39F3FB0430FF81B4"
Data "2E709B0CCC278C759D9A88271FDC62F39DF33FB9E0CEB91E21C8F3AEBD7610A56F1EFD53DA74F2D4E64B7E7ED4150E397B66B2"
Data "E9C3692D78FEF5261AB092368AB583303320B3D566D7C41D1A090026C6C853C11C1883BEE5CB44C308807415961C808D8DB799"
Data "1C6DB0252EC1DD3B4BC1C52BC51EE964247F07F61F66067CDD719C07DF7CEBC5FD5F9FFDD2CAAD3EB3DBCAB5743FBB91CB659D"
Data "A79E7E3099CD66DBBDC57F3DAD25B7DFBE0A7356AC19846504B2BDB75EE6E03775B270BE9EECF233B3C7190A3ACAA03B2FC619"
Data "D86CFF36943A2FBDF430C290C7240A7A0AE2B5888ABE70E767E227DD7F3163B0446B2ADD7E94B7108FFFDE0FF7F9CD41FB9FFD"
Data "CAF1875F16C87AF3D26B8F8C78E3ADA7475672F318471C7CD15BF87DE1C76FD7FFE8975FFEDCE2A51F2C4D673A4C78F247D5F4"
Data "5B06FA3A1A50D14BD89480F29D780CE94DC7893E0CCC82315A67F41B40E2C0F235C7EF770F475D8E371860249D6C3044D7C6F2"
Data "13157308B8D099F0B0BC6FD001ED906BE17984BD7044BA41F36FE7762575F9F97CEE2F5E79EEEE077F7DFB0BAFCCD8FEDCD3EE"
Data "993172F8844EBF83071FBD7E93675EBC6B442C167FAD921B984EB71F79D0172EEA761E7A60E655936FBEEBFB5FF038803F6673"
Data "E90B49037E142510160C6463FB19985803E3F2D143CF00138264A9584E961A7764AF09FEE74F7CFD9674264277641C835979F9"
Data "F61E99122C4AC11D5DBE66CC169F20AF474F1C0B6356269BDA6EDE47AF5F7DC6059B1E7FEC21574F9FB6D309F35ADB56AFCAE7"
Data "B38FA5D3D94A33F41CD9D1460BBC3E23BFB876FF2FCD7DE7DF3BE6F259E31E3CB3C27E148310A55E0F6E73E30DF3B7478F383C"
Data "8FD184B20F5CA4687A24D107BE924B9A01E5CE2FE78C814918D7E058C6B1F5892642791D6C6F272A578195CAE532DFF2CACCE9"
Data "B79EF4C7A75FB8FDB654BA7555996D8BF0FCCB0FA5AEBFEDA8B3DB3B562EF588C816D4A55957287A444F0941CA95C16D3BA054"
Data "E4C93EC3088C6D31BB547A970D3B2E7D126CF10A617DD9A2FE9C32C6A804E64DBCCFCF7EEB91BB1CC7D9C8FB5E5536DCAB6FF8"
Data "D2E5AEEB5EE5F5A531FE8A8A60B302C89D4D26E1E063F8165DDE61917BC84141363D0363A395406ADB65BCBD5CAC61C401CD80"
Data "328109CE9D28F8924FD7F23FC73964E0988C5C94968A4AF18EB770B7F39A579B9AFBC37C3E674C7CFFA9B2BD6210232C1808B3"
Data "F360641C9ABBF87D7651E84746F3E1ABB3F998D49EDBE2F81D516CDA7C54D8C9FAC8FAA30CCF7D47E17F5ED4590A2E6C94FF73"
Data "140C8526B28B40D56AB8731E113893BA42822B850921D6E0194555B0E900642C3C2BF0D0EB0E77434C1D2EDFE08B3B232E62A2"
Data "20F71096CCC3161D88EF10903BAFCD57407EDAE2FA79A7E771F1371A82C82F0E210A3A441115149FF27835A82649872E7E45D5"
Data "08CB0884AC31B3BFD22C882634749C918B56CAD4B6745E4441199DA8E0A4836F19466DBCDC7591CD473B3F8971DD9031999340"
Data "77629E3BBF7188CD8A322CDA15E32B1435019B0860ECF91C1B6FE201D8CC870400D962260498D483C89E3C04776FEE83E3EF39"
Data "76001734A689424B00417F689224684B14E410F214D439C8F3A82BE0BCFF04734B923D10887F8BED78393073326F1E5A2329BA"
Data "148A4A1096159817053BEF30ABCFC739738E94D36D9A7694C7D17987DB987E8C1721C70DA0EC8D75E531A9D80BE30AD079C716"
Data "3128539BA1E8C2FDF2CB47D85F80C742DF85AAB201C5E375574623D1C91DA9B603D6CE2D5E67E80F3EFCEA6558216C1C002AC9"
Data "A4A71D1201CC0A640BE6C952311760DB390DA761945F184884E7A5E65DEEB6C851C8052E3D09E39679489D00F7898B9B537E49"
Data "3105C7AD86081C188FD51DD3D434349F5D96392B9BCBFCBA3737B3AF71E9193D27FBA482C724269A65CE8AB33B31B7C96F8DC2"
Data "88CDF9D415A466B20F3570DF3FB8CA59A78950060A6C6640C5BAC1C458347EC3F7CFBAE9F531A3470F3FE3DC3D2EF508C0BF68"
Data "2DC7EFAF4DC46201E21A96EC9309265A97F83B13513429B319D93CAB86531C465D0BBF9E8ABD4F1515C2C601F005C754DE7833"
Data "A5BD1DD97F9B930DD7939E7E1C47606E288782727D823E305C17C7E7A01C54FCD589BA11F1BFE45808FAC1DFC561A9F88214CC"
Data "7D88BF332BEA9683682C96B87BAF5D8F9FBDD3F65F5E56DF40C9FF3BE927EDD74EBFE8FE8E8EB64DA96BD72B07FDE1C1EFBE96"
Data "D17891B396D4CFF00ECFF789173DDF278CF9E0EB8DAF6637C79900701F926B545480B07703DA587BE9F32E156CB61BEF588E61"
Data "18AD19BF81EC6FFF210AEE143DC9F8B848A53580938AD87C0F2461928A469E1BFF1E3493A2AB72D922402412BB62F4888989D3"
Data "BEF987FF5157120C3AFAB0EF74BCF8F2BF46BEF8F253D357B7AE3CBCDC1BD89FD86E8F036883FE656C86B4C848710A9F2DCCF2"
Data "9CA082199613BFB27508EFB1A20AD83800DB6BBC25259766321BE5975A7BB61AB02720270C8943FF81A950316597BA09B9F332"
Data "8B1913F5300AD1F6FA329B3F02063A3130DA11E729332297C281D148EC881F9CF9E09FBDDE87E3894B2FB931F99543373FD05B"
Data "7E47795FFF56CE0D8CC7FB0FDB1D8B775A8D30818BAC8316237CE10B5131A1C7670C89162B6273FE9C6CB11A8A3211160C242F"
Data "347A02CA5DD7960B90CFF1FFE879C784854D8BB6D4DFD807B28336975E4CE821890C8E1987BE6CE206CE5D2E2A247032E02902"
Data "7DF6B41B4D749CC89F0E3FF0F2E9634777E6BF1BEEC00C860D1D49BFBDF28EE4374EDAEFBA543AF58C77E89D1E6F60A2FFB0DD"
Data "1E07C0F78245252642490A720219B2BFD149120C24EE385F26E2CD148CE45454081B07C03B253FDC6C02647690A8C09A316BC9"
Data "2FD3E07A047525F1406220450AF426E4C5CCF9F66D8B15EDFA3C3FCCD6831E7E9C705226FE40D39ECDA2810BCA16DC843A03CC"
Data "23503457C789DEFCE98D76BD67DFDD4E370B7B9CADD2D41DA6D1C9DFFA6EDDF43FFFE681D6D6D59FA11E1E6E6FD7ED376C7734"
Data "1EB82EC684BC9AECC965586FC2CF8B2402C88920B14A51B1CE455A651415C0C601F01B6E988567F31C51714E3EDE21B2145C74"
Data "72376262802646827E500440CEC140BE3D58BAE1A2FD9E77271E83E561738E65645C142C7EA0C721FF86C06511BF09E7217D21"
Data "C2F0138FF59FB0F1C45DEE7FF0B12B3E3D64C890919FDBE94B54DF30D6B47456AD5AEEBCFEC6AB94F096CA2E3BEF11B9EDF6E9"
Data "93BC36577B44E0D4523730DE8FD86E8F0388C35826ED1927FBC4FBC8449DC47C648C06519080F3B5E767C51027E33C85792B15"
Data "15A29803E87A34F866A003105362B95099C2B39C8D96034CE8818484C7402EC3F49782FE59FEE407CA460498B5C75799717622"
Data "A2827721472BA6A9B08B707B746796C0852D0391CA0D173698EC38CECE7937F7C18C277F7980F7BF93CDA5B76F6AFEEBC3E3C7"
Data "1DD9D966CE9B2FC44F3F67FFEC9021C35E77FC5EF3F99C09F4F92C9578DB8FC701F41BB63B160FF41996EC13DFA2C4D7362BC6"
Data "C76BCFF71FD3B031E7C7E28DA24AD83800C59AC73BAEEBEEEEBA59CAFBCF7A2C56F791A416C9BAFA15CB972FDDB6928E63FD88"
Data "EDF6380014411A29F86A7799959939AEACE80B73446216281C1B45B934A9085035C28281902D44331766D5412D3FBEAC13FD05"
Data "880A379359713C8EA642191D28C38C651831515086455F7FCC07C0EC3C2BB070D7C0F9C4E05898B9D0668AEC537804A0DFB0DD"
Data "DE5C30C763BDFFD9E117E648F07A2321426B91B4D4C8580FBC4FFCDC28AA409823103E1CE68632F5B6BDB403D96264A551A917"
Data "8173A89D66DD810BDF1B2818809485B1A56C2E9558BC33D8129AD6518188493D8301BAFA4ABF07A2C24388D18964E9A702800D"
Data "C0E9518760453C11B80E7DCA764763DD91A34C6438D8AB1DAE7154CC032D2B6C816093A42D092B12249B054A51016C1C80B961"
Data "BC00F92670282CFA06A05F3D6AC0519B8CC7A4AFBEA4E0D88EDB3201E21D013DF4781E79E8837743F41740E261CE272DBF5B26"
Data "F590198CF00194730853BE958453F26B053730DE7FD86E6F2E1848856F97463D02EEFCE830C6E829AC1C15BF661EAC7F525401"
Data "1B0760A8353BE8B0FCC7DC807CFDB6BC5936360D157878B39178A4619CB0842444F6B05F7CDF00EE2C7C1EB5DABC03C9F71330"
Data "01C9407B242E6826E479E1AEC50F78450FE288E1E39835AEFE06F623B6DB1747F85A7028396F16DC177200A86F90BB3C12DC28"
Data "152BA5C9BF5F52B9ACA800360E8035E9E8238F0F3C3F2828EFE38343F07F9E828B226FA9CB0B8BE7826F0E4AC3FF3642C321CB"
Data "E678428CCBE3E12EC673960B9535E83642E28AE3BC5322A469B02C34350C37D7BA5704201EEF3F6CB71F0C94F5C73673605D01"
Data "4663D6FBF7B5DD725D994B63E2603ED92FA58E0ACF836D135054019B19906FACDCAD0D3AA8C0C63551F143800B4BBE5D583A9C"
Data "F003668E25A9B008DB44DDB045CBF3CA88B171DE32EB10B79121C3A67F1673642C82CC0120DBA372729DCBA2FD89ED8EC503EE"
Data "D318971183BE5254883770E19C8C41E19D9EB9184CCCCADF57FA9FBD22A28319360E809570A89C63361B7713C922CA987866D7"
Data "6CCA43A2205BCAB2BB8C2540E523EA08A4BC4E145C803C07D61FC8D787CB3716BB5047BEC804839D903B91B10295440322BA89"
Data "AC878A5D5AFB13DB1D8D752F62F612C5F6DCBF31537650718425C624205168A7A0F216DD945BA9203E2AAA40D89B81A4790D17"
Data "60A95D0E1778B9E632A9799739F6A4B79A6C1BE6CF4FA2AD6C27EBCBB1704C9B4EC1B5F4D12B0E20164F2CACB44D3CD17FD8EE"
Data "58BC3BAA10E3364C1F497FAC15D4B56B9B32840A9C84B44EF07B27CDCB520C47D8EA9F375CE77A541073D062A1A80261C14028"
Data "07328B2C595F22BB9DBC92DC78D2D42659751C53720E0C99CDC7C665D8163C7FE2C323C743E59EEDB7CABED679504A7F62BB63"
Data "B1C0EBE0890ADE9DE81BC2D7118905067B711D33DFE55E594485380EF3F2D4E154104578F7572B4095B07100E62632CBCFF223"
Data "C780334B8E917206E88A8B310436A512DAA6314FA02D1807FDD8990D448D3CA6114316370BF38A5250F38D8B97FB4305211232"
Data "7EE0CD83C7D184F8FE000C5E42FF82F2E0140853B5AC83EF0ADC2FD86E6F2E7CCFF1DA64FDF1F97A9A3A26059C210C6D626C33"
Data "2F36D332C159EDD76DA0E0F566EE0263381415A2942720EF2A98AD176563DE25F821429751A20221C0C5EFC098F80072DF1CCA"
Data "8B3B775CF4C76D597BCD4406E3D9B10DDABF51A4E1F3B883B03EA21EEA716C01C71CA4A8D8D78077FF6A3980AA1FE0783F62BB"
Data "3D0290846B1A833E4D7F1D5488EF3062CA271424001C2FC29B8D4CEA12F7CF1115B814165D1455222C1600CD7CACA043B7519B"
Data "7D1F9D4EA40D5D26DC20681711FDE0DB818982BB382ABC700E3C267B0346C538592A1085B088449BB5813920747A428D3AEA07"
Data "4AE5A6DBCF719CEF3B4E341231C543269B1A252BB5B5ADDA74F8F0512F7130507B7B6BBB8793A8743050BF61BBA3B1CE856D08"
Data "88211E9CE8953905364B9AF11BFDF6ABA9C06DA0699237820CCCCFCC15777C26626A01E805C2A201516B8C0B0CD9AD0E0A2E6A"
Data "7913A5E61CBDD3B83E8FC5F5A5198A090B3F0018196890A6A0B69A1D79F0E1CCC25C31CE80A04F823E70AE982F004D6AD22108"
Data "6DEA36CCF0CA59F15872837D3E7FE6CD43878E183964C890B7C78DDDD8F4D96C3AD97CD3ED337FFCED8CE189246D53E73DE6E7"
Data "9E7F727AE1C28EE95462F1774EB41FB1DDDE5C8652D0948B5621F430E41C0309FFDE3854483812F1EF6B07DC7BCECA8C8BDDD4"
Data "31C466241544144585B07100B82B205B2B136266A938D8468A00E8D68BBB3C8FCD7DA24C8D8B137DEF51EF20890CEA0F384109"
Data "C27C674E467A322644FF5257C1F5D06109E780AC74A808E0BAEE51E94CDBECA5CBDF1F79F8413F7E2BD940ADC93A1AC77A80E6"
Data "E661EE0E53A691779C6EBAE5CAFCC2851FBDDDDABAFAF49E6E603CD17FD8EE582CB060514710B1F48F7A1B8E63E097AF30D767"
Data "E6DD48050296A4E0C6C4B910D50A50256C4A405CFCA825979A7E763F453BB10C32E1801E0E2291C93719BC2BF08E4E5490F1D1"
Data "0E8F04C266A2E3871AC50899262C22FAE063A82494494DB2703C2AEADB586D1B3E71DDFC91CFBE72CB3F5E9D73F42F779CB29F"
Data "BC069DFFBF3EEB05BAF467E7A552E9D457A80C9D82B7EBF61BB6DB9BCB622A10747C3E9058F23D42C723696D32F36DA28222DA"
Data "10A12154D0F9F0E6504F0591475105C2740036375069FAB2BD08541E475959C6024848AF3D64F9112892B8E27FF421E03E5109"
Data "69F36570428ED938021423C8D2AE27CCF43881ABAEF9EB31C76DB7F587B77473AE7E0FAB56B7D0374FFE629BB7F84FA032F201"
Data "1AF427B6DBE30058118CE21F5A87D85B91FBE75FCFAECBAC6F61DD50935F07F347F266C2F10E29FF5351056C1C40186CCE3436"
Data "7BB86C6373AC591370CB3C564E3F3DF90B50C879AE537634A0C705FCB0BDA365EF5FFCFEE03D7E74DE7D6FA01DF09C1F1CD1B6"
Data "BA75D5ADDEB7DBCA9D7C2CDE7FD8EE683C20EEA17997BD310DCC423784A4810AC48189058B6E686D6AA4E02662389DD57E69A5"
Data "82795351056C1C00CABFB80BCA08318CD567F310B2947C63F9C63195AE83BE6D21C1BC23D95EFC29FDD5BBA74D419F7554C6A1"
Data "2FBF2DAF2089B632CE9FD96254364A5F0247F45F0AB96C367DC84BAF3F34E791C7FFB4EA2B079CD0C915DDF0B7CBEB5E78F1DF"
Data "1F7674B49D5A461FDD88F723B6DB0F0662AE0DB9911CCC8F9D92985BCBC0BC58AF245DCAF1393404C498365BA86095A886F02B"
Data "C86E052895DE1A4D76788331424E2610C5072F6CA744F91EE54DC9EE4B82806D65E1F912F4C18B419AFA90BD4736956DDFBC3B"
Data "4AF65FFE8672F1513E9F3BE6DA1BCEB871EA0E7B3DDFB26A7EFDB5D32F4AA4D3A903A84279D6E300FA0DDB0D5E89321519730C"
Data "EDFEFF712AD6353001608B04128A3A2A7EEED0294C958055A2544E405C588C30F91B9D6D18E8332095779D43897ED8275D9A1F"
Data "31112912014444146C8B44831F76A9CB90DE89A833907A0329C6A005A3122270773E97BDF9C24B0F3A70E9B20F9BBCC5FF0D2A"
Data "53EE0FDCC044FF61BBFDF702208758E77F5FE9B75D425DBBB7B90F43A8206A6056E676FF781315CC987C5F127E9FED545066EA"
Data "E2EF056C3A00A34CE287089D460C303B0EEF30EC3997807AE82423593B04EEBE71F86E5B6436252312178CF843CD36B39972D7"
Data "270A66C291DC879C97DCFD23A22FB41C94854C3675E6BC0FE7EC168D441FA40AE47E84FF66A07EC1767BC4683D0AEEEA89CE7E"
Data "1D6A740C1170A8C1E9D22B74BA8ABB6691BB9D568CCE7070D7B47103D9A091A3E1E720EA389D2F2A19EB7DB690CAFFBD424F4A"
Data "2F4575A844D13991BA3CEFAA3165F587FBD5CD1965D27D379D7882FD271595C016DDA7A5F7A5127C40D5DBB1FBFA7776FFD63D"
Data "F7DCFB2EF36A792E2EFCDF59F25D259783E21FCBBB65967C717F9D7D7AE5B4D3BE3DAFCA6B38A8A11453B146B0BAC59DE67D3C"
Data "DE875378BC69A8B3475F5F875A83BE5249B146905549BC26A10440B14690D5B49C350925007D87E4B851DB7EB5A961EC1E1127"
Data "3AC16404EC3CEABA054D9AE3584534C73BE192DBA3C6CDA1607B6E238FC3F9F9ABDB163DF2D1E2E7FE49C5015525A11C406D42"
Data "1280FEA0550E033EB4B532CF30346C387ED79FEFB8C5C95F993461CF7C73E33899EE1C3FD1F98A4D9E32BA52C65860E00E5E33"
Data "99DEAC5B91E7BA795AD5B670ABB73E98B1CF73B3A2DBCD5FF4CC45540111C829075093B07802F6AFB575CB2DB7761C79E41145"
Data "D167A79C724A5F4F2D806F7FFBCC8ECD37DFACACE41413D6DBFE985DB63DE32B5B6E72283A201960FE3D5B8A6EA97D0FD3CADB"
Data "AC1136A72EA81FA1E143D6CFEDB8E509148D468FC866DB672D5CFACA5FCBFDFDCA01D426AC2240AAA33B7456BADCF2273AF8E0"
Data "4B4319590ABAA7F2C32B1378DA1038F7F7BFDF3931ACE295BFBEA6DFCCB32E4913A94C0C6B9EF0C54F6FB467241A0B7843CA78"
Data "07C9054827271960558A43C2380DC965C876EEA693F68EBCF1DE3D5FA9880028075093B012805CB6282D975C54D2E34C66F329"
Data "955E1B3F6D283B62B056E659D4D0C9279A9B4648B6DDF62A2E844C43265FA186AEC8D88F13F2DD1175BBBF8F18B67E2E4FD9E6"
Data "4A7E937200B5092B01F06E26066A10051708C6C7E7C577464ED4210ABE26ACDCC5557281D5CA3C253A05F968D1CE8FFF1385B3"
Data "F9F2F7A0EBB28D2B906DC9F2895C45552E75CA01D426C238005C58B645858BC9B6EBC8C83D663FCB595CB6456045ADCC53C289"
Data "7426D044259EEC078903CE1103744AFD062400114B7F047DD892AB76CEB112E49403A849F44400888A1F4229AF120517031EC7"
Data "483EB2D4B52DAEB2A3EA6A659E1211C7717C02807DD8FAB62D7EA9EC93BF5DEA0EE4A2B7E94B8A3805A74216403980DA442911"
Data "80617BB8184EC8FFB8587A32DFD96454A744FD9A9B67714FAE1B8D06169F4D0781BF49CE8BC7964953B03E8655DB8883FC0DC1"
Data "292A01181408E3006C76E9520F7998A249A2A78512B6235A512BF32C6AEC748A0036AD3F12011C4B5A2624F71036C7220D3FFC"
Data "1F6655F0FFAFCC1EAC4AC0DA444F04C0C0263B4BD81EB630AD74D8EE2ACFF5A85CAB957916F7E2BA7EF20CEECB26C6D8928F4A"
Data "11C026E6D87E1F730BF89A7312F5025C41A53A00E5006A1376112053723149D6B594A6BCD4C2908B2F6C9C50D4CA3C8B07EB14"
Data "01C216A36D6EBC80F1984DAEB72DDB527E02611C47A79EA292DFA44AC0DA44180710C64A5713EF8EECAB3CCE085BC0251757AD"
Data "CCB3A8C32E1140E622240A6AE4C3ECF47C0C2D1C390A8A0AB26D39F35325E020449812302C17BF75B7807364F91E569FEB84E5"
Data "74EB51CB5E2BF3B4B5103A0064DF2511425F055CD0D2D4290980CDCF80428E15CDB062114039809A44290EC08630E5574F72B7"
Data "AC8F908F5AD98BA956E6593490D3ED0864DBB11DCB77DEE5716C1B21932F5CE57E6CEF5D24CB98050EA0C2DFA41C406DA21C25"
Data "6098CC5CEE020863C7C3BCE86C72A915B532CFA281BA38009B161E21539A879936313290FB916204131A741F2E29BAA8127070"
Data "204C04900A34FCDFA64C2BA53197FF1395BF707A12016A629E129148A72390DCF9A50580A8F83D0C368D3F7A2D32A7C0F5A2A2"
Data "0F39E7700EAA42B2A64AC0DA4418075013A895794AF8228081245A3240089D7C241782FFA35B2FE60B40DD85F9CE69CFB3544C"
Data "7C703EAA041C245002D007700A1C40F721B22B006DFE0661CA487EE311179B57241F2FC51D75C502544A006AF45E0C7694B202"
Data "F46437970FA7AD4ED8B930B9B7547F353BCFA2464E7730901C1F6313A4294F9A0AE59CE4CE1FE616CD7DE035432EA193102907"
Data "3038D0931F4098761A11B6804AD9E26DC12C78AE2CFB75ADCCB3A853A7281CD846046C73C0DF2777765BD49F345F462CE3C9CF"
Data "2E4F40E50006054A29016D8A354439FEF0A59468BDF2A7AFA5791675D8C501E0D83856B9C76DC48815806105FB91B105816B51"
Data "2901D09C80B589300EC0A60DB7C129E37CD8E22A2768A7A758809A986751A32E0E00157C36BF7F9B8C8EBB3A5A0CE44B50E5DC"
Data "F95C960A8A429B0EA23B398A720083033D2901C3761EE9C082E7254A2DAA528F59397E003531CFA206916E0E40CAE9613EFB06"
Data "D2CE8FE28054FA85290A519F10A6DFE86AEF54180DA81C404D224C04B0A127F354D80E564E82CD526385A256E659D4A8D81598"
Data "E72A61F3D8C3458E736605A04C942A2D0C682990C947B978A28486030F06546206944A2F7CC0C2425789820F71390BC629B35E"
Data "CDCCB3A861C10FA0D2F628CB4B775F69CFEF29484A061405AE83EA000607CAD50130A4920D4352E5C28AC039DB5B88C3FAAF84"
Data "00D4C43C8BE1BAC001840505153512E7A537608E8A958032D71FBA0DB3D2D0966E2C12A9D010A81C406DA21C11C0A6E42AC7CD"
Data "16171466AF0D334161DF652DAE5A99A7048800A8C80B53F8E1EFC0DFD9D3EFB54544F6A40CED3E57851FC00AEADBB703BFDC87"
Data "63D72C7AE200CAD18097AAD753E86DA945D5E3E2AA9579164DA84B04C85BFAC3B1251B2FEBC8FA28EB3351439181AF833917A5"
Data "E2E8C00001AA94005C748DF38AF7B14765AD147D8DB08C40986CD240EE2444E539BF94E38567DBA5A4E2CA8A5A99675167413F"
Data "001EDF269EC8F16C4A41B2B42967AE927805DA544A0014B589300E007711DBE232A8444B1CE68CC2FDDAE4F27238809A986711"
Data "22DDE1C06173740A3503E2494F28E5E1875E8061BA84C01C15031FA5AC0036AF3A444FE7CB816DF194BD986A659E129DEF0588"
Data "0696982DAF01BAF7729D528E4761F23E7F67021009A917F8540E6070A0123F807E875A99A78471048AC54A720E36FD82D3433D"
Data "039BE3927416220AE61EB4B904BB955A0114B5899E94803DB1B795C8D908E9D482FD95ED5A5B2BF32C9A4CB10E001767A9DF60"
Data "530ADAF40314528FBFDB388B0001D0E53F3810460058B9860F97CD73AD27C71369C6420F369B4C2B77AA9E74003531CFA2C605"
Data "472003F6CB9779FB785E32A34F98A253860DDB7E63BC87EBD4ED21A81CC0E04098082017163E9C92252DE5771EA6900B5B5CE5"
Data "EEE835354F09C80988A6399BE39201A7FC260A721E3D1133062A2ACB169A74F90F0E847100092A0E2C09B395DB1E6099C3CE20"
Data "4C9E0D7B88C31EF09A9BA704E40494D17D1248789867089B071205C90DB017E06A2A161DE45B90FDB954160BA0A84D1411805F"
Data "5E7A5BE6D97977ACD7D713EB09877EE5ACCC5EFB53BF9FA71D9D6F06EAFC87828B5F2AF46C918295F83548B7E02C05177E583C"
Data "81EA0006098A08C039E71F1EEFEB499583BD0FD8B426E669433416C9B5B5AFCC35370F9172B82D15188A35B6F8019BCB2FEA01"
Data "D0DFDFAAF187CFCEFE162F59ECC4E2D18EBEBE4E8AB50F49006A85EED7CA3CAD58B2E4E3C79E7DEEBF5BEDBBEF17D2140CCF0D"
Data "5B98A5DC726C160ED47B201711A3628251A4DF78F6D9FF443F5EB470465F5F27C5DA47B4F75D282AC5871F7E387BC992C59BAF"
Data "3F7EDCE40913D677E3F158241221C72F04C585634E89429676FC694ADEAF17156DF07C3E956AA7871F7E287AD5D557CEF8CF7F"
Data "9FBADC9B6ABAAFAF9562EDA2A677D21AC7B069D3A69D3474E8D05DBCFF936BAA53D70D57DE39BE873FD6C1FFBDD3A9969696C7"
Data "9F7CF2C9E9D4A530540C70D80840AD6A7F7B1303D017F35328FA1C5633E0FCC71EDBA1AF27560936D8638FE7ACBFE35FFFBAAE"
Data "AFE7D639BF3DF73CA9AFE7A050D86025009E80383076AB4824D7FB4E148A818B014D003C99B69C105A8562D0C24A0068801000"
Data "8F022807A05094809D038846070401F03819E500148A1218D02200A908A05094441801181009A11C1501148A9218D81C808A00"
Data "0A45490C680250635680C95E79A7AF27A1185C18D004A0C6AC00D752D78B357EDAD713510C1E0C6833608D5901CCBDF88957B6"
Data "F1CAF15E69EDEB0929063E06340750A34AC043BDB299570E221509146B19039A00D4B012700BAF3CEF95C3BDA271F98AB58681"
Data "ED08545B4A4089615EB9CF2B7B7BE589BE9E8C626062607300B52902304CFEBE534817BF622D624013801A5302221651970EE0"
Data "7F7D3D11C5C0C680260035EA0AFC0C752DFE8FFB7A228A818F816D06AC3D11E07AEA62FB6B6DDE8A1AC5C0E6006A4B04388F94"
Data "E557AC63683050FF812E7EC53AC7C0E6006A5307A050AC330C680250C3560085629D20D6FB2EFA2F6A4C045028D639AC04C0CD"
Data "E7FB5B4EFDEAA02280425112039A00A808A0509446180118180B47450085A224063607A022804251127625E0002100FA662085"
Data "A234940350280631063401502B8042511A039A00382A02281425612700B9DC802000CA012814A531B0390025000A45490C6C02"
Data "A0228042511203DB0CA81C80425112039A03681C35EA81BE9E8342D19F319009C08008695628D6260632015028143D60600703"
Data "29148A92500E40A118C418D88E400A85A22406B61950A15094848A000AC520861200856210C3662BAFD5C5AF767F8542A15028"
Data "140A8542A15028140A8542A15028140A8542A1500C76546B3BDF2F168BEDD9D0D0B06B369BFD543EEFD6C562D105B95CEEF5F6"
Data "F6769384E33EAFB454D1EF48AF7CA9B1A171BF4834B285D7F768F386DF6834FA81D7EFE3DEF787BDF34FF4F5455328060A2A25"
Data "0053EBEB1BAEAFABAB9B70D8D78F5A306DB73D5BD69FB041AAA1BE21F7D65B6F36CC7DEB8DC69BFEF697511F7CF05EA3470CCE"
Data "CBE7F3D796D96F3491487CC775DD8BB6F8EC564B0F3BECA86593266DD2BED18693DA57AE6C897DF8D1FCBA99331F1E7AD73F6E"
Data "DF209FCBBDD1D6DE76BCD766565F5F3C85A2D6512E01882693C9F3A2D1D8B9DF3AF1F479DF39FB820F3C42109A33E0FE07FE31"
Data "F2E21F7D6FD2A28F17CE696B6B3DD43BF44989BED7F7FAFAE7C4891BAD7FD1053F7B6FBF7DBFB42CAC627B7B5BE4E7BFB878C3"
Data "EBAEBFFA53E974FA428FC05CD9D71750A1A865944500BC1DFF1743860C3FE1EE3B9F7C71A38D36E928A78DC7AE3BDFFCD6C19F"
Data "79F2DF8F7474A43A76F00EB55AAA0DADAB4BBEF4E52F1E9AFDF52FFF3CD7132BCA72439E35FB9586AF1FB9F7B62B562CBBC223"
Data "023FE9EB8BA850D42ACA2100873534345D77CFDFFFF7EC261B7FA6BD92CE0D11F8DA91BB6D396BF64B4FA7521D87CBF38944DD"
Data "A35377D86DF24D7F79F8F54A27FEEA6BCF371D72F8E7A7A6D3A92F7B5F67F6DD2554286A173D118068B2AEFEFDEF7DE7F2C5C7"
Data "1C79DA826A0658BC7841628F2F4CDAD55BA8BB7A5F5F80537B353634FFF35F33DE796AC4F0D1D96AFABEF6FACB3EF5BB6B7F9C"
Data "E8E868DFBC8FAE9F4251D388F470FEF03163D68F1F76C8690BD229A26ACAB0A1E3D3471F7EC67BF5F58D0156DD5BFC979C70EC"
Data "39EF35358CCECA360F3F7ADF88238E9DB6FD8EBB8ED97BDF2F6DB6EB15BFF9E1866D6D5947D63BE198EFCF1BD23C7C94D7DD17"
Data "FBFA422A14B5889204C05BB447EFB3C7D79656BBF8B91CF8C593167822C05E5E97757ED723DB3BDA76F8F201DF5C28EBDE7CEB"
Data "B5E34E3FFBA09D9F7FF1C9B1CB972F49BEF7FE9B43AFB9EE922D4E3EED806D6D7DEFBEEB41CBBC791ED6D71752A1A845942400"
Data "F95C7EFB5D773E7849BAC35B6CBD2863476FD23174C848E317B0BDDFF5F6E3C64E5C3AB4697C1AEB2DFBA4257AC5D5DFDD2A9F"
Data "CF158926CF3CFBC8F83BEF9A3E56F63D659BBD3F2197A6F5F58554286A112509402ADD3E6AE4F0891DBDE5004C193E6C8C5120"
Data "8EF5BB1E3B62F8B894AC33F3F17F7A9C416B3C6C3E4FFEE7DE31B2CDF8F5366D4B675263FAFA422A14B58858897351F3C7CD25"
Data "5CB3D07A8B8813C7F162112756D46F5B6B7BB4541FA9543A2ADBB8F9B8EBA1643B854261472902908BC793CBE77FF47EDDA489"
Data "5BB7F576A0652B1625BD8F45FED7454B962E48C8C5BCE5E67B2D8F44A2AE4D0430D878A31D96CB361FCC7B27198FD72D4EA57A"
Data "3D458562D0A1A408108DC4663FF3DC03A37ACBFE2F5AB420B1A265F130AFCBE7FDAE5F5EB4F8DD31CB97B744B1DEA8E19B74EC"
Data "F9F9E3DEB1CD65BDD11BAD3A68FF73E7C9BE9F7FE9E1911127FA4C5F5F4885A216519275CEE6D24ECBCAA55FDCEBF3A72CCCE5"
Data "3C96A0CA72CF8C2B27BCF3FE73EF65B3698E0D5895AC6BFE6AB26E68D3E4893BAFC2BADB6F7DE0D2F68E95B90F17CE1E9AC9A6"
Data "A28623F8ECA6BB2F3AE7D4BB5E6CAC1F9D957D5F77D3FF9BBC62E5A22B486303148A8AD1932350632C969877EAB17F9DBBD376"
Data "5F5F5ACD006DED2DD1332E9AB88BF77930053DF60E6B6E1A75CDD5977CF07422D150D5BB081FFBEFF4B137DC71FAD874A67D43"
Data "EF6BAE4FAEA04251C3E8497996F1E4F1D6396FFDFB901DB73A72713CDA9CCB65BD955641F9ED0D476CB670F19B73F2F9ECC5A2"
Data "EF596E3E77E4E2251F8CDA7AB3839655DAEFC74BDEAFFBCD9F0EDE3A955E7DBAD7D76B7D7D21158A5A4439DAF3E73C22B0DDCB"
Data "B3EFDF71FB2D8E5A1C71926EB9ACFF8D77FDDFC6CFBF7A47533697DA972CC1405EBFF72EF878CE77B3398A4CDE605A4BB9FD7E"
Data "B27C41E2E77FD87DDBD6B64FFEEEBAF99FF5F54554286A156599CFBCDDFBDE74A66DB3C7FF77CDDE75899199F1A3B75B5D6A81"
Data "CE5BF04AC3B5371FF299D96F3F94C9643BF6F1BA981FD2F5AABC9BBBFFDD794F9FF8E6BB4F8E193B6AABD58DC9B199527DFFEB"
Data "99DF8EBFEED6AF6DD1D6BEE2568FB09C46B5FB221385A2CF516942904362B1E435C39A27E477D9F6D4059B6DB4DFB21143374C"
Data "C5E30DF98F97CEAEFF68F14B4DCFCFBA69CCDCF71F1D178DC47F97C9B69FEFB529C78BA031116FB82297CB1CB7C52607CEDF7E"
Data "8BE3168F19B969DBE8E19B74B4A75AA24B97BF553FF7FD47463CFDF2756357B52E4A7BFD9EE8B599D1D7174FA1188C30FEFC27"
Data "7B8BFEAE78ACE143871C13C9E746A3894FEA12CDFFF3FE378B7E72957D6FEA38918B4D3FB168D22406714DFFF158FDFC44BCF1"
Data "76EFFB715488275028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028"
Data "140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A"
Data "8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542"
Data "A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140A8542A15028140AC540C3FF07E98C59A4C0CA"
Data "03980000000049454E44AE426082"
Data "END"+t_fancy

Data "START"+t_white
Data 1+2
Data "89504E470D0A1A0A0000000D49484452000001000000010008060000005C72A8660000002A744558744372656174696F6E2054"
Data "696D65006F6E2039206A756C20323030332032313A30343A3135202B30313030E67A5FBA0000000774494D4507D3071B152318"
Data "DA6E4603000000097048597300001EC100001EC101C36954530000000467414D410000B18F0BFC610500001E524944415478DA"
Data "EDDD076014D78137F0B7455BD47B0344AF4184268A643AA2096CD34D0C0EC698103B39C7D8719CD8775F12276EB99C43CEDF97"
Data "73212E7036C6C6F422101D218A040221219A24841AEA6D7BFBDE93B464BD6C53D91DADE6FF4B9EA51DCDCCBE59F6FDE74D2704"
Data "00000000000000000000007A264127A6F5A565D4AC59B392FDFCFCFA4A249258FA5ACEF50241BBA80C064369636363F1B163C7"
Data "0ED1D779B428B9AE14784E4702403660C080944993266D484949194D4586868692E0E0602293C9B85E1E6807B55A4DEAEBEB49"
Data "656525C9CECE2E3D74E8504E6A6AEADFEBEAEA8ED13F6BDDF8D6FD46C44F9811121A3155A351CB040262E4FAB3F046269349A9"
Data "D3E9AA8B0B6F66D4D5569EA383AADB3B8FF606C080279E78E2BD55AB56CDA18D3FD0DFDF9FEBCF00BA10ED0990DDBB77D7EFDC"
Data "B9F3C0DEBD7B5FA7834ABAF82D24237F3CF1F91123C7BE326EE2F4FE31B17144241271BDD85E4BABD512AD4645CA4A8AB4D997"
Data "D373EFDFBBFB5F972F9DF98AFEC9E540753900E472F9A4B56BD76E7EF5D55727D01E00D7CB0E6E949F9F4FDE7FFFFD333B76EC"
Data "F88542A1B8D645B38D9E3A7DEE5FE62C58B23269EA2C1F8944CAF562F6285AAD869C3A7ED89071F6D8D6D483BB5EA1836A5D99"
Data "CED50018B271E3C66D7FF8C31F12222323B95E56F080E2E262F2E69B6F9EDABA75EB5AFAB2A893B3938D9F94FC65F2A26796C7"
Data "F51BC6F5A2F568B7F3AF905347776CCB3A9FF61C7161334EECC23CFD172E5CF8EE2BAFBC82C6CF23717171E4B5D75E9B565656"
Data "F6FB63C78E6DA483D41D9DD78449D37EB570F1B225495392B85EAC1E6F48FFD9442E56AE32E995672F679EFBC8D9F84E37C0C6"
Data "8C19B366D3A64DBF484C4C9470BD70E0592CF07D7C7C065EB97225AFAEAEEE4607673364DACC94F7E7A6AC88200221319A4C28"
Data "6E2ED1317D84252545037273B20ED3CFBFCED13F8EB31E40684242C2C6B973E7FA71FD65046EA4A4A4041C3D7A74534141C151"
Data "FAB2B1BDD3F78E1B3CB557FF3143CA2A7174D193FA0E4A18D13BEEC4CC92E2DB058EC6731800A1A1A109F3E6CD1B89C37BFC15"
Data "18184866CD9A15BF7DFBF6512A95EA6C7BA71F3C78F0D4E953C791888828AE1785577A478E27996707CFA001F0A9A3F11C0640"
Data "5252D2E2F8F878B47E9EA39B81013366CC483978F060BB0340AD31C456D7E9884ADBC0F562F08A4EDBFAD93B1BCF6100F8F9F9"
Data "0D080F0FE77A598063EC44AFA0A0A00EEDBEA7DBA422BDC1485801CF11887C5AF60738E33000F47ABD0F3BC30FF88D7D07743A"
Data "5D87BE08017E123266643FAE178197D867EF8C2B870181E73AB30FA8A1494DAEDDA8E07A1178897DF6CE2000C0ADA412318908"
Data "C341242EB0CFDE190400B895582C24FE2E7445A1EBB1CFDEE9385C57127AB69ADAA6F4975E5CC7753578A9A6B2B4C8D9380800"
Data "70AB9C2B67DEE4BA0E609FF33E0200F4580800001E430000F018020080C71000C077AC0DF0F674570400F05A6040D0FCD090B0"
Data "855CD7832B0800E0B31193274F5D3F6C58FC13C4F55E408F3A74DEA31606BAB790D0B0D1FD070C9A2C1008071A0D06A35024BA"
Data "7B23F7DA19A55291E7E6B70E248FDECC247CEC9809BF5EBFEEDF04172E9E0DCABF797D5A6D6DF51E27F389EED76FE0AF8A8AEE"
Data "FE27E9C02DB8BB2304007882FFA81F8FFBD9E4A4696BA6CE4836854744D5E875BAC6F2F2D2B1C78F1E5C9579F1DC37B76EE67D"
Data "419C3C944426934F88FFF1D87946A33152A55416E6E55E65CF2FC876F2DE715191313F7F5059FE17F2AF3BE54A860E19F1D233"
Data "6B3686D306DD585D53298E8A8A49A601B08FD8BFA5B6FFB87193FE943C7B41F2D1B483FE5959E7D96DD39BB9FE603B0B0100EE"
Data "26A48DFFD5556B9E5B313F65B14028149AA223FC87F9CA7C24B50DC3F2C78C4D28DFB963DB8AFD7BBEF3BD7635EBAFF6E6313E"
Data "61F2EB895366AC9E397B8169C8E07EE2C2827B353BBED99672FEDCE96F6EE6E7DABBF965DCB8B193FE98303E71F8AEDD5FE7D0"
Data "1060F7CC27B1B1BD9F5A307FF198A4C4E9B5353555F2DD7BB61B0B0BEF7C4EEC377EC98811A35E5FB6F427493366CCAD91CB7D"
Data "67D25ECBA61B3772DE25AE3F4065D0F0E1F13FA7D3FC37E9FC5D96BB0C0200DC8A76FB93A64C9FFD246DFCCDB4F1B3C7C935D7"
Data "35A86A888904F78A0C98209388AF2D5DB1FA4E61C19DF9B417704AAD56655ACF23202070FAE4C7A6AF58F7FC2F152291D03F36"
Data "2A286AE880D88143860EBEFCF69FFFF8F4BDA2BB57D56AF579ABC9C4C386FEE837CFAE7D2176F8B0F892ABD7B29EA40170582A"
Data "950D494A9CB17CF9B235351A8D5AB8E5B30F8332324E6FB6F5BE6D8483060D7D2165C1E29469D39259B75F989C9CA2ADABAB59"
Data "AA5034951717177DE2EC33080E0E993665CAAC37E6CD7B7CE0C183BB47A7A51DFC2D7DEF8B5CFFDBB42C1CD715809E6DE8B091"
Data "F3A74C9B2DA28DDF87B4AE2DEB355AC3BD8AEAE67385A5F57BC243E46302FD7D03A6CF9C6B18367CE4545BF3183D76C2AAB9F3"
Data "9F60F330994CC4505CDE905F5AD994D3BF77D8A8397317360D193632C5C6647A356D64555515243030489D3C3B252824246CE5"
Data "E449535F5EB7F6C506A14864FA72DBC791E9E927763636351CB257FF98985ECBE95AFFE9458B96E9E9FBB3A79988E94FFD9225"
Data "AB9A67CE98F7425858780AB14F487B1BAB172D5CF6CE8B2FBE1A3E6EECC486177EBE2972D9B2A737D3F9AE24DDA0FD715E01E8"
Data "D90402C180A8E818F39D291ADA0ADB21D7A054E94A9B95BADB91617E837BF58EABA7DBF8C36DCC42A8D3E9C2C3C32335F4F787"
Data "2152DFA8CED51B4C0D6347C7CBA8FEB6DEBBA8E8EE81E327521B6977DD346BE6FCAAA4C9D3973EFBD317C4745EBA7DFBBE8B3A"
Data "7A74FF99B2F292CF889DAEBF542A7D6CFAB4E44D2B573C23904824ECBD590FA6E5DA6689446A5CB5EA599FE9D3E6BC41DF7FBC"
Data "8DC9FD870C19FE1B3AEDA6E79FFFA5203828444187A9C2C22214CFAFFFA5CFF265AB7F3B70E0905FD1619CDE73130100EE4457"
Data "D9468158ECC31A988E964A5A584330B695A6AA5AC579A3C9A424C454AFD3EB6C3DA9CA484CA66ADAE536FFED6188DCBD5FF755"
Data "E6E56B455AADF6BE9DF7AF2E2CBC7DE4D4E9B4205F5F3FDDCF36BC5C4DB7E59BD2CF9D0CA7DBFD770A8BEEFC8DD8DF861F969C"
Data "BCF0ED356B9E0FF6F70F10B5D5D7405A379B5910F80705050B9F7EFAB9501A02EFD0D796CFCB8B1C3B66C27BEB9E7DE127CB97"
Data "AFD1D3B060D34BDBA6D5D3A0533FF5D45AF2D3677EF6B3D1A3C7BF4D877176E34DEC030077628DA6B8F4FEBD3EB4B1B086C6D6"
Data "A26C8DC7C280DDB152AC50E9EA69C9B85F7C2F886E175FB63593DBB76EEC3F75E2C8C49FAC59CF7A120F4344ABD5690F1DD815"
Data "7833FFFA57F62A50525ABCF7C8D1BDB3A74D9D2D888E8ED5E4DFBC1EF0D5D75BEA73F3AEB2466B6F2F7E2CEDBAAFAFAFAF55FC"
Data "F9ED37EE9A8CF47F348504B43FC3FE487B350293A9F58E9BEC77F63334346C7D6D6DCD7FD15FC3E9B2AE96FBFAF6DFB3F7DBA2"
Data "DD7B76988402A1908D4767D3823DD6572412D7B3E9E472DFC101FE81BF686A6EFC92BE74780F7F774000805BDDC8CB39723EE3"
Data "74E288913F666B4FD6F85983D1B4FD64AF7D0C068330FDCCF1C082BBB72ED99A474D4DD581B4D4FD4974DB7BDEDC054FCA4342"
Data "420D151565C26FFEF7B3D8F3E74E9D572995271C54A1826E0AA4D15EC0A231A313945BFEF9A1F0E2A5F43FD3E1650EA6292B2B"
Data "2B7995968E2C72754343FD9BE9E927B9FEE85D820000B76AA8AF3B71F278EADC010387CE983E734E0D695DF3B3ED68F6DD93D3"
Data "223AB06F67CCD52B99594A8522DDCE6CF49997327E575E5E7AF678DAA179343022F47A7D39ED196C6B6E6A3C4E9C3C0E9BF502"
Data "8EA6ED4BBE7A2D33303BFBD2FB74503ED79F4B7781000077D3675FBEF4EE968F376B0B0B6ECD983D27A52922324664D0EBE4B4"
Data "41071CD8BB33F2DCD91367684FE143E2B821EB4B4B8AF7B2D2813A54DCBE7333F5D6AD1BCAFA86BA131D98BEC74200802754D3"
Data "35FC9B8D0DF5C91732CE4ED5EB757D0D06BDBF8F8FE46EF1BDC22D65A5F74F13276BF1CEAAA828DD417AC0997B5D0D01009E62"
Data "2C2CB893CA0A47EFDFEE079BF2010E0302F0187A00008F1AD4B76FFF97FBF4E937C07CB88F98C80F1EB4676AF943EBA141E66E"
Data "C1AD5B1515651FD03FC54647C7AE1C3468E83076F890FD9F8D6F3E84C8A6613FD9A141360B36EDADDB37F2ABAA1E6C25CE2F6C"
Data "EA7208008047DDA9A828FF62D2C429FFD8B0E1A5603F3F7F76FE013B8F41D8565863660DDB5453532DF9E493CD3559972FB0AB"
Data "198B59A141504903E09DD56BD6C78F199DC0F63B988F7AE849EB390C2C04022F5C382BDBBEFDF374DAF837B74DEB71D80400B0"
Data "815DAC7334EDE0EFB77FF38552ABD59A4F5C3263616050A994D21D3BBE549E4D3FF1965AADB25C7B179C3D7BE2C5FFF99F0F0E"
Data "1D3EBC576E341AD9F8ACE1B32061A703090E1CF85EF8C9A7FFFD7DC6F9332F138E1A3F831E00801DB5B5D5078E1CD9D7CBDF3F"
Data "60E3F265AB85143BA597ADC555B4119B76EEFC4A9276ECD0DFABABAB6CEDD8ACBE7A35EB8DE6E6A652BA867F6AF9F2D506994C"
Data "4EE86BD9B7DF6D33A5A51DFCE8EEDD5BEC3266572F27760B0400807DC67BF70AFF79F8D09EE890E0D02573E62C3477DF4D070E"
Data "EE0A484DDDB7B5B4B478AB83E9D5B491FF6DD7EEEDF7EBEA6A5E9A3FFFC9B07DFBBEAB3976FCD03B74D3815D81E8D6439FAE40"
Data "0080DBC964B20943068F582293CA069987997786597AB8C3CDEA775BE3589F8B6FFEC9866B349ADB770B6EEDA2DD729BD716B4"
Data "93F646FEF5FFDCB56B7B786050F09449131F539C3B772A78FFFE9DA9B7EFE4FF9D386FC4C6B2B2926FBFDFF57561FECDBC97F2"
Data "F2AEFDD56A738153080070ABC080A0A98B5296FE7EF1934F1907F41FACF2F7974BDBFEC41A706BE3113CDCBE36FF345AFC6E22"
Data "AD3BDD4C16D358363AF34E39814E6BD0AAD51A136D9863BEF9F6CB898752F7FCCEC18D3EDAA3F94AF6A5DFFB7EEBF7FF14CD4D"
Data "E3F61FF83E9D76EFD9C5444A5767A056AB332F5FBEF01CE1B8CB6F0D01006E3564F0F067D73CFD9C6952D298018141B23E74D3"
Data "59F7E8DA5F606AC72CADC77D7809B1482490A914DA0A3F3FF9651F1F1F7D61D19D35D95733BB220098EAF4F493AFD7D5D6BC9E"
Data "7723E74FA4633705ED568D9F4100805B0985C2800989A3FB4AA4E2C0DB371E1CD368F4E69B8398D7F2D60DDA441E5DDB5B8F27"
Data "20160DDF3C4C2C164A7AF70D1D1337203441A118984E4320B68B17A78036FE4DA4079D528CC380E076121F91BCA2B43EB7ADF1"
Data "5B36668155B164B251888DF11ED2EB8DBAFB45B5D932B924CAD757E6636F3F4227F598C6CFA007006E5770BB8A75C32D1BA3F5"
Data "DADC7A98F9B575E337EF0FB01B020683514F8B522416B2EFB686EB65EFEE1000E0566D7BE72D1BADB96B6F1D08D65D7F476B7D"
Data "EBF9B9634DCF0B0800F004EBB53CDBF4B40E0162318EB3C64FACE6479C0C033B1000E009960120B031CC566FC0721CEB79D90A"
Data "01EB69EC6E2638D1AFADB45711E9460FFC701502003CC17C1C5F481EDDA6375AFCEEEADADBBAD1131BF3E8684FA01F2DD33B30"
Data "DD49820000B0CB1C02B6D8EBF63BEA09D8DAA968F91EDD7253A0330F4875C7C3551100C005EB066F8BADCD06421C6F32987B19"
Data "8CD14D87013BAA330F48ED9287ABDA8200002E581E19B06CE0B60EFB59FEB49CCEFA1C7C93D570CE2FB4B1D09907A43E326D44"
Data "98DF085FA958D2D03C2CCFC587ABDAAF18D79F0C8005674160398E25CB6B08CC4717BA4D00583D20953D1FA1B1AE4155A854E9"
Data "1EB007A4F68909EDBF74C5EAF21FC58F9E2F93C9C7DB9B9676FD850AA53AEEDEFDDAA81B77AB42EAEA158FC544040FB537AD2B"
Data "1000C0054767F959F60C1C9D2A6CEFF76EB70FA0330F48B59856A2A48D3FE76A96F6FDB77F9BFBEE5BAF655FBC70BEBAB2A671"
Data "94B387AB3A8200004F3139289604767EB79C8F57E9CC0352CDD31A8D2699C168101F3DBCBB9C6EFF6BB41A8D7AEFAEAF0B541A"
Data "BD2930403AD2C1C3551D42008027B8DAF8CD58C3B7BCFF9EADF999C7B377A25047CF03E86A9D7940AAE5B4069D4EABA3B4A636"
Data "1A1A023AAD564BC341EDE0E1AA8E2BC7F5A703BCE0A8AB6E7D8A3063D9F8AD83C05EA317588DD75DBEDBE607A4B26D7FB697DE"
Data "FC80541F62F180D4FBE58DEC01A97EB44DE7D99A562814D4CA64BEE2F851E3425BF604129369ECF8C9113E3E126355ADF2948D"
Data "695D82A300E049B62EEB75B409606F1EB62E20B20E0881F92E415CEBCC03522DA6D5CA6492CB0B1E5F3E76DC84A400B6333122"
Data "22DA4F26931EA6D39A1C3D5CD591EE9292D0F3D96AFC963F6D11D829C4C93067F3F5A8B607A4669C3C7E2498B4AE7425E4870F"
Data "48951CD8B7B397AD07A45A4E2B120A1A7DE5B2D37DFBF6BBDEBB4FDC395F5FE9372291A0CADEB4AE400F00DCAAED641C5B17FE"
Data "D83AD1C7DE7E017B270559FFDDD930AE74E601A9B6A62DA3D3D6D06903E9B4B12E3E5CD52604007892BD7B0298D96BB496270C"
Data "59FFB4DC8CE84E8DDE5A671E90EAB687AB2200C0936C0580BD9B7C589FFE6BF9DA686398C31B85B4431169BDB0A723D339D399"
Data "07A4BAE5E1AA0800F0045BDBE5E62B03ED71F437F3FD046C9D33D0D97D0045C40BAFEAEB2804007882E5A139576E02626B5ACB"
Data "D7B6D6FED6BF77E7CD816E0301006E65714B304B263BC31C9D18D4EEB7E67AD9BD010200DCCAE2925C5B0DDE9AF5F5FC8EEE21"
Data "606BDA1F0EE826E70174670800F0044777F3B5151046ABE11D0E01700C01009E2670F2DADECD3ECCE35A5E29F8C8C94062B1D0"
Data "472412FA6A353A1DD70BEA0D702620B895D164543EA8AC905A0DB675F8CEDE197FC4C1EB1F5C3E2C9589657D07864F5034A9EF"
Data "1715158AF47A7D471EDFC52B080070ABC2A2BBDFEEDCF595BCBABA929DFAEAE8441FCB2224AE87C2C361B17D4246E9B4FAA64B"
Data "17727376ECDCE65F5878E73BAE97BFBBC32600B8554D4DD581EF777F6DCACCCA5821128AFCD8305BF7EAB37E60281DC5E9893D"
Data "968F046F1B7481FDC76030341514DEDEDCD0507F8CEBE5EFEE1000E06EC6CACA8AFDAC705D117814360100780C0100C0630800"
Data "001E430000F018020080C71000003C86C38000FF32DD03EFC19E0F709EEB053543008027B047564DA025D243EF57415A1B5976"
Data "3BA79BEE81BAD5130400F048222D636939484B312D7A37BF1FFB4EF7A3E571D2BA897BB91DD39EF4C0E7A1EEFC2CBA0E0200DC"
Data "8D3DAFEE4B5ACA3CF47E2C60EED0F23D2D4F92EE1700DD0A760282BBB1075F78AAF15B2AA12598EB85EFEE1000D053B97B53A3"
Data "47400000F018020080C71000003C860000E0310400008F210000780C0100C0630800001E430000F018020080C71000009D13C8"
Data "75053A030100D039EC526776D5A1575E598B0000E8BCD1B4AC235ED81B400000748D585A3690D69B91780D040040D7F1A7E519"
Data "D27AFB33AF800000E85AAC4D2D205E1202080080AE778E964CAE2BE10AAFDC7309D04D6969614F41BEC675455C850000E81AEC"
Data "76DFDB49EB2DC9BD060200A0F30A68F98E1625D715692F040040E7E4D1729A1623D715E908040040E754725D81CEC05100001E"
Data "4300404F85EFB60BF02181BBB14363E11CBC6F342DCD5C2F7C77870000776327C4B00775867AF03D59E0B02BF42E72BDF0DD1D"
Data "760282BBA5D13293968DB4483CF49EEC09BCEC11DCA7B95EF8EE0E0100EEC60E8FA5B515E866B00900C0630800001E430000F0"
Data "18020080C71000E09456ABE5BA0AE0260E03402C161B1B1B1BB9AE2370ACBEBE9E4824129C54D303390C008D4673AFB6B696EB"
Data "3A02C75800343535DDE1BA1ED0F51C06C0850B17F6E6E5E5A1FFC773393939EAF4F4F4835CD703BA9EC300282B2B3B7FF4E8D1"
Data "9B7ABD9EEB7A0247D46A35494B4BCBA13DC12CAEEB025DCFD94EC08A8C8C8C2F4E9E3C895E004F1D3972444D7B821FD15FB12D"
Data "D803899C8D505A5A7A53A7D3252426260E0C0808E0BABEE041454545E4DD77DFDD4F57007FA62F355CD707BA9ED300A054D7AF"
Data "5FCF15894453274E9C1821954AB9AE337800DBF9FBD65B6F656DDBB6ED25FAF23ED7F501F770250098F27B547373F3D8F8F8F8"
Data "703F3F3FAEEB0D6E54525242DE7BEFBD6B070E1CF8755D5DDD05AEEB03EEE36A00B0C340B7B2B2B2328A8B8B87040606F68A8B"
Data "8B130985388FA8276127FCA4A6A66A3FF8E083B48F3FFE78036DFCB89EBE871374609AD08484843593274F5EB568D1A2512346"
Data "8C9087868612994CC6F5B24007B0BDFCD5D5D5243737B779DFBE7DD7D2D2D2FE79F3E6CD6FE99F7006180F742400CCA2636363"
Data "278D1F3F7EA1582CEE457B034800EFA4A26BFEB23367CEECA46B7C76A8CFABEF720B00000000000000000000000000000000D0"
Data "63994CA621B444D38273B7E107DA732660F4E0A123170F1F113FAD5FBFB8417E7EBE2E5F47C0B5C6C6267D5959C5ADEC2B9927"
Data "0AEFE6EFA683AA3B309B96E58F8CEE35592814F6E17A995C25168B051B37AC8BF3F7F76B68A8AFBB7C2CEDC81FB76CD9728FEB"
Data "7A79891EFF9D772900A432F9D8458B9FFABFEB9EDB30A14FEFDE42B9DC974ED999B3883DCC64224AA582DCBB576CFCF4937F9C"
Data "4C3DB8EB65B54A79CDD5C9D9F24F9DB96073F2FC25937BC7F5178586461081975C0825120949688094FE436B89A2A9C174AFF0"
Data "D6AD77DFF9D39A9C6B572F715DB7EE8C2FDF79579628FA27CF6C38F0EBDFFC6E6C40402031D219ABD47AA2D519B85E44974925"
Data "222297FAB4FCFBD5D5D592F7DEF9D3D9EFB67FFE0471ED2E37D1735296ED5EF3DC4B1323A362B95E940E13D3208889F0276A55"
Data "1339752C35F7E5977E3ED5C5E5E723DE7CE79D3E1C74DC84296B9F5DF77CCB07A1D6EAC9836A05D11B8C5C2F5FBBF98885243A"
Data "DC9F84848492B5CFAE4FBC7A2573E5ED9BD7FFE16CBAD1E3127F3A67C152AF6EFC0CFB37ABA86E267131C164FC84C923122626"
Data "ADBE7421FDEF5CD7AB3BE2D377DE6900C48F1AB520B6572F62309AE81748410C5EF841303ABD9194D306D0273A90C4C5C50927"
Data "4C4C5CE44A00848486CF8CEB3F98EBEA77D967C0D66241C1A18204BAFC2E0640282DBDDB7E7A1B7665630569674F874FDF79A7"
Data "0110191EE62F95CA489342EBB51F84999E7E20AC2BE7EBEB47FCFDFDC25D9B4627090A0AE1BAEA5D46A3359000BAFC02620A76"
Data "326A60FCE8840D03060D5F353E6152EFBEFDFA474A243E5C57DF656AB5961416DCA9CACA3C5F70E766DED6FCBCEC2FE860971E"
Data "6EC2A7EFBCD3001089452DFB09BCB10B644B55AD821869B2E7DDC857705D17CE38DF99259B983863F3CAA79F5B33674EB24826"
Data "F59E866FE9B1A449114B972D8F3874E8D0E89D3BB6FEE8E2B913BFA2839DDEE19A4FDF79A701D0D3B06E1D38D677C090154B57"
Data "3EB3EAF1450B5A0E7BB12F8F4AE3653BC17C44442615135FB9942C59FCA454A3D5ACBD7FEFEED1F2D2E25D5CD7CDD31C7DE779"
Data "1700E0DCB0E1A35626CF9AD972FB67854A4B2A6B942D7BC2BD8D50282051A17E34047CC8BC39C9F253C70E2FE5630038E21D07"
Data "B3C1A3FAF48E090F080C203ABDA1650FB837367E86F55C1ED4285AB683434242484C4CD440AEEBD4DDA007008F88880897B09F"
Data "0A958E7867D3FF17165E0D0A0D110B8544D1ACF49E6D180F4100805D5EBAE27F447DA3BAE567754D8D8EEBBA7437D80400E031"
Data "0400008F210000780C0100C0630800001E430000F018020080C71000003C860000E0310400008F210000780C0100C063080000"
Data "1E4300F094542AC5BF3D2000F84A2A95E0DF1E1000007C860000E0310400008F210000780C0100C0630800001E430000F01802"
Data "0080C71000003C860000E0310400008F210000780C0100C0630800001E430000F018020080C71000003C860000E0310400008F"
Data "210000780C0100C06308001709B8AE00801B20009C888C0897F48A0A20BDA202B9AE4A97100A5BA34CA5521BB9AE0B70CF6900"
Data "0885228356AB212261CF5907D6D55411B1D8A7D99571952AB546480C442A1111B1C8BBF392FD1BCAA562A25629496565750DD7"
Data "F5E9AEFCFDFCC45CD7C1539C7EA32B2B1F5C686AA827BE721F2214F48C1028B95F48AAABCA4FB9326E55D583F4A2A2E296DFA3"
Data "C2FD1EAE41BD0DAB7754987FCBCFFB2525242727FB08D775EAAE84C2D66661349AB8AE8ADB394DBA43FB777D306DDAB4C563C6"
Data "27C64485F99107350A623479EF075353FD801C3FB2273327FBD257AE8C9F79FEF496CF3FFB74C91BFFFE7F46F8F9FA923ED181"
Data "A449A1E57A31DA85357A7F1AE022DA83513437912F3EDF72C5D5E5E73383B1E76F25390D809292923BC7D20EBF46BFFC7FEDDD"
Data "7760644C4420D1D0EF7F4DBD9278530CA868B7B7B4B8901CDCBBFD527666C66FE8A03217272D3A91B6FF65B94CFAB775EB370C"
Data "8F8E8A26218132AE17A7DDF47A1DFDB72C259F7CF48F2BA78F1F79C5D1F2DF2F2955D735AA894AADE3BADA5DA6B9B9D1E57105"
Data "82D6AEAEA087F4781D71695BE7B32D9F6E8B0C0F2B1AAB51FD878F8F64605D7DBDE1F32FBF2AE5BAF2ED21128974F5753517B3"
Data "B3323EA52F8BDA336DD583F2235F6CF9F0F1FC1BB91B468E1C9914161A221789455EF3ED30E80DA60755558A1B7979672E669C"
Data "FAD8D9F2E7E5E6567CF2D187F9EC774573A346A968D656573D5070BD1C9D6132992A8B8BEED4BB32AE442A3FA43718AFD04DDE"
Data "6AFAD2A569BC414868C423CBD2AE2F31FD105960C4D122A3E998C7F50281DB84D3E2DFF6BBBAADF48486104D4B05D795000000"
Data "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
Data "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
Data "0007FE3F5289C2A10ECD1BED0000000049454E44AE426082"
Data "END"+t_white

Data "START"+t_grey
Data 1+2+512
Data "89504E470D0A1A0A0000000D4948445200000080000000800806000000C33E61CB0000002A744558744372656174696F6E2054"
Data "696D65006F6E2039206A756C20323030332032323A34343A3338202B30313030C89B264B0000000774494D4507D3071B152E0F"
Data "EC13BD89000000097048597300001EC100001EC101C36954530000000467414D410000B18F0BFC610500000C214944415478DA"
Data "ED9D7D4C14E91DC79F655F40100EE1E4558952510FAF1605A34D5BEF208D561A434D4BAE2136525F8A265B83F194461AD33F4C"
Data "3CE3FDA1C5C41A953BB5A7D65E93229560A4C64BEE480DBD5A5F1A455044455EA24660E56DD9DDFE7E2C83B3B03BF38C3BBBF3"
Data "ECCEF3499E30ECCCFCE637CFF37D7ECF33F33C33430887C3D12F06D1B24B6B67027C7EDED0E3397B6012FF535757A7B5F3AA51"
Data "585848B5DD810307BAB5F6552D2A2A2A9295EE6352BA43B861329914D59870830BC0648AD0DA074DCF5F6B07B4C66C367301E8"
Data "19DE04E81CDE04E81C2E009DC39B009DC32380CEE102D039BC09D039FC3E80CEE14D80CEE14D80CEC9CFCFE71140C7E8BAF623"
Data "BA563F870B40F7E8BD09A045E9D43143806CA86E8F0B80927BF7EEC96ED3D2D2625BBB76ED745FEB0F1E3C283BFD6CE1C28531"
Data "523694DA4376EDDAE573AA18178002EAEBEB9F536CE6B3F0CC66B3516EE7ACAC2CAAC2A7B527071780022C16CB449FA9AFAF6F"
Data "6C392E2ECEF936FBABEDCFDBC205A00021C38787870D870F1F9E1E1919E982F0FA1AFF2AD95FC066B3192E5DBA14555C5C3C18"
Data "11A1BC2CB900820C8E1B389D4E72E4C891E8CECECEB1F07BE2C48998EDDBB70FD014A078DCC16EB7A39D98D6D656B46358BF7E"
Data "FDD0DBF8E3EF39F1CB4005408D3356575747DFBD7B77A2E2DCB871C374F6ECD969B80E93DCFE423A76EC58F478E1932B57AE58"
Data "1A1A1AA2E4F697B22795A46CF008A0809E9E1E634A4A8A0B42B67DF23AE81318131313259B02A1C69E3A75CADCD4D4E491F720"
Data "224B52521259B26409B53F6A44002E0005CC9D3BD700C957A7CF4064AEDD8536BBA8A8C80969C4CB7A45FEF03E4090F137C385"
Data "FD67CD9AC5843F08170025FDFDFD2E7FAFBBA18930C5C6C6AA3600A5C67D008FA783C3F0E150B5329BDF0AD6396A0849EDA167"
Data "55ECF1CB409DC305A073F4D4047C00E943CA6DAF41FA4AF43FEF0384011F42FA03E5B6B89D58007C3898C38783758F5A378282"
Data "E1CFE9D3A763F2F2F246B2B3B3ED5236B80014D0D1D161BE79F3A6D9DBBAE5CB978FA4A6A64ACE0D100AECE9D3A7461C0AF6B6"
Data "4D414101B53FBE04D0D6D6667CF0E08179C3860D8372E3055C000A98376F9EABA6A6C674E7CE1D8F7CCBCDCDB5E3EDDD089931"
Data "61A13070BBAAAAAA689C57205EBF78F1E2D1CD9B3753FB83F6BABBBB239293933D8477EEDCB9E88D1B370E464747CB461C7E19"
Data "A880A8A828E3CE9D3B8733323226327CFEFCF90EABD53A82EB688783A19D27E5E5E5C346E39BCD719069C78E1DC34AFC415BB5"
Data "B5B551C25032A6EBD7AF47827FAE9C9C1C42331CCC05A000AC71B1B1B1117BF7EE1D49484870A5A5A5B976EFDE6DC7DF709D5C"
Data "B815B6C1B46CD932D7962D5BC646047188B9B2B27204ED28F567D1A245CE3367CE582E5FBE6C71381C11D0513543ED1F151F4B"
Data "CA066F021420B4B9386EBF6FDF3EFBF8B2EC30F0E4FD050A0B0B5D030303A32B56AC702AB123B68736EC76FBE8C99327CD8D8D"
Data "8DC6E2E262477C7C3CB52D2E0005880B3033335358A42E346F9DB692921217A1984B20650F0A1D45E078F8F0A1213F3F1F7FA2"
Data "8E245C0094B03E1C0C3D7E323434A4F8DE809E8683F9AD602FE829027C4526DDDE55001F0EE684275C003A870B40E77001E81C"
Data "3D7502FD263E3EFE8F717171895AFBE12F7D7D7D2F5EBD7AB51D973D0440FB9915BD020278B7B6B67681D67EF8437B7B7BA7D5"
Data "6A358000C6FE170B40F72F4C920347F10C0683B1A1A1E1BF5AFBE2E7794409CBBC095000963F8AC062B198FDB7A6ED7908CB5C"
Data "000A301A8D068C00A12E00F130B458005A7F43CF5713C48C5F58FA1801CC80C63EF9774206C3A8B0EC11016866BEAA4D7373B3"
Data "ADA8A8487222E4FEFDFBBB82ED577676F6F4C97E6104186F02423A72C2793884E52927525353A3C587142505206EB382C58205"
Data "0BA6F8247402433D02C0694C4C14357959A9B57FDE1CD6DA8531441120A40580E7212C7B1300739783ACF8347E1510F29D40C9"
Data "AB0056329B459FD08FDEDE5E5B1834015C006FC3F3E7CFBBCACACAD8688FFC3C0F61990B40018F1E3D2A83A4B51BAAC23B813A"
Data "8747009DC305A073B80094A1C66D6956CE650C2E00E5F8E38BD6E31A53E09D40F67807526FB00EC623007BFC0BD2CF203507E3"
Data "605C00ECB190B845F00B48FF0CF4C1B800D8241E523D242BA463813C101700BB60D9FC09520E710BC1E19F39DF07F180C5CC66"
Data "D1A720B215520AA4758130CEAF02D8E711A4DF07CA388F006CF33571770603364B8B0B805D3E8784AF0C0B48DB2FC005C01E38"
Data "631743FE81601C8C0B803DF026D0A5601D8C7702D92368858FF008A073B800740E178072981BD2F5072E0065B0E2876AF04EA0"
Data "CEF11080CD6663A9B64D802F519E3E9DFA431A1C0578BC2994215FC4B0EA1787C3E170381C4EC8C23B386F4F58744E7DBDEB26"
Data "66FCEF6B4A3BE9903A34CE90A0A3C53B95F0523D2F2F4F357BBE048005BF9FB867A64ABD631F1F62D807E9D3A0E70423747575"
Data "39FDB7A218D5EE8C49BDEDEA1348F846CC2F897B82C2E44F9AE11738FE3CBEAEDD870DE3F8318625D6CBCD78613AD43A9D5A94"
Data "BF7A4809001F4FC229490D907E0CA914D24DE26E1E501C385519C5714AC206162ECE6AC5071DBE9DB40E0584F3DF6BE49C6439"
Data "D4BA80A03BA72272EFBBC327538E107761FF9BB80B1E2729E2D32B4F89BB70E53841DC931B512C9F8E1F139B8DF721ADA175B4"
Data "B3B393C9500B1120AC05807C4CDC11000B5D3C3DB914D20B8AFD31FC63244101FD84B8E7B863CD7F5F89A3ACD63456FDA28546"
Data "00588058F05F8A7EFB0751F6DC1A361D9F903702C22842239E0958AD69E1DC0710C08EDAC7937EC39AFC3DE22E581AB0DFB05E"
Data "F43F2EFF4D89A3AC66B41E2200D6DA15C43D5D196B3116DE1C48E789FBB9359A0F1E0B97893F84348FB8FB159B209DA47594E1"
Data "08C0A45FB4C8096039710B00BBE1BF246F42391660297117EC6F656CFC74FC38D8E6E3FD856F88FBC38C6803AF30DA0905AC66"
Data "743847000CDB9F13772F1E9B00E1AE20FEFD3571F70370DDDF89747FE039A42D937EC3425F0BE907845200AC6634AB4D132D52"
Data "02C042FF1DF17D9D8E6D385EDF6344C01EBEAFD79A5C9738C637B48EF2081018A4C602B076CBDDDFC7F5BF82F41D12E0F7DAB0"
Data "2A0056FDA2456A2C807620087910684759CDE8708D00CCC16A4687731F00F9202525E523C8FB95FDFDFDC9B1B1B11DB0FC754F"
Data "4FCF1922DDB6AB6E874780C0E04B00EF2424249C82735BB36EDD3AD39C3973487A7ABAEBC9932709ADADADDF3D7FFEFC6FA2A2"
Data "A22EBC78F1A28C4837156AD9615600ACFA458B3701244E9B36EDDED2A54B676CDDBAD519131333315C9B989848727272C8AA55"
Data "ABC8A143878A6FDFBEBDD266B3BD47BC179E5A76848CD63AAFBC12EA1160CA68D78C19332E141414C49797973BA076BA1C0EC7"
Data "940485E9AAACAC24B9B9B929B0FD17DE0CAB6547006B5AB0134D06A230839D0229802228ACEF9796968E024EB9B46DDB36ACD5"
Data "ABC75320EC4CE0D2009A0C64D52F5A3C9A0068AFCB56AF5E6DC20F0B02F23B9B4C18C64DF5F5F525BDBDBD97A5EC3C7EFC38E2"
Data "E8D1A36668EF0DD0217459ADD691A4A42497941D31ACB6B5ACFA458B8700868787974147CD81B592D6404646860344F923393B"
Data "555555916D6D6D6311E7E5CB9786E3C78F9B2B2A2A86A4EC886135A343BD0F201680F1F5EBD7EF262727DBA0E0A84F2A2D2D8D"
Data "0C0C0CA44BD9C1764B287C8196969608B140BCD8F1805501B0DA39A5452C00ECACBDEAEAEA3243EF9DFAAC3A3A3A0CB07D175C"
Data "DF4BDA993D7BB6032EFF26BE5A9C9999E9100BCD8B1D0F58AD69ACFA458B4713000577A3B9B9790514969DD600D46CFC986293"
Data "9C9D4D9B360D54575747435FC0989595355A525232208E00DEEC8861380230E9172D1E0280DA77E6DAB56BCB57AE5CE9A27929"
Data "03B4F58686868608E8B8FD55CE0E74FC46F7ECD9D327DE4EE820FAB22386D58C0EF508E051CA706DFE99CD666BA9A9A989A4B9"
Data "7CBB70E182050A068782FF12083B6258BDDE66D52F5AA6DC0984822BBA7AF5EAFF40D8D3D6AC5933E02D1240A119A070A39A9A"
Data "9A464746467EEECDB05A764419CD644D0BF508E0ED5670BBDD6E5FD4D8D85873EBD6AD2CB89EB7A7A6A68ECE9C39D3D1DDDD6D"
Data "7CF6EC99A9AEAECE0205F69FF142F3F52263B5EC309DD1AC0A93165F8341ED508373A060365DBC78F1A3A1A1A1258383834931"
Data "31313D66B3F95BB85C3B0DEBBEA0B0AF8A1DE820DA58CD685685494B283C1EAE7506FB7C77113EB2069DD780BDCADD1756AB35"
Data "9904F8F170966056A41899423D0284820098243D3DFDE4FDFBF7EF6A74ECF73A3AD4791DC3FF016B0CF5315CCF61B900000000"
Data "49454E44AE426082"
Data "END"+t_grey

Data "START"+t_hell
Data 1+2
Data "89504E470D0A1A0A0000000D4948445200000080000000800806000000C33E61CB0000002B744558744372656174696F6E2054"Data "696D6500746F203234206A756C20323030332031393A34333A3431202B3031303007004AA60000000774494D4507D3071B1535"
Data "2377FD1AF0000000097048597300001EC100001EC101C36954530000000467414D410000B18F0BFC61050000149E4944415478"
Data "DAED5D0B9814D5953EFD187A8619676086C9F018181419D435190DE84208082BEBBA90688C1B410D868D26AE66DD24BBEAA79F"
Data "1A88AF049335BA1B9F8B8B1A7C450DD1B092CD86C897C717F4FB544844E515010501790C0C303D3DDD5DFB9FAEAAE9EA9EBA55"
Data "B76BBA1EDDD3FFF79DA9E9AABAF7DCAA73EE39E756DD738BA882418D90605F4870CC6F2806AAA008C8177218140545B46D5014"
Data "41177A1294D2B669BF1B550E300A97853F045403AAD5B655A42A83DF60A1F782BA41C7B46D822A4A306044B52D2B020B9A857E"
Data "D0EF4659E0B3A0BDA003A42A85028DFD109A30DAEF86952AA279FF0FE57F96801A493503BA09087BD828EED67A97E7EE7E506B"
Data "1330493B852D401C9444FB86FC4F353420088EAAC430234E47CD2C4046F8CDA01348F5097E2900DBF8AEDC436DA0FDA45A8148"
Data "A6DD6879120AD0EB6503CB044A3CD702E83140A6E7B3F0EB4131D2EFB4870D2355017AB4DFC7B3879A40755A3BC3FAB9AC00C9"
Data "20442AA586CE5C0560646E2A9B7DBEC32C7CDC5BDF2C0069EDA8CA1EE22645739AC3160076AB372A5F7F052A94507F05C82062"
Data "425E5A009D9791BF86B059537AA116BD433C6C60B920943B0AE81BF387297BA78D5BAF90CEE36BE01DEA477A0C10F3F146962A"
Data "4416A094A0C700BDD57EB7A4F4C0F7AEE41540B700C91ABF1B528228070BC0C858808A02140CA52C1420A49AFF8A023843C92B"
Data "405F0C505180C2512E1620F31C60A8DF0D293D94870BA04A10E81865A1006C01621517E00465610192294ADC729FDFAD2859D4"
Data "95BE0224698CDF6D2865545EA20E725414C00643887651EE645437A8CD2F9E25EF02DC06CF385A5DE5DE8CA3E9093A9A3F07CF"
Data "4B9E1505B00384908230522E0943E1796FF993DC3DE459510009B030926E39CBE3E6BB8BC193A7D4BD8A3F7F973F57C2C0B3A2"
Data "0036C84C4FE3DEE8D694B310F5B300C5E2F9EF5D44CF41D8AB9244DFAD276AD015CAC0B31C15A00174D8643F4F19E929B0AE0C"
Data "32C2F0F84E0D94E71FBA55E1337E87ABFEE201A27B9B894ECFB306E5A6008B410B40B3489D39ACA305B416F430E8FE826AD4FC"
Data "71D2A53BA50892F306C2F3600A3DFE50EEBE1AF4FEB6A1A83394CBB39C14807BFE3F8146922AEC59A42A812EFC534037811E27"
Data "730B2144A63756155262E01808CF3B3E20EA4C657F4720F0256330B4886527DBEA28270560A1CEA2ACB079CBD6E059EDF71EED"
Data "7841C267A459186E4D3A1544FA4E79BEB09FE8B563B9FB2E83E99FD460107E995A00C626CA5582F5DA7E5DF89B0AAE31A40AC2"
Data "35052822CF6DF0F98FEEC9DD775A2DD11563C543CA725300060B997BFE5AC3BE05E444F8948DC8932E2980590C20E21947177E"
Data "0BF66B5A63FF32BD69A2BBB763E8674897ADC128E2667483742C378BB65C63001DECF31FCEDBC7BF67516E60280D8EC63D8F01"
Data "F2786E3A42F4FD7771017108FA5344670CCF3DFF91AD44DBF39E295C3391A8A9AEBFDF37A2DCDE0518033E36865FD0B67A4CD0"
Data "52708D0673EC068996E8309EF3DC6EA2EBD7ABC267DCBB19419EE19C75508E5FECCAAD623AAE74F6587B9EA61620AD91A26D43"
Data "E46D22BECE57DF4AF2E651C05ACA0DF8D8ECBF47B981E1542A3010743308142D7562E4D9CE19915BB3C7F64311EEC755DD3C19"
Data "8A8031FE7D1B73CB3655137DE30CF17304234FD3535279C4F0233730BF0D3660A1FE1E348C72033E6360F84B72300A70D50508"
Data "823323CF5330B0BD00E67CE5E6ECF1D7A0E2ABD1EB5FFF88E84822BB9F877CDF9C4214ABB1B86F26162067ED1D7E57C075EA8F"
Data "CDFCCC0E4E68ED3169A7D95A41FA73803C83985102F40967310007636E0581B23C2FE94000B80F7EBE33BB6FD906DCA7BC3B30"
Data "B71D43BED1EA1A3A3230B5003C8CD4F3F283B03EC0B1DC43560B4471B15D82638E84CF11B3D7CF01443CAF9B4974CB2B180D68"
Data "D2CD177E1B02C3F95324DE225AC4001977ABBF2BE6A032282B846860A3E0F90251291F6200339E9F1801019F45F4C41FFB9F5F"
Data "8DF3BFF137A82F66EF32453100DFD48C3759E2CEB51603BC36D051F27881A8203D099C0D57B001A382F53B72F7CF9F06056996"
Data "8C9704310097E5B5777821265E8B87A70C71FCC96FD14CF3F23D803E10E09ECFC2DFA16DBBB5F6BABF5E60485D8828E9E57300"
Data "1B9E8BCE23BA75057A42B7FAFBCC93886674C8FB7D238C1680CBB3D5D77D25DF687D9D283F97606221EBDE405F1FE83839BB5E"
Data "4770D30538E15983FD8BCE27FAF14AA27A4868E1F9CEDB67660158F0FCC8013167A0D709F4C60290CBCF011CBE0C3AED148C6D"
Data "27139D7E32FC7F83F450B91F4FB31880B771AAAC14DAC7D8EB61A02CCF2F7E4EDD0EC4149A8D027AB53A138557E7C9BDF176AD"
Data "601E9279FD20C80F9E1598231AF53E2FC04B9E66BAE0D74ADCF96D094A3BCA1AA64F029F6BC906006E4077E687E170B6C2E1DC"
Data "D3697EDEC58870472204AD0DBB3B0ED5C79AA27694334C15A00A7724EA723F08310FC57A88310A07C7A385F5616F147230C27C"
Data "A148C5FD1E97E1A191087568C0308D2A0AE00E4C152033F653DC75867DE34B0B056025E140D82B8B64064ED4F46039FAF1A43E"
Data "E5F49CA7A90218570A75037A189AB70AA8B01DFC8EDB758B24A87C502687EABDDF750B606365FACEF1A83DA203832E39D44B05"
Data "B01CEC2901500012276AEEC3D0615197D87D642E0115BFD26051B98BC9A1323CCD5D800741A042F64160D810287AD11ED13151"
Data "A2662245B41B4AF0AA45DDB3159BF7080E924359F1AE3C607F5DBF68B6E7E9BF05B03B2F2016C06C82654A1B3AD82D52E4E445"
Data "925572682229A178927C7DB50021090B10F2D90258256ACAFA68ABB9044E924375BE768A27E26B9F18E2418FCB5CA7640CE055"
Data "7B4410256ACA2A80630B20106031F9FA6601C214AC18C02ADE12BD9B977D1F6D1B0314C0B3287CED2C80673180EC797E0F03B5"
Data "8C9ACD889EBFBB251BBBC84EC2B8F49DECFF6168DA5DED4463AD3E7091971CBA3F41B4CBB0B4C5A15E92C29B79CB618C03CFE1"
Data "7956A5342C00F967018C899A27814EAF278A1C24BA49F25D652650D382C5EFE0021A1A8946D5671F3DCB2487F2B9DFD948D488"
Data "032D5A43CF36193D187136CE7B669BFAFF2E988C387E2F9BAC7E5DCD3606F0EA86DBF56AFDB89F0AC03066E97C15BDF7DAD7D1"
Data "0BD1FD4F97A85B0FD47826F746DCFC4726CA2DFD62E4C9BDF6EB2713AD84F579322937476F859653C773E7FE1E17770DDA5D5D"
Data "DDDF6A995E77DFD0CB23122110EDC84BD43CA18EE872DCCCDB22F22E80A7562DC1F9579D0A210C2D3C399469F638A226588E07"
Data "0BEC05F7E0FC09B03A53C798F33455809CE0CB65B2B3005EB645043D20D3E96F4FC2BEA1EAD2233258C66F3421BCCF8CEB2F58"
Data "459227D3D59F265A1E52B35D65B001B40A12FEFA99629E150B20D10EDD1C1BE9AA2944F747D479EA56D8A929009F9F5F47CA62"
Data "C2BD19CF4628D1A5F03B374A581FB63A37E0BC4567100DAD15F3F4DF02D82840102C803E43D748ADCD44336109EEB4795ECFA6"
Data "FFF3A7108D186E5E4F213C99E6A0AEAA06A2C76D5CC1BD383EA209566782354FFF2D80C545843C6E8B198C899AF97411A2EAD7"
Data "A36A80678657403B6244E77714B64084154FA6AFCE207A00927B5FC0975DC48BDCFB3FEB708108AF8681522E8002300A103C94"
Data "8962DFC29944B7AE255A9DD4BEBCAD81B39AEF8610BE360B755BE4EA8B2EDF2A33887BF685F0EB37BC45F4425EC5FCF3064875"
Data "C1340C398799F3ADC40005B6C3AA37766078367224867779DA793FEE6C3B82BE89E3C46585A3001B9E4CE7C2FAC4E10A56E495"
Data "E7514214EE66DA5FC9F1F45701C81E5EBA015103F4444D11FDC31C8CCF236AC0C7781BF45244DD6F57D629CF340479C55C3510"
Data "D517446097B01C12BD629E3C4FF19C4092139053C8F008E751D05C808E6130C9E7C1E4DE8A6060395CC162DCD50B6713D5D417"
Data "96B357084F46730BD139B00437BEA13E20BA1E653E3F436D8F2C5F5305482AEE2A00DF703DC92F2D110378A59022C824879E33"
Data "9D68E99F88AE3D4CD40DDF3B75B29C109C2687EA380F8AF683CD44577662E807D33FE3AF251688B00B020F29EEE684B3CCF97D"
Data "06AFD6744CB13ED16F05C828AB6472E8255F22BAEF31F4C84B06964C5A084FC682F97005E07BBD03BEA60AF08EE2EEC2507C81"
Data "ACA51C297F60157C916A8D92E48D45324501899AADE389AEBB9AE813A30B30FD45480E1DD94AF46FD711353516BE4288E87EF8"
Data "41816C47B92787565041058319BA375006544BFFFA2A2811F405819DEB26CE1E48459FBBF6C357573DD83A6BD8D42D6B8BD4B6"
Data "622965A118544A9C330A28A2F08A82AF81C6411C279037EB037CCB44E506657268503016126F2775F5672F9E4B98A19044CD4E"
Data "ADAD852090C9A141411DA96B033492470A60E674241335F7A1EC42FE545B8DDA6669DE414C0E0D0AC221356D9B1BE9F68329AB"
Data "80432651F3CE2EB5921FF0471A6B0B605E84E4D0A77A88CEC24D6A975DD1B154BE1CAA68DFB8B313D080F958D49F796A69F315"
Data "CFDF43005B5344CFE3FF8BD0BBDE449B3B6497781BE097437740E11E8040C7E2DC15232417F52E952F87DA3D2A2C361F11AC12"
Data "35BB5170E9C744DFC316F79F6EC6F6F6C344CF8E1ED80AEB325F0EE5C075319CF9B7B1FD3FFC581127BABCBE303E815780CCF4"
Data "F650F6D3356EF231854DA2E6630788CE4405D3B4DF73412FA2B2E54789BE329C6C31902F87FE148A168605F832FE9F83365C74"
Data "04ED80028CB3B13E25F3D5B03E17100A800530B9A9EFC3F4BF8C9BFE4A5EE1C52C0C0C09E6207A1DE970B54FBB2F87EE81AB79"
Data "FC10824EEDC51D27A0F0E752EEDC079770A2BCF509F657C3B457808A472482687AD6D28F88BEA9997E23C681AE02FD708FC3AF"
Data "8691FD94B0BBC1FB2AF03ED150E62BAC0C508CE70FCBF30CB405E833FF7EBB0093AF78AE86DFE7C9F70B04C5AE44A53FC7B070"
Data "0D5CC1AC462A0C029E3A5E422FEF8EAB3C8C604B700F2E64FE5EA2CF3413B5384D0F0F12FC0E02F588DC38D1E208FCEEB20F89"
Data "FE3B2DCED3E3D397E0F80D3B11234018B582130BF972288333859FDC0512F0668BB00815DCF31758A84FD9F30CB40BF0CAF4DB"
Data "B980FC2C9D877173E7A5ED934339309C8AF31EDF699E1564E5E3CD328398FE732BD16569F52388225C0D05881F572D851DCF40"
Data "5B0025143C17F03602AFF5187AFD4AD224DD848AE7EE55933B4FAE37AFDF8EA78E35BB89F622E8BCD686B7EE0A16BE4F743686"
Data "A34D3131CF605B008F49043D208BA3BB3CF836D16D69F505950C3840FC579CFFD046A25E93C04EB1E1A9D3019CB8FC3D55B032"
Data "D3FED842CCC7B90F6EB4E6197C0508900B58891ED5DAAB8EF50BC19740D50808577DE03C39F4BFFE4C74316E4847017CFF05E7"
Data "7F8CE1E89A8FC43CFB5C00BFCFF756BCF6D005E3AB0B203518E3F7B32F6C563FCFDE6E38B6D9A29CF13C9EADB90D3DF8ACF144"
Data "8D35F66D32CE0A7E0D01E73AB89139F87FA5767C32A9C34D33BC49D977CBD3C177F906A24FB61235982C4BA32B40882773B874"
Data "7F1D23080F82F444CD11B508E62ECBEEDF7F0C3D6CA57DDD4F7FB9FFBE9C99BB36C9A18CCD883B6642DABFD58EAFDF83D82221"
Data "56806721D5F71A8846692FA5A6C0CEFF19754C6BEBCFB3CF02046D3248DFCD207B1F5D2C1E229865E9A424BFA86497DC21E26B"
Data "E4397F5AEEB1A52F91FA6D37519D10F0CCD388664CCCABD38467A04701FAA7E3FD760166593A69C947BCB6D93D4E3283246E44"
Data "26AFC0E9327181811E9C79E002ACDA60965429FB2551475F1C0D59278F2A320A1091E31D680508420CC0307501C5B20005F034"
Data "DE173B585A00034A4201D805B89D1AE6D405B493356C6300072E4041EF7E08C79F133C5EDE9EC4A82E2AA740C15600F23F0814"
Data "256AD63713FDC762FBBA9D7C8BC82E39F4820BD5974122F0D7BF5B46C8258A065E01B8F7875D9E1666F72838685F0EE5645019"
Data "0813454BC502E8EF01647CDE409051008176A55294B8FD87AEB2AFF39367B01580542D765B01F4C52A4C8F256D97E52F7E7B3C"
Data "E4196805E0C5AE8F2BEE7F269C17A948FA9588E63302AB002D11FA656B94DE1D12A25E5880E303AF518C1E8562E0111A17A109"
Data "3B9D2EEA5341057968024DF7BB11C542C70991C8432D5555EF62FBF1982143FED4108DFE18FB277954BE14C1AF5E947AA2A7B1"
Data "6D1868657E21D2188D2EAD8B44BABF3D7A74EAF94993940D1D1DCA33EDEDCA75A346A58686C33D38763389A7C60DB47C2923A3"
Data "00F3E06162EA724897FBDD203358C6D7C32291074E8CC5FEF1C909136A4655F51F947E9048D0FCAD5BE3BB1389DB8FA6D3DF2B"
Data "76F900C11822CA8E495801B6F37C015E4BF826A238B4E0ADA3440BF1739BDF1724733193D143FFB8B6BDBDAA7588F891D2B69E"
Data "1E3A6FCB9644773ACD73503715B17C90A0B020DBCDEF19CFB89B6A526624E8597DC208BF3D7E04039A47D57FBF8F11CE9DE47C"
Data "1DC9A241A800CDD1E8AA2B860F9FF7CF2346D85672F7BE7DF46267E7130753A94556E5F76380BB09021F0F851863B00866E503"
Data "062B056883FFDA7A2AD1D1FC42D08CA1CFE44DE17B1F740B51F7BBEA9C924BF1F30F7E5E987018D8AB2853A7C4629448DA3FCD"
Data "E6F37E4634D3AAFCCEDE5EBA78E74E3A924E532C14A29FB4B6524775B5B07C2901115EFC67926B43F0BC7D4485352F138D5D4C"
Data "B4063F9F81227C8BD475333D87685268A433956A1A130E530F0467476D380F821D6355FED5AEAE8CF0193D8A42BFC66F8BF265"
Data "8F0B2833C52B361756A05A9DC237DF8F7688142055170E1FD9118F530202B2A3BFE0BCBA5068AF55F909E15C56E3F1DBA2FCA0"
Data "004F2DBF0B4AF0131891B1448FD5A9D3FE3C5DC051382D1C5AF9C61BDDDD19136E476FC433EF26D759953F1502FFD1F0E17441"
Data "4D0DDDDED040B3100358951F4CE0A9DE2F12D5C2874C433CF13B521F227902AB51C0B9B5A1D0EAA7870DABAA0F894FDB0FB3BE"
Data "E8F0E1C43145611FFE5A11CB070996416023D1DBEB4CDEEAC902F1430A43821E0C09567413DD481EC6035689216BA08D2FDFD5"
Data "D5153FC2A6DAA4E71FC2FE3BBABA12B823CBA8BFF0065ABEECB105F405A2AE3B88DEC1106226847F35791C0CDA3DD4A845EF7D"
Data "02829C7759345A7D1ACC782B68077AED3BA0A792C98442F4D45145B986D49777C52E1F14585A008C0236FE1CD79A5F8887582D"
Data "2695F163C11FE17A9FC76009BDFE468C931EA5003C13B0C2BC7AA2DFD4A84BE129B075FBF1FB57F8FF1C8FCAFB0D5600D1A4A4"
Data "3118EFEF86F43F3612AEF54033C6FB9BB5B23ADD0742F0771CC77F4AE6FA51410061A50022706CD0A50BFE7F419FC66F087E3B"
Data "8E9DEBF7055550181C2BC00694B9129600EE200E57781BA98F8E2B283138999CDC368428C14A10539FF8553ED030C8D01656BF"
Data "E876B1DF0DA9C01FB0A92F64D1D80A2AF01EFF0F7977A5FF6859F9EF0000000049454E44AE426082"
Data "END"+t_hell



Data "START"+t_pointer
Data 1+2+16+32
Data "89504E470D0A1A0A0000000D4948445200000020000000200806000000737A7AF400000006624B474400FF00FF00FFA0BDA793"
Data "000000097048597300000B1100000B11017F645F910000000774494D4507D40501112334B7DE561F000001FC49444154789CED"
Data "D73B6E144110C6F1DFEC8E6D0406F1102F4140C011380009211239E2107002AE418205040410101070082E61100444D860CBEC"
Data "93A0AB3DBDC322C0B3BB24FEA4D2CCEEB6A6FE555D553D5B618A1B711D62801F713FC2247E5B8AAAE2E1B7C2E95ED87E802C15"
Data "A207D3E914DEE32A2EE11C36710275ACAB96065040BCC3355CC6F95540F4CA0F01F10AD771651510BDF61701F1625510BF0014"
Data "105BAB80980B50403C956A22439CC2C622217E0B50406C49DD71116703626D250005C4334D7BE62C2C04E28F0005C44B4D0636"
Data "D00FE7CB03A8AAEAD0426FA5425CB7A03AA8E7398D88B3DEE0133E60BBE5383B2F47FA3F69260345A4A5F6F00DBB71FD8E03E9"
Data "DCC867C491CF89438070FE04CF334864E2BE7442661B621CCE2747759C5517CE1F690AACAD32D289D9D3B1D329993370179FA5"
Data "3DDEC6C356161EC7DA6C0B1BC5356EE282D4D7B59481D373D6AE87AD695AB0B32A69C26D4A91D5529B9D9106CFEBDC1191917B"
Data "F8882FD8918A71A4C336D4D29BCF3860FA529443F323CC5BD037DB8A9DBA601010FB9AD7B15D7CC59D62103DD0B4DF58C7F6CB"
Data "AA352D458A26DFE7086FE364ACDB09D0C1A220EA96F34A93FE2A9C1C488539D564A9F3DE970059653483B81F07505E3794DE94"
Data "179681798596A3CFC596673F295B23CDB62D05A084284DE1B0B44EFA9B61D25EB3B47F49C73AD67FD14FC88DA85E4172E46100"
Data "00000049454E44AE426082"
Data "END"+t_pointer

Data "START"+t_pointer2
Data 1+2+16+32
Data "89504E470D0A1A0A0000000D49484452000000100000002008060000016C8EC85A0000000774494D4507D4010C021317D37572"
Data "AA000000097048597300000B1200000B1201D2DD7EFC0000000467414D410000B18F0BFC6105000000A34944415478DAED93DD"
Data "0A8030088535F6FEAF6C3FCCB1CCE91983E8A203C5B2E3E7868E88488E875817DBF912B9D6563288D7BF8A6898C889C8D6DB6C"
Data "705805AD009DC58AFB5D30B3C67C430B1A632B519DF19621D3DB8AE7C1E9976B884CB7067BA6C7045853E93FBC66F519929D08"
Data "EA434EC9089FD5D20CA6F7660AD08213201730030A0108A800892AADC2438026981DE547708C7067223A04C95AB53423BFDED2"
Data "0E44A975E2AB2910570000000049454E44AE426082"
Data "END"+t_pointer2

Data "START"+t_blackpointer
Data 1+2+16+32
Data "89504E470D0A1A0A0000000D4948445200000020000000200806000000737A7AF40000002A744558744372656174696F6E2054"
Data "696D65006CF82031206D616A20323030342031393A33303A3131202B303130307EBBC5510000000774494D4507D30709141A1F"
Data "B15CAB39000000097048597300000B1200000B1201D2DD7EFC0000000467414D410000B18F0BFC61050000019F4944415478DA"
Data "ED96CF2E43411487CFE552919020141B416225B1B2EE0B58DAF000E2053C8747B1656547040B0B890D51219AD0D49F842855DF"
Data "714F13ADE96D2373EF464FF275E6CE4C7A7E3367E6CC04552C0882591179811294B54D9A1863C5A775E90FFECE291661123281"
Data "6F2F7166B3AD5AB90233D0A793D5A6461213F043C46A9C884405B423227101AD44A422204E446A029A894855402A225A09485C"
Data "443B02A43E4F4C432615012EA37D09B2D0EDC37FE8105497EFA91728F27003573008FD12A5F18A57014D8E993ADE8513B8873B"
Data "78824F1F2BD078175CC281233D6FC0020CDBECC33FBAFB65B5DB5097FA98EA1E6C39C6E9EE1F820F78B5D28B05F61ED8A4DE0B"
Data "FB700A599AB76B7BC104AE53DD816B9F0242FE5897761E9ECDB9C6F8D13156C79D41D1C67AB3115BE27189928C866500728EBD"
Data "B00653E2790F3CD8B2EACCDFF0A3BB5BE39C778C9F8331AF02705881B295DFE79042635C243CB9DA354CFD48A2D87BBD12C398"
Data "E79FAEC205FDCB12BD17D50EA1203E4F418B7ECDF9A33061DFB762A14A4B80F66BCEEFB1EF7789D26F022F938E75AC63FFD5BE"
Data "008C66570B516CE26E0000000049454E44AE426082"
Data "END"+t_blackpointer