Function createkarts(nofkarts)

;lanewidth=15 ; offset between lanes of starters
;initialx = 40 ; x position of *back* of grid
;initialz = -400;; z position of *back* of grid

;torsotex=LoadTexture("data\models\driver\torso.png")
;uarmtex=LoadTexture("data\models\driver\uarm.png")
larmtex=LoadTexture("data\models\driver\larm.png")

font=LoadFont("Arial",15,1,0,0)
namefont=LoadFont("Arial Black",48,0,0,0)
ropetext=LoadTexture("data\models\yacht\xsailblue.png")

For mo=1 To nofkarts

	SetFont font
	;loadscreen("Creating X-Sail "+Str(mo))

	ws#(mo)=0.7
	wp(mo)=1
	tarx(mo)=wpx(1)+Rnd(-15,15);25
	tarz(mo)=wpz(1)+Rnd(-15,15);25
	saillimit#(mo)=0.5
	rwres(mo)=2
	lwres(mo)=2
	fwres(mo)=2
	chasres(mo)=2
	drivermass#=48.0;Rnd(44.0,52.0)
	dmf#=1.0;+((drivermass#-48.0)/24.0)

	randtop=1;Rnd(1,6)
	;If randtop=6 Then randtop=1
	uarmtex$="data\models\driver\uarm"+Str(randtop)+".png"
	uarmtex=LoadTexture(uarmtex$)
	torsotex$="data\models\driver\torso"+Str(randtop)+".png"
	torsotex=LoadTexture(torsotex$)

	position(mo)=(nofkarts+1)-mo

	If kartcolor=0
		;floorpantex(mo)=LoadTexture("data\models\yacht\floorpanb.png");h.png")
		sailtex(mo)=LoadTexture("data\models\yacht\simsail2.png");
		;podtex(mo)=LoadTexture("data\models\blokart\podr.png")
	EndIf	
;	If kartcolor=1
;		floorpantex(mo)=LoadTexture("data\models\blokart\floorpany.png")
;		sailtex(mo)=LoadTexture("data\models\blokart\saily.png")
;		podtex(mo)=LoadTexture("data\models\blokart\pody.png")
;	EndIf	
;	If kartcolor=2
;		floorpantex(mo)=LoadTexture("data\models\blokart\floorpang.png")
;		sailtex(mo)=LoadTexture("data\models\blokart\sailg.png")
;		podtex(mo)=LoadTexture("data\models\blokart\podg.png")
;	EndIf	
;	If kartcolor=3
;		floorpantex(mo)=LoadTexture("data\models\blokart\floorpanb.png")
;		sailtex(mo)=LoadTexture("data\models\blokart\sailb.png")
;		podtex(mo)=LoadTexture("data\models\blokart\podb.png")
;	EndIf	
;	If kartcolor=4
;		floorpantex(mo)=LoadTexture("data\models\blokart\floorpano.png")
;		sailtex(mo)=LoadTexture("data\models\blokart\sailo.png")
;		podtex(mo)=LoadTexture("data\models\blokart\podo.png")
;	EndIf	
;	kartcolor=kartcolor+1
;	If kartcolor=5 Then kartcolor=0

	leftwheel(mo) = CreatePivot()
	If mo=1 Then lwlo(mo)=LoadMesh("data\models\yacht\rwlo.3ds")
	If mo>1 Then lwlo(mo)=CopyEntity(lwlo(1))
	ScaleEntity lwlo(mo),0.95,0.95,0.95;0.9
	EntityParent lwlo(mo),leftwheel(mo)
	If mo=1 Then lwme(mo)=LoadMesh("data\models\yacht\rwme.3ds")
	If mo>1 Then lwme(mo)=CopyEntity(lwme(1))
	ScaleEntity lwme(mo),0.95,0.95,0.95
	EntityParent lwme(mo),leftwheel(mo)
	If mo=1 Then lwhi(mo)=LoadMesh("data\models\yacht\rwhi.3ds")
	If mo>1 Then lwhi(mo)=CopyEntity(lwhi(1))
	ScaleEntity lwhi(mo),0.95,0.95,0.95
	EntityParent lwhi(mo),leftwheel(mo)
	HideEntity lwhi(mo)
	HideEntity lwme(mo)
	HideEntity lwlo(mo)
	lwres(mo)=3

	rightwheel(mo) = CreatePivot()
	If mo=1 Then rwlo(mo)=LoadMesh("data\models\yacht\rwlo.3ds")
	If mo>1 Then rwlo(mo)= CopyEntity(rwlo(1))
	ScaleEntity rwlo(mo),0.95,0.95,0.95
	EntityParent rwlo(mo),rightwheel(mo)
	If mo=1 Then rwme(mo)=LoadMesh("data\models\yacht\rwme.3ds")
	If mo>1 Then rwme(mo)= CopyEntity(rwme(1))
	ScaleEntity rwme(mo),0.95,0.95,0.95
	EntityParent rwme(mo),rightwheel(mo)
	If mo=1 Then rwhi(mo)=LoadMesh("data\models\yacht\rwhi.3ds")
	If mo>1 Then rwhi(mo)=CopyEntity(rwhi(1)) 
	ScaleEntity rwhi(mo),0.95,0.95,0.95
	EntityParent rwhi(mo),rightwheel(mo)
	HideEntity rwhi(mo)
	HideEntity rwme(mo)
	HideEntity rwlo(mo)
	rwres(mo)=3
	
	If mo=1 Then 	leftaxle(mo) = LoadMesh("data\models\yacht\axle.3ds")
	If mo>1 Then leftaxle(mo)=CopyEntity(leftaxle(1))
	EntityShininess leftaxle(mo),.5
	If mo=1 Then rightaxle(mo) = LoadMesh("data\models\yacht\axle.3ds")
	If mo>1 Then rightaxle(mo)=CopyEntity(rightaxle(1))
	EntityShininess rightaxle(mo),.5

	frontwheel(mo)= CreatePivot()
	fwlo(mo)= LoadMesh("data\models\yacht\rwlo.3ds");fwlo.3ds")
	ScaleEntity fwlo(mo),0.85,0.85,0.85; 0.8
	EntityParent fwlo(mo),frontwheel(mo)
	fwme(mo)= LoadMesh("data\models\yacht\rwme.3ds");fwme.3ds")
	ScaleEntity fwme(mo),0.85,0.85,0.85
	EntityParent fwme(mo),frontwheel(mo)
	fwhi(mo)= LoadMesh("data\models\yacht\rwhi.3ds");fwhi.3ds")
	ScaleEntity fwhi(mo),0.85,0.85,0.85
	EntityParent fwhi(mo),frontwheel(mo)
	HideEntity fwhi(mo)
	HideEntity fwme(mo)
	HideEntity fwlo(mo)
	fwres(mo)=3

	If mo=1 Then boom(mo) = LoadMesh("data\models\yacht\mast.3ds")
	If mo>1 Then boom(mo)= CopyEntity(boom(1))

	sail(mo) = LoadMesh("data\models\yacht\sail.3ds")
	sailmask(mo)= LoadMesh("data\models\yacht\sailmask.3ds")
	EntityTexture sail(mo),sailtex(mo)
	EntityFX sail(mo),17
	EntityShininess sail(mo),0.9;8
	EntityAlpha sail(mo),0.9
	EntityColor sail(mo),200,200,205
	EntityAlpha sailmask(mo),0.0
	EntityPickMode sailmask(mo),2
	EntityParent sailmask(mo),sail(mo)
	sailshad(mo,1)=CreatePivot();bottomback
	PositionEntity sailshad(mo,1),0,-12,-9
	EntityParent sailshad(mo,1),boom(mo)
	sailshad(mo,2)=CreatePivot();bottommiddle
	PositionEntity sailshad(mo,2),0,-12,0
	EntityParent sailshad(mo,2),boom(mo)
	sailshad(mo,3)=CreatePivot();bottomfront
	PositionEntity sailshad(mo,3),0,-12,9
	EntityParent sailshad(mo,3),boom(mo)
	sailshad(mo,4)=CreatePivot();middleback
	PositionEntity sailshad(mo,4),0,1,-9
	EntityParent sailshad(mo,4),boom(mo)
	sailshad(mo,5)=CreatePivot();middlemiddle
	PositionEntity sailshad(mo,5),0,1,0
	EntityParent sailshad(mo,5),boom(mo)
	sailshad(mo,6)=CreatePivot();middlefront
	PositionEntity sailshad(mo,6),0,1,9
	EntityParent sailshad(mo,6),boom(mo)
	sailshad(mo,7)=CreatePivot();topback
	PositionEntity sailshad(mo,7),0,13,-9
	EntityParent sailshad(mo,7),boom(mo)
	sailshad(mo,8)=CreatePivot();topmiddle
	PositionEntity sailshad(mo,8),0,13,0
	EntityParent sailshad(mo,8),boom(mo)
	sailshad(mo,9)=CreatePivot();topfront
	PositionEntity sailshad(mo,9),0,13,9
	EntityParent sailshad(mo,9),boom(mo)

	;TextureFilter "chromenv",1+64
	;chromenv=LoadTexture("data\models\yacht\chromenv.png")
	If mo=1 Then steering(mo) = LoadMesh("data\models\yacht\steering2.3ds")
	If mo>1 Then steering(mo) = CopyEntity(steering(1))
	EntityShininess steering(mo),0
	EntityFX steering(mo),16
	;EntityTexture steering(mo),chromenv,0,2
	
	mchassis(mo) = CreatePivot()
	If mo=1 Then chaslo(mo)=LoadMesh("data\models\yacht\chas-lo2.3ds")
	If mo>1 Then chaslo(mo)=CopyEntity(chaslo(1))
	EntityFX chaslo(mo),16
	If mo=1 Then chasme(mo)=LoadMesh("data\models\yacht\chas-me2.3ds")
	If mo>1 Then chasme(mo)=CopyEntity(chasme(1))
	EntityFX chasme(mo),16
	If mo=1 Then chashi(mo)=LoadMesh("data\models\yacht\chas-hi2.3ds")
	If mo>1 Then chashi(mo)=CopyEntity(chashi(1))

	EntityFX chashi(mo),16
	EntityParent chaslo(mo),mchassis(mo)
	EntityParent chasme(mo),mchassis(mo)
	EntityParent chashi(mo),mchassis(mo)
	HideEntity chasme(mo)
	HideEntity chashi(mo)
	HideEntity chaslo(mo)
	chasres(mo)=3
	EntityShininess chaslo(mo),0.75
	EntityShininess chasme(mo),0.75
	EntityShininess chashi(mo),0.75
	; pivot points for kartshadow projection
	kartshad(mo,1)=CreatePivot() ; backleft
	PositionEntity kartshad(mo,1),-8,0.9,-7
	EntityParent kartshad(mo,1),mchassis(mo)
	kartshad(mo,2)=CreatePivot() ; backmiddle
	PositionEntity kartshad(mo,2),0,0.9,-7
	EntityParent kartshad(mo,2),mchassis(mo)
	kartshad(mo,3)=CreatePivot() ; backright
	PositionEntity kartshad(mo,3),8,0.9,-7
	EntityParent kartshad(mo,3),mchassis(mo)
	kartshad(mo,4)=CreatePivot() ;middleleft
	PositionEntity kartshad(mo,4),-8,0.9,0.5
	EntityParent kartshad(mo,4),mchassis(mo)
	kartshad(mo,5)=CreatePivot() ;middlemiddle
	PositionEntity kartshad(mo,5),0,0.9,0.5
	EntityParent kartshad(mo,5),mchassis(mo)
	kartshad(mo,6)=CreatePivot() ;middleright
	PositionEntity kartshad(mo,6),8,0.9,0.5
	EntityParent kartshad(mo,6),mchassis(mo)
	kartshad(mo,7)=CreatePivot() ;frontleft
	PositionEntity kartshad(mo,7),-8,0.9,8
	EntityParent kartshad(mo,7),mchassis(mo)
	kartshad(mo,8)=CreatePivot() ;frontmiddle
	PositionEntity kartshad(mo,8),0,0.9,8
	EntityParent kartshad(mo,8),mchassis(mo)
	kartshad(mo,9)=CreatePivot() ;frontright
	PositionEntity kartshad(mo,9),8,0.9,8
	EntityParent kartshad(mo,9),mchassis(mo)
	
	belt(mo)=LoadMesh("Data\models\yacht\belt.b3d")
	EntityFX belt(mo),16
	EntityParent belt(mo),mchassis(mo)

	seattexture=LoadImage("data\models\yacht\nameback.png")
	seattex(mo)=CreateTexture(256,64,16)
	SetBuffer BackBuffer()
	Cls
	DrawImage seattexture,0,0
	SetFont namefont
	Color 20,20,40
	Text 129,7,Upper$(playername$(mo)),1
	Color 70,70,200
	Text 128,6,Upper$(playername$(mo)),1
	CopyRect 0,0,256,64,0,0,BackBuffer(),TextureBuffer(seattex(mo))
	nameplatep(mo)=LoadMesh("data\models\common\plane.b3d")
	ScaleEntity nameplatep(mo),6,1.5,6
	EntityFX nameplatep(mo),16+1
;	If mo=1 Then seat(mo) = LoadMesh("data\models\yacht\seat.3ds")
;	If mo>1 Then seat(mo)=CopyEntity(seat(1))
	EntityTexture nameplatep(mo),seattex(mo)
	RotateMesh nameplatep(mo),0,180,0
	EntityOrder nameplatep(mo),-49
	;EntityAlpha nameplatep(mo),0.8
	EntityAutoFade nameplatep(mo),150,200
	
	playerpointn(mo)=CopyMesh(nameplatep(mo))
	ScaleMesh playerpointn(mo),0.15,0.04,0.15
	RotateMesh playerpointn(mo),90,180,0
	EntityOrder playerpointn(mo),-106
	EntityFX playerpointn(mo),1+16
	EntityTexture playerpointn(mo),seattex(mo)
;	
;	EntityTexture seat(mo),seattex(mo)
;	EntityFX seat(mo),16
;	;EntityShininess seat(mo),0.5
;	EntityParent seat(mo),mchassis(mo)

;	If mo=1 Then floorpan(mo) = LoadMesh("data\models\yacht\floorpan.3ds")
;	If mo>1 Then floorpan(mo)=CopyEntity(floorpan(1))
;	EntityTexture floorpan(mo),floorpantex(mo)
;	EntityFX floorpan(mo),16
;	EntityParent floorpan(mo),mchassis(mo)
;
;	If mo=1 Then floorpb(mo) = LoadMesh("data\models\yacht\floorpb.3ds")
;	If mo>1 Then floorpb(mo)=CopyEntity(floorpb(1))
;	EntityParent floorpb(mo),mchassis(mo)

;	If Rnd(0,2)>1.0
;		pod(mo) = LoadMesh("models\pod.3ds")
;		EntityFX pod(mo),16
;		EntityParent pod(mo),mchassis(mo)
;		EntityShininess pod(mo),0.5
;		EntityTexture pod(mo),podtex(mo)
;	EndIf

	; ---------------------------- body parts

	lthigh(mo)=CreatePivot()
	lthighhi(mo)=LoadMesh("data\models\driver\thighhi.b3d")
	ScaleMesh lthighhi(mo),1.1,1.1,1.0;dmf#,dmf#,1.0
	RotateMesh lthighhi(mo),-32,10,0
	EntityParent lthighhi(mo),lthigh(mo)
	lthighme(mo)=LoadMesh("data\models\driver\thighme.b3d")
	ScaleMesh lthighme(mo),1.1,1.1,1.0;dmf#,dmf#,1.0
	RotateMesh lthighme(mo),-32,10,0
	EntityParent lthighme(mo),lthigh(mo)
	lthighlo(mo)=LoadMesh("data\models\driver\thighlo.b3d")
	ScaleMesh lthighlo(mo),1.1,1.1,1.0;dmf#,dmf#,1.0
	RotateMesh lthighlo(mo),-32,10,0
	EntityParent lthighlo(mo),lthigh(mo)
	PositionEntity lthigh(mo),-0.5,-0.3,-2.3
	EntityParent lthigh(mo),mchassis(mo)
	HideEntity lthighhi(mo)
	HideEntity lthighme(mo)
	HideEntity lthighlo(mo)
	lthighres(mo)=3
	
	rthigh(mo)=CreatePivot()
	rthighhi(mo)=LoadMesh("data\models\driver\thighhi.b3d")
	ScaleMesh rthighhi(mo),1.1,1.1,1.0;dmf#,dmf#,1.0
	RotateMesh rthighhi(mo),-32,-10,0
	EntityParent rthighhi(mo),rthigh(mo)
	rthighme(mo)=LoadMesh("data\models\driver\thighme.b3d")
	ScaleMesh rthighme(mo),1.1,1.1,1.0;dmf#,dmf#,1.0
	RotateMesh rthighme(mo),-32,-10,0
	EntityParent rthighme(mo),rthigh(mo)
	rthighlo(mo)=LoadMesh("data\models\driver\thighlo.b3d")
	ScaleMesh rthighlo(mo),1.1,1.1,1.0;dmf#,dmf#,1.0
	RotateMesh rthighlo(mo),-32,-10,0
	EntityParent rthighlo(mo),rthigh(mo)
	PositionEntity rthigh(mo),0.5,-0.3,-2.3
	EntityParent rthigh(mo),mchassis(mo)
	HideEntity rthighhi(mo)
	HideEntity rthighme(mo)
	HideEntity rthighlo(mo)
	rthighres(mo)=3

	lcalf(mo)=CreatePivot()
	lcalfhi(mo)=LoadMesh("data\models\driver\calfhi.b3d")
	ScaleMesh lcalfhi(mo),dmf#,dmf#,1.0
	RotateMesh lcalfhi(mo),40,-5,0
	EntityParent lcalfhi(mo),lcalf(mo)
	lcalfme(mo)=LoadMesh("data\models\driver\calfme.b3d")
	ScaleMesh lcalfme(mo),dmf#,dmf#,1.0
	RotateMesh lcalfme(mo),40,-5,0
	EntityParent lcalfme(mo),lcalf(mo)
	lcalflo(mo)=LoadMesh("data\models\driver\calflo.b3d")
	ScaleMesh lcalflo(mo),dmf#,dmf#,1.0
	RotateMesh lcalflo(mo),40,-5,0
	EntityParent lcalflo(mo),lcalf(mo)
	PositionEntity lcalf(mo),-0.92,1.33,0.31
	EntityParent lcalf(mo),lthigh(mo)
	HideEntity lcalfhi(mo)
	HideEntity lcalfme(mo)
	HideEntity lcalflo(mo)
	lcalfres(mo)=3
	
	rcalf(mo)=CreatePivot()
	rcalfhi(mo)=LoadMesh("data\models\driver\calfhi.b3d")
	ScaleMesh rcalfhi(mo),dmf#,dmf#,1.0
	RotateMesh rcalfhi(mo),40,5,0
	EntityParent rcalfhi(mo),rcalf(mo)
	rcalfme(mo)=LoadMesh("data\models\driver\calfme.b3d")
	ScaleMesh rcalfme(mo),dmf#,dmf#,1.0
	RotateMesh rcalfme(mo),40,5,0
	EntityParent rcalfme(mo),rcalf(mo)
	rcalflo(mo)=LoadMesh("data\models\driver\calflo.b3d")
	ScaleMesh rcalflo(mo),dmf#,dmf#,1.0
	RotateMesh rcalflo(mo),40,5,0
	EntityParent rcalflo(mo),rcalf(mo)
	PositionEntity rcalf(mo),1.1,1.33,0.31
	EntityParent rcalf(mo),rthigh(mo)
	HideEntity rcalfhi(mo)
	HideEntity rcalfme(mo)
	HideEntity rcalflo(mo)
	rcalfres(mo)=3

	foottexno=Rnd(1,5)
	foottex=LoadTexture("data\models\driver\shoe"+Str(foottexno)+".png")
	lfoot(mo)=CreatePivot()
	lfoothi(mo)=LoadMesh("data\models\driver\foothi.b3d")
	RotateMesh lfoothi(mo),-40,10,10
	EntityParent lfoothi(mo),lfoot(mo)
	EntityTexture lfoothi(mo),foottex
	lfootme(mo)=LoadMesh("data\models\driver\footme.b3d")
	RotateMesh lfootme(mo),-40,10,10
	EntityParent lfootme(mo),lfoot(mo)
	EntityTexture lfootme(mo),foottex
	lfootlo(mo)=LoadMesh("data\models\driver\footlo.b3d")
	RotateMesh lfootlo(mo),-40,10,10
	EntityParent lfootlo(mo),lfoot(mo)
	EntityTexture lfootlo(mo),foottex
	PositionEntity lfoot(mo),-0.68,-0.46,2.65
	EntityParent lfoot(mo),lcalf(mo)
	HideEntity lfoothi(mo)
	HideEntity lfootme(mo)
	HideEntity lfootlo(mo)
	lfootres(mo)=3

	rfoot(mo)=CreatePivot()
	rfoothi(mo)=LoadMesh("data\models\driver\foothi.b3d")
	RotateMesh rfoothi(mo),-35,-10,-10
	EntityParent rfoothi(mo),rfoot(mo)
	EntityTexture rfoothi(mo),foottex
	rfootme(mo)=LoadMesh("data\models\driver\footme.b3d")
	RotateMesh rfootme(mo),-35,-10,-10
	EntityParent rfootme(mo),rfoot(mo)
	EntityTexture rfootme(mo),foottex
	rfootlo(mo)=LoadMesh("data\models\driver\footlo.b3d")
	RotateMesh rfootlo(mo),-35,-10,-10
	EntityParent rfootlo(mo),rfoot(mo)
	EntityTexture rfootlo(mo),foottex
	PositionEntity rfoot(mo),0.89,-0.46,2.65
	EntityParent rfoot(mo),rcalf(mo)
	HideEntity rfoothi(mo)
	HideEntity rfootme(mo)
	HideEntity rfootlo(mo)
	rfootres(mo)=3
	
	topcolor=Rand(0,255)
	rgbrnd=Rand(1,3)
	If rgbrnd=1
		redc=topcolor
		bluec=20
		greenc=20
	EndIf
	If rgbrnd=2
		redc=20
		bluec=topcolor
		greenc=20
	EndIf
	If rgbrnd=3
		redc=20
		bluec=20
		greenc=topcolor
	EndIf
	
	torso(mo)=CreatePivot()
	torsohi(mo)=LoadMesh("data\models\driver\torsohi.b3d")
	;ScaleEntity torsohi(mo),1.0,1.0,dmf#
	RotateMesh torsohi(mo),-49.0,0,0
	EntityParent torsohi(mo),torso(mo)
	;EntityColor torsohi(mo),redc,bluec,greenc
	EntityTexture torsohi(mo),torsotex
	torsome(mo)=LoadMesh("data\models\driver\torsome.b3d")
	;ScaleEntity torsome(mo),1.0,1.0,dmf#
	RotateMesh torsome(mo),-49.0,0,0
	EntityParent torsome(mo),torso(mo)
	;EntityColor torsome(mo),redc,bluec,greenc
	EntityTexture torsome(mo),torsotex
	torsolo(mo)=LoadMesh("data\models\driver\torsolo.b3d")
	;ScaleEntity torsolo(mo),1.0,1.0,dmf#
	RotateMesh torsolo(mo),-49.0,0,0
	EntityParent torsolo(mo),torso(mo)
	EntityTexture torsolo(mo),torsotex
	;EntityColor torsolo(mo),redc,bluec,greenc
	PositionEntity torso(mo),0,-0.3,-2.3
	EntityParent torso(mo),mchassis(mo)
	;HideEntity torsohi(mo)
	HideEntity torsome(mo)
	HideEntity torsolo(mo)
	torsores(mo)=3
		
	neck(mo)=CreatePivot()
	neckhi(mo)=LoadMesh("data\models\driver\neckhi.b3d")
	RotateMesh neckhi(mo),-30,0,0
	EntityParent neckhi(mo),neck(mo)
	EntityTexture neckhi(mo),larmtex
	;EntityColor neckhi(mo),200,150,150
	neckme(mo)=LoadMesh("data\models\driver\neckme.b3d")
	RotateMesh neckme(mo),-30,0,0
	EntityParent neckme(mo),neck(mo)
	EntityTexture neckme(mo),larmtex
	;EntityColor neckme(mo),200,150,150
	necklo(mo)=LoadMesh("data\models\driver\necklo.b3d")
	RotateMesh necklo(mo),-30,0,0
	EntityParent necklo(mo),neck(mo)
	EntityTexture necklo(mo),larmtex
	;EntityColor necklo(mo),200,150,150
	PositionEntity neck(mo),0,2.63,-5.47
	EntityParent neck(mo),torso(mo)
	HideEntity neckhi(mo)
	HideEntity neckme(mo)
	HideEntity necklo(mo)
	neckres(mo)=3

	;If mo=1
		;head(mo)=LoadMesh("data\models\driver\head.b3d")
		head(mo)=LoadMesh("data\models\driver\newhead.b3d")
		RotateMesh head(mo),-10,0,0
		ScaleMesh head(mo),1.05,1.05,1.05
	;EndIf	
	;If mo>1 Then head(mo)=CopyEntity(head(1))
	PositionEntity head(mo),0,3.7,-5.81
	EntityParent head(mo),neck(mo)
	;EntityColor head(mo),100,250,50
	EntityShininess head(mo),0.2
	EntityFX head(mo),16
	;weld(head(mo))
	;UpdateNormals(head(mo))
	;helcol=Rand(3)
	;Local hecolimg
	;hecolimg=LoadTexture("data\models\driver\redhelmet.png")
	;If helcol=2 Then hecolimg=LoadTexture("data\models\driver\bluehelmet.png")
	;If helcol=3 Then hecolimg=LoadTexture("data\models\driver\whitehelmet.png")
	;EntityTexture head(mo),hecolimg
	;FreeImage hecolimg
	
	luarm(mo)=CreatePivot()
	luarmhi(mo)=LoadMesh("data\models\driver\uarmhi.b3d")
	ScaleMesh luarmhi(mo),dmf#,dmf#,1.0
	RotateMesh luarmhi(mo),26,25,0
	EntityParent luarmhi(mo),luarm(mo)
	EntityTexture luarmhi(mo),uarmtex
	;EntityColor luarmhi(mo),redc,bluec,greenc
	luarmme(mo)=LoadMesh("data\models\driver\uarmme.b3d")
	ScaleMesh luarmme(mo),dmf#,dmf#,1.0
	RotateMesh luarmme(mo),26,25,0
	EntityParent luarmme(mo),luarm(mo)
	EntityTexture luarmme(mo),uarmtex
	;EntityColor luarmme(mo),redc,bluec,greenc
	luarmlo(mo)=LoadMesh("data\models\driver\uarmlo.b3d")
	ScaleMesh luarmlo(mo),dmf#,dmf#,1.0
	RotateMesh luarmlo(mo),26,25,0
	EntityParent luarmlo(mo),luarm(mo)
	EntityTexture luarmlo(mo),uarmtex
	;EntityColor luarmlo(mo),redc,bluec,greenc
	PositionEntity luarm(mo),-1.15,2.40,-5.32;,-1.19,2.43,-5.32
	EntityParent luarm(mo),torso(mo)
	;HideEntity luarmhi(mo)
	HideEntity luarmme(mo)
	HideEntity luarmlo(mo)
	luarmres(mo)=3
	
	llarm(mo)=CreatePivot()
	llarmhi(mo)=LoadMesh("data\models\driver\larmhi.b3d")
	;RotateMesh llarmhi(mo),-11,-25,0
	ScaleMesh llarmhi(mo),dmf#,dmf#,1.0
	EntityParent llarmhi(mo),llarm(mo)
	EntityTexture llarmhi(mo),larmtex
	;EntityColor llarmhi(mo),redc,bluec,greenc
	llarmme(mo)=LoadMesh("data\models\driver\larmme.b3d")
	ScaleMesh llarmme(mo),dmf#,dmf#,1.0
	;RotateMesh llarmme(mo),-11,-25,0
	EntityParent llarmme(mo),llarm(mo)
	EntityTexture llarmme(mo),larmtex
	;EntityColor llarmme(mo),redc,bluec,greenc
	llarmlo(mo)=LoadMesh("data\models\driver\larmlo.b3d")
	ScaleMesh llarmlo(mo),dmf#,dmf#,1.0
	;RotateMesh llarmlo(mo),-11,-25,0
	EntityParent llarmlo(mo),llarm(mo)
	EntityTexture llarmlo(mo),larmtex
	;EntityColor llarmlo(mo),redc,bluec,greenc
	PositionEntity llarm(mo),-1.97,1.52,-3.59
	EntityParent llarm(mo),luarm(mo)
	HideEntity llarmhi(mo)
	HideEntity llarmme(mo)
	HideEntity llarmlo(mo)
	llarmres(mo)=3

	lhand(mo)=CreatePivot()
	lhandhi(mo)=LoadMesh("data\models\driver\lhandhi.b3d")
	EntityParent lhandhi(mo),lhand(mo)
	EntityTexture lhandhi(mo),larmtex
	;EntityColor lhandhi(mo),200,150,150
	lhandme(mo)=LoadMesh("data\models\driver\lhandme.b3d")
	EntityParent lhandme(mo),lhand(mo)
	EntityTexture lhandme(mo),larmtex
	;EntityColor lhandme(mo),200,150,150
	lhandlo(mo)=LoadMesh("data\models\driver\lhandlo.b3d")
	EntityParent lhandlo(mo),lhand(mo)
	EntityTexture lhandlo(mo),larmtex
	;EntityColor lhandlo(mo),200,150,150
	PositionEntity lhand(mo),-1.99,1.52,-2.02;-1.97,1.52,-2.02
	EntityParent lhand(mo),llarm(mo)
	HideEntity lhandhi(mo)
	HideEntity lhandme(mo)
	HideEntity lhandlo(mo)
	lhandres(mo)=3
	
	ruarm(mo)=CreatePivot()
	ruarmhi(mo)=LoadMesh("data\models\driver\uarmhi.b3d")
	ScaleMesh ruarmhi(mo),dmf#,dmf#,1.0
	RotateMesh ruarmhi(mo),28,-35,0
	EntityParent ruarmhi(mo),ruarm(mo)
	EntityTexture ruarmhi(mo),uarmtex
	;EntityColor ruarmhi(mo),redc,bluec,greenc
	ruarmme(mo)=LoadMesh("data\models\driver\uarmme.b3d")
	ScaleMesh ruarmme(mo),dmf#,dmf#,1.0
	RotateMesh ruarmme(mo),28,-35,0
	EntityParent ruarmme(mo),ruarm(mo)
	EntityTexture ruarmme(mo),uarmtex
	;EntityColor ruarmme(mo),redc,bluec,greenc
	ruarmlo(mo)=LoadMesh("data\models\driver\uarmlo.b3d")
	ScaleMesh ruarmlo(mo),dmf#,dmf#,1.0	
	RotateMesh ruarmlo(mo),28,-35,0
	EntityParent ruarmlo(mo),ruarm(mo)
	EntityTexture ruarmlo(mo),uarmtex
	;EntityColor ruarmlo(mo),redc,bluec,greenc
	PositionEntity ruarm(mo),1.23,2.44,-5.36;1.43,2.48,-5.36
	EntityParent ruarm(mo),torso(mo)
	;HideEntity ruarmhi(mo)
	HideEntity ruarmme(mo)
	HideEntity ruarmlo(mo)
	ruarmres(mo)=3
	
	rlarm(mo)=CreatePivot()
	rlarmhi(mo)=LoadMesh("data\models\driver\larmhi.b3d")
	ScaleMesh rlarmhi(mo),dmf#,dmf#,1.0
	RotateMesh rlarmhi(mo),-15,42,0
	EntityParent rlarmhi(mo),rlarm(mo)
	EntityTexture rlarmhi(mo),larmtex
	;EntityColor rlarmhi(mo),redc,bluec,greenc
	rlarmme(mo)=LoadMesh("data\models\driver\larmme.b3d")
	ScaleMesh rlarmme(mo),dmf#,dmf#,1.0	
	RotateMesh rlarmme(mo),-15,42,0
	EntityParent rlarmme(mo),rlarm(mo)
	EntityTexture rlarmme(mo),larmtex
	;EntityColor rlarmme(mo),redc,bluec,greenc
	rlarmlo(mo)=LoadMesh("data\models\driver\larmlo.b3d")
	ScaleMesh rlarmlo(mo),dmf#,dmf#,1.0	
	RotateMesh rlarmlo(mo),-15,42,0
	EntityParent rlarmlo(mo),rlarm(mo)
	EntityTexture rlarmlo(mo),larmtex
	;EntityColor rlarmlo(mo),redc,bluec,greenc
	PositionEntity rlarm(mo),2.2,1.47,-3.8;2.4,1.47,-3.8
	EntityParent rlarm(mo),ruarm(mo)
	HideEntity rlarmhi(mo)
	HideEntity rlarmme(mo)
	HideEntity rlarmlo(mo)
	rlarmres(mo)=3

	rhand(mo)=CreatePivot()
	rhandhi(mo)=LoadMesh("data\models\driver\rhandhi.b3d")
	RotateMesh rhandhi(mo),0,20,-75
	EntityParent rhandhi(mo),rhand(mo)
	EntityTexture rhandhi(mo),larmtex
	;EntityColor rhandhi(mo),200,150,150
	rhandme(mo)=LoadMesh("data\models\driver\rhandme.b3d")
	RotateMesh rhandme(mo),0,20,-75
	EntityParent rhandme(mo),rhand(mo)
	EntityTexture rhandme(mo),larmtex
	;EntityColor rhandme(mo),200,150,150
	rhandlo(mo)=LoadMesh("data\models\driver\rhandlo.b3d")
	RotateMesh rhandlo(mo),0,20,-75
	EntityParent rhandlo(mo),rhand(mo)
	EntityTexture rhandlo(mo),larmtex
	;EntityColor rhandlo(mo),200,150,150
	PositionEntity rhand(mo),1.05,1.87,-2.5;1.3,1.8,-2.6
	EntityParent rhand(mo),rlarm(mo)
	HideEntity rhandhi(mo)
	HideEntity rhandme(mo)
	HideEntity rhandlo(mo)
	rhandres(mo)=3
	
	handpivot(mo) = CreatePivot()
	PositionEntity handpivot(mo),-1,-1,-4.75;-1,-.6,-3.75
	EntityParent handpivot(mo),steering(mo)

;	handpivotcube(mo)=CreateCube()
;	ScaleEntity handpivotcube(mo),0.2,0.2,0.2
;	EntityColor handpivotcube(mo),255,0,0
;	PositionEntity handpivotcube(mo),-1,-1,-4.75
;	EntityParent handpivotcube(mo),handpivot(mo)
	
	; position x-sails according to start slots
	ax#=psx(mo)
	ay#=psy(mo)
	az#=psz(mo)


	; chassis
	pchassis(mo) = TOKRB_Create()
	TOKRB_CollideConnected pchassis(mo),0
	TOKRB_AddBox pchassis(mo),4.0,1.80,8.0;4,2,8
	TOKRB_SetPosition pchassis(mo),0+ax,4+ay,4+az
	TOKRB_SetLinearDamping pchassis(mo),0.002
	TOKRB_SetAngularDamping pchassis(mo),0.03;0.003
	TOKRB_SetMass pchassis(mo),drivermass#
	TOKRB_SetBoxInertiaTensor pchassis(mo),4.0,2.0,8.0,drivermass#
	TOKRB_SetRotation pchassis(mo),0,0,0
	TOKGEOM_SetMaterialIndex pchassis(mo),3

	TOKGEOM_SetPositionAndRotation TOKRB_AddBox(pchassis(mo),5.0,3.0,6.0),0.0,2.5,-3.0,0.0,0.0,0.0 ; box was 4,3,6
	TOKRB_UpdateBoundingInfo pchassis(mo)
	
	; leftrearaxle
	pleftaxle(mo) = TOKRB_Create()
	TOKRB_CollideConnected pleftaxle(mo),0
	TOKRB_AddBox pleftaxle(mo),4.0,0.25,0.25
	TOKRB_SetPosition pleftaxle(mo),-4.1+ax,3+ay,0+az
	TOKRB_SetLinearDamping pleftaxle(mo),0.003
	TOKRB_SetAngularDamping pleftaxle(mo),0.003;0.003
	TOKRB_SetMass pleftaxle(mo),0.1;12
	TOKRB_SetBoxInertiaTensor pleftaxle(mo),9.0,0.25,0.25,0.1 
	TOKRB_SetRotation pleftaxle(mo),0,0,0
	TOKGEOM_SetMaterialIndex pleftaxle(mo),3

	; rightrearaxle
	prightaxle(mo) = TOKRB_Create()
	TOKRB_CollideConnected prightaxle(mo),0
	TOKRB_AddBox prightaxle(mo),4.0,0.25,0.25
	TOKRB_SetPosition prightaxle(mo),4.1+ax,3+ay,0+az
	TOKRB_SetLinearDamping prightaxle(mo),0.003
	TOKRB_SetAngularDamping prightaxle(mo),0.003;0.003
	TOKRB_SetMass prightaxle(mo),0.1;12
	TOKRB_SetBoxInertiaTensor prightaxle(mo),9.0,0.25,0.25,0.1 
	TOKRB_SetRotation prightaxle(mo),0,0,0
	TOKGEOM_SetMaterialIndex prightaxle(mo),3

	; right wheel
	rb2(mo) = TOKRB_Create()
	TOKRB_CollideConnected rb2(mo),0
	TOKRB_AddCylinder rb2(mo),2.5,0.5;2.7,0.4
	TOKGEOM_SetMaterialIndex rb2(mo),2 
	TOKRB_SetPosition rb2(mo),5.25+ax,3.0+ay,0+az;5
	TOKRB_SetLinearDamping rb2(mo),0.003;0.003
	TOKRB_SetAngularDamping rb2(mo),0.001;0.003
	TOKRB_SetMass rb2(mo),2.0
	TOKRB_SetCylinderInertiaTensor rb2(mo),2.5,0.5,2 
	TOKRB_SetRotation rb2(mo),0,0,90
	TOKRB_SetCollisionID rb2(mo),1

	; left wheel
	rb3(mo) = TOKRB_Create()
	TOKRB_CollideConnected rb3(mo),0
	TOKRB_AddCylinder rb3(mo),2.5,0.5;2.7,0.4
	TOKGEOM_SetMaterialIndex rb3(mo),2 
	TOKRB_SetPosition rb3(mo),-5.25+ax,3.0+ay,0+az;5
	TOKRB_SetLinearDamping rb3(mo),0.003;0.003
	TOKRB_SetAngularDamping rb3(mo),0.001;0.003
	TOKRB_SetMass rb3(mo),2.0
	TOKRB_SetCylinderInertiaTensor rb3(mo),2.5,0.5,2 
	TOKRB_SetRotation rb3(mo),0,0,90
	TOKRB_SetCollisionID rb3(mo),1

	; frontaxle
	rb4(mo) = TOKRB_Create()
	TOKRB_CollideConnected rb4(mo),0
	TOKRB_AddBox rb4(mo),0.1,0.1,0.1
	TOKRB_SetPosition rb4(mo),0+ax,3.0+ay,11.25+az
	TOKRB_SetLinearDamping rb4(mo),0.003;0.003
	TOKRB_SetAngularDamping rb4(mo),0.01;0.003
	TOKRB_SetMass rb4(mo),4.0
	TOKRB_SetBoxInertiaTensor rb4(mo),5.0,2.0,2.0,2.0 
	TOKRB_SetRotation rb4(mo),0,0,0

	; front wheel 
	rb5(mo) = TOKRB_Create()
	TOKRB_CollideConnected rb5(mo),0
	TOKRB_AddCylinder rb5(mo),2.5,1.5;1.5 was 2.5
	TOKGEOM_SetMaterialIndex rb5(mo),2 
	TOKRB_SetPosition rb5(mo),0+ax,3.0+ay,11.25+az
	TOKRB_SetLinearDamping rb5(mo),0.001
	TOKRB_SetAngularDamping rb5(mo),0.002;0.003
	TOKRB_SetMass rb5(mo),2.0
	TOKRB_SetCylinderInertiaTensor rb5(mo),2.5,1.5,2.0
	TOKRB_SetRotation rb5(mo),0,0,90
	TOKRB_SetCollisionID rb5(mo),1

	; boom
	rb7(mo) = TOKRB_Create()
	TOKRB_CollideConnected rb7(mo),0
	TOKRB_AddBox rb7(mo),2.0,15.0,10.0;1,1,10
	TOKRB_SetPosition rb7(mo),0+ax,16+ay,1.01+az;9,1
	TOKRB_SetLinearDamping rb7(mo),0.001
	TOKRB_SetAngularDamping rb7(mo),0.001
	TOKRB_SetMass rb7(mo),2.0
	TOKRB_SetBoxInertiaTensor rb7(mo),2.0,15.0,10.0,2.0
	TOKRB_SetRotation rb7(mo),0,0,0

	; set up joints

	; right axle to chassis
	Joint3(mo) = TOKJOINT_Create(2,prightaxle(mo),pchassis(mo))
	TOKJOINT_SetPositionAndRotationWorld(Joint3(mo),3.1+ax,3+ay,0+az,90,0,0)
	TOKJOINT_SetType(joint3(mo),3)
	TOKJOINT_SetJointLength joint3(mo),3
	TOKJOINT_Enable(joint3(mo),True)
	TOKJOINT_SetUpperLimit joint3(mo),0.065
	TOKJOINT_SetLowerLimit joint3(mo),0.0
	TOKJOINT_EnableLimit joint3(mo),1
	TOKJOINT_SetEpsilon joint3(mo),0
	TOKJOINT_SetIterations joint3(mo),50;40
	TOKJOINT_SetDampingFactor joint3(mo),30

	; left axle to chassis
	Joint2(mo) = TOKJOINT_Create(2,pleftaxle(mo),pchassis(mo))
	TOKJOINT_SetPositionAndRotationWorld(Joint2(mo),-3.1+ax,3+ay,0+az,90,180,0)
	TOKJOINT_SetType(joint2(mo),3)
	TOKJOINT_SetJointLength joint2(mo),3
	TOKJOINT_Enable(joint2(mo),True)
	TOKJOINT_SetUpperLimit joint2(mo),0.065
	TOKJOINT_SetLowerLimit joint2(mo),0.0
	TOKJOINT_EnableLimit joint2(mo),1
	TOKJOINT_SetEpsilon joint2(mo),0
	TOKJOINT_SetIterations joint2(mo),50;40 
	TOKJOINT_SetDampingFactor joint2(mo),30

	; right wheel to rightaxle
	Joint1(mo) = TOKJOINT_Create(2,rb2(mo),prightaxle(mo))
	TOKJOINT_SetPositionAndRotationWorld(Joint1(mo),5+ax,3+ay,0+az,0,0,90)
	TOKJOINT_SetType(joint1(mo),3)
	TOKJOINT_SetJointLength joint1(mo),2
	TOKJOINT_Enable(joint1(mo),True)
	TOKJOINT_SetEpsilon joint1(mo),0.0

	; left wheel to leftaxle
	Joint4(mo) = TOKJOINT_Create(2,rb3(mo),pleftaxle(mo))
	TOKJOINT_SetPositionAndRotationWorld(Joint4(mo),-5+ax,3+ay,0+az,0,0,90)
	TOKJOINT_SetType(joint4(mo),3)
	TOKJOINT_SetJointLength joint4(mo),2
	TOKJOINT_Enable(joint4(mo),True)
	TOKJOINT_SetEpsilon joint4(mo),0.0

	;front axle to pchassis (hinge)
	Joint5(mo) = TOKJOINT_Create(2,rb4(mo),pchassis(mo))
	TOKJOINT_SetPositionAndRotationWorld(Joint5(mo),0+ax,3+ay,11.15+az,0,0,0);10 315
	TOKJOINT_SetType(joint5(mo),3)
	TOKJOINT_SetJointLength(joint5(mo),10);10
	TOKJOINT_SetUpperLimit(joint5(mo),1.5)
	TOKJOINT_SetLowerLimit(joint5(mo),-1.5)
	TOKJOINT_EnableLimit joint5(mo),1
	TOKJOINT_SetIterations(joint5(mo),2);0
	TOKJOINT_Enable(joint5(mo),True)
	TOKJOINT_SetEpsilon joint5(mo),0

	;front axle to front wheel (hinge)
	Joint7(mo)= TOKJOINT_Create(2,rb5(mo),rb4(mo))
	TOKJOINT_SetPositionAndRotationWorld(Joint7(mo),0+ax,3+ay,11.25+az,0,0,90)
	TOKJOINT_SetType(joint7(mo),3)
	TOKJOINT_SetJointLength(joint7(mo),10);10
	TOKJOINT_SetIterations(joint7(mo),2);1
	TOKJOINT_Enable(joint7(mo),True)
	TOKJOINT_SetEpsilon joint7(mo),0

	;boom to pchassis hinge
	Joint12(mo) = TOKJOINT_Create(2,rb7(mo),pchassis(mo))
	TOKJOINT_SetPositionAndRotationWorld(Joint12(mo),0+ax,7.5+ay,5.85+az,0,0,0);7.5 was 6  5.85 was 6
	TOKJOINT_SetJointLength joint12(mo),0.85;1
	TOKJOINT_SetType(joint12(mo),3)
	TOKJOINT_Enable(joint12(mo),True)
	TOKJOINT_SetUpperLimit(joint12(mo),2.2)
	TOKJOINT_SetLowerLimit(joint12(mo),-2.2)
	;TOKJOINT_EnableLimit(joint12(mo),1)
	TOKJOINT_SetIterations joint12(mo),2
	TOKJOINT_SetEpsilon joint12(mo),0
	;TOKJOINT_SetDampingFactor joint12(mo),0
	TOKJOINT_EnableMotor joint12(mo),1
	TOKJOINT_SetMotorSpeed joint12(mo),0,0;+ve = clockwise

	; set up rearrope
	rope(mo)=LoadMesh("data\models\yacht\rope.3ds")
	EntityTexture rope(mo),ropetext
	ropestart(mo)=CreatePivot()
	ropeend(mo)=CreatePivot()
	PositionEntity ropestart(mo),0,4.5,-8.3;y was 3.9 z was -7.6
	EntityParent ropestart(mo),mchassis(mo)
	PositionEntity rope(mo),0,4.5,-8.3;y was 3.9 z was -7.6
	EntityParent rope(mo),ropestart(mo)
	PositionEntity ropeend(mo),0,-6.25,-5.0
	EntityParent ropeend(mo),boom(mo)

	; set up rearrope2
	rope2(mo)=LoadMesh("data\models\yacht\rope2.3ds")
	EntityTexture rope2(mo),ropetext
	ropestart2(mo)=CreatePivot()
	PositionEntity ropestart2(mo),0,2.2,2
	EntityParent ropestart2(mo),mchassis(mo)
	PositionEntity rope2(mo),0,2.2,2
	EntityParent rope2(mo),ropestart2(mo)
	
	; set up steering column
	steeringpivot(mo) = CreatePivot()
	PositionEntity steeringpivot(mo),0,0.65,2.9
	RotateEntity steeringpivot(mo),30.5,0,0
	EntityParent steeringpivot(mo),mchassis(mo)

	; set up false front wheel
	falsefw(mo) = CreatePivot()
	PositionEntity falsefw(mo),0,0.70,4.6
	RotateEntity falsefw(mo),90,90,0
	EntityParent falsefw(mo),steering(mo)

Next

SetFont font

End Function